/*
 * Decompiled with CFR 0.152.
 */
package clover.it.unimi.dsi.fastutil.objects;

import clover.it.unimi.dsi.fastutil.objects.Reference2DoubleMaps;
import clover.it.unimi.dsi.fastutil.objects.Reference2DoubleSortedMap;
import clover.it.unimi.dsi.fastutil.objects.ReferenceSortedSets;
import java.io.Serializable;
import java.util.Comparator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;

public class Reference2DoubleSortedMaps {
    public static final EmptySortedMap EMPTY_MAP = new EmptySortedMap();

    private Reference2DoubleSortedMaps() {
    }

    public static Reference2DoubleSortedMap singleton(Object key, double value) {
        return new Singleton(key, value);
    }

    public static Reference2DoubleSortedMap singleton(Object key, double value, Comparator comparator) {
        return new Singleton(key, value, comparator);
    }

    public static Reference2DoubleSortedMap singleton(Object key, Object value) {
        return new Singleton(key, (Double)value);
    }

    public static Reference2DoubleSortedMap singleton(Object key, Object value, Comparator comparator) {
        return new Singleton(key, (Double)value, comparator);
    }

    public static Reference2DoubleSortedMap synchronize(Reference2DoubleSortedMap m) {
        return new SynchronizedSortedMap(m);
    }

    public static Reference2DoubleSortedMap synchronize(Reference2DoubleSortedMap m, Object sync) {
        return new SynchronizedSortedMap(m, sync);
    }

    public static Reference2DoubleSortedMap unmodifiable(Reference2DoubleSortedMap m) {
        return new UnmodifiableSortedMap(m);
    }

    public static class UnmodifiableSortedMap
    extends Reference2DoubleMaps.UnmodifiableMap
    implements Reference2DoubleSortedMap,
    Serializable {
        public static final long serialVersionUID = -7046029254386353129L;
        protected final Reference2DoubleSortedMap sortedMap;

        protected UnmodifiableSortedMap(Reference2DoubleSortedMap m) {
            super(m);
            this.sortedMap = m;
        }

        public Comparator comparator() {
            return this.sortedMap.comparator();
        }

        public SortedMap subMap(Object from, Object to) {
            return new UnmodifiableSortedMap((Reference2DoubleSortedMap)this.sortedMap.subMap(from, to));
        }

        public SortedMap headMap(Object to) {
            return new UnmodifiableSortedMap((Reference2DoubleSortedMap)this.sortedMap.headMap(to));
        }

        public SortedMap tailMap(Object from) {
            return new UnmodifiableSortedMap((Reference2DoubleSortedMap)this.sortedMap.tailMap(from));
        }

        public Object firstKey() {
            return this.sortedMap.firstKey();
        }

        public Object lastKey() {
            return this.sortedMap.lastKey();
        }
    }

    public static class SynchronizedSortedMap
    extends Reference2DoubleMaps.SynchronizedMap
    implements Reference2DoubleSortedMap,
    Serializable {
        public static final long serialVersionUID = -7046029254386353129L;
        protected final Reference2DoubleSortedMap sortedMap;

        protected SynchronizedSortedMap(Reference2DoubleSortedMap m, Object sync) {
            super(m, sync);
            this.sortedMap = m;
        }

        protected SynchronizedSortedMap(Reference2DoubleSortedMap m) {
            super(m);
            this.sortedMap = m;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Comparator comparator() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedMap.comparator();
            }
        }

        public SortedMap subMap(Object from, Object to) {
            return new SynchronizedSortedMap((Reference2DoubleSortedMap)this.sortedMap.subMap(from, to), this.sync);
        }

        public SortedMap headMap(Object to) {
            return new SynchronizedSortedMap((Reference2DoubleSortedMap)this.sortedMap.headMap(to), this.sync);
        }

        public SortedMap tailMap(Object from) {
            return new SynchronizedSortedMap((Reference2DoubleSortedMap)this.sortedMap.tailMap(from), this.sync);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object firstKey() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedMap.firstKey();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object lastKey() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedMap.lastKey();
            }
        }
    }

    public static class Singleton
    extends Reference2DoubleMaps.Singleton
    implements Reference2DoubleSortedMap,
    Serializable,
    Cloneable {
        public static final long serialVersionUID = -7046029254386353129L;
        protected final Comparator comparator;

        protected Singleton(Object key, double value, Comparator comparator) {
            super(key, value);
            this.comparator = comparator;
        }

        protected Singleton(Object key, double value) {
            this(key, value, null);
        }

        final int compare(Object k1, Object k2) {
            return this.comparator == null ? ((Comparable)k1).compareTo(k2) : this.comparator.compare(k1, k2);
        }

        public Comparator comparator() {
            return this.comparator;
        }

        public Set keySet() {
            if (this.keys == null) {
                this.keys = ReferenceSortedSets.singleton(this.key, this.comparator);
            }
            return this.keys;
        }

        public SortedMap subMap(Object from, Object to) {
            if (this.compare(from, this.key) <= 0 && this.compare(this.key, to) < 0) {
                return this;
            }
            return EMPTY_MAP;
        }

        public SortedMap headMap(Object to) {
            if (this.compare(this.key, to) < 0) {
                return this;
            }
            return EMPTY_MAP;
        }

        public SortedMap tailMap(Object from) {
            if (this.compare(from, this.key) <= 0) {
                return this;
            }
            return EMPTY_MAP;
        }

        public Object firstKey() {
            return this.key;
        }

        public Object lastKey() {
            return this.key;
        }
    }

    public static class EmptySortedMap
    extends Reference2DoubleMaps.EmptyMap
    implements Reference2DoubleSortedMap,
    Serializable,
    Cloneable {
        public static final long serialVersionUID = -7046029254386353129L;

        protected EmptySortedMap() {
        }

        public Comparator comparator() {
            return null;
        }

        public SortedMap subMap(Object from, Object to) {
            return EMPTY_MAP;
        }

        public SortedMap headMap(Object to) {
            return EMPTY_MAP;
        }

        public SortedMap tailMap(Object from) {
            return EMPTY_MAP;
        }

        public Object firstKey() {
            throw new NoSuchElementException();
        }

        public Object lastKey() {
            throw new NoSuchElementException();
        }
    }
}

