/*
 * Decompiled with CFR 0.152.
 */
package clover.it.unimi.dsi.fastutil.ints;

import clover.it.unimi.dsi.fastutil.ints.Int2ReferenceMaps;
import clover.it.unimi.dsi.fastutil.ints.Int2ReferenceSortedMap;
import clover.it.unimi.dsi.fastutil.ints.IntComparator;
import clover.it.unimi.dsi.fastutil.ints.IntSortedSets;
import java.io.Serializable;
import java.util.Comparator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;

public class Int2ReferenceSortedMaps {
    public static final EmptySortedMap EMPTY_MAP = new EmptySortedMap();

    private Int2ReferenceSortedMaps() {
    }

    public static Int2ReferenceSortedMap singleton(int key, Object value) {
        return new Singleton(key, value);
    }

    public static Int2ReferenceSortedMap singleton(int key, Object value, IntComparator comparator) {
        return new Singleton(key, value, comparator);
    }

    public static Int2ReferenceSortedMap singleton(Object key, Object value) {
        return new Singleton((Integer)key, value);
    }

    public static Int2ReferenceSortedMap singleton(Object key, Object value, IntComparator comparator) {
        return new Singleton((Integer)key, value, comparator);
    }

    public static Int2ReferenceSortedMap synchronize(Int2ReferenceSortedMap m) {
        return new SynchronizedSortedMap(m);
    }

    public static Int2ReferenceSortedMap synchronize(Int2ReferenceSortedMap m, Object sync) {
        return new SynchronizedSortedMap(m, sync);
    }

    public static Int2ReferenceSortedMap unmodifiable(Int2ReferenceSortedMap m) {
        return new UnmodifiableSortedMap(m);
    }

    public static class UnmodifiableSortedMap
    extends Int2ReferenceMaps.UnmodifiableMap
    implements Int2ReferenceSortedMap,
    Serializable {
        public static final long serialVersionUID = -7046029254386353129L;
        protected final Int2ReferenceSortedMap sortedMap;

        protected UnmodifiableSortedMap(Int2ReferenceSortedMap m) {
            super(m);
            this.sortedMap = m;
        }

        public Comparator comparator() {
            return this.sortedMap.comparator();
        }

        public Int2ReferenceSortedMap subMap(int from, int to) {
            return new UnmodifiableSortedMap(this.sortedMap.subMap(from, to));
        }

        public Int2ReferenceSortedMap headMap(int to) {
            return new UnmodifiableSortedMap(this.sortedMap.headMap(to));
        }

        public Int2ReferenceSortedMap tailMap(int from) {
            return new UnmodifiableSortedMap(this.sortedMap.tailMap(from));
        }

        public int firstIntKey() {
            return this.sortedMap.firstIntKey();
        }

        public int lastIntKey() {
            return this.sortedMap.lastIntKey();
        }

        public Object firstKey() {
            return this.sortedMap.firstKey();
        }

        public Object lastKey() {
            return this.sortedMap.lastKey();
        }

        public SortedMap subMap(Object from, Object to) {
            return new UnmodifiableSortedMap((Int2ReferenceSortedMap)this.sortedMap.subMap(from, to));
        }

        public SortedMap headMap(Object to) {
            return new UnmodifiableSortedMap((Int2ReferenceSortedMap)this.sortedMap.headMap(to));
        }

        public SortedMap tailMap(Object from) {
            return new UnmodifiableSortedMap((Int2ReferenceSortedMap)this.sortedMap.tailMap(from));
        }
    }

    public static class SynchronizedSortedMap
    extends Int2ReferenceMaps.SynchronizedMap
    implements Int2ReferenceSortedMap,
    Serializable {
        public static final long serialVersionUID = -7046029254386353129L;
        protected final Int2ReferenceSortedMap sortedMap;

        protected SynchronizedSortedMap(Int2ReferenceSortedMap m, Object sync) {
            super(m, sync);
            this.sortedMap = m;
        }

        protected SynchronizedSortedMap(Int2ReferenceSortedMap m) {
            super(m);
            this.sortedMap = m;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Comparator comparator() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedMap.comparator();
            }
        }

        public Int2ReferenceSortedMap subMap(int from, int to) {
            return new SynchronizedSortedMap(this.sortedMap.subMap(from, to), this.sync);
        }

        public Int2ReferenceSortedMap headMap(int to) {
            return new SynchronizedSortedMap(this.sortedMap.headMap(to), this.sync);
        }

        public Int2ReferenceSortedMap tailMap(int from) {
            return new SynchronizedSortedMap(this.sortedMap.tailMap(from), this.sync);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int firstIntKey() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedMap.firstIntKey();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int lastIntKey() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedMap.lastIntKey();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object firstKey() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedMap.firstKey();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object lastKey() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedMap.lastKey();
            }
        }

        public SortedMap subMap(Object from, Object to) {
            return new SynchronizedSortedMap((Int2ReferenceSortedMap)this.sortedMap.subMap(from, to), this.sync);
        }

        public SortedMap headMap(Object to) {
            return new SynchronizedSortedMap((Int2ReferenceSortedMap)this.sortedMap.headMap(to), this.sync);
        }

        public SortedMap tailMap(Object from) {
            return new SynchronizedSortedMap((Int2ReferenceSortedMap)this.sortedMap.tailMap(from), this.sync);
        }
    }

    public static class Singleton
    extends Int2ReferenceMaps.Singleton
    implements Int2ReferenceSortedMap,
    Serializable,
    Cloneable {
        public static final long serialVersionUID = -7046029254386353129L;
        protected final IntComparator comparator;

        protected Singleton(int key, Object value, IntComparator comparator) {
            super(key, value);
            this.comparator = comparator;
        }

        protected Singleton(int key, Object value) {
            this(key, value, null);
        }

        final int compare(int k1, int k2) {
            return this.comparator == null ? (k1 < k2 ? -1 : (k1 == k2 ? 0 : 1)) : this.comparator.compare(k1, k2);
        }

        public Comparator comparator() {
            return this.comparator;
        }

        public Set keySet() {
            if (this.keys == null) {
                this.keys = IntSortedSets.singleton(this.key, this.comparator);
            }
            return this.keys;
        }

        public Int2ReferenceSortedMap subMap(int from, int to) {
            if (this.compare(from, this.key) <= 0 && this.compare(this.key, to) < 0) {
                return this;
            }
            return EMPTY_MAP;
        }

        public Int2ReferenceSortedMap headMap(int to) {
            if (this.compare(this.key, to) < 0) {
                return this;
            }
            return EMPTY_MAP;
        }

        public Int2ReferenceSortedMap tailMap(int from) {
            if (this.compare(from, this.key) <= 0) {
                return this;
            }
            return EMPTY_MAP;
        }

        public int firstIntKey() {
            return this.key;
        }

        public int lastIntKey() {
            return this.key;
        }

        public SortedMap headMap(Object oto) {
            return this.headMap((Integer)oto);
        }

        public SortedMap tailMap(Object ofrom) {
            return this.tailMap((Integer)ofrom);
        }

        public SortedMap subMap(Object ofrom, Object oto) {
            return this.subMap((Integer)ofrom, (Integer)oto);
        }

        public Object firstKey() {
            return new Integer(this.firstIntKey());
        }

        public Object lastKey() {
            return new Integer(this.lastIntKey());
        }
    }

    public static class EmptySortedMap
    extends Int2ReferenceMaps.EmptyMap
    implements Int2ReferenceSortedMap,
    Serializable,
    Cloneable {
        public static final long serialVersionUID = -7046029254386353129L;

        protected EmptySortedMap() {
        }

        public Comparator comparator() {
            return null;
        }

        public Int2ReferenceSortedMap subMap(int from, int to) {
            return EMPTY_MAP;
        }

        public Int2ReferenceSortedMap headMap(int to) {
            return EMPTY_MAP;
        }

        public Int2ReferenceSortedMap tailMap(int from) {
            return EMPTY_MAP;
        }

        public int firstIntKey() {
            throw new NoSuchElementException();
        }

        public int lastIntKey() {
            throw new NoSuchElementException();
        }

        public SortedMap headMap(Object oto) {
            return this.headMap((Integer)oto);
        }

        public SortedMap tailMap(Object ofrom) {
            return this.tailMap((Integer)ofrom);
        }

        public SortedMap subMap(Object ofrom, Object oto) {
            return this.subMap((Integer)ofrom, (Integer)oto);
        }

        public Object firstKey() {
            return new Integer(this.firstIntKey());
        }

        public Object lastKey() {
            return new Integer(this.lastIntKey());
        }
    }
}

