/*
 * Decompiled with CFR 0.152.
 */
package clover.it.unimi.dsi.fastutil.ints;

import clover.it.unimi.dsi.fastutil.HashCommon;
import clover.it.unimi.dsi.fastutil.ints.AbstractIntIterator;
import clover.it.unimi.dsi.fastutil.ints.AbstractIntSet;
import clover.it.unimi.dsi.fastutil.ints.Int2LongMap;
import clover.it.unimi.dsi.fastutil.ints.IntIterator;
import clover.it.unimi.dsi.fastutil.ints.IntSet;
import clover.it.unimi.dsi.fastutil.longs.AbstractLongCollection;
import clover.it.unimi.dsi.fastutil.longs.AbstractLongIterator;
import clover.it.unimi.dsi.fastutil.longs.LongCollection;
import clover.it.unimi.dsi.fastutil.longs.LongIterator;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class AbstractInt2LongMap
implements Int2LongMap,
Serializable {
    protected long defRetValue;

    protected AbstractInt2LongMap() {
    }

    public void setDefRetValue(long rv) {
        this.defaultReturnValue(rv);
    }

    public long getDefRetValue() {
        return this.defaultReturnValue();
    }

    public void defaultReturnValue(long rv) {
        this.defRetValue = rv;
    }

    public long defaultReturnValue() {
        return this.defRetValue;
    }

    public long put(int key, long value) {
        throw new UnsupportedOperationException();
    }

    public long remove(int key) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public Object get(Object ok) {
        int k = (Integer)ok;
        return this.containsKey(k) ? new Long(this.get(k)) : null;
    }

    public Object put(Object ok, Object ov) {
        int k = (Integer)ok;
        long v = this.put(k, (Long)ov);
        return this.containsKey(k) ? new Long(v) : null;
    }

    public Object remove(Object ok) {
        int k = (Integer)ok;
        long v = this.remove(k);
        return this.containsKey(k) ? new Long(v) : null;
    }

    public boolean containsValue(Object ov) {
        return this.containsValue((Long)ov);
    }

    public boolean containsKey(Object ok) {
        return this.containsKey((Integer)ok);
    }

    public boolean containsValue(long v) {
        return ((LongCollection)this.values()).contains(v);
    }

    public boolean containsKey(int k) {
        return ((IntSet)this.keySet()).contains(k);
    }

    public void putAll(Map m) {
        int n = m.size();
        Iterator i = m.entrySet().iterator();
        if (m instanceof Int2LongMap) {
            while (n-- != 0) {
                Int2LongMap.Entry e = (Int2LongMap.Entry)i.next();
                this.put(e.getIntKey(), e.getLongValue());
            }
        } else {
            while (n-- != 0) {
                Map.Entry e = i.next();
                this.put(e.getKey(), e.getValue());
            }
        }
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Set keySet() {
        return new AbstractIntSet(){

            public boolean contains(int k) {
                return AbstractInt2LongMap.this.containsKey(k);
            }

            public int size() {
                return AbstractInt2LongMap.this.size();
            }

            public IntIterator intIterator() {
                return new AbstractIntIterator(){
                    final Iterator i;
                    {
                        this.i = AbstractInt2LongMap.this.entrySet().iterator();
                    }

                    public int nextInt() {
                        return ((Int2LongMap.Entry)this.i.next()).getIntKey();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    public Collection values() {
        return new AbstractLongCollection(){

            public boolean contains(long k) {
                return AbstractInt2LongMap.this.containsValue(k);
            }

            public int size() {
                return AbstractInt2LongMap.this.size();
            }

            public LongIterator longIterator() {
                return new AbstractLongIterator(){
                    final Iterator i;
                    {
                        this.i = AbstractInt2LongMap.this.entrySet().iterator();
                    }

                    public long nextLong() {
                        return ((Int2LongMap.Entry)this.i.next()).getLongValue();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    public int hashCode() {
        int h = 0;
        int n = this.size();
        Iterator i = this.entrySet().iterator();
        while (n-- != 0) {
            h += ((Object)i.next()).hashCode();
        }
        return h;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        if (m.size() != this.size()) {
            return false;
        }
        return this.entrySet().containsAll(m.entrySet());
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        Iterator i = this.entrySet().iterator();
        int n = this.size();
        boolean first = true;
        s.append("{");
        while (n-- != 0) {
            if (first) {
                first = false;
            } else {
                s.append(", ");
            }
            Int2LongMap.Entry e = (Int2LongMap.Entry)i.next();
            s.append(String.valueOf(e.getIntKey()));
            s.append("=>");
            s.append(String.valueOf(e.getLongValue()));
        }
        s.append("}");
        return s.toString();
    }

    public static class BasicEntry
    implements Int2LongMap.Entry {
        protected int key;
        protected long value;

        public BasicEntry(Object key, Object value) {
            this.key = (Integer)key;
            this.value = (Long)value;
        }

        public BasicEntry(int key, long value) {
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return new Integer(this.key);
        }

        public int getIntKey() {
            return this.key;
        }

        public Object getValue() {
            return new Long(this.value);
        }

        public long getLongValue() {
            return this.value;
        }

        public long setValue(long value) {
            throw new UnsupportedOperationException();
        }

        public Object setValue(Object value) {
            return new Long(this.setValue((Long)value));
        }

        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return this.key == (Integer)e.getKey() && this.value == (Long)e.getValue();
        }

        public int hashCode() {
            return this.key ^ HashCommon.long2int(this.value);
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

