/*
 * Decompiled with CFR 0.152.
 */
package clover.it.unimi.dsi.fastutil;

import clover.it.unimi.dsi.fastutil.AbstractIndirectPriorityQueue;
import clover.it.unimi.dsi.fastutil.IndirectPriorityQueue;
import java.util.Comparator;
import java.util.NoSuchElementException;

public class IndirectPriorityQueues {
    public static final EmptyIndirectPriorityQueue EMPTY_QUEUE = new EmptyIndirectPriorityQueue();

    private IndirectPriorityQueues() {
    }

    public static IndirectPriorityQueue synchronize(IndirectPriorityQueue q) {
        return new SynchronizedIndirectPriorityQueue(q);
    }

    public static IndirectPriorityQueue synchronize(IndirectPriorityQueue q, Object sync) {
        return new SynchronizedIndirectPriorityQueue(q, sync);
    }

    public static class SynchronizedIndirectPriorityQueue
    implements IndirectPriorityQueue {
        public static final long serialVersionUID = -7046029254386353129L;
        protected final IndirectPriorityQueue q;
        protected final Object sync;

        protected SynchronizedIndirectPriorityQueue(IndirectPriorityQueue q, Object sync) {
            this.q = q;
            this.sync = sync;
        }

        protected SynchronizedIndirectPriorityQueue(IndirectPriorityQueue q) {
            this.q = q;
            this.sync = this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void enqueue(int x) {
            Object object = this.sync;
            synchronized (object) {
                this.q.enqueue(x);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int dequeue() {
            Object object = this.sync;
            synchronized (object) {
                return this.q.dequeue();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int first() {
            Object object = this.sync;
            synchronized (object) {
                return this.q.first();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int last() {
            Object object = this.sync;
            synchronized (object) {
                return this.q.last();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isEmpty() {
            Object object = this.sync;
            synchronized (object) {
                return this.q.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int size() {
            Object object = this.sync;
            synchronized (object) {
                return this.q.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            Object object = this.sync;
            synchronized (object) {
                this.q.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void changed() {
            Object object = this.sync;
            synchronized (object) {
                this.q.changed();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void allChanged() {
            Object object = this.sync;
            synchronized (object) {
                this.q.allChanged();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void changed(int i) {
            Object object = this.sync;
            synchronized (object) {
                this.q.changed(i);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove(int i) {
            Object object = this.sync;
            synchronized (object) {
                this.q.remove(i);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Comparator comparator() {
            Object object = this.sync;
            synchronized (object) {
                return this.q.comparator();
            }
        }
    }

    public static class EmptyIndirectPriorityQueue
    extends AbstractIndirectPriorityQueue {
        protected EmptyIndirectPriorityQueue() {
        }

        public void enqueue(int i) {
            throw new UnsupportedOperationException();
        }

        public int dequeue() {
            throw new NoSuchElementException();
        }

        public boolean isEmpty() {
            return true;
        }

        public int size() {
            return 0;
        }

        public void clear() {
        }

        public int first() {
            throw new NoSuchElementException();
        }

        public int last() {
            throw new NoSuchElementException();
        }

        public void changed() {
            throw new NoSuchElementException();
        }

        public void allChanged() {
        }

        public Comparator comparator() {
            return null;
        }

        public void changed(int i) {
            throw new IllegalArgumentException("Index " + i + " is not in the queue");
        }

        public void remove(int i) {
            throw new IllegalArgumentException("Index " + i + " is not in the queue");
        }
    }
}

