/*
 * Decompiled with CFR 0.152.
 */
package clover.com.lowagie.text.rtf;

import clover.com.lowagie.text.Cell;
import clover.com.lowagie.text.DocumentException;
import clover.com.lowagie.text.Element;
import clover.com.lowagie.text.Paragraph;
import clover.com.lowagie.text.rtf.RtfRow;
import clover.com.lowagie.text.rtf.RtfTable;
import clover.com.lowagie.text.rtf.RtfTableCell;
import clover.com.lowagie.text.rtf.RtfWriter;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Iterator;

public class RtfCell {
    private static final int MERGE_HORIZ_FIRST = 1;
    private static final int MERGE_VERT_FIRST = 2;
    private static final int MERGE_BOTH_FIRST = 3;
    private static final int MERGE_HORIZ_PREV = 4;
    private static final int MERGE_VERT_PREV = 5;
    private static final int MERGE_BOTH_PREV = 6;
    private static final byte[] cellMergeFirst = "clmgf".getBytes();
    private static final byte[] cellVMergeFirst = "clvmgf".getBytes();
    private static final byte[] cellMergePrev = "clmrg".getBytes();
    private static final byte[] cellVMergePrev = "clvmrg".getBytes();
    private static final byte[] cellVerticalAlignBottom = "clvertalb".getBytes();
    private static final byte[] cellVerticalAlignCenter = "clvertalc".getBytes();
    private static final byte[] cellVerticalAlignTop = "clvertalt".getBytes();
    private static final byte[] cellBorderLeft = "clbrdrl".getBytes();
    private static final byte[] cellBorderRight = "clbrdrr".getBytes();
    private static final byte[] cellBorderTop = "clbrdrt".getBytes();
    private static final byte[] cellBorderBottom = "clbrdrb".getBytes();
    private static final byte[] cellBackgroundColor = "clcbpat".getBytes();
    private static final byte[] cellWidthStyle = "clftsWidth3".getBytes();
    private static final byte[] cellWidthTag = "clwWidth".getBytes();
    private static final byte[] cellRightBorder = "cellx".getBytes();
    protected static final byte[] cellInTable = "intbl".getBytes();
    private static final byte[] cellEnd = "cell".getBytes();
    private static final byte[] cellPaddingTop = "clpadt".getBytes();
    private static final byte[] cellPaddingTopUnit = "clpadft3".getBytes();
    private static final byte[] cellPaddingBottom = "clpadb".getBytes();
    private static final byte[] cellPaddingBottomUnit = "clpadfb3".getBytes();
    private static final byte[] cellPaddingLeft = "clpadl".getBytes();
    private static final byte[] cellPaddingLeftUnit = "clpadfl3".getBytes();
    private static final byte[] cellPaddingRight = "clpadr".getBytes();
    private static final byte[] cellPaddingRightUnit = "clpadfr3".getBytes();
    private RtfWriter writer = null;
    private RtfTable mainTable = null;
    private int cellWidth = 0;
    private int cellRight = 0;
    private Cell store = null;
    private boolean emptyCell = true;
    private int mergeType = 0;
    private int cellpadding = 0;

    public RtfCell(RtfWriter writer, RtfTable mainTable) {
        this.writer = writer;
        this.mainTable = mainTable;
    }

    public int importCell(Cell cell, int cellLeft, int cellWidth, int x, int y, int cellpadding) {
        block10: {
            block9: {
                this.cellpadding = cellpadding;
                this.cellWidth = cellWidth;
                if (cell == null) {
                    this.cellRight = cellLeft + cellWidth;
                    return this.cellRight;
                }
                if (cell.cellWidth() != null && !cell.cellWidth().equals("")) {
                    this.cellWidth = (int)((double)Integer.parseInt(cell.cellWidth()) * 20.0);
                }
                this.cellRight = cellLeft + this.cellWidth;
                this.store = cell;
                this.emptyCell = false;
                if (cell.colspan() <= 1) break block9;
                if (cell.rowspan() > 1) {
                    this.mergeType = 3;
                    int i = y;
                    while (i < y + cell.rowspan()) {
                        if (i > y) {
                            this.mainTable.setMerge(x, i, 5, this);
                        }
                        int j = x + 1;
                        while (j < x + cell.colspan()) {
                            this.mainTable.setMerge(j, i, 6, this);
                            ++j;
                        }
                        ++i;
                    }
                } else {
                    this.mergeType = 1;
                    int i = x + 1;
                    while (i < x + cell.colspan()) {
                        this.mainTable.setMerge(i, y, 4, this);
                        ++i;
                    }
                }
                break block10;
            }
            if (cell.rowspan() <= 1) break block10;
            this.mergeType = 2;
            int i = y + 1;
            while (i < y + cell.rowspan()) {
                this.mainTable.setMerge(x, i, 5, this);
                ++i;
            }
        }
        return this.cellRight;
    }

    public boolean writeCellSettings(ByteArrayOutputStream os) {
        byte[] bStyle;
        byte[] rStyle;
        byte[] tStyle;
        byte[] lStyle;
        float bWidth;
        float rWidth;
        float tWidth;
        float lWidth;
        block32: {
            try {
                if (this.store instanceof RtfTableCell) {
                    RtfTableCell c = (RtfTableCell)this.store;
                    lWidth = c.leftBorderWidth();
                    tWidth = c.topBorderWidth();
                    rWidth = c.rightBorderWidth();
                    bWidth = c.bottomBorderWidth();
                    lStyle = RtfTableCell.getStyleControlWord(c.leftBorderStyle());
                    tStyle = RtfTableCell.getStyleControlWord(c.topBorderStyle());
                    rStyle = RtfTableCell.getStyleControlWord(c.rightBorderStyle());
                    bStyle = RtfTableCell.getStyleControlWord(c.bottomBorderStyle());
                } else {
                    rWidth = bWidth = this.store.borderWidth();
                    tWidth = bWidth;
                    lWidth = bWidth;
                    bStyle = RtfRow.tableBorder;
                    tStyle = rStyle = RtfRow.tableBorder;
                    lStyle = rStyle;
                }
                if (this.mergeType != 4 && this.mergeType != 6) break block32;
                return true;
            }
            catch (IOException e) {
                return false;
            }
        }
        switch (this.mergeType) {
            case 2: {
                os.write(92);
                os.write(cellVMergeFirst);
                break;
            }
            case 3: {
                os.write(92);
                os.write(cellVMergeFirst);
                break;
            }
            case 4: {
                os.write(92);
                os.write(cellMergePrev);
                break;
            }
            case 5: {
                os.write(92);
                os.write(cellVMergePrev);
                break;
            }
            case 6: {
                os.write(92);
                os.write(cellMergeFirst);
            }
        }
        switch (this.store.verticalAlignment()) {
            case 6: {
                os.write(92);
                os.write(cellVerticalAlignBottom);
                break;
            }
            case 1: 
            case 5: {
                os.write(92);
                os.write(cellVerticalAlignCenter);
                break;
            }
            case 4: {
                os.write(92);
                os.write(cellVerticalAlignTop);
            }
        }
        if ((this.store.border() & 4) == 4 && lWidth > 0.0f) {
            os.write(92);
            os.write(cellBorderLeft);
            os.write(92);
            os.write(lStyle);
            os.write(92);
            os.write(RtfRow.tableBorderWidth);
            this.writeInt(os, (int)((double)lWidth * 20.0));
            os.write(92);
            os.write(RtfRow.tableBorderColor);
            if (this.store.borderColor() == null) {
                this.writeInt(os, this.writer.addColor(new Color(0, 0, 0)));
            } else {
                this.writeInt(os, this.writer.addColor(this.store.borderColor()));
            }
            os.write(10);
        }
        if ((this.store.border() & 1) == 1 && tWidth > 0.0f) {
            os.write(92);
            os.write(cellBorderTop);
            os.write(92);
            os.write(tStyle);
            os.write(92);
            os.write(RtfRow.tableBorderWidth);
            this.writeInt(os, (int)((double)tWidth * 20.0));
            os.write(92);
            os.write(RtfRow.tableBorderColor);
            if (this.store.borderColor() == null) {
                this.writeInt(os, this.writer.addColor(new Color(0, 0, 0)));
            } else {
                this.writeInt(os, this.writer.addColor(this.store.borderColor()));
            }
            os.write(10);
        }
        if ((this.store.border() & 2) == 2 && bWidth > 0.0f) {
            os.write(92);
            os.write(cellBorderBottom);
            os.write(92);
            os.write(bStyle);
            os.write(92);
            os.write(RtfRow.tableBorderWidth);
            this.writeInt(os, (int)((double)bWidth * 20.0));
            os.write(92);
            os.write(RtfRow.tableBorderColor);
            if (this.store.borderColor() == null) {
                this.writeInt(os, this.writer.addColor(new Color(0, 0, 0)));
            } else {
                this.writeInt(os, this.writer.addColor(this.store.borderColor()));
            }
            os.write(10);
        }
        if ((this.store.border() & 8) == 8 && rWidth > 0.0f) {
            os.write(92);
            os.write(cellBorderRight);
            os.write(92);
            os.write(rStyle);
            os.write(92);
            os.write(RtfRow.tableBorderWidth);
            this.writeInt(os, (int)((double)rWidth * 20.0));
            os.write(92);
            os.write(RtfRow.tableBorderColor);
            if (this.store.borderColor() == null) {
                this.writeInt(os, this.writer.addColor(new Color(0, 0, 0)));
            } else {
                this.writeInt(os, this.writer.addColor(this.store.borderColor()));
            }
            os.write(10);
        }
        os.write(92);
        os.write(cellBackgroundColor);
        if (this.store.backgroundColor() == null) {
            this.writeInt(os, this.writer.addColor(new Color(255, 255, 255)));
        } else {
            this.writeInt(os, this.writer.addColor(this.store.backgroundColor()));
        }
        os.write(10);
        os.write(92);
        os.write(cellWidthStyle);
        os.write(10);
        os.write(92);
        os.write(cellWidthTag);
        this.writeInt(os, this.cellWidth);
        os.write(10);
        if (this.cellpadding > 0) {
            os.write(92);
            os.write(cellPaddingLeft);
            this.writeInt(os, this.cellpadding / 2);
            os.write(92);
            os.write(cellPaddingTop);
            this.writeInt(os, this.cellpadding / 2);
            os.write(92);
            os.write(cellPaddingRight);
            this.writeInt(os, this.cellpadding / 2);
            os.write(92);
            os.write(cellPaddingBottom);
            this.writeInt(os, this.cellpadding / 2);
            os.write(92);
            os.write(cellPaddingLeftUnit);
            os.write(92);
            os.write(cellPaddingTopUnit);
            os.write(92);
            os.write(cellPaddingRightUnit);
            os.write(92);
            os.write(cellPaddingBottomUnit);
        }
        os.write(92);
        os.write(cellRightBorder);
        this.writeInt(os, this.cellRight);
        return true;
    }

    public boolean writeCellContent(ByteArrayOutputStream os) throws DocumentException {
        block11: {
            if (this.mergeType != 4 && this.mergeType != 6) break block11;
            return true;
        }
        try {
            if (!this.emptyCell) {
                Iterator cellIterator = this.store.getElements();
                Paragraph container = null;
                while (cellIterator.hasNext()) {
                    Element element = (Element)cellIterator.next();
                    if (!(element instanceof Paragraph)) {
                        if (container != null) {
                            container.add(element);
                            continue;
                        }
                        container = new Paragraph();
                        container.setAlignment(this.store.horizontalAlignment());
                        container.add(element);
                        continue;
                    }
                    if (container != null) {
                        this.writer.addElement(container, os);
                        container = null;
                        container = null;
                    }
                    if (element instanceof Paragraph && ((Paragraph)element).alignment() == -1) {
                        ((Paragraph)element).setAlignment(this.store.horizontalAlignment());
                    }
                    this.writer.addElement(element, os);
                    if (element.type() != 12 || !cellIterator.hasNext()) continue;
                    os.write(92);
                    os.write(RtfWriter.paragraph);
                }
                if (container != null) {
                    this.writer.addElement(container, os);
                    container = null;
                }
            } else {
                os.write(92);
                os.write(RtfWriter.paragraphDefaults);
                os.write(92);
                os.write(cellInTable);
            }
            os.write(92);
            os.write(cellEnd);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public void setMerge(int mergeType, RtfCell mergeCell) {
        this.mergeType = mergeType;
        this.store = mergeCell.getStore();
    }

    public Cell getStore() {
        return this.store;
    }

    public int getCellWidth() {
        return this.cellWidth;
    }

    public void setCellWidth(int value) {
        this.cellWidth = value;
    }

    public int getCellRight() {
        return this.cellRight;
    }

    public void setCellRight(int value) {
        this.cellRight = value;
    }

    private void writeInt(ByteArrayOutputStream out, int i) throws IOException {
        out.write(Integer.toString(i).getBytes());
    }
}

