/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.wiki.namespaces;

import info.bliki.Messages;
import info.bliki.wiki.namespaces.INamespace;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeMap;

public class Namespace
implements INamespace {
    protected final String[] fNamespaces1 = new String[]{"Media", "Special", "", "Talk", "User", "User_talk", "Meta", "Meta_talk", "Image", "Image_talk", "MediaWiki", "MediaWiki_talk", "Template", "Template_talk", "Help", "Help_talk", "Category", "Category_talk"};
    protected final String[] fNamespaces2 = new String[]{"Media", "Special", "", "Talk", "User", "User_talk", "Meta", "Meta_talk", "File", "File_talk", "MediaWiki", "MediaWiki_talk", "Template", "Template_talk", "Help", "Help_talk", "Category", "Category_talk"};
    protected final String[] fTalkNamespaces = new String[]{null, null, null, null, "User_talk", "User_talk", "Meta_talk", "Meta_talk", "Image_talk", "Image_talk", "MediaWiki_talk", "MediaWiki_talk", "Template_talk", "Template_talk", "Help_talk", "Help_talk", "Category_talk", "Category_talk"};
    protected final String[] fNamespacesLowercase = new String[]{"media", "special", "", "talk", "user", "user_talk", "project", "project_talk", "image", "image_talk", "mediawiki", "mediawiki_talk", "template", "template_talk", "help", "help_talk", "category", "category_talk"};
    public final Map<String, String> NAMESPACE_MAP = new HashMap<String, String>();
    public final Map<String, String> TALKSPACE_MAP = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
    protected ResourceBundle fResourceBundle = null;

    public Namespace() {
        this((ResourceBundle)null);
    }

    public Namespace(Locale locale) {
        this(Messages.getResourceBundle(locale));
    }

    public Namespace(ResourceBundle resourceBundle) {
        int i;
        this.fResourceBundle = resourceBundle;
        this.initializeNamespaces();
        for (i = 0; i < this.fNamespacesLowercase.length; ++i) {
            this.NAMESPACE_MAP.put(this.fNamespacesLowercase[i], this.fNamespaces1[i]);
        }
        for (i = 0; i < this.fNamespacesLowercase.length; ++i) {
            if (this.fTalkNamespaces[i] == null) continue;
            this.TALKSPACE_MAP.put(this.fNamespacesLowercase[i], this.fTalkNamespaces[i]);
        }
    }

    public String getCategory() {
        return this.fNamespaces1[16];
    }

    public String getCategory_talk() {
        return this.fNamespaces1[17];
    }

    public String getCategory_talk2() {
        return this.fNamespaces2[17];
    }

    public String getCategory2() {
        return this.fNamespaces2[16];
    }

    public String getHelp() {
        return this.fNamespaces1[14];
    }

    public String getHelp_talk() {
        return this.fNamespaces1[15];
    }

    public String getHelp_talk2() {
        return this.fNamespaces2[15];
    }

    public String getHelp2() {
        return this.fNamespaces2[14];
    }

    public String getImage() {
        return this.fNamespaces1[8];
    }

    public String getImage_talk() {
        return this.fNamespaces1[9];
    }

    public String getImage_talk2() {
        return this.fNamespaces2[9];
    }

    public String getImage2() {
        return this.fNamespaces2[8];
    }

    public String getMedia() {
        return this.fNamespaces1[0];
    }

    public String getMedia2() {
        return this.fNamespaces2[0];
    }

    public String getMediaWiki() {
        return this.fNamespaces1[10];
    }

    public String getMediaWiki_talk() {
        return this.fNamespaces1[11];
    }

    public String getMediaWiki_talk2() {
        return this.fNamespaces2[11];
    }

    public String getMediaWiki2() {
        return this.fNamespaces2[10];
    }

    public String getMeta() {
        return this.fNamespaces1[6];
    }

    public String getMeta_talk() {
        return this.fNamespaces1[7];
    }

    public String getMeta_talk2() {
        return this.fNamespaces2[7];
    }

    public String getMeta2() {
        return this.fNamespaces2[6];
    }

    public String getNamespaceByLowercase(String lowercaseNamespace) {
        return this.NAMESPACE_MAP.get(lowercaseNamespace);
    }

    public String getNamespaceByNumber(int numberCode) {
        return this.fNamespaces1[numberCode + 2];
    }

    public ResourceBundle getResourceBundle() {
        return this.fResourceBundle;
    }

    public String getSpecial() {
        return this.fNamespaces1[1];
    }

    public String getSpecial2() {
        return this.fNamespaces2[1];
    }

    public String getTalk() {
        return this.fNamespaces1[3];
    }

    public String getTalk2() {
        return this.fNamespaces2[3];
    }

    public String getTemplate() {
        return this.fNamespaces1[12];
    }

    public String getTemplate_talk() {
        return this.fNamespaces1[13];
    }

    public String getTemplate_talk2() {
        return this.fNamespaces2[13];
    }

    public String getTemplate2() {
        return this.fNamespaces2[12];
    }

    public String getUser() {
        return this.fNamespaces1[4];
    }

    public String getUser_talk() {
        return this.fNamespaces1[5];
    }

    public String getUser_talk2() {
        return this.fNamespaces2[5];
    }

    public String getUser2() {
        return this.fNamespaces2[4];
    }

    private void initializeNamespaces() {
        String ns2;
        if (this.fResourceBundle == null) {
            return;
        }
        String ns1 = Messages.getString(this.fResourceBundle, "wiki.api.media1");
        if (ns1 != null) {
            this.fNamespaces1[0] = ns1;
            ns2 = Messages.getString(this.fResourceBundle, "wiki.api.media2");
            if (ns2 != null) {
                this.fNamespaces2[0] = ns2;
            }
        }
        if ((ns1 = Messages.getString(this.fResourceBundle, "wiki.api.special1")) != null) {
            this.fNamespaces1[1] = ns1;
            ns2 = Messages.getString(this.fResourceBundle, "wiki.api.special2");
            if (ns2 != null) {
                this.fNamespaces2[1] = ns2;
            }
        }
        if ((ns1 = Messages.getString(this.fResourceBundle, "wiki.api.talk1")) != null) {
            this.fNamespaces1[3] = ns1;
            ns2 = Messages.getString(this.fResourceBundle, "wiki.api.talk2");
            if (ns2 != null) {
                this.fNamespaces2[3] = ns2;
            }
        }
        if ((ns1 = Messages.getString(this.fResourceBundle, "wiki.api.user1")) != null) {
            this.fNamespaces1[4] = ns1;
            ns2 = Messages.getString(this.fResourceBundle, "wiki.api.user2");
            if (ns2 != null) {
                this.fNamespaces2[4] = ns2;
            }
        }
        if ((ns1 = Messages.getString(this.fResourceBundle, "wiki.api.usertalk1")) != null) {
            this.fNamespaces1[5] = ns1;
            ns2 = Messages.getString(this.fResourceBundle, "wiki.api.usertalk2");
            if (ns2 != null) {
                this.fNamespaces2[5] = ns2;
            }
        }
        if ((ns1 = Messages.getString(this.fResourceBundle, "wiki.api.meta1")) != null) {
            this.fNamespaces1[6] = ns1;
            ns2 = Messages.getString(this.fResourceBundle, "wiki.api.meta2");
            if (ns2 != null) {
                this.fNamespaces2[6] = ns2;
            }
        }
        if ((ns1 = Messages.getString(this.fResourceBundle, "wiki.api.metatalk1")) != null) {
            this.fNamespaces1[7] = ns1;
            ns2 = Messages.getString(this.fResourceBundle, "wiki.api.metatalk2");
            if (ns2 != null) {
                this.fNamespaces2[7] = ns2;
            }
        }
        if ((ns1 = Messages.getString(this.fResourceBundle, "wiki.api.image1")) != null) {
            this.fNamespaces1[8] = ns1;
            ns2 = Messages.getString(this.fResourceBundle, "wiki.api.image2");
            if (ns2 != null) {
                this.fNamespaces2[8] = ns2;
            }
        }
        if ((ns1 = Messages.getString(this.fResourceBundle, "wiki.api.imagetalk1")) != null) {
            this.fNamespaces1[9] = ns1;
            ns2 = Messages.getString(this.fResourceBundle, "wiki.api.imagetalk2");
            if (ns2 != null) {
                this.fNamespaces2[9] = ns2;
            }
        }
        if ((ns1 = Messages.getString(this.fResourceBundle, "wiki.api.mediawiki1")) != null) {
            this.fNamespaces1[10] = ns1;
            ns2 = Messages.getString(this.fResourceBundle, "wiki.api.mediawiki2");
            if (ns2 != null) {
                this.fNamespaces2[10] = ns2;
            }
        }
        if ((ns1 = Messages.getString(this.fResourceBundle, "wiki.api.mediawikitalk1")) != null) {
            this.fNamespaces1[11] = ns1;
            ns2 = Messages.getString(this.fResourceBundle, "wiki.api.mediawikitalk2");
            if (ns2 != null) {
                this.fNamespaces2[11] = ns2;
            }
        }
        if ((ns1 = Messages.getString(this.fResourceBundle, "wiki.api.template1")) != null) {
            this.fNamespaces1[12] = ns1;
            ns2 = Messages.getString(this.fResourceBundle, "wiki.api.template2");
            if (ns2 != null) {
                this.fNamespaces2[12] = ns2;
            }
        }
        if ((ns1 = Messages.getString(this.fResourceBundle, "wiki.api.templatetalk1")) != null) {
            this.fNamespaces1[13] = ns1;
            ns2 = Messages.getString(this.fResourceBundle, "wiki.api.templatetalk2");
            if (ns2 != null) {
                this.fNamespaces2[13] = ns2;
            }
        }
        if ((ns1 = Messages.getString(this.fResourceBundle, "wiki.api.help1")) != null) {
            this.fNamespaces1[14] = ns1;
            ns2 = Messages.getString(this.fResourceBundle, "wiki.api.help2");
            if (ns2 != null) {
                this.fNamespaces2[14] = ns2;
            }
        }
        if ((ns1 = Messages.getString(this.fResourceBundle, "wiki.api.helptalk1")) != null) {
            this.fNamespaces1[15] = ns1;
            ns2 = Messages.getString(this.fResourceBundle, "wiki.api.helptalk2");
            if (ns2 != null) {
                this.fNamespaces2[15] = ns2;
            }
        }
        if ((ns1 = Messages.getString(this.fResourceBundle, "wiki.api.category1")) != null) {
            this.fNamespaces1[16] = ns1;
            ns2 = Messages.getString(this.fResourceBundle, "wiki.api.category2");
            if (ns2 != null) {
                this.fNamespaces2[16] = ns2;
            }
        }
        if ((ns1 = Messages.getString(this.fResourceBundle, "wiki.api.categorytalk1")) != null) {
            this.fNamespaces1[17] = ns1;
            ns2 = Messages.getString(this.fResourceBundle, "wiki.api.categorytalk2");
            if (ns2 != null) {
                this.fNamespaces2[17] = ns2;
            }
        }
    }

    public String getTalkspace(String namespace) {
        return this.TALKSPACE_MAP.get(namespace);
    }
}

