/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.core;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Vector;
import org.postgresql.Driver;
import org.postgresql.core.BaseConnection;
import org.postgresql.core.BaseResultSet;
import org.postgresql.core.BaseStatement;
import org.postgresql.core.Encoding;
import org.postgresql.core.Field;
import org.postgresql.core.Notification;
import org.postgresql.core.PGStream;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public class QueryExecutor {
    private String[] m_sqlFrags;
    private Object[] m_binds;
    private BaseStatement statement;
    private BaseResultSet rs;
    private BaseConnection connection;
    private PGStream pgStream;
    private Field[] fields = null;
    private Vector tuples = new Vector();
    private String status = null;
    private int update_count = 1;
    private long insert_oid = 0L;
    private int maxRows;

    public static BaseResultSet execute(String[] p_sqlFrags, Object[] p_binds, BaseStatement statement) throws SQLException {
        QueryExecutor qe = new QueryExecutor();
        qe.m_sqlFrags = p_sqlFrags;
        qe.m_binds = p_binds;
        qe.statement = statement;
        qe.maxRows = statement != null ? statement.getMaxRows() : 0;
        qe.connection = statement.getPGConnection();
        qe.pgStream = qe.connection.getPGStream();
        return qe.execute();
    }

    public static void execute(String[] p_sqlFrags, Object[] p_binds, BaseResultSet rs) throws SQLException {
        QueryExecutor qe = new QueryExecutor();
        qe.m_sqlFrags = p_sqlFrags;
        qe.m_binds = p_binds;
        qe.rs = rs;
        qe.statement = qe.rs.getPGStatement();
        qe.maxRows = qe.statement != null ? qe.statement.getMaxRows() : 0;
        qe.connection = qe.statement.getPGConnection();
        qe.pgStream = qe.connection.getPGStream();
        qe.execute();
    }

    private QueryExecutor() {
    }

    private BaseResultSet execute() throws SQLException {
        if (this.connection.getPGProtocolVersionMajor() == 3) {
            if (Driver.logDebug) {
                Driver.debug("Using Protocol Version3 to send query");
            }
            return this.executeV3();
        }
        if (Driver.logDebug) {
            Driver.debug("Using Protocol Version2 to send query");
        }
        return this.executeV2();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BaseResultSet executeV3() throws SQLException {
        PSQLException error = null;
        if (this.pgStream == null) {
            throw new PSQLException("postgresql.con.closed", PSQLState.CONNECTION_DOES_NOT_EXIST);
        }
        PGStream pGStream = this.pgStream;
        synchronized (pGStream) {
            this.sendQueryV3();
            boolean l_endQuery = false;
            block15: while (!l_endQuery) {
                int c2 = this.pgStream.ReceiveChar();
                switch (c2) {
                    case 65: {
                        int msglen = this.pgStream.ReceiveIntegerR(4);
                        int pid = this.pgStream.ReceiveIntegerR(4);
                        String msg = this.pgStream.ReceiveString(this.connection.getEncoding());
                        String param = this.pgStream.ReceiveString(this.connection.getEncoding());
                        this.connection.addNotification(new Notification(msg, pid));
                        break;
                    }
                    case 67: {
                        this.receiveCommandStatusV3();
                        break;
                    }
                    case 68: {
                        this.receiveTupleV3();
                        break;
                    }
                    case 69: {
                        int l_elen = this.pgStream.ReceiveIntegerR(4);
                        String totalMessage = this.connection.getEncoding().decode(this.pgStream.Receive(l_elen - 4));
                        PSQLException l_error = PSQLException.parseServerError(totalMessage);
                        if (error != null) {
                            error.setNextException(l_error);
                            break;
                        }
                        error = l_error;
                        break;
                    }
                    case 73: {
                        int t = this.pgStream.ReceiveIntegerR(4);
                        break;
                    }
                    case 78: {
                        int l_nlen = this.pgStream.ReceiveIntegerR(4);
                        this.statement.addWarning(this.connection.getEncoding().decode(this.pgStream.Receive(l_nlen - 4)));
                        break;
                    }
                    case 80: {
                        String pname = this.pgStream.ReceiveString(this.connection.getEncoding());
                        break;
                    }
                    case 83: {
                        int l_len = this.pgStream.ReceiveIntegerR(4);
                        String l_pStatus = this.connection.getEncoding().decode(this.pgStream.Receive(l_len - 4));
                        if (!Driver.logDebug) continue block15;
                        Driver.debug("ParameterStatus=" + l_pStatus);
                        break;
                    }
                    case 84: {
                        this.receiveFieldsV3();
                        break;
                    }
                    case 90: {
                        if (this.pgStream.ReceiveIntegerR(4) != 5) {
                            throw new PSQLException("postgresql.con.setup", PSQLState.CONNECTION_UNABLE_TO_CONNECT);
                        }
                        char l_tStatus = (char)this.pgStream.ReceiveChar();
                        l_endQuery = true;
                        break;
                    }
                    default: {
                        throw new PSQLException("postgresql.con.type", PSQLState.CONNECTION_FAILURE, new Character((char)c2));
                    }
                }
            }
            if (error != null) {
                throw error;
            }
            if (this.rs != null) {
                this.rs.reInit(this.fields, this.tuples, this.status, this.update_count, this.insert_oid);
            } else {
                this.rs = this.statement.createResultSet(this.fields, this.tuples, this.status, this.update_count, this.insert_oid);
            }
            return this.rs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BaseResultSet executeV2() throws SQLException {
        StringBuffer errorMessage = null;
        if (this.pgStream == null) {
            throw new PSQLException("postgresql.con.closed", PSQLState.CONNECTION_DOES_NOT_EXIST);
        }
        PGStream pGStream = this.pgStream;
        synchronized (pGStream) {
            this.sendQueryV2();
            boolean l_endQuery = false;
            while (!l_endQuery) {
                int c2 = this.pgStream.ReceiveChar();
                switch (c2) {
                    case 65: {
                        int pid = this.pgStream.ReceiveIntegerR(4);
                        String msg = this.pgStream.ReceiveString(this.connection.getEncoding());
                        this.connection.addNotification(new Notification(msg, pid));
                        break;
                    }
                    case 66: {
                        this.receiveTupleV2(true);
                        break;
                    }
                    case 67: {
                        this.receiveCommandStatusV2();
                        break;
                    }
                    case 68: {
                        this.receiveTupleV2(false);
                        break;
                    }
                    case 69: {
                        if (errorMessage == null) {
                            errorMessage = new StringBuffer();
                        }
                        errorMessage.append(this.pgStream.ReceiveString(this.connection.getEncoding()));
                        break;
                    }
                    case 73: {
                        int t = this.pgStream.ReceiveIntegerR(4);
                        break;
                    }
                    case 78: {
                        this.statement.addWarning(this.pgStream.ReceiveString(this.connection.getEncoding()));
                        break;
                    }
                    case 80: {
                        String pname = this.pgStream.ReceiveString(this.connection.getEncoding());
                        break;
                    }
                    case 84: {
                        this.receiveFieldsV2();
                        break;
                    }
                    case 90: {
                        l_endQuery = true;
                        break;
                    }
                    default: {
                        throw new PSQLException("postgresql.con.type", PSQLState.CONNECTION_FAILURE, new Character((char)c2));
                    }
                }
            }
            if (errorMessage != null) {
                throw new SQLException(errorMessage.toString().trim());
            }
            if (this.rs != null) {
                this.rs.reInit(this.fields, this.tuples, this.status, this.update_count, this.insert_oid);
            } else {
                this.rs = this.statement.createResultSet(this.fields, this.tuples, this.status, this.update_count, this.insert_oid);
            }
            return this.rs;
        }
    }

    private void sendQueryV3() throws SQLException {
        int i2 = 0;
        while (i2 < this.m_binds.length) {
            if (this.m_binds[i2] == null) {
                throw new PSQLException("postgresql.prep.param", PSQLState.INVALID_PARAMETER_VALUE, new Integer(i2 + 1));
            }
            ++i2;
        }
        try {
            byte[][] l_parts = new byte[this.m_binds.length * 2 + 1][];
            int j2 = 0;
            int l_msgSize = 4;
            Encoding l_encoding = this.connection.getEncoding();
            this.pgStream.SendChar(81);
            int i3 = 0;
            while (i3 < this.m_binds.length) {
                l_parts[j2] = l_encoding.encode(this.m_sqlFrags[i3]);
                l_msgSize += l_parts[j2].length;
                l_parts[++j2] = l_encoding.encode(this.m_binds[i3].toString());
                l_msgSize += l_parts[j2].length;
                ++j2;
                ++i3;
            }
            l_parts[j2] = l_encoding.encode(this.m_sqlFrags[this.m_binds.length]);
            this.pgStream.SendInteger((l_msgSize += l_parts[j2].length) + 1, 4);
            int k2 = 0;
            while (k2 < l_parts.length) {
                this.pgStream.Send(l_parts[k2]);
                ++k2;
            }
            this.pgStream.SendChar(0);
            this.pgStream.flush();
        }
        catch (IOException e2) {
            throw new PSQLException("postgresql.con.ioerror", PSQLState.CONNECTION_FAILURE_DURING_TRANSACTION, (Object)e2);
        }
    }

    private void sendQueryV2() throws SQLException {
        int i2 = 0;
        while (i2 < this.m_binds.length) {
            if (this.m_binds[i2] == null) {
                throw new PSQLException("postgresql.prep.param", PSQLState.INVALID_PARAMETER_VALUE, new Integer(i2 + 1));
            }
            ++i2;
        }
        try {
            this.pgStream.SendChar(81);
            int i3 = 0;
            while (i3 < this.m_binds.length) {
                this.pgStream.Send(this.connection.getEncoding().encode(this.m_sqlFrags[i3]));
                this.pgStream.Send(this.connection.getEncoding().encode(this.m_binds[i3].toString()));
                ++i3;
            }
            this.pgStream.Send(this.connection.getEncoding().encode(this.m_sqlFrags[this.m_binds.length]));
            this.pgStream.SendChar(0);
            this.pgStream.flush();
        }
        catch (IOException e2) {
            throw new PSQLException("postgresql.con.ioerror", PSQLState.CONNECTION_FAILURE_DURING_TRANSACTION, (Object)e2);
        }
    }

    private void receiveTupleV3() throws SQLException {
        if (this.fields == null) {
            throw new PSQLException("postgresql.con.tuple", PSQLState.CONNECTION_FAILURE);
        }
        byte[][] tuple = this.pgStream.ReceiveTupleV3(this.fields.length);
        if (this.maxRows == 0 || this.tuples.size() < this.maxRows) {
            this.tuples.addElement(tuple);
        }
    }

    private void receiveTupleV2(boolean isBinary) throws SQLException {
        if (this.fields == null) {
            throw new PSQLException("postgresql.con.tuple", PSQLState.CONNECTION_FAILURE);
        }
        byte[][] tuple = this.pgStream.ReceiveTupleV2(this.fields.length, isBinary);
        if (isBinary) {
            int i2 = 0;
            while (i2 < this.fields.length) {
                this.fields[i2].setFormat(1);
                ++i2;
            }
        }
        if (this.maxRows == 0 || this.tuples.size() < this.maxRows) {
            this.tuples.addElement(tuple);
        }
    }

    private void receiveCommandStatusV3() throws SQLException {
        int l_len = this.pgStream.ReceiveIntegerR(4);
        this.status = this.connection.getEncoding().decode(this.pgStream.Receive(l_len - 5));
        this.pgStream.Receive(1);
        try {
            if (this.status.startsWith("INSERT") || this.status.startsWith("UPDATE") || this.status.startsWith("DELETE") || this.status.startsWith("MOVE")) {
                this.update_count = Integer.parseInt(this.status.substring(1 + this.status.lastIndexOf(32)));
            }
            if (this.status.startsWith("INSERT")) {
                this.insert_oid = Long.parseLong(this.status.substring(1 + this.status.indexOf(32), this.status.lastIndexOf(32)));
            }
        }
        catch (NumberFormatException nfe) {
            throw new PSQLException("postgresql.con.fathom", PSQLState.CONNECTION_FAILURE, this.status);
        }
    }

    private void receiveCommandStatusV2() throws SQLException {
        this.status = this.pgStream.ReceiveString(this.connection.getEncoding());
        try {
            if (this.status.startsWith("INSERT") || this.status.startsWith("UPDATE") || this.status.startsWith("DELETE") || this.status.startsWith("MOVE")) {
                this.update_count = Integer.parseInt(this.status.substring(1 + this.status.lastIndexOf(32)));
            }
            if (this.status.startsWith("INSERT")) {
                this.insert_oid = Long.parseLong(this.status.substring(1 + this.status.indexOf(32), this.status.lastIndexOf(32)));
            }
        }
        catch (NumberFormatException nfe) {
            throw new PSQLException("postgresql.con.fathom", PSQLState.CONNECTION_FAILURE, this.status);
        }
    }

    private void receiveFieldsV3() throws SQLException {
        if (this.fields != null) {
            throw new PSQLException("postgresql.con.multres", PSQLState.CONNECTION_FAILURE);
        }
        int l_msgSize = this.pgStream.ReceiveIntegerR(4);
        int size = this.pgStream.ReceiveIntegerR(2);
        this.fields = new Field[size];
        int i2 = 0;
        while (i2 < this.fields.length) {
            String typeName = this.pgStream.ReceiveString(this.connection.getEncoding());
            int tableOid = this.pgStream.ReceiveIntegerR(4);
            int tablePosition = this.pgStream.ReceiveIntegerR(2);
            int typeOid = this.pgStream.ReceiveIntegerR(4);
            int typeLength = this.pgStream.ReceiveIntegerR(2);
            int typeModifier = this.pgStream.ReceiveIntegerR(4);
            int formatType = this.pgStream.ReceiveIntegerR(2);
            this.fields[i2] = new Field(this.connection, typeName, typeOid, typeLength, typeModifier);
            this.fields[i2].setFormat(formatType);
            ++i2;
        }
    }

    private void receiveFieldsV2() throws SQLException {
        if (this.fields != null) {
            throw new PSQLException("postgresql.con.multres", PSQLState.CONNECTION_FAILURE);
        }
        int size = this.pgStream.ReceiveIntegerR(2);
        this.fields = new Field[size];
        int i2 = 0;
        while (i2 < this.fields.length) {
            String typeName = this.pgStream.ReceiveString(this.connection.getEncoding());
            int typeOid = this.pgStream.ReceiveIntegerR(4);
            int typeLength = this.pgStream.ReceiveIntegerR(2);
            int typeModifier = this.pgStream.ReceiveIntegerR(4);
            this.fields[i2] = new Field(this.connection, typeName, typeOid, typeLength, typeModifier);
            ++i2;
        }
    }
}

