/*
 * Decompiled with CFR 0.152.
 */
package de.superx.util;

import de.memtext.util.DateUtils;
import de.memtext.util.StringUtils;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;

public class SqlStringUtils {
    public static final int bufSize = 32768;
    public static String maxRowsOrganigramm = "400";
    private static String COMM_START = "/*";
    private static String COMM_END = "*/";
    private static int COMM_START_LEN = COMM_START.length();
    private static int COMM_END_LEN = COMM_END.length();
    private static String COMMENT1_ANF = "{";
    private static String COMMENT1_END = "}";
    private static String COMMENT2_ANF = "--";
    private static String COMMENT2_END = "\n";
    private static String COMMENT3_ANF = "/*";
    private static String COMMENT3_END = "*/";
    private static String COMMENT1_ANF_MASK = "#K#";
    private static String COMMENT1_END_MASK = "#/K";
    private static String COMMENT2_ANF_MASK = "#S#";
    private static String COMMENT2_END_MASK = "#/S#";
    private static String COMMENT3_ANF_MASK = "#*A#";
    private static String COMMENT3_END_MASK = "#*E#";
    private static String PREV_POS = ">>";
    private static String PREV_POS_MASK = ">#>";
    private static String NEXT_POS = "<<";
    private static String NEXT_POS_MASK = "<#<";
    private static String SELECT_DELIMITER = ";";
    private static String SELECT_DELIMITER_MASK = "^";
    private static String STR_DELIMITER1 = "\"";
    private static String STR_DELIMITER1_MASK = "#s1#";
    private static String STR_DELIMITER2 = "'";
    private static String STR_DELIMITER2_MASK = "#s2#";
    private static String NEWLINE = "\\\n";
    private static String NEWLINE_MASK = "\\";

    public static String generateSQL(String databaseAbbr, Hashtable formular, String sql) {
        if (!databaseAbbr.equals("IDS") && !databaseAbbr.equals("PG")) {
            throw new IllegalArgumentException("Database Abbr must be IDS or PG not " + databaseAbbr);
        }
        sql = SqlStringUtils.noxmlout(sql);
        Enumeration en = formular.keys();
        while (en.hasMoreElements()) {
            String fieldname = (String)en.nextElement();
            String fieldvalue = formular.get(fieldname).toString();
            if (fieldvalue == null) continue;
            sql = SqlStringUtils.replace(sql, "<<" + fieldname + ">>", fieldvalue);
        }
        sql = sql.replaceAll("<<DATABASE_ABBR>>", databaseAbbr);
        sql = sql.replaceAll("<<Organigramm-Stand>>", "today()");
        sql = SqlStringUtils.removeComment(sql, "/*", "*/");
        sql = SqlStringUtils.removeComment(sql, "--", "\n");
        return sql;
    }

    private static String noxmlout(String sql_str) {
        while (sql_str != null && sql_str.indexOf("--notinxmlfrontend") > -1) {
            int pos = sql_str.indexOf("--notinxmlfrontend");
            String prev = sql_str.substring(0, pos);
            if (prev.lastIndexOf("/*") == -1) {
                throw new IllegalStateException("--notinxmlfrontend muss eingeschlossen sein von /* */, nicht " + sql_str);
            }
            prev = prev.substring(0, prev.lastIndexOf("/*") - 1);
            if (sql_str.indexOf("*/", pos) == -1) {
                throw new IllegalStateException("--notinxmlfrontend muss eingeschlossen sein von /* */, nicht " + sql_str);
            }
            String post = sql_str.substring(sql_str.indexOf("*/", pos) + 2);
            sql_str = String.valueOf(prev) + "\n" + post;
        }
        return sql_str;
    }

    public static String removeComment(String source, String commentStart, String commentEnd) {
        String searchFor = commentStart;
        int posCommentEnd = -1;
        int pos = -1;
        int offset = 0;
        int len = source.length();
        int search_len = searchFor.length();
        StringBuffer result = new StringBuffer();
        while (offset < len) {
            pos = source.indexOf(searchFor, offset);
            if (pos != -1) {
                if (pos > 0 && commentStart.equals("{") && source.charAt(pos - 1) == '$') {
                    result.append(source.substring(offset, pos + 1));
                    offset = pos + 1;
                    continue;
                }
                String chunk = source.substring(offset, pos);
                posCommentEnd = source.indexOf(commentEnd, pos + search_len);
                if (posCommentEnd == -1) {
                    posCommentEnd = source.length() - 1;
                }
                result.append(chunk);
                offset = posCommentEnd + commentEnd.length();
                continue;
            }
            result.append(source.substring(offset, len));
            offset = len;
        }
        return result.toString();
    }

    private static String replace(String str, String search_str, String replace_str) {
        StringBuffer buffer = new StringBuffer(32768);
        boolean delete_comment = false;
        int pos = -1;
        int offset = 0;
        int len = str.length();
        int search_len = search_str.length();
        int comm_start = -1;
        int comm_end = -1;
        int prev_pos = -1;
        int next_pos = -1;
        int mode = -1;
        try {
            delete_comment = replace_str.equals("");
            block7: while (offset < len) {
                mode = -1;
                pos = str.indexOf(search_str, offset);
                if (pos != -1) {
                    String prev_str = str.substring(offset, pos);
                    comm_start = prev_str.lastIndexOf(COMM_START);
                    prev_pos = prev_str.lastIndexOf(PREV_POS);
                    comm_end = str.indexOf(COMM_END, pos + search_len);
                    next_pos = str.indexOf(NEXT_POS, pos + search_len);
                    if (comm_start >= 0 && prev_pos >= 0 && comm_start < prev_pos) {
                        comm_start = -1;
                    }
                    if (comm_end >= 0 && next_pos >= 0 && comm_end > next_pos) {
                        comm_end = -1;
                    }
                    mode = comm_start != -1 && comm_end != -1 && comm_start <= pos && comm_end >= pos ? (delete_comment ? 2 : 1) : 0;
                    switch (mode) {
                        case 0: {
                            buffer.append(prev_str);
                            buffer.append(replace_str);
                            offset = pos + search_len;
                            continue block7;
                        }
                        case 1: {
                            buffer.append(prev_str.substring(0, comm_start));
                            buffer.append(prev_str.substring(comm_start + COMM_START_LEN));
                            buffer.append(replace_str);
                            buffer.append(str.substring(pos + search_len, comm_end));
                            offset = comm_end + COMM_END_LEN;
                            continue block7;
                        }
                        case 2: {
                            buffer.append(prev_str.substring(0, comm_start));
                            offset = comm_end + COMM_END_LEN;
                            continue block7;
                        }
                        default: {
                            throw new IllegalArgumentException("replace comment fehlgeschlagen");
                        }
                    }
                }
                buffer.append(str.substring(offset, len));
                offset = len;
            }
        }
        catch (Exception e2) {
            buffer.append("--ERROR--");
            buffer.append(search_str);
        }
        return buffer.toString();
    }

    public static Vector getHeader(String str) {
        Vector<String> header = new Vector<String>();
        int pos = 0;
        int end_pos = 0;
        int offset = 0;
        int len = str.length();
        String search_str = "heading_text=\"";
        String header_str = null;
        int search_len = search_str.length();
        while (offset < len) {
            pos = str.indexOf(search_str, offset);
            if (pos == -1 || (end_pos = str.indexOf("\"", pos + search_len)) == -1) break;
            header_str = str.substring(pos + search_len, end_pos);
            header.addElement(header_str);
            offset = pos + search_len + header_str.length() + 1;
        }
        return header;
    }

    public static String escapeString(String str) {
        StringBuffer escapeBuffer = new StringBuffer(str);
        StringUtils.replace(escapeBuffer, PREV_POS, PREV_POS_MASK);
        StringUtils.replace(escapeBuffer, NEXT_POS, NEXT_POS_MASK);
        StringUtils.replace(escapeBuffer, SELECT_DELIMITER, SELECT_DELIMITER_MASK);
        StringUtils.replace(escapeBuffer, STR_DELIMITER1, STR_DELIMITER1_MASK);
        StringUtils.replace(escapeBuffer, STR_DELIMITER2, STR_DELIMITER2_MASK);
        StringUtils.replace(escapeBuffer, COMMENT1_ANF, COMMENT1_ANF_MASK);
        StringUtils.replace(escapeBuffer, COMMENT2_ANF, COMMENT2_ANF_MASK);
        StringUtils.replace(escapeBuffer, COMMENT3_ANF, COMMENT3_ANF_MASK);
        StringUtils.replace(escapeBuffer, COMMENT1_END, COMMENT1_END_MASK);
        StringUtils.replace(escapeBuffer, COMMENT3_END, COMMENT3_END_MASK);
        return escapeBuffer.toString();
    }

    public static String unescapeString(String str) {
        StringBuffer unescapeBuffer = new StringBuffer(str);
        StringUtils.replace(unescapeBuffer, PREV_POS_MASK, PREV_POS);
        StringUtils.replace(unescapeBuffer, NEXT_POS_MASK, NEXT_POS);
        StringUtils.replace(unescapeBuffer, NEWLINE_MASK, NEWLINE);
        StringUtils.replace(unescapeBuffer, STR_DELIMITER1_MASK, STR_DELIMITER1);
        StringUtils.replace(unescapeBuffer, STR_DELIMITER2_MASK, "\\'");
        StringUtils.replace(unescapeBuffer, COMMENT1_ANF_MASK, COMMENT1_ANF);
        StringUtils.replace(unescapeBuffer, COMMENT2_ANF_MASK, COMMENT2_ANF);
        StringUtils.replace(unescapeBuffer, COMMENT3_ANF_MASK, COMMENT3_ANF);
        StringUtils.replace(unescapeBuffer, COMMENT1_END_MASK, COMMENT1_END);
        StringUtils.replace(unescapeBuffer, COMMENT3_END_MASK, COMMENT3_END);
        return unescapeBuffer.toString();
    }

    public static String escapeSpecialChars(String str) {
        if (str.equals("") || str == null) {
            return null;
        }
        StringBuffer escapeSpecialChars = new StringBuffer(str);
        StringUtils.replace(escapeSpecialChars, SELECT_DELIMITER, "\\" + SELECT_DELIMITER);
        StringUtils.replace(escapeSpecialChars, STR_DELIMITER1, "\\" + STR_DELIMITER1);
        StringUtils.replace(escapeSpecialChars, STR_DELIMITER2, "\\" + STR_DELIMITER2);
        if (escapeSpecialChars.toString().endsWith("\\")) {
            escapeSpecialChars.setLength(escapeSpecialChars.length() - 1);
        }
        return escapeSpecialChars.toString();
    }

    public static String getValueAsString(Object value) {
        String field_type = "";
        String f_wert = "";
        String fehler = "";
        try {
            f_wert = value instanceof Date ? DateFormat.getDateInstance(2, Locale.GERMANY).format(value) : (value instanceof Timestamp ? DateFormat.getDateTimeInstance(2, 2, Locale.GERMANY).format(value) : (value instanceof Time ? DateFormat.getTimeInstance(2, Locale.GERMANY).format(value) : value.toString()));
        }
        catch (Exception e2) {
            fehler = e2.toString();
            f_wert = fehler.equals("java.lang.NullPointerException") ? "" : "Feldtyp unbekannt:" + fehler;
        }
        return f_wert;
    }

    public static String adaptSql(String sqlDialect, String feldwert, String attribut) {
        String stmt = "";
        stmt = feldwert;
        if (feldwert.startsWith("sp_")) {
            feldwert = sqlDialect.equals("Informix") ? "<<SQL>> execute procedure " + feldwert : "<<SQL>> select " + feldwert;
        }
        if (feldwert.startsWith("<<SQL>>")) {
            stmt = feldwert.substring(7);
        } else if (attribut != null && !attribut.trim().equals("")) {
            if (attribut.indexOf(44) == -1) {
                attribut = "tid, " + attribut;
            }
            stmt = "select " + attribut + " from " + feldwert + " order by 2";
        } else if (feldwert != null && !feldwert.trim().equals("")) {
            stmt = "select '" + feldwert + "' from xdummy;";
        }
        return stmt;
    }

    public static String createRelationString(String sqlDialect, String feldart, String feldwert, String attribut) {
        String stmt = "";
        if (feldwert != null && !feldwert.equals("")) {
            stmt = SqlStringUtils.adaptSql(sqlDialect, feldwert, attribut);
        }
        if (feldart.equals("4")) {
            stmt = SqlStringUtils.getOrganigrammSql(sqlDialect, "<<UserID>>", DateUtils.getTodayString(), 0);
        }
        if (feldart.equals("6") || feldart.equals("12")) {
            stmt = SqlStringUtils.getOrganigrammSql(sqlDialect, "<<UserID>>", DateUtils.getTodayString(), 1);
        }
        if (feldart.equals("7")) {
            stmt = SqlStringUtils.getOrganigrammSql(sqlDialect, "<<UserID>>", DateUtils.getTodayString(), 2);
        }
        return stmt;
    }

    private static String getOrganigrammSql(String sqlDialect, String userid, String lStand, int llehre) {
        if (lStand == null) {
            lStand = DateUtils.getTodayString();
        }
        int einschraenkungLehre = llehre;
        String prozedur = "SELECT organigramm.parent, organigramm.key_apnr, organigramm.name FROM organigramm WHERE gueltig_seit < date('" + DateUtils.getTodayString() + "') And gueltig_bis> date('" + DateUtils.getTodayString() + "') ORDER BY organigramm.name;";
        if (sqlDialect.equals("Informix")) {
            prozedur = "execute procedure sp_user_orga(" + userid + ",date('" + lStand + "')," + einschraenkungLehre + "); execute procedure sp_filter_orga(" + maxRowsOrganigramm + "); select name, key_apnr, parent, erlaubt from tmp_organigramm; drop table tmp_organigramm;";
        } else if (sqlDialect.equals("Postgres")) {
            prozedur = "select sp_user_orga(" + userid + ",date_val('" + lStand + "')," + einschraenkungLehre + "); select sp_filter_orga(" + maxRowsOrganigramm + "); select name, key_apnr, parent,  erlaubt from tmp_organigramm; drop table tmp_organigramm;";
        }
        return prozedur;
    }

    public static void main(String[] args) {
        System.out.println(SqlStringUtils.noxmlout("11764^Projekt^4^0^0^100^300^1^char^4^0^1^<<SQL>> /* execute procedure sp_user_orga_child(<<UserID>>,mdy (1, 1,year(<<Organigramm-Stand>>)),<<Organigramm-Sicht>>,<<Institution>>, <<erlaubt>>); --notinxmlfrontend */ /* execute procedure sp_user_orga(<<UserID>>,mdy (1, 1,year<<Organigramm-Stand>>)),<<Organigramm-Sicht>>); --notinapplet */ select distinct fb, fb ||  || ktobez from mbs_projekte_konto where 1=1 and inst_nr in (select ch110_institut from tmp_ch110_institut) /* and dr in (<<Deckungsring>>)  */ /* and jahr = <<Haushaltsjahr>> */ /* and kap in (<<Kapitel>>) */ order by 2;^ ^^"));
    }

    public static String getEncoding() {
        String res = "ISO-8859-1";
        if (System.getProperty("file.encoding").equalsIgnoreCase("utf-8")) {
            res = "UTF-8";
        }
        return res;
    }

    public static String getSqlDialect(String driver) {
        String driverName = driver.toLowerCase();
        String sqlDialect = "ansi";
        if (driverName.indexOf("postgres") > -1) {
            sqlDialect = "Postgres";
        } else if (driverName.indexOf("informix") > -1) {
            sqlDialect = "Informix";
        } else if (driverName.indexOf("hsqldb") > -1) {
            sqlDialect = "Hsqldb";
        }
        return sqlDialect;
    }
}

