/*
 * Decompiled with CFR 0.152.
 */
package de.superx.servlet;

import de.memtext.baseobjects.coll.NamedObjectList;
import de.memtext.util.XMLUtils;
import de.superx.common.SuperX_el;
import de.superx.common.SxResultRow;
import de.superx.common.SxResultSet;
import de.superx.servlet.SuperXManager;
import de.superx.util.SqlStringUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SxSQL_Server {
    private String mandantenID = "default";
    private int updateCount = -1;
    private int numberOfColumns = -1;
    private NamedObjectList preparedstatements;
    private ResultSetMetaData metaData;

    public SxSQL_Server(String mandantenID) {
        this.mandantenID = mandantenID;
        XMLUtils.getExceptionHandler().setExitWanted(false);
    }

    public synchronized void executeQuery(String query, Connection connection, SuperX_el gesamt) throws SQLException {
        SxResultSet rows = new SxResultSet();
        Statement statement = connection.createStatement();
        statement.setMaxRows(SuperXManager.maxRows);
        String value = "";
        Logger.getLogger("superx_" + this.mandantenID).log(Level.INFO, "Abfrage ausf\u00fchren:" + query);
        try {
            ResultSet resultSet = statement.executeQuery(query);
            this.metaData = resultSet.getMetaData();
            this.numberOfColumns = this.metaData.getColumnCount();
            String[] columnName = new String[this.numberOfColumns];
            String[] columnLabel = new String[this.numberOfColumns];
            int[] columnDisplaySize = new int[this.numberOfColumns];
            int[] columnType = new int[this.numberOfColumns];
            int[] scales = new int[this.numberOfColumns];
            boolean[] isWritable = new boolean[this.numberOfColumns];
            int column = 0;
            while (column < this.numberOfColumns) {
                columnName[column] = this.metaData.getColumnName(column + 1);
                ++column;
            }
            column = 0;
            while (column < this.numberOfColumns) {
                columnLabel[column] = this.metaData.getColumnLabel(column + 1);
                ++column;
            }
            column = 0;
            while (column < this.numberOfColumns) {
                columnDisplaySize[column] = this.metaData.getColumnDisplaySize(column + 1);
                ++column;
            }
            column = 0;
            while (column < this.numberOfColumns) {
                columnType[column] = this.adaptColumType(this.metaData.getColumnType(column + 1));
                ++column;
            }
            column = 0;
            while (column < this.numberOfColumns) {
                scales[column] = this.metaData.getScale(column + 1);
                ++column;
            }
            column = 0;
            while (column < this.numberOfColumns) {
                isWritable[column] = this.metaData.isWritable(column + 1);
                ++column;
            }
            int naturalOrderNo = 1;
            while (resultSet.next()) {
                SxResultRow newRow = new SxResultRow(this.numberOfColumns, naturalOrderNo++);
                int i2 = 0;
                while (i2 < this.numberOfColumns) {
                    switch (this.metaData.getColumnType(i2 + 1)) {
                        case 1: 
                        case 12: {
                            String s;
                            try {
                                s = resultSet.getString(i2 + 1);
                                value = s == null ? "" : s.trim();
                            }
                            catch (Exception e2) {
                                value = "";
                                Logger.getLogger("superx_" + this.mandantenID).log(Level.INFO, "char-feld " + columnName[i2] + " konnte nicht ausgewertet werden:" + e2.toString());
                            }
                            if (value == null || value.equals("null")) {
                                newRow.add(new String(""));
                                break;
                            }
                            newRow.add(value);
                            break;
                        }
                        case -1: {
                            String s;
                            try {
                                s = resultSet.getString(i2 + 1);
                                value = s == null ? "" : s.trim();
                            }
                            catch (Exception e3) {
                                value = "";
                                Logger.getLogger("superx_" + this.mandantenID).log(Level.INFO, "Blob " + columnName[i2] + " konnte nicht ausgewertet werden:" + e3.toString());
                            }
                            if (value == null || value.equals("null")) {
                                newRow.add(new String(""));
                                break;
                            }
                            newRow.add(value);
                            break;
                        }
                        case 4: {
                            try {
                                newRow.add(resultSet.getObject(i2 + 1));
                            }
                            catch (Exception e4) {
                                Logger.getLogger("superx_" + this.mandantenID).log(Level.INFO, "Integer " + columnName[i2] + " konnte nicht ausgewertet werden:" + e4.toString());
                                newRow.add(null);
                            }
                            break;
                        }
                        case 91: {
                            Object myObj;
                            try {
                                myObj = resultSet.getObject(i2 + 1);
                                newRow.add(myObj);
                            }
                            catch (Exception e5) {
                                Logger.getLogger("superx_" + this.mandantenID).log(Level.INFO, "Datum " + columnName[i2] + " konnte nicht ausgewertet werden:" + e5.toString());
                                newRow.add(null);
                            }
                            break;
                        }
                        case 93: {
                            Object myObj;
                            try {
                                myObj = resultSet.getObject(i2 + 1);
                                newRow.add(myObj);
                            }
                            catch (Exception e6) {
                                Logger.getLogger("superx_" + this.mandantenID).log(Level.INFO, "Timestamp " + columnName[i2] + " konnte nicht ausgewertet werden:" + e6.toString());
                                newRow.add(null);
                            }
                            break;
                        }
                        default: {
                            try {
                                newRow.add(resultSet.getObject(i2 + 1));
                                break;
                            }
                            catch (Exception e7) {
                                Logger.getLogger("superx_" + this.mandantenID).log(Level.INFO, "Unbekanntes Objekt " + columnName[i2] + " konnte nicht ausgewertet werden:" + e7.toString());
                                newRow.add(null);
                            }
                        }
                    }
                    ++i2;
                }
                rows.add(newRow);
            }
            gesamt.setColumnCount(this.numberOfColumns);
            gesamt.setAndAdaptColumnNames(columnName);
            gesamt.setColumnLabels(columnLabel);
            gesamt.setColumnDisplaySizes(columnDisplaySize);
            gesamt.setColumnTypes(columnType);
            gesamt.setScales(scales);
            gesamt.setisWritable(isWritable);
            gesamt.setRows(rows);
            if (resultSet != null) {
                resultSet.close();
            }
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException e8) {
            Logger.getLogger("superx_" + this.mandantenID).log(Level.INFO, e8.toString());
            gesamt.setError_String(e8.toString());
        }
        catch (Exception e9) {
            Logger.getLogger("superx_" + this.mandantenID).log(Level.INFO, "Allgemeiner Fehler beim DB-Zugriff:" + e9.toString());
            gesamt.setError_String(e9.toString());
        }
    }

    private synchronized void executePst(PreparedStatement pst, String args) throws NumberFormatException, SQLException {
        int i2 = args.indexOf("<pstexec>");
        int i22 = args.indexOf("</pstexec>");
        if (i2 == -1 || i22 == -1) {
            throw new IllegalArgumentException("<pstexec> nicht XML konform definiert");
        }
        XMLUtils.getExceptionHandler().setExitWanted(false);
        Document doc = null;
        try {
            doc = XMLUtils.buildDocumentFromString2(args, false);
        }
        catch (Exception e2) {
            System.err.println(args);
            throw new SQLException("Xml-Parsingproblem " + e2);
        }
        if (doc != null) {
            NodeList list = doc.getElementsByTagName("arg");
            i2 = 0;
            while (i2 < list.getLength()) {
                Node n = list.item(i2);
                String no = XMLUtils.getAttribValue(n, "no");
                String datatype = "string";
                if (XMLUtils.hasAttrib(n, "type")) {
                    datatype = XMLUtils.getAttribValue(n, "type");
                }
                String val = XMLUtils.getTheValue(n);
                pst.setString(Integer.parseInt(no), val);
                ++i2;
            }
            int rows = pst.executeUpdate();
            System.out.println(String.valueOf(rows) + " r");
        }
    }

    synchronized void executeALL(String query, Connection connection, SuperX_el gesamt) throws SQLException {
        gesamt.setAktuelleNachricht("");
        gesamt.setError_String("");
        if (SuperXManager.isDevelopmentMode || query.indexOf("--Abfrage") <= -1) {
            StringTokenizer st = new StringTokenizer(query, ";");
            int n = 0;
            while (st.hasMoreTokens()) {
                ++n;
                String sqlstmt = st.nextToken().trim();
                if (sqlstmt.length() < 5) continue;
                sqlstmt = SqlStringUtils.unescapeString(sqlstmt);
                this.execute(sqlstmt, connection, gesamt);
                String errorstring = gesamt.getError_String();
                if (errorstring.equals("")) continue;
                String msg = String.valueOf(errorstring) + " bei sql-statement Nr " + n + " " + sqlstmt;
                throw new SQLException(msg);
            }
        } else {
            int pos = query.lastIndexOf("select");
            if (query.lastIndexOf("Select") > pos) {
                pos = query.lastIndexOf("Select");
            }
            if (query.lastIndexOf("SELECT") > pos) {
                pos = query.lastIndexOf("SELECT");
            }
            String hauptteil = query.substring(0, pos);
            String rest = query.substring(pos);
            Statement stm = connection.createStatement();
            StringTokenizer st = new StringTokenizer(hauptteil, ";");
            int tokennr = 0;
            int totallength = 0;
            while (st.hasMoreTokens()) {
                ++tokennr;
                String sqlstmt = st.nextToken().trim();
                totallength += sqlstmt.length();
                if (sqlstmt.length() > 5) {
                    stm.addBatch(sqlstmt);
                }
                if (totallength <= 30000) continue;
                stm.executeBatch();
                stm.clearBatch();
            }
            stm.executeBatch();
            stm.close();
            Logger.getLogger("superx_" + this.mandantenID).log(Level.FINE, "Hauptteil ausgef\u00fchrt");
            this.execute(rest, connection, gesamt);
        }
    }

    synchronized void execute(String query, Connection connection, SuperX_el gesamt) throws SQLException {
        SxResultSet rows = new SxResultSet();
        Statement statement = connection.createStatement();
        statement.setMaxRows(SuperXManager.maxRows);
        StringTokenizer st = new StringTokenizer(query, ";");
        int n = 0;
        while (st.hasMoreTokens()) {
            ++n;
            String sqlstmt = st.nextToken().trim();
            if (sqlstmt.length() < 5) continue;
            Level l2 = Level.INFO;
            if (sqlstmt.indexOf("sx_captions") > -1) {
                l2 = Level.FINEST;
            }
            Logger.getLogger("superx_" + this.mandantenID).log(l2, "sql-Abfrage ausf\u00fchren:" + sqlstmt);
            try {
                if (statement.execute(sqlstmt)) {
                    ResultSet resultSet = statement.getResultSet();
                    this.metaData = resultSet.getMetaData();
                    this.numberOfColumns = this.metaData.getColumnCount();
                    String[] columnNames = new String[this.numberOfColumns];
                    String[] columnLabel = new String[this.numberOfColumns];
                    int[] columnDisplaySize = new int[this.numberOfColumns];
                    int[] columnType = new int[this.numberOfColumns];
                    int[] Scale = new int[this.numberOfColumns];
                    boolean[] isWritable = new boolean[this.numberOfColumns];
                    int column = 0;
                    while (column < this.numberOfColumns) {
                        columnNames[column] = this.metaData.getColumnName(column + 1);
                        ++column;
                    }
                    column = 0;
                    while (column < this.numberOfColumns) {
                        columnLabel[column] = this.metaData.getColumnLabel(column + 1);
                        ++column;
                    }
                    column = 0;
                    while (column < this.numberOfColumns) {
                        columnDisplaySize[column] = this.metaData.getColumnDisplaySize(column + 1);
                        ++column;
                    }
                    column = 0;
                    while (column < this.numberOfColumns) {
                        columnType[column] = this.adaptColumType(this.metaData.getColumnType(column + 1));
                        ++column;
                    }
                    column = 0;
                    while (column < this.numberOfColumns) {
                        Scale[column] = this.metaData.getScale(column + 1);
                        ++column;
                    }
                    column = 0;
                    while (column < this.numberOfColumns) {
                        isWritable[column] = this.metaData.isWritable(column + 1);
                        ++column;
                    }
                    int naturalOrderNo = 1;
                    while (resultSet.next()) {
                        SxResultRow newRow = this.addRow(naturalOrderNo++, resultSet, columnNames);
                        rows.add(newRow);
                    }
                    gesamt.setColumnCount(this.numberOfColumns);
                    gesamt.setAndAdaptColumnNames(columnNames);
                    gesamt.setColumnLabels(columnLabel);
                    gesamt.setColumnDisplaySizes(columnDisplaySize);
                    gesamt.setColumnTypes(columnType);
                    gesamt.setScales(Scale);
                    gesamt.setisWritable(isWritable);
                    gesamt.setRows(rows);
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    this.updateCount = -1;
                } else {
                    this.updateCount = statement.getUpdateCount();
                }
            }
            catch (SQLException e2) {
                Logger.getLogger("superx_" + this.mandantenID).log(Level.INFO, e2.toString());
                gesamt.setError_String(e2.toString());
            }
            catch (Exception e3) {
                Logger.getLogger("superx_" + this.mandantenID).log(Level.INFO, "Allgemeiner Fehler beim DB-Zugriff:" + e3.toString());
                gesamt.setError_String(e3.toString());
            }
            gesamt.setUpdateCount(this.updateCount);
        }
        if (statement != null) {
            statement.close();
        }
    }

    /*
     * Unable to fully structure code
     */
    private SxResultRow addRow(int naturalOrderNo, ResultSet resultSet, String[] columnName) throws SQLException {
        newRow = new SxResultRow(this.numberOfColumns, naturalOrderNo);
        i = 0;
        while (i < this.numberOfColumns) {
            switch (this.metaData.getColumnType(i + 1)) {
                case 1: 
                case 12: {
                    try {
                        value = resultSet.getString(i + 1);
                    }
                    catch (Exception e) {
                        value = "";
                        Logger.getLogger("superx_" + this.mandantenID).log(Level.WARNING, "Textfeld " + columnName[i] + " konnte nicht ausgewertet werden:" + e.toString());
                    }
                    if (value == null || value.equals("null")) {
                        newRow.add(new String(""));
                        break;
                    }
                    newRow.add(value.trim());
                    break;
                }
                case -1: {
                    try {
                        value = resultSet.getString(i + 1);
                    }
                    catch (Exception e) {
                        value = "";
                        Logger.getLogger("superx_" + this.mandantenID).log(Level.WARNING, "Blob " + columnName[i] + " konnte nicht ausgewertet werden:" + e.toString());
                    }
                    if (value == null || value.equals("null")) {
                        newRow.add(new String(""));
                        break;
                    }
                    newRow.add(value.trim());
                    break;
                }
                case 4: {
                    try {
                        newRow.add(resultSet.getObject(i + 1));
                    }
                    catch (Exception e) {
                        Logger.getLogger("superx_" + this.mandantenID).log(Level.WARNING, "Integer " + columnName[i] + " konnte nicht ausgewertet werden:" + e.toString());
                        newRow.add(null);
                    }
                    break;
                }
                case 2: {
                    try {
                        myNum = resultSet.getBigDecimal(i + 1);
                        newRow.add(myNum);
                    }
                    catch (Exception e) {
                        Logger.getLogger("superx_" + this.mandantenID).log(Level.WARNING, "Numeric " + columnName[i] + " konnte nicht ausgewertet werden:" + e.toString());
                        newRow.add(null);
                    }
                    break;
                }
                case 93: {
                    try {
                        myObj = resultSet.getObject(i + 1);
                        Logger.getLogger("superx_" + this.mandantenID).log(Level.INFO, "Objekt: " + myObj.toString());
                        newRow.add(myObj);
                    }
                    catch (Exception e) {
                        Logger.getLogger("superx_" + this.mandantenID).log(Level.WARNING, "Timestamp " + columnName[i] + " konnte nicht ausgewertet werden:" + e.toString());
                        newRow.add("");
                    }
                    break;
                }
                case 91: {
                    myObj = null;
                    try {
                        myObj = resultSet.getDate(i + 1);
                        newRow.add(myObj);
                        break;
                    }
                    catch (Exception e) {
                        System.out.println("myObj " + myObj + " i:" + i + " columncount:" + resultSet.getMetaData().getColumnCount());
                        ix = 0;
                        ** while (ix < resultSet.getMetaData().getColumnCount())
                    }
lbl-1000:
                    // 1 sources

                    {
                        System.out.println(String.valueOf(resultSet.getMetaData().getColumnName(ix + 1)) + " " + resultSet.getMetaData().getColumnTypeName(ix + 1));
                        ++ix;
                        continue;
                    }
lbl80:
                    // 1 sources

                    Logger.getLogger("superx_" + this.mandantenID).log(Level.WARNING, "Datum " + columnName[i] + " konnte nicht ausgewertet werden:" + e.toString());
                    newRow.add("Fehler beim Datum einlesen");
                    break;
                }
                default: {
                    try {
                        newRow.add(resultSet.getObject(i + 1));
                        break;
                    }
                    catch (Exception e) {
                        Logger.getLogger("superx_" + this.mandantenID).log(Level.WARNING, "Unbekanntes Objekt " + columnName[i] + " konnte nicht ausgewertet werden:" + e.toString());
                        newRow.add(null);
                    }
                }
            }
            ++i;
        }
        return newRow;
    }

    public void cancel() throws Exception {
        try {
            System.err.println("SxSQL: Cancel statement");
        }
        catch (Exception e2) {
            System.err.println("SxSQL: Error canceling statement: " + e2);
        }
        throw new UnsupportedOperationException("");
    }

    public void cancel(String url, String user, String passwd) throws Exception {
        try {
            System.err.println("SxSQL: Cancel statement");
        }
        catch (Exception e2) {
            System.err.println("SxSQL: Error canceling statement: " + e2);
        }
        throw new UnsupportedOperationException("");
    }

    public int adaptColumType(int rsColType) {
        int returnType;
        switch (rsColType) {
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                returnType = 4;
                break;
            }
            case 16: {
                returnType = -7;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                returnType = 3;
                break;
            }
            case 91: {
                returnType = 6;
                break;
            }
            case 93: {
                returnType = 8;
                break;
            }
            case 92: {
                returnType = 9;
                break;
            }
            default: {
                returnType = 1;
            }
        }
        return returnType;
    }
}

