/*
 * Decompiled with CFR 0.152.
 */
package de.superx.common;

import de.memtext.baseobjects.NamedIdObject;
import de.memtext.baseobjects.coll.NamedIdObjectList;
import de.memtext.tree.KeyParentEqualException;
import de.memtext.tree.NoMainEntryException;
import de.memtext.util.DateUtils;
import de.memtext.util.EqualsUtil;
import de.memtext.util.ServletHelper;
import de.memtext.util.StringUtils;
import de.memtext.util.TimeUtils;
import de.memtext.util.XMLUtils;
import de.superx.common.ChartCreator;
import de.superx.common.DBServletException;
import de.superx.common.Field;
import de.superx.common.FieldContainer;
import de.superx.common.FieldXmlEncoder;
import de.superx.common.GraphicFormat;
import de.superx.common.HeaderManager;
import de.superx.common.InvalidDataTypeException;
import de.superx.common.InvalidKeyException;
import de.superx.common.ObligatoryFieldEmptyException;
import de.superx.common.RepositoryItemCollection;
import de.superx.common.SelectableItem;
import de.superx.common.SelectableItemNode;
import de.superx.common.SharedData;
import de.superx.common.SichtException;
import de.superx.common.Stylesheet;
import de.superx.common.SuperX_el;
import de.superx.common.SxResultRow;
import de.superx.common.SxResultSet;
import de.superx.common.SxUser;
import de.superx.common.TranslationContainer;
import de.superx.common.TransletCache;
import de.superx.common.UngueltigeEingabeException;
import de.superx.common.XMLResultCreator;
import de.superx.servlet.ServletUtils;
import de.superx.servlet.SuperXManager;
import de.superx.servlet.SxPools;
import de.superx.util.SqlStringUtils;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class Maske
extends NamedIdObject
implements Serializable {
    private String mandantenID = "default";
    private boolean isResultReuseFeatureWanted = true;
    private String schleifenrelation;
    private String schleifenfeldname;
    private String schleifenfstand;
    private String schleifenfsicht;
    private String aktion;
    private String select_stmt = "";
    private String cleanup_stmt = "";
    private String xilString = "";
    private String chartx = "";
    private String charty = "";
    private String standString = "";
    private String desiredContenttype = "";
    private HashMap map = new HashMap();
    private boolean isMakroSubMaske = false;
    private String selectedMaskStylesheetFile = null;
    private Stylesheet selectedTableStylesheet = null;
    private SharedData sharedData = new SharedData();
    private FieldContainer individualFields = new FieldContainer();
    private List maskStylesheetList = new LinkedList();
    private List tableStylesheetList = new LinkedList();
    private SuperX_el result_el = new SuperX_el();
    private String lastExecuted;
    private String lastHeaderXml = "";
    private int offset;
    private String colset;
    private int maxOffset;
    private static final long serialVersionUID = 1L;
    private String browser = "";
    private boolean isReuseResult = false;
    private Integer sortNr;
    private NamedIdObjectList submaskenListe = new NamedIdObjectList();
    private Locale locale;
    private String maskHtml;
    private StringBuffer lastXmlResult;
    private static final int MACRO_MAX_OFFSET = 10000;
    private String explanation;
    private String hinweis = "";
    private String hinweisCaption = "";
    private String colsort = null;
    private HeaderManager headerManager = new HeaderManager();

    private Maske() {
        this.locale = TranslationContainer.defaultLocale;
    }

    public Maske(String mandantenID, SxUser user, Integer tid, Locale locale) throws TransformerConfigurationException, TemplateException, KeyParentEqualException, CloneNotSupportedException, SichtException, IOException, SQLException, DBServletException, NoMainEntryException {
        Logger.getLogger("superx_" + mandantenID).log(Level.FINE, "Aufbau der Maske " + tid + " " + DateUtils.getNowString());
        this.mandantenID = mandantenID;
        this.setId(tid);
        this.setLocale(locale);
        this.initFromMaskeninfo();
        NamedIdObjectList fields = this.readFelderFromDb(user);
        this.individualFields.addAll((Collection)fields);
        this.initMaskStylesheets();
        this.initTableStylesheets();
        this.initSubMasken(user);
    }

    private Maske(String mandantenID, SxUser user, SharedData sharedData, SxResultRow singleSubMaskRow, Locale locale) throws TemplateException, KeyParentEqualException, CloneNotSupportedException, SichtException, IOException, SQLException, DBServletException, NoMainEntryException {
        this.mandantenID = mandantenID;
        this.locale = locale;
        this.isResultReuseFeatureWanted = true;
        this.setName(singleSubMaskRow.get(0).toString());
        this.setId(singleSubMaskRow.get(1));
        this.setSchleifenrelation(singleSubMaskRow.get(2));
        this.setSchleifenfeldname(singleSubMaskRow.get(3));
        this.setSchleifenfstand((String)singleSubMaskRow.get(4));
        this.setSchleifenfsicht((String)singleSubMaskRow.get(5));
        if (this.getSchleifenrelation() != null && this.getSchleifenfeldname() == null) {
            throw new IllegalStateException("Bei der Maske " + this.getId() + " ist in makro_masken_bez kein Schleifenfeldname f\u00fcr die Schleife angegeben");
        }
        if (this.getSchleifenrelation() == null && this.getSchleifenfeldname() != null) {
            throw new IllegalStateException("Bei der Maske " + this.getId() + " ist in makro_masken_bez keine Schleifenrelation f\u00fcr die Schleife");
        }
        this.setAktion(singleSubMaskRow.get(6));
        this.setSortNr(new Integer(singleSubMaskRow.get(7).toString()));
        this.initFromMaskeninfo();
        this.sharedData = sharedData;
        this.individualFields.addAll((Collection)this.readFelderFromDb(user));
        this.initSubMasken(user);
    }

    public String getAktion() {
        if (this.aktion == null || this.aktion.toString().trim().equals("")) {
            this.aktion = "SHOWTABLE";
        }
        return this.aktion;
    }

    public void setAktion(Object aktion) {
        this.aktion = aktion == null || aktion.toString().trim().equals("") ? "SHOWTABLE" : aktion.toString().toUpperCase();
    }

    private String getSchleifenfeldname() {
        return this.schleifenfeldname;
    }

    private void setSchleifenfeldname(Object schleifenfeldname) {
        this.schleifenfeldname = schleifenfeldname == null || schleifenfeldname.toString().trim().equals("") ? null : schleifenfeldname.toString();
    }

    private String getSchleifenrelation() {
        return this.schleifenrelation;
    }

    public Collection getTmpFiles() {
        return this.sharedData.getGraphicFiles();
    }

    private void setSchleifenrelation(Object schleifenrelation) {
        this.schleifenrelation = schleifenrelation == null || schleifenrelation.toString().trim().equals("") ? null : schleifenrelation.toString();
    }

    public String getDesiredContenttype() {
        return this.desiredContenttype;
    }

    public void setDesiredContenttype(String desiredContenttype) {
        this.desiredContenttype = desiredContenttype;
    }

    private NamedIdObjectList readFelderFromDb(SxUser user) throws TemplateException, KeyParentEqualException, CloneNotSupportedException, SichtException, IOException, SQLException, DBServletException, NoMainEntryException {
        if (this.getId() == null) {
            throw new IllegalStateException("Kann keine Maske ohne tid vorbereiten");
        }
        NamedIdObjectList felder = new NamedIdObjectList();
        String query = "select F.tid, F.name, F.nummer, F.x, F.y, F.buttonbreite, F.feldbreite, F.zeilenanzahl, F.typ, F.laenge, F.obligatorisch, F.art, F.relation, F.attribut, F.defaultwert, M.name as Maskenname from felderinfo F, masken_felder_bez B, maskeninfo M  where F.art!=999 and B.maskeninfo_id = " + this.getId() + " and M.tid = " + this.getId() + " and F.tid = B.felderinfo_id " + "order by F.nummer;";
        SxResultSet felderset = ServletUtils.execute("Einlesen der Felder f\u00fcr Maske " + this.getId(), query, this.mandantenID);
        String sql = "select field_name,locale,contents_short, contents_long  from sx_captions  where table_name='felderinfo'  and field_name in (select name from felderinfo where tid in (select felderinfo_id from masken_felder_bez where maskeninfo_id=" + this.getId() + "))" + " and (record_no is null OR record_no in (select felderinfo_id from masken_felder_bez where maskeninfo_id=" + this.getId() + "))" + " and (locale ='" + this.locale.getLanguage() + "' or locale is null or locale='' or locale='de')";
        SxResultSet captionSet = ServletUtils.execute("Einlesen der Captions f\u00fcr Maske " + this.getId(), sql, this.mandantenID);
        for (SxResultRow feldRow : felderset) {
            Field feld = new Field(this.mandantenID, user, feldRow, this.locale, this.individualFields, captionSet);
            felder.add(feld);
        }
        return felder;
    }

    public void setFieldDefaults(SxUser user, HttpServletRequest request) throws ParseException, SQLException, DBServletException, KeyParentEqualException, CloneNotSupportedException, SichtException, TemplateException, IOException, UngueltigeEingabeException, TransformerException, NoMainEntryException, InvalidDataTypeException {
        Hashtable formular = this.individualFields.getFormular();
        formular.put("erlaubt", "0");
        this.sharedData.getFormular().put("erlaubt", "0");
        this.standParamSetzen("Organigramm", DateUtils.getTodayString());
        formular.put("UserID", user.getId());
        ServletUtils.addToFormular(request, formular);
        for (Field aField : this.individualFields) {
            String param = (String)formular.get(aField.getName());
            if (param != null && param.length() > 30 && param.length() > aField.getLaenge()) {
                String shortparam = StringUtils.trimLength(param, Math.max(30, aField.getLaenge()));
                Logger.getLogger("superx_" + this.mandantenID).log(Level.WARNING, "Parameter f\u00fcr Feld " + aField.getName() + " (" + aField.getId() + ") wird gek\u00fcrzt auf angegebene L\u00e4nge " + aField.getLaenge() + " Zeichen:" + shortparam + " \nwar:" + param);
                formular.put(aField.getName(), shortparam);
            }
            if (aField.isOldOrganigrammArt() || aField.isSicht()) {
                this.setFeldStand(aField.getName(), ServletHelper.getParameter(request, String.valueOf(aField.getName()) + "-Stand"), user);
                this.setSelectedFeldSicht(aField.getName(), ServletHelper.getParameter(request, String.valueOf(aField.getName()) + "-Sicht"), user);
            }
            if (aField.getZeilenanzahl() <= 1 || param == null || param.indexOf(",") <= -1 && param.indexOf("|") <= -1) continue;
            formular.put(aField.getName(), aField.getParamAdaptedEscaped(param));
        }
        for (Field aField : this.individualFields) {
            String[] fw = request.getParameterValues(aField.getName());
            String param = "";
            if (fw != null) {
                int i2 = 0;
                while (i2 < fw.length) {
                    if (StringUtils.containsTags(fw[i2])) {
                        throw new IllegalArgumentException("Parameter f\u00fcr " + aField.getName() + " enth\u00e4lt unerlaubte Tags");
                    }
                    param = i2 < fw.length - 1 ? String.valueOf(param) + fw[i2].trim() + "," : String.valueOf(param) + fw[i2].trim();
                    ++i2;
                }
            } else {
                param = "";
            }
            param = param.replace(';', '^');
            if (aField.isDynamic() && this.hasArt0Fields()) {
                for (Field f2 : this.individualFields) {
                    if (f2.getArt() != 0 || aField.getRelation() == null || aField.getRelation().indexOf("<<" + f2.getName() + ">>") <= -1) continue;
                    aField.setInited(false);
                    break;
                }
            }
            aField.updateDefaultValue(formular, param, user);
            formular.put(aField.getName(), aField.getDefaultValueEscaped());
        }
        this.setFieldsDefaultSichten(user, request);
    }

    public void setLocale(Locale newlocale) throws SQLException, DBServletException {
        if (this.locale == null || !this.locale.equals(newlocale)) {
            this.locale = newlocale;
            this.individualFields.getFormular().put("locale", this.locale.getLanguage());
            for (Field f2 : this.individualFields) {
                f2.setLocale(this.locale);
            }
            for (Field f2 : this.sharedData.getFields()) {
                f2.setLocale(this.locale);
            }
        }
    }

    private void initSubMasken(SxUser user) throws TemplateException, KeyParentEqualException, CloneNotSupportedException, SichtException, IOException, SQLException, DBServletException, NoMainEntryException {
        String query = "select A.name,M.maskeninfo_id2, M.schleifenrelation,M.schleifenfeldname,M.schleifenfstand,M.schleifenfsicht,M.aktion,M.sortnr from macro_masken_bez M, maskeninfo A where M.active=1 and M.maskeninfo_id2 = A.tid and M.maskeninfo_id1 = " + this.getId() + " order by M.sortnr;";
        SxResultSet submaskenrs = ServletUtils.execute("Suche m\u00f6glicher Submasken in makro_masken_bez", query, this.mandantenID);
        if (submaskenrs.size() > 0) {
            this.sharedData.addUniqueFields(this.individualFields);
        }
        for (SxResultRow singleSubMaskRow : submaskenrs) {
            Maske m = new Maske(this.mandantenID, user, this.sharedData, singleSubMaskRow, this.locale);
            m.isMakroSubMaske = true;
            if (SxPools.get(this.mandantenID).hasMakroFieldSelection(this.getId(), m.getSortNr())) {
                SxPools.get(this.mandantenID).applyMacroFieldSelectionTo(this.getId(), m);
            }
            m.setMaxOffset(10000);
            this.submaskenListe.add(m);
        }
        if (this.isMakro()) {
            this.setMaxOffset(10000);
            this.isResultReuseFeatureWanted = true;
        }
    }

    public boolean isMakro() {
        return this.submaskenListe.size() > 0;
    }

    private void initFromMaskeninfo() throws DBServletException, SQLException {
        if (this.getId() == null) {
            throw new IllegalStateException("Kann keine Maske ohne tid vorbereiten");
        }
        String query = "select M.tid, M.name, M.select_stmt, M.xil_proplist, M.cleanup_stmt, M.breite, M.hoehe, S.datum, M.chart_xtitel, M.chart_ytitel,M.erlaeuterung,M.hinweis from maskeninfo M, maske_system_bez B, systeminfo S where M.tid = " + this.getId() + "  and M.tid = B.maskeninfo_id" + "  and S.tid = B.systeminfo_id" + ";";
        SxResultSet masksRs = ServletUtils.execute("Lesen aus Maskeninfo f\u00fcr Maske " + this.getId(), query, this.mandantenID);
        if (masksRs.size() == 0) {
            throw new RuntimeException("Fehlende Angaben in Tabellen maskeninfo,maske_system_bez oder systeminfo f\u00fcr Maske " + this.getId() + " gefunden");
        }
        SxResultRow maskRow = (SxResultRow)masksRs.first();
        this.setName(maskRow.get(1).toString());
        this.select_stmt = (String)maskRow.get(2);
        this.xilString = (String)maskRow.get(3);
        this.cleanup_stmt = (String)maskRow.get(4);
        this.standString = SqlStringUtils.getValueAsString(maskRow.get(7));
        this.chartx = SqlStringUtils.getValueAsString(maskRow.get(8));
        this.charty = SqlStringUtils.getValueAsString(maskRow.get(9));
        this.explanation = (String)maskRow.get(10);
        this.setHinweis((String)maskRow.get(11));
        this.setHinweisCaption(this.getHinweis());
    }

    public String getCharty() {
        return this.charty;
    }

    public void setCharty(String charty) {
        this.charty = charty;
    }

    public String getChartx() {
        return this.chartx;
    }

    public String getCleanup_stmt() {
        return this.cleanup_stmt;
    }

    public String getSelect_stmt() {
        return this.select_stmt;
    }

    public String getStandString() {
        return this.standString;
    }

    public String getXilString() {
        return this.xilString;
    }

    public String getHinweis() {
        return this.hinweis;
    }

    public void setSelectedMaskStylesheetFile(String filename) {
        this.selectedMaskStylesheetFile = filename;
    }

    public String getSelectedMaskStylesheetFile() {
        return this.selectedMaskStylesheetFile;
    }

    private void initMaskStylesheets() throws SQLException, DBServletException {
        String query = "select t1.filename, t1.caption, t1.description,  t1.contenttype, t0.ord from sx_mask_style t0,sx_stylesheets t1 where  (t0.stylesheet_id=t1.tid) and  (t1.relation ='mask')  and (t0.maskeninfo_id =" + this.getId() + ")" + " and (t1.useragent = '' or t1.useragent is null or t1.useragent = '" + this.browser + "')" + " order by t0.ord;";
        SxResultSet stylesheetsRs = ServletUtils.execute("Einlesen der Stylesheets f\u00fcr die Maske " + this.getId(), query, this.mandantenID);
        if (stylesheetsRs.size() > 0) {
            SxResultRow stylesheetRow = (SxResultRow)stylesheetsRs.first();
            Stylesheet s = new Stylesheet(stylesheetRow);
            this.maskStylesheetList.add(s);
            if (this.selectedMaskStylesheetFile == null) {
                this.selectedMaskStylesheetFile = s.getFilename();
            }
        } else {
            this.selectedMaskStylesheetFile = SuperXManager.defaultMaskXsl;
        }
    }

    private void initTableStylesheets() throws SQLException, DBServletException {
        String query = "select S.filename, S.caption, S.description,  S.contenttype, M.ord from sx_stylesheets S,sx_mask_style M where  M.stylesheet_id=S.tid  and  M.maskeninfo_id =" + this.getId() + " " + " and  S.relation ='table'  " + " and (S.useragent = '' or S.useragent is null or S.useragent = '" + this.browser + "')" + " union" + " select S.filename, S.caption, S.description, " + " S.contenttype, 99999 from sx_stylesheets S " + " where S.filename = 'tabelle_html.xsl'" + " union" + " select S.filename, S.caption, S.description, " + " S.contenttype, 100000 from sx_stylesheets S " + " where S.filename in ('tabelle_html_p.xsl','tabelle_xml.xsl','tabelle_fo_pdf.xsl','tabelle_xls.xsl')" + " order by 5;";
        SxResultSet stylesheetsRs = ServletUtils.execute("Einlesen der Stylesheets f\u00fcr die Tabellen der Maske " + this.getId(), query, this.mandantenID);
        SxResultRow stylesheetRow2 = null;
        for (SxResultRow stylesheetRow2 : stylesheetsRs) {
            Stylesheet s = new Stylesheet(stylesheetRow2);
            this.tableStylesheetList.add(s);
            if (this.selectedTableStylesheet != null) continue;
            this.selectedTableStylesheet = s;
        }
    }

    public void resetTableStylesheet() {
        this.selectedTableStylesheet = null;
        if (this.tableStylesheetList.size() > 0) {
            Stylesheet s;
            this.selectedTableStylesheet = s = (Stylesheet)this.tableStylesheetList.get(0);
        }
    }

    private StringBuffer getStylesheetXml() {
        StringBuffer result = new StringBuffer();
        if (this.tableStylesheetList.size() > 0) {
            result.append("<stylesheets>\n");
            for (Stylesheet stylesheet : this.tableStylesheetList) {
                result.append(stylesheet.toXml());
            }
            result.append("</stylesheets>\n");
        }
        return result;
    }

    public String getMaskHtml(SxUser user, String jsessionid) throws TransformerConfigurationException, TransformerException, DBServletException {
        this.resetTableStylesheet();
        if (this.maskHtml == null) {
            this.prepareHtml(user);
        } else {
            Logger.getLogger("superx_" + this.mandantenID).log(Level.FINE, "  " + this.getMaskInfo() + " benutze HTML-Vorlage (XSL-Transformation nicht n\u00f6tig)");
        }
        String result = this.maskHtml.replaceAll("_JSESSIONID_", jsessionid);
        result = result.replaceAll("_USERID_", user.getId().toString());
        result = result.replaceAll("_USER_IS_ADMIN_", user.isAdmin() ? "true" : "false");
        return result;
    }

    public String getMaskXml(SxUser user, String jsessionid) throws TransformerConfigurationException, TransformerException, DBServletException {
        this.resetTableStylesheet();
        String result = this.prepareXml(user, true).toString().replaceAll("_JSESSIONID_", jsessionid);
        result = result.replaceAll("_USERID_", user.getId().toString());
        result = result.replaceAll("_USER_IS_ADMIN_", user.isAdmin() ? "true" : "false");
        result = XMLUtils.removeTroublesomeCharacters(result);
        return result;
    }

    private StringBuffer prepareXml(SxUser user, boolean isFullXMLRequired) throws DBServletException {
        int rownr = 0;
        Logger.getLogger("superx_" + this.mandantenID + "_xml").log(Level.FINE, "baue XML auf f\u00fcr " + this.getMaskInfo() + " fullXMLRequired:" + isFullXMLRequired);
        Logger.getLogger("superx_" + this.mandantenID).log(Level.FINE, "baue XML auf f\u00fcr " + this.getMaskInfo() + " fullXMLRequired:" + isFullXMLRequired);
        StringBuffer result = new StringBuffer("<?xml version=\"1.0\" encoding=\"" + SqlStringUtils.getEncoding() + "\" ?>\n" + "<maske tid=\"" + this.getId() + "\" name=\"" + this.getName() + "\" sortnr=\"" + this.getSortNr() + "\"" + " datum=\"" + DateUtils.getTodayString() + "\" MandantenID=\"" + this.mandantenID + "\" jsessionid=\"_JSESSIONID_" + "\">\n");
        result.append("<UserID admin=\"_USER_IS_ADMIN_\">_USERID_</UserID>\n");
        if (user != null) {
            result.append(user.getThemenbaum().getMenupath(this.getId().toString()));
        }
        result.append("<felder>");
        for (Field feld : this.individualFields) {
            if (feld.getY() == 0) {
                ++rownr;
            }
            result.append(FieldXmlEncoder.toXml(feld, isFullXMLRequired, rownr));
        }
        result.append("<rownr>" + rownr + "</rownr></felder>\n");
        for (Stylesheet aStylesheet : this.maskStylesheetList) {
            result.append(aStylesheet.toXml());
        }
        result.append("</maske>\n");
        Logger.getLogger("superx_" + this.mandantenID + "_xml").log(Level.FINE, result.toString());
        SuperXManager.setLastXml(result.toString());
        return result;
    }

    private void prepareHtml(SxUser user) throws TransformerException, TransformerConfigurationException, DBServletException {
        String stylesheet = "file:///" + ServletUtils.getPath() + File.separatorChar + this.selectedMaskStylesheetFile;
        boolean isFullXMLRequired = TransletCache.isFullXMLRequired(stylesheet);
        StringBuffer result = this.prepareXml(user, isFullXMLRequired);
        TimeUtils t = new TimeUtils();
        Transformer transformer = TransletCache.getTransformer(this.mandantenID, stylesheet);
        transformer.setOutputProperty("method", "html");
        StringWriter erg = new StringWriter();
        transformer.transform(new StreamSource(new StringReader(result.toString())), new StreamResult(erg));
        Logger.getLogger("superx_" + this.mandantenID).log(Level.FINE, "  " + this.getMaskInfo() + " XSL-Transformation der Maske (mittels Translet) dauerte " + t.getSinceStart());
        this.maskHtml = erg.toString();
    }

    public String getMaskInfo() {
        return String.valueOf(this.getName()) + " (" + this.getId() + (this.getSortNr() != null ? " sortnr=" + this.getSortNr() : "") + ")";
    }

    public String runQuery(SxUser user, HttpServletRequest request) throws TemplateException, IOException, SQLException, KeyParentEqualException, CloneNotSupportedException, SichtException, TransformerConfigurationException, ObligatoryFieldEmptyException, ParseException, InvalidKeyException, TransformerException, DBServletException, UngueltigeEingabeException, NoMainEntryException, InvalidDataTypeException {
        if (this.isMakro() && this.isReuseResult()) {
            SuperXManager.logActivity(Level.INFO, " Makro-Abfrage " + this.getMaskInfo() + " liefere gecachtes Ergebnis");
            if (this.lastXmlResult == null || this.lastXmlResult.toString().trim().equals("")) {
                throw new IllegalStateException("Parameter reuseresult wurde \u00fcbergeben, es wurde aber kein gecachter XML im Maskenobjekt (runQuery,lastXmlResult) gefunden");
            }
            return this.lastXmlResult.toString();
        }
        SuperXManager.logActivity(Level.INFO, "Anforderung: Abfrage " + this.getMaskInfo());
        this.individualFields.getFormular().put("UserID", user.getId());
        this.sharedData.getFormular().put("UserID", user.getId());
        this.sharedData.setErgebnisOrdNr(0);
        this.sharedData.setErgebnisElementOrdNr(0);
        if (!this.isReuseResult()) {
            String keyfieldsused = ServletHelper.getParameter(request, "keyfieldsused");
            if (EqualsUtil.areEqual(keyfieldsused, "true")) {
                for (Field aField : this.individualFields) {
                    if (aField.getArt() != 0 && !aField.isSicht() && aField.isDynamic()) {
                        aField.setInited(false);
                    }
                    if (!aField.isSicht()) continue;
                    aField.initIfNeeded(this.individualFields.getFormular(), user);
                    this.setFeldStand(aField.getName(), ServletHelper.getParameter(request, String.valueOf(aField.getName()) + "-Stand"), user);
                    this.setSelectedFeldSicht(aField.getName(), ServletHelper.getParameter(request, String.valueOf(aField.getName()) + "-Sicht"), user);
                }
                this.setFieldDefaults(user, request);
            }
            this.setFieldSelections(user, request);
        }
        StringBuffer result = new StringBuffer("<?xml version=\"1.0\" encoding=\"" + SqlStringUtils.getEncoding() + "\"?>\n<ergebnisse MandantenID=\"" + this.mandantenID + "\" jsessionid=\"" + request.getSession().getId() + "\" datum=\"" + DateUtils.getTodayString() + "\" zeit=\"" + DateUtils.getNowString() + "\" isMakro=\"" + (this.isMakro() ? "true" : "false") + "\">\n");
        if (this.isMakro()) {
            result.append("<makro id=\"" + this.getId() + "\">\n<name>" + this.getName() + "</name>\n</makro>\n");
        }
        result.append("<user id=\"" + user.getId() + "\" admin=\"" + (user.isAdmin() ? "true" : "false") + "\"><![CDATA[" + user.getName() + "]]></user>\n");
        result.append("<userID admin=\"" + (user.isAdmin() ? "true" : "false") + "\">" + user.getId() + "</userID>\n");
        if (user != null) {
            result.append(user.getThemenbaum().getMenupath(this.getId().toString()));
        }
        result.append(this.addGeneralInfo());
        result.append(this.getStylesheetXml());
        result.append(this.getMaskResult(user, request));
        result.append("</ergebnisse>\n");
        String resultstr = XMLUtils.removeTroublesomeCharacters(result);
        this.lastXmlResult = new StringBuffer(resultstr);
        return resultstr;
    }

    private void setFieldsDefaultSichten(SxUser user, HttpServletRequest request) throws SQLException, DBServletException, KeyParentEqualException, CloneNotSupportedException, SichtException, TemplateException, IOException, NoMainEntryException {
        Hashtable formular = this.individualFields.getFormular();
        for (Field aField : this.individualFields) {
            if (!aField.isSicht() || !aField.hasDynamicDefaultSicht()) continue;
            aField.setDefaultSicht(formular, user);
        }
    }

    private String addGeneralInfo() {
        String info = "<generalinfo>\n<REPORT_HEADING_INSTITUTION><![CDATA[@@REPORT_HEADING_INSTITUTION@@]]></REPORT_HEADING_INSTITUTION> \n<REPORT_HEADING_URL><![CDATA[@@REPORT_HEADING_URL@@]]></REPORT_HEADING_URL> \n<REPORT_LOGO_FILE><![CDATA[@@REPORT_LOGO_FILE@@]]></REPORT_LOGO_FILE> \n<REPORT_HEADING_ADRESS><![CDATA[@@@REPORT_HEADING_ADRESS@@@]]></REPORT_HEADING_ADRESS> \n<REPORT_EMAIL><![CDATA[@@REPORT_EMAIL@@]]></REPORT_EMAIL> \n<REPORT_DOCUMENTATION_URL><![CDATA[@@REPORT_DOCUMENTATION_URL@@]]></REPORT_DOCUMENTATION_URL></generalinfo>\n";
        return info;
    }

    private void setColsort(String colsort) {
        if (colsort != null && !colsort.trim().equals("")) {
            if (colsort.equalsIgnoreCase("restore")) {
                colsort = null;
            }
            this.colsort = colsort;
            this.result_el.setColsort(colsort);
        }
    }

    public SuperX_el getResult_el() {
        return this.result_el;
    }

    private void setColset(String param) {
        if (param != null && !param.trim().equals("")) {
            if (this.isMakro()) {
                throw new IllegalArgumentException(String.valueOf(this.getMaskInfo()) + " ist ein Makro - definieren von colset " + param + " nicht m\u00f6glich");
            }
            this.colset = param.trim().equalsIgnoreCase("restore") ? null : param;
        }
    }

    private String getColset() {
        return this.colset;
    }

    private String getXmlFieldSelection(SxUser user) throws ParseException, SQLException, DBServletException, KeyParentEqualException, CloneNotSupportedException, SichtException, TemplateException, IOException, NoMainEntryException {
        StringBuffer result = new StringBuffer("<felder>\n");
        StringBuffer completeFields = new StringBuffer("<completefields>\n");
        int rownr = 0;
        boolean isFullXMLRequired = false;
        for (Field feld : this.individualFields) {
            try {
                result.append(feld.getSelectedKeyXml(this.individualFields.getFormular(), user));
            }
            catch (InvalidKeyException e2) {
                e2.printStackTrace();
                throw new RuntimeException("Maske " + this.getMaskInfo() + " hatte im Feld " + feld.getName() + " (" + feld.getId() + ") einen ung\u00fcltigen key.\n" + e2);
            }
            if (feld.getY() == 0) {
                ++rownr;
            }
            completeFields.append("<feld varname=\"" + feld.getName() + "\"></feld>\n");
        }
        result.append("</felder>\n");
        completeFields.append("</completefields>");
        result.append(completeFields);
        return result.toString();
    }

    private void setFieldSelections(SxUser user, HttpServletRequest request) throws ObligatoryFieldEmptyException, ParseException, InvalidKeyException, TransformerException, SQLException, DBServletException, KeyParentEqualException, CloneNotSupportedException, SichtException, TemplateException, IOException, NoMainEntryException, InvalidDataTypeException {
        this.individualFields.getFormular().put("Organigramm-Sicht", "0");
        this.sharedData.getFormular().put("Organigramm-Sicht", "0");
        Enumeration en = request.getParameterNames();
        while (en.hasMoreElements()) {
            String name = (String)en.nextElement();
            this.individualFields.getFormular().put(name, request.getParameter(name));
        }
        for (Field feld : this.individualFields) {
            String c2;
            if (feld.isOldOrganigrammArt() || feld.isSicht()) {
                this.setFeldStand(feld.getName(), ServletHelper.getParameter(request, String.valueOf(feld.getName()) + "-Stand"), user);
                this.setSelectedFeldSicht(feld.getName(), ServletHelper.getParameter(request, String.valueOf(feld.getName()) + "-Sicht"), user);
            }
            String param = "";
            String[] params = request.getParameterValues(feld.getName());
            if (params != null) {
                int i2 = 0;
                while (i2 < params.length) {
                    if (StringUtils.containsTags(params[i2])) {
                        throw new IllegalArgumentException("Parameter f\u00fcr " + feld.getName() + " enth\u00e4lt unerlaubte Tags");
                    }
                    param = String.valueOf(param) + params[i2].trim();
                    if (i2 < params.length - 1) {
                        param = String.valueOf(param) + "|";
                    }
                    ++i2;
                }
            }
            if (param.equals("") && feld.isObligatorisch() && feld.getDefaultValue() != null && feld.getDefaultValue().getId() != null) {
                param = feld.getDefaultValue().getId().toString();
            }
            String selectedKey = new String(param);
            selectedKey = selectedKey.trim();
            if (feld.isObligatorisch() && selectedKey.equals("")) {
                throw new ObligatoryFieldEmptyException("Bitte f\u00fcllen Sie das Feld " + feld.getName() + " aus.");
            }
            feld.setSelectedKey(selectedKey);
            if (feld.isOldOrganigrammArt() || feld.isSicht()) {
                this.sichtParamsInsFormular(feld);
            }
            String escapedKey = feld.getSelectedKeyEscaped();
            if (feld.getName().equals("tablestylesheet") && selectedKey != null && !selectedKey.equals("")) {
                this.setSelectedTableStylesheetFileAndContenttype(selectedKey);
            }
            if (feld.getName().equals("Ausgabeformat") && selectedKey != null && !selectedKey.equals("")) {
                this.setDesiredContenttype(selectedKey);
            }
            if ((c2 = ServletHelper.getParameter(request, "contenttype")) != null && !c2.equals("")) {
                this.setDesiredContenttype(c2);
            }
            this.individualFields.getFormular().put(feld.getName(), escapedKey);
            this.sharedData.getFormular().put(feld.getName(), escapedKey);
            if (feld.isOldOrganigrammArt()) continue;
            feld.isSicht();
        }
    }

    public Hashtable getFormularCopy() {
        Hashtable f2 = new Hashtable();
        f2.putAll(this.sharedData.getFormular());
        f2.putAll(this.individualFields.getFormular());
        return f2;
    }

    private void sichtParamsInsFormular(Field feld) {
        String feldname = feld.getName();
        this.standParamSetzen(feldname, feld.getSichtgruppe().getSelectedSicht().getStand());
        this.individualFields.getFormular().put(String.valueOf(feldname) + "-Sicht", feld.getSichtgruppe().getSelectedSicht().getId().toString());
        this.sharedData.getFormular().put(String.valueOf(feldname) + "-Sicht", feld.getSichtgruppe().getSelectedSicht().getId().toString());
        String sichtart = feld.getSichtgruppe().getArt();
        if (sichtart.endsWith("-Sicht")) {
            sichtart = sichtart.substring(0, sichtart.length() - 6);
        }
        this.standParamSetzen(sichtart, feld.getSichtgruppe().getSelectedSicht().getStand());
        this.individualFields.getFormular().put(String.valueOf(sichtart) + "-Sicht", feld.getSichtgruppe().getSelectedSicht().getId().toString());
        this.sharedData.getFormular().put(String.valueOf(sichtart) + "-Sicht", feld.getSichtgruppe().getSelectedSicht().getId().toString());
        if (feld.isOldOrganigrammArt() || feld.isOrganigrammSichtArt()) {
            String erlaubt = "0";
            if (feld.getSelectedKey() != null && !feld.getSelectedKey().equals("") && !feld.getSelectedKey().equals("null") && feld.getSichtgruppe().getSelectedSicht().getSelectionCount() > 0) {
                SelectableItemNode selectedNode = (SelectableItemNode)feld.getSichtgruppe().getSelectedSicht().getSelectionPath().getLastPathComponent();
                erlaubt = selectedNode.isAllowed() ? "1" : "0";
            }
            this.individualFields.getFormular().put("erlaubt", erlaubt);
            this.sharedData.getFormular().put("erlaubt", erlaubt);
        }
    }

    private void standParamSetzen(String name, String value) {
        if (!name.endsWith("-Stand")) {
            name = String.valueOf(name) + "-Stand";
        }
        value = SxPools.get(this.mandantenID).getSqlDialect().equals("Postgres") ? "date_val('" + value.trim() + "')" : "date('" + value.trim() + "')";
        this.individualFields.getFormular().put(name, value);
        this.sharedData.getFormular().put(name, value);
    }

    private StringBuffer getMaskResult(SxUser user, HttpServletRequest request) throws TemplateException, IOException, InvalidKeyException, ParseException, SQLException, DBServletException, KeyParentEqualException, CloneNotSupportedException, SichtException, NoMainEntryException, InvalidDataTypeException {
        StringBuffer xmlBuffer = new StringBuffer("");
        if (this.isMakro()) {
            this.updateFormular(user);
            NamedIdObjectList schleifenElemente = this.getSchleifenElemente();
            int schleifendurchl\u00e4ufe = Math.max(1, schleifenElemente.size());
            int i2 = 0;
            while (i2 < schleifendurchl\u00e4ufe) {
                for (Maske eineMaske : this.submaskenListe) {
                    this.updateFormular(user);
                    Field schleifenField = null;
                    if (schleifenElemente.size() > 0) {
                        NamedIdObject schleifenElement = (NamedIdObject)schleifenElemente.get(i2);
                        SuperXManager.logActivity(Level.FINE, "  Abfrage " + eineMaske.getMaskInfo() + " Schleife einsetzen:" + schleifenElement);
                        if (!eineMaske.getFields().containsField(this.getSchleifenfeldname())) {
                            throw new IllegalArgumentException("Versuch einen Schleifenwert " + schleifenElement + " f\u00fcr das Feld " + this.getSchleifenfeldname() + " bei der Maske " + eineMaske.getMaskInfo() + " fehlgeschlagen, da in der Abfrage kein Feld " + this.getSchleifenfeldname() + " gefunden wurde");
                        }
                        schleifenField = (Field)eineMaske.getFields().getByName(this.getSchleifenfeldname());
                        this.fieldSichtStandSetzen(user, schleifenField);
                        if (!schleifenField.getSelectableItemsTree().containsItemWithId((String)schleifenElement.getId())) {
                            SelectableItem item = new SelectableItem(schleifenElement);
                            item.setTemporary(true);
                            schleifenField.addTempSelectionElement(item);
                        }
                        schleifenField.setSelectedKey(schleifenElement.getId().toString());
                        schleifenField.setSpecialSelectionApplied(true);
                        eineMaske.getFields().getFormular().put(this.getSchleifenfeldname(), schleifenField.getSelectedKeyEscaped());
                        this.sharedData.getFormular().put(this.getSchleifenfeldname(), schleifenField.getSelectedKeyEscaped());
                    }
                    this.sharedData.setSchleifenField(schleifenField);
                    xmlBuffer.append(eineMaske.getMaskResult(user, request));
                }
                ++i2;
            }
        } else {
            this.updateFormular(user);
            NamedIdObjectList schleifenElemente = this.getSchleifenElemente();
            int schleifendurchl\u00e4ufe = Math.max(1, schleifenElemente.size());
            SuperXManager.logActivity(Level.INFO, "Abfrage " + this.getMaskInfo() + " durchf\u00fchren");
            int i3 = 0;
            while (i3 < schleifendurchl\u00e4ufe) {
                NamedIdObject schleifenElement = null;
                Field schleifenFeld = null;
                if (schleifenElemente.size() > 0) {
                    schleifenElement = (NamedIdObject)schleifenElemente.get(i3);
                    SuperXManager.logActivity(Level.FINE, "  Abfrage " + this.getMaskInfo() + " Schleife einsetzen:" + schleifenElement);
                    schleifenFeld = (Field)this.individualFields.getByName(this.getSchleifenfeldname());
                    this.fieldSichtStandSetzen(user, schleifenFeld);
                    schleifenFeld.setSelectedKey(schleifenElement.getId().toString());
                    schleifenFeld.setSpecialSelectionApplied(true);
                    this.individualFields.getFormular().put(this.getSchleifenfeldname(), schleifenFeld.getSelectedKeyEscaped());
                }
                xmlBuffer.append("<ergebnis ordnr=\"" + this.sharedData.getErgebnisOrdNr() + "\">\n");
                this.sharedData.incOrdnr();
                if (this.sharedData.getSchleifenField() != null) {
                    xmlBuffer.append(this.sharedData.getSchleifenField().getSchleifenXml());
                }
                xmlBuffer.append("<maskenname id=\"" + this.getId() + "\">" + this.getName() + "</maskenname>\n");
                xmlBuffer.append("<explanation><![CDATA[" + this.getExplanation() + "]]></explanation>\n");
                StringBuffer tableXml = this.executeQuery(user, request);
                String hinweis = this.getHinweisCaption();
                if (this.isMaxRowsReached()) {
                    hinweis = String.valueOf(hinweis) + SuperXManager.getMaxRowsHinweis();
                }
                xmlBuffer.append("<hinweis><![CDATA[" + hinweis + "]]></hinweis>\n");
                xmlBuffer.append("<stand>" + this.getStandString() + "</stand>\n");
                xmlBuffer.append("<chartx>" + this.getChartx() + "</chartx>\n");
                xmlBuffer.append("<charty>" + this.getCharty() + "</charty>\n");
                xmlBuffer.append(this.getXmlFieldSelection(user));
                StringTokenizer st = new StringTokenizer(this.getAktion(), "|");
                while (st.hasMoreElements()) {
                    String anAktion = st.nextToken();
                    this.performAktion(anAktion, tableXml, xmlBuffer);
                }
                xmlBuffer.append("</ergebnis>\n");
                ++i3;
            }
        }
        return xmlBuffer;
    }

    private void fieldSichtStandSetzen(SxUser user, Field f2) throws ParseException, SQLException, DBServletException, KeyParentEqualException, CloneNotSupportedException, SichtException, TemplateException, IOException, NoMainEntryException {
        String stand;
        try {
            f2.initIfNeeded(this.individualFields.getFormular(), user);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            throw new RuntimeException("Maske " + this.getMaskInfo() + " konnte Feld " + f2.getName() + " (" + f2.getId() + ") nicht initialisieren,\n um ggfs. Sicht oder Stand zu setzen.\n" + e2);
        }
        if (f2.getArt() == 12 && f2.getSichtgruppe().size() > 1) {
            String sicht = this.getSchleifenfsicht();
            if (sicht == null || sicht.trim().equals("")) {
                throw new IllegalStateException("F\u00fcr das Feld " + f2.getName() + " (" + f2.getId() + ") Maske " + this.getMaskInfo() + " muss in macro_masken_bez eine Sicht hinterlegt sein (z.B. fest 13 oder dynamisch z.B. Kostenstellen-Sicht in doppelten Kleiner-/Gr\u00f6\u00dferzeichen = auf Hauptmaske ausgewaehlte Sicht)");
            }
            if (sicht.startsWith("<<SQL>>")) {
                throw new UnsupportedOperationException("Sql bei der Sichtenauswahl in macros wird noch nicht unterst\u00fctzt  Maske " + this.getId());
            }
            sicht = SqlStringUtils.generateSQL(SxPools.get(this.mandantenID).getDatabaseAbbr(), this.individualFields.getFormular(), new String(sicht));
            int sichttid = 0;
            try {
                sichttid = Integer.parseInt(sicht);
            }
            catch (NumberFormatException e3) {
                throw new IllegalArgumentException("Konnte gew\u00fcnschte Sicht f\u00fcr das Feld  " + f2.getName() + " (" + f2.getId() + ")  Maske " + this.getId() + "nicht ermitteln, " + sicht + " ist kein g\u00fcltige Integerzahl.(tid)");
            }
            f2.setSicht(this.individualFields.getFormular(), new Integer(sichttid), user);
        }
        if ((stand = this.getSchleifenfstand()) == null || stand.trim().equals("")) {
            if (f2.isOldOrganigrammArt() || f2.getArt() == 12 && f2.getSichtgruppe().isStandButtonWanted()) {
                throw new IllegalStateException("F\u00fcr das Feld " + f2.getName() + " (" + f2.getId() + ")  Maske " + this.getId() + " muss in macro_masken_bez ein Stand hinterlegt sein (z.B. fest 01.01.2005 oder dynamisch <<Org. Einheit-Stand>>)");
            }
        } else {
            if (stand.startsWith("<<SQL>>")) {
                throw new UnsupportedOperationException("Sql bei der Standauswahl in macros wird noch nicht unterst\u00fctzt  Maske " + this.getId());
            }
            stand = SqlStringUtils.generateSQL(SxPools.get(this.mandantenID).getDatabaseAbbr(), this.individualFields.getFormular(), new String(stand));
            f2.setStand(this.individualFields.getFormular(), stand, user);
        }
    }

    public void removeTempFieldItems() {
        this.getFields().removeTempFieldItems();
        for (Maske m : this.submaskenListe) {
            m.removeTempFieldItems();
        }
    }

    private FieldContainer getFields() {
        return this.individualFields;
    }

    private void performAktion(String anAktion, StringBuffer tableXml, StringBuffer xmlBuffer) throws IOException {
        if (anAktion.equals("SHOWTABLE")) {
            xmlBuffer.append("<ergebniselement typ=\"tabelle\" id=\"" + this.getId() + "\" ordnr=\"" + this.sharedData.getErgebnisElementOrdNr() + "\">");
            this.sharedData.incErgebnisElementOrdNr();
            xmlBuffer.append(tableXml);
            xmlBuffer.append("</ergebniselement>\n");
        }
        if (anAktion.startsWith("CREATECHART-")) {
            GraphicFormat f2 = SxPools.get(this.mandantenID).getGraphicFormat(anAktion.substring(12));
            File graphicFile = ChartCreator.createFile(tableXml, f2);
            this.sharedData.addGraphicFile(graphicFile);
            xmlBuffer.append("<ergebniselement typ=\"image\" localurl=\"file:///" + graphicFile.getAbsolutePath() + "\" url=\"../xml/" + graphicFile.getName() + "\" ordnr=\"" + this.sharedData.getErgebnisOrdNr() + "\"/>\n");
            this.sharedData.incErgebnisElementOrdNr();
        }
    }

    public String getSql2() {
        String select_string = SqlStringUtils.generateSQL(SxPools.get(this.mandantenID).getDatabaseAbbr(), this.individualFields.getFormular(), String.valueOf(this.getSelect_stmt()) + "\n" + this.getCleanup_stmt());
        return select_string;
    }

    public String getSql3(SxUser user) throws TemplateException, IOException, SQLException {
        String select_string = SxPools.get(this.mandantenID).getTemplateProcessor().process(user.getBasicMap(), (Integer)this.getId(), this.getMaskInfo(), this.getSql2(), this.individualFields, SxPools.get(this.mandantenID).getRepository(), SxPools.get(this.mandantenID).getSqlDialect());
        return select_string;
    }

    public String getFormularValues() {
        StringBuffer buf = new StringBuffer();
        TreeSet set = new TreeSet(this.sharedData.getFormular().keySet());
        set.addAll(this.individualFields.getFormular().keySet());
        for (Object key : set) {
            if (key.toString().equalsIgnoreCase("passwort")) continue;
            Object val = this.sharedData.getFormular().get(key);
            if (this.individualFields.getFormular().get(key) != null) {
                val = this.individualFields.getFormular().get(key);
            }
            buf.append("<b>" + key + "</b> : " + val + "<br/>");
        }
        return buf.toString();
    }

    private StringBuffer executeQuery(SxUser user, HttpServletRequest request) throws DBServletException, SQLException, TemplateException, IOException, KeyParentEqualException, CloneNotSupportedException, SichtException, NoMainEntryException {
        if (this.isResultReuseFeatureWanted && this.isReuseResult() && this.result_el == null) {
            throw new IllegalStateException("Can't reuse result for Maske " + this.getId() + " because result_el is null");
        }
        String desiredRows = ServletHelper.getParameter(request, "irowno");
        if (!this.isResultReuseFeatureWanted || this.isResultReuseFeatureWanted && !this.isReuseResult()) {
            this.individualFields.updateStandTags(user);
            boolean isTemplate = this.getSelect_stmt().toUpperCase().indexOf("FREEMARKER TEMPLATE") > -1;
            String select_string = SqlStringUtils.generateSQL(SxPools.get(this.mandantenID).getDatabaseAbbr(), this.individualFields.getFormular(), String.valueOf(this.getSelect_stmt()) + "\n" + this.getCleanup_stmt());
            this.map.clear();
            if (isTemplate) {
                SuperXManager.setLastFMMaskenSql("-- " + this.getMaskInfo() + " " + DateUtils.getNowString() + "\n" + select_string);
                this.map.putAll(user.getBasicMap());
                select_string = SxPools.get(this.mandantenID).getTemplateProcessor().process(this.map, (Integer)this.getId(), this.getMaskInfo(), select_string, this.individualFields, SxPools.get(this.mandantenID).getRepository(), SxPools.get(this.mandantenID).getSqlDialect());
            }
            select_string = SqlStringUtils.removeComment(select_string, "{", "}");
            this.lastExecuted = DateUtils.getNowString();
            this.result_el = ServletUtils.executeALL_el("Abfrage Maske " + this.getMaskInfo() + " durchf\u00fchren", "--Abfrage\n" + select_string, this.mandantenID, true);
            String errorstring = this.result_el.getError_String();
            String errorselect = this.result_el.getAktuelleNachricht();
            if (errorstring != null && !errorstring.equals("")) {
                throw new SQLException("<h2>Fehler</h2><p class='errmsg'>Bei der Abfrage<br /> " + this.getMaskInfo() + "<br /> ist ein Fehler aufgetreten:<br />" + errorstring + "<br /> sql:" + errorselect + "</p>");
            }
        }
        this.setColset(ServletHelper.getParameter(request, "colset"));
        this.setColsort(ServletHelper.getParameter(request, "colsort"));
        String stylesheet = ServletHelper.getParameter(request, "stylesheet");
        String usetreetable = ServletHelper.getParameter(request, "usetreetable");
        if (usetreetable != null) {
            usetreetable = usetreetable.toLowerCase();
        }
        boolean isEbenenWanted = false;
        if (!(this.isMakroSubMaske || this.result_el == null || !this.result_el.hasEbeneCol() || EqualsUtil.areEqual(usetreetable, "false") || this.colsort != null || EqualsUtil.areEqual(stylesheet, "tabelle_html_p.xsl") || this.desiredContenttype != null && !this.desiredContenttype.trim().equals("") && this.desiredContenttype.toLowerCase().indexOf("htm") <= -1)) {
            isEbenenWanted = true;
        }
        if (this.hinweis != null && this.hinweis.startsWith("<<SQL>>")) {
            this.setHinweisCaption("");
            String sql = this.hinweis.substring(7, this.hinweis.length());
            try {
                sql = SqlStringUtils.generateSQL(SxPools.get(this.mandantenID).getDatabaseAbbr(), this.individualFields.getFormular(), sql);
                SxResultSet rs = ServletUtils.execute("Hinweis holen", sql, this.mandantenID);
                Iterator it = rs.iterator();
                StringBuffer hinw = new StringBuffer();
                int i2 = 0;
                while (it.hasNext()) {
                    SxResultRow row = (SxResultRow)it.next();
                    if (i2 > 0) {
                        hinw.append("\n");
                    }
                    hinw.append(row.get(0));
                    ++i2;
                }
                this.setHinweisCaption(hinw.toString());
            }
            catch (Exception e2) {
                System.out.println("Error beim Hinweis lesen:" + sql + " " + e2);
            }
        }
        return this.getXmlResultTable(user, desiredRows, isEbenenWanted);
    }

    public String getLastExecuted() {
        return this.lastExecuted;
    }

    private void updateFormular(SxUser user) throws InvalidKeyException, SQLException, DBServletException, KeyParentEqualException, CloneNotSupportedException, SichtException, TemplateException, IOException, NoMainEntryException, InvalidDataTypeException {
        Enumeration it = this.sharedData.getFormular().keys();
        while (it.hasMoreElements()) {
            String keyname = (String)it.nextElement();
            Object wertInSuperMaske = this.sharedData.getFormular().get(keyname);
            this.individualFields.getFormular().put(keyname, wertInSuperMaske);
        }
        for (Field superField : this.sharedData.getFields()) {
            if (!this.individualFields.containsItemWithName(superField.getName())) continue;
            Field f2 = (Field)this.individualFields.getByName(superField.getName());
            f2.initIfNeeded(this.individualFields.getFormular(), user);
            if (superField.isOldOrganigrammArt() || superField.isSicht()) {
                f2.setStand(this.individualFields.getFormular(), superField.getSichtgruppe().getStand(), user);
                if (f2.isSicht()) {
                    f2.setSicht(this.individualFields.getFormular(), (Integer)superField.getSichtgruppe().getSelectedSicht().getId(), user);
                }
            }
            if (f2.isSpecialSelectionApplied()) continue;
            f2.setSelectedKey(superField.getSelectedKey());
        }
        for (Field f3 : this.individualFields) {
            if (!f3.isSpecialSelectionApplied()) continue;
            this.individualFields.getFormular().put(f3.getName(), f3.getSelectedKeyEscaped());
        }
        if (this.maxOffset == 0) {
            this.individualFields.getFormular().put("MAXOFFSET", "ALL");
        } else {
            this.individualFields.getFormular().put("MAXOFFSET", "" + this.maxOffset);
        }
        this.individualFields.getFormular().put("OFFSET", "" + this.getOffset());
    }

    private NamedIdObjectList getSchleifenElemente() throws DBServletException, SQLException {
        NamedIdObjectList result = new NamedIdObjectList();
        if (this.getSchleifenrelation() != null) {
            String stmt = "";
            if (this.getSchleifenrelation().startsWith("sp_")) {
                stmt = SxPools.get(this.mandantenID).getSqlDialect().equals("Postgres") ? "select " + this.schleifenrelation : "execute procedure " + this.schleifenrelation;
            }
            if (this.getSchleifenrelation().startsWith("<<SQL>>")) {
                stmt = this.getSchleifenrelation().substring(7);
            }
            stmt = SqlStringUtils.generateSQL(SxPools.get(this.mandantenID).getDatabaseAbbr(), this.individualFields.getFormular(), stmt);
            Logger.getLogger("superx_" + this.mandantenID).log(Level.INFO, "Hole Schleifenelemente : " + stmt);
            SxResultSet rs = ServletUtils.execute("Hole Schleifenelemente aus makro_maske_bez maske:" + this.getId(), stmt, this.mandantenID);
            for (SxResultRow row : rs) {
                result.add(new NamedIdObject(row.get(0), (String)row.get(1)));
            }
        }
        return result;
    }

    private StringBuffer getXmlResultTable(SxUser user, String desiredRows, boolean isEbenenWanted) throws SQLException, DBServletException, IOException, TemplateException, KeyParentEqualException, NoMainEntryException {
        StringBuffer result = new StringBuffer();
        result.append("\n<sqlerg max=\"" + this.result_el.getResultSet().size() + "\" maxOffset= \"" + this.maxOffset + "\" offset=\"" + this.offset + "\" istreetable=");
        if (this.result_el != null && this.result_el.hasEbeneCol()) {
            result.append("\"true\"");
        } else {
            result.append("\"false\"");
        }
        result.append(">\n");
        result.append(this.getXmlHeader(user));
        if (this.headerManager.hasTreeFunction()) {
            this.setColset(this.headerManager.getColset());
        }
        XMLResultCreator rc = new XMLResultCreator(this.result_el, this.maxOffset, this.offset, this.mandantenID);
        if (desiredRows != null && !desiredRows.equals("")) {
            rc.setDesiredRows(desiredRows);
        }
        rc.addXML(result, this.getColset(), isEbenenWanted, "table0", -1);
        result.append("</sqlerg>\n");
        this.addCustomXmlAdditions(user, result);
        return result;
    }

    private void addCustomXmlAdditions(SxUser user, StringBuffer result) throws TemplateException, IOException, SQLException {
        for (String key : SxPools.get(this.mandantenID).getRepository().keySet()) {
            if (!key.startsWith("CUSTOMXMLADD")) continue;
            String customadd = ((RepositoryItemCollection)SxPools.get(this.mandantenID).getRepository().get(key)).get("content").toString();
            Logger.getLogger("superx_" + this.mandantenID + "_xml").log(Level.FINE, "Hinzuf\u00fcgen von " + key + ":\n " + customadd + DateUtils.getNowString());
            HashMap map = new HashMap();
            map.putAll(user.getBasicMap());
            customadd = SxPools.get(this.mandantenID).getTemplateProcessor().process(map, (Integer)this.getId(), this.getMaskInfo(), customadd, this.individualFields, SxPools.get(this.mandantenID).getRepository(), SxPools.get(this.mandantenID).getSqlDialect());
            Logger.getLogger("superx_" + this.mandantenID + "_xml").log(Level.FINE, "Hinzuf\u00fcgen von " + key + ":\n " + customadd + DateUtils.getNowString());
            result.append(customadd);
        }
    }

    private String getXmlHeader(SxUser user) throws SQLException, DBServletException, IOException, TemplateException, KeyParentEqualException, NoMainEntryException {
        StringBuffer preresult = null;
        if (this.isReuseResult) {
            preresult = this.headerManager.getHeaders(null, this.getColset(), this.getColsort(), this.result_el, this.individualFields.getFormular(), this.mandantenID);
        } else {
            String tmpxil = this.getXilString();
            tmpxil = SqlStringUtils.generateSQL(SxPools.get(this.mandantenID).getDatabaseAbbr(), this.individualFields.getFormular(), tmpxil);
            tmpxil = SxPools.get(this.mandantenID).getTemplateProcessor().process(this.map, (Integer)this.getId(), this.getMaskInfo(), tmpxil, this.individualFields, SxPools.get(this.mandantenID).getRepository(), SxPools.get(this.mandantenID).getSqlDialect());
            this.headerManager.setXilString(tmpxil);
            preresult = this.headerManager.getHeaders(tmpxil, this.getColset(), this.getColsort(), this.result_el, this.individualFields.getFormular(), this.mandantenID);
        }
        this.lastHeaderXml = SxPools.get(this.mandantenID).getTemplateProcessor().process(this.map, (Integer)this.getId(), "xil_proplist" + this.getId(), preresult.toString(), this.individualFields, SxPools.get(this.mandantenID).getRepository(), SxPools.get(this.mandantenID).getSqlDialect());
        return this.lastHeaderXml;
    }

    private String getColsort() {
        return this.colsort;
    }

    public int getMaxOffset() {
        return this.maxOffset;
    }

    public void setMaxOffset(int maxOffset) {
        this.maxOffset = maxOffset;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public String getSelectedTableStylesheetFilename() {
        String result = "";
        if (this.selectedTableStylesheet != null) {
            result = this.selectedTableStylesheet.getFilename();
        }
        return result;
    }

    public void setSelectedTableStylesheetFileAndContenttype(String desiredTableStylesheet) {
        this.selectedTableStylesheet = null;
        for (Stylesheet s : this.tableStylesheetList) {
            if (!s.getFilename().equals(desiredTableStylesheet) && (!desiredTableStylesheet.equals("") || !s.getFilename().equals("tabelle_html.xsl"))) continue;
            this.selectedTableStylesheet = s;
            this.setDesiredContenttype(s.getContenttype());
        }
    }

    public Integer getSortNr() {
        return this.sortNr;
    }

    public void setSortNr(Integer sortNr) {
        this.sortNr = sortNr;
    }

    public void setSpecialFieldSelection(String fieldname, String selectedKey) throws InvalidKeyException, InvalidDataTypeException {
        if (!this.individualFields.containsItemWithName(fieldname)) {
            throw new IllegalArgumentException("Kein Feld mit Namen " + fieldname + " gefunden in Maske " + this.getMaskInfo());
        }
        Field f2 = (Field)this.individualFields.getByName(fieldname);
        f2.setSelectedKey(selectedKey);
        f2.setSpecialSelectionApplied(true);
    }

    public Field getField(String fieldname) {
        if (!this.individualFields.containsItemWithName(fieldname)) {
            throw new IllegalArgumentException("Kein Feld mit Name " + fieldname + " in der Maske " + this.getMaskInfo() + "  vorhanden");
        }
        Field f2 = (Field)this.individualFields.getByName(fieldname);
        return f2;
    }

    public boolean isReuseResult() {
        return this.isReuseResult;
    }

    public void setReuseResult(boolean isReuseResult) {
        this.isReuseResult = isReuseResult;
        for (Maske aMask : this.submaskenListe) {
            aMask.setReuseResult(isReuseResult);
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        Maske cl = new Maske();
        cl.setId(this.getId());
        cl.setName(this.getName());
        cl.locale = this.locale;
        cl.schleifenrelation = this.schleifenrelation;
        cl.schleifenfeldname = this.schleifenfeldname;
        cl.aktion = this.aktion;
        cl.select_stmt = this.select_stmt;
        cl.cleanup_stmt = this.cleanup_stmt;
        cl.xilString = this.xilString;
        cl.chartx = this.chartx;
        cl.charty = this.charty;
        cl.standString = this.standString;
        cl.selectedMaskStylesheetFile = this.selectedMaskStylesheetFile;
        cl.selectedTableStylesheet = this.selectedTableStylesheet;
        cl.sharedData = (SharedData)this.sharedData.clone();
        cl.individualFields = (FieldContainer)this.individualFields.clone();
        LinkedList l2 = new LinkedList();
        l2.addAll(this.maskStylesheetList);
        cl.maskStylesheetList = l2;
        l2 = new LinkedList();
        l2.addAll(this.tableStylesheetList);
        cl.tableStylesheetList = l2;
        cl.sortNr = this.sortNr;
        NamedIdObjectList tmpList = new NamedIdObjectList();
        for (Maske m : this.submaskenListe) {
            tmpList.add((Maske)m.clone());
        }
        cl.submaskenListe = tmpList;
        cl.maskHtml = this.maskHtml;
        return cl;
    }

    public void setFeldStand(String feldname, String neuerStand, SxUser user) throws TransformerException, SQLException, DBServletException, KeyParentEqualException, CloneNotSupportedException, SichtException, TemplateException, IOException, NoMainEntryException {
        if (neuerStand == null) {
            return;
        }
        if (!this.individualFields.containsItemWithName(feldname)) {
            throw new IllegalArgumentException("Es wurde versucht, den Stand des Feldes " + feldname + " zu \u00e4ndern, aber in der Maske wurde kein Feld mit dem Namen gefunden");
        }
        if (!SuperXManager.isZukuenftigerStandErlaubt && DateUtils.isValidDate(neuerStand)) {
            try {
                neuerStand = neuerStand.replaceAll("'", "");
                neuerStand = neuerStand.replaceAll("\\(", "");
                neuerStand = neuerStand.replaceAll("\\)", "");
                if (DateUtils.isDateInFuture(DateUtils.parse(neuerStand))) {
                    throw new IllegalArgumentException("Datum in der Zukunft nicht erlaubt");
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        Field f2 = (Field)this.individualFields.getByName(feldname);
        f2.setStand(this.individualFields.getFormular(), neuerStand, user);
        this.maskHtml = null;
    }

    /*
     * Unable to fully structure code
     */
    public void setSelectedFeldSicht(String feldname, String sichtStr, SxUser user) throws TransformerConfigurationException, TransformerException, DBServletException, SQLException, KeyParentEqualException, CloneNotSupportedException, SichtException, TemplateException, IOException, NoMainEntryException {
        block6: {
            if (!this.individualFields.containsItemWithName(feldname)) {
                throw new IllegalArgumentException("Es wurde versucht, eine andere Sicht f\u00fcr das Feld " + feldname + " auszuw\u00e4hlen, aber in der Maske wurde kein Feld mit dem Namen gefunden");
            }
            f = (Field)this.individualFields.getByName(feldname);
            f.initIfNeeded(this.individualFields.getFormular(), user);
            if (sichtStr != null) {
                sichtint = 0;
                try {
                    sichtint = Integer.parseInt(sichtStr);
                    f.setSicht(this.individualFields.getFormular(), new Integer(sichtint), user);
                    break block6;
                }
                catch (NumberFormatException e) {
                    found = false;
                    buf = new StringBuffer();
                    ** for (sicht : f.getSichtgruppe())
                }
lbl-1000:
                // 1 sources

                {
                    buf.append(String.valueOf(sicht.getName_intern()) + " ");
                    if (!sicht.getName_intern().equals(sichtStr)) continue;
                    f.setSicht(this.individualFields.getFormular(), (Integer)sicht.getId(), user);
                    found = true;
                    continue;
                }
lbl21:
                // 1 sources

                if (!found) {
                    throw new IllegalArgumentException("Feld " + f.getName() + " konnte nicht aktualisiert werden, da Parameter " + f.getName() + "-Sicht, keine g\u00fcltige tid oder name_intern einer Sicht lieferte (" + sichtStr + ")" + " m\u00f6glich w\u00e4ren " + buf + " gewesen");
                }
            }
        }
        this.maskHtml = null;
    }

    private String getSchleifenfstand() {
        return this.schleifenfstand;
    }

    private void setSchleifenfstand(String schleifenfstand) {
        this.schleifenfstand = schleifenfstand;
    }

    private String getSchleifenfsicht() {
        return this.schleifenfsicht;
    }

    private void setSchleifenfsicht(String schleifenfsicht) {
        this.schleifenfsicht = schleifenfsicht;
    }

    public String getExplanation() {
        return this.explanation;
    }

    public void setExplanation(String explanation) {
        this.explanation = explanation;
    }

    public void setHinweis(String hinweis) {
        this.hinweis = hinweis;
        if (hinweis != null && hinweis.startsWith("<<SQL>>")) {
            hinweis = "";
        }
    }

    public String getHinweisCaption() {
        return this.hinweisCaption;
    }

    public void setHinweisCaption(String hinweisCaption) {
        this.hinweisCaption = hinweisCaption;
    }

    public String getKidRows(String treetableid, int row) {
        if (this.result_el == null) {
            throw new IllegalStateException("result-objekt ist null, kann keine Kinder per Ajax nachladen");
        }
        XMLResultCreator rc = new XMLResultCreator(this.result_el, this.maxOffset, this.offset, this.mandantenID);
        StringBuffer xml = new StringBuffer();
        rc.addXML(xml, this.colset, true, treetableid, row);
        return xml.toString();
    }

    public void markDynamicFields() {
        for (Field f2 : this.individualFields) {
            if (!f2.isDynamic()) continue;
            f2.setInited(false);
        }
    }

    public boolean hasDynamicFields() {
        boolean result = false;
        for (Field f2 : this.individualFields) {
            if (!f2.isDynamic()) continue;
            result = true;
        }
        return result;
    }

    public boolean hasArt0Fields() {
        boolean result = false;
        for (Field f2 : this.individualFields) {
            if (f2.getArt() != 0) continue;
            result = true;
        }
        return result;
    }

    public void openHeader(String key) {
        this.headerManager.openHeader(key);
        this.setReuseResult(true);
    }

    public void closeHeader(String key) {
        this.headerManager.closeHeader(key);
        this.setReuseResult(true);
    }

    public boolean isMaxRowsReached() {
        boolean result = false;
        if (this.result_el != null && this.result_el.getResultSet() != null && this.result_el.getResultSet().size() == SuperXManager.maxRows) {
            result = true;
        }
        return result;
    }

    public List getHeaderCaptionList(boolean removeNewline) {
        int pos = this.lastHeaderXml.indexOf("<headersconcated>");
        if (pos == -1) {
            throw new IllegalStateException("Kein Knoten headersconcated im Masken-Xml gefunden)");
        }
        int pos2 = this.lastHeaderXml.indexOf("]>\n</headersconcated>", pos) - 1;
        String concated = this.lastHeaderXml.substring(pos + 26, pos2);
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(concated, "\t");
        while (st.hasMoreTokens()) {
            String h2 = st.nextToken();
            if (removeNewline) {
                h2 = StringUtils.replace(h2, "\n", " ");
                h2 = StringUtils.replace(h2, "\\n", " ");
                h2 = StringUtils.replace(h2, "\\000", " ");
            }
            result.add(h2);
        }
        return result;
    }

    public String fmProcess(SxUser user, String vorlage) throws TemplateException, IOException, SQLException {
        String result = SqlStringUtils.generateSQL(SxPools.get(this.mandantenID).getDatabaseAbbr(), this.individualFields.getFormular(), vorlage);
        this.map.clear();
        this.map.putAll(user.getBasicMap());
        result = SxPools.get(this.mandantenID).getTemplateProcessor().process(this.map, (Integer)this.getId(), this.getMaskInfo(), result, this.individualFields, SxPools.get(this.mandantenID).getRepository(), SxPools.get(this.mandantenID).getSqlDialect());
        return result;
    }

    public String getExportName() {
        String result = this.getName();
        if (this.selectedTableStylesheet != null && this.selectedTableStylesheet.getFilename().indexOf(".jrxml") > -1) {
            result = this.selectedTableStylesheet.getCaption();
        }
        return result;
    }
}

