/*
 * Decompiled with CFR 0.152.
 */
package de.superx.bin;

import de.memtext.util.ExceptionHandler;
import de.memtext.util.GetOpts;
import de.memtext.util.XMLUtils;
import de.superx.bin.Doquery;
import de.superx.bin.Dosql;
import de.superx.bin.SxDBUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SxExtractor {
    String delim = "^";
    String header = "false";
    String logfile = "../conf/logging.properties";
    String tabelle = "";
    String dbpropfile = "../conf/db.properties";
    String myElement = "table";
    String myAttrib = "name";
    String outformat = "txt";
    String outfile = "";
    String _dateiPfad = "";
    private static final String extraction_table = "extraction-table";
    private static final String extraction_script = "extraction-script";
    private static final String extraction_sql = "extraction-sql";
    private static final String database_name = "database";
    private static final String version_name = "version";
    private static final String transfer_unload_file = "transfer-unload-file";
    private static Document document;
    public Logger logger = Logger.getLogger(SxExtractor.class.toString());
    private ExceptionHandler exceptionHandler = new ExceptionHandler(false);
    private static String usage;

    static {
        usage = "-------------------------------------\nDieses Script analysiert eine vorgegebene XML-Datei auf Attribute extraction-table, extraction-script und extraction-sql. Wess es ein Attribur findet, startet es die entsprechende DB-Verbindung und entl\u00e4dt das Ergebnis nach dem Wert des Attributs transfer-unload-file\nGebrauch: java de.superx.bin.SxExtractor -logger=<<Pfad zu logging.properties>> -dbproperties=<<Pfad zu db.properties>> -xml:<xml-Datei> -params:<Parameter, die in sql- oder Script-Dateien ersetzt werden; Syntax:param1=wert1|param2=wert2 etc> -outFormat:<Ausgabeformat (txt | html | xml)>(optional)  -delim:<delimiter> -header:<mit Spalten\u00fcberschriften (true | false)>(optional) -outfile:<Ausgabedatei>(optional) \n---------------------------------------------------";
    }

    public SxExtractor(String[] args) throws IOException {
        File f2;
        FileInputStream is;
        String name = "";
        String unl_file = "";
        String params = "";
        String database = "";
        String version = "";
        String p_database = "";
        String p_version = "";
        String unload_params = "";
        String sourcesystem = "";
        GetOpts.setOpts(args);
        String isdrin = GetOpts.isAllRequiredOptionsPresent("-logger,-dbproperties,-xml");
        if (isdrin != null) {
            System.err.println("Folgende Optionen fehlen: " + isdrin);
            System.err.println(usage);
            System.exit(1);
        }
        Properties props = new Properties();
        if (GetOpts.isPresent("-logger")) {
            this.logfile = GetOpts.getValue("-logger");
        }
        if (GetOpts.isPresent("-dbproperties")) {
            this.dbpropfile = GetOpts.getValue("-dbproperties");
        }
        if (GetOpts.isPresent("-xml")) {
            this._dateiPfad = GetOpts.getValue("-xml");
        }
        if (GetOpts.isPresent("-params")) {
            params = GetOpts.getValue("-params");
        }
        if (GetOpts.isPresent("-outFormat")) {
            this.outformat = GetOpts.getValue("-outFormat");
        }
        if (GetOpts.isPresent("-delim")) {
            this.delim = GetOpts.getValue("-delim");
        }
        if (GetOpts.isPresent("-header")) {
            this.header = GetOpts.getValue("-header");
        }
        if (GetOpts.isPresent("-database")) {
            p_database = GetOpts.getValue("-database");
        }
        if (GetOpts.isPresent("-version")) {
            p_version = GetOpts.getValue("-version");
        }
        if (GetOpts.isPresent("-unload_params")) {
            unload_params = GetOpts.getValue("-unload_params");
        }
        if ((is = new FileInputStream(unload_params)) != null) {
            props.load(is);
            is.close();
            Enumeration<?> propnames = props.propertyNames();
            if (propnames != null) {
                params = "";
                while (propnames.hasMoreElements()) {
                    String propname = (String)propnames.nextElement();
                    params = String.valueOf(params) + propname + "=" + props.getProperty(propname) + "|";
                    if (!propname.equals("$SOURCESYSTEM")) continue;
                    sourcesystem = props.getProperty(propname);
                }
            }
        }
        if (!(f2 = new File(this.logfile)).exists()) {
            throw new IOException("Datei nicht gefunden: " + this.logfile);
        }
        FileInputStream ins = new FileInputStream(this.logfile);
        LogManager MyLogManager = LogManager.getLogManager();
        MyLogManager.readConfiguration(ins);
        XMLUtils.getExceptionHandler().setWithGui(false);
        XMLUtils.getExceptionHandler().setExitWanted(true);
        if (this.delim.equals("")) {
            this.delim = "^";
        }
        document = XMLUtils.buildDocument(new File(this._dateiPfad), false);
        NodeList myNodes = document.getElementsByTagName("unload-job");
        int i2 = 0;
        while (i2 < myNodes.getLength()) {
            Node myNode = myNodes.item(i2);
            if (myNode.getNodeType() != 3) {
                unl_file = XMLUtils.hasAttrib(myNode, transfer_unload_file) ? XMLUtils.getAttribValue(myNode, transfer_unload_file) : "";
                name = XMLUtils.hasAttrib(myNode, extraction_table) ? XMLUtils.getAttribValue(myNode, extraction_table) : "";
                version = XMLUtils.hasAttrib(myNode, version_name) ? XMLUtils.getAttribValue(myNode, version_name) : "";
                database = XMLUtils.hasAttrib(myNode, database_name) ? XMLUtils.getAttribValue(myNode, database_name) : "";
                if (!name.equals("")) {
                    this.extractTable(name, unl_file, database, version, p_database, p_version);
                }
                if (!(name = XMLUtils.hasAttrib(myNode, extraction_script) ? XMLUtils.getAttribValue(myNode, extraction_script) : "").equals("") && (!XMLUtils.hasAttrib(myNode, "sourcesystem") || XMLUtils.getAttribValue(myNode, "sourcesystem").equals("") || XMLUtils.hasAttrib(myNode, "sourcesystem") && XMLUtils.getAttribValue(myNode, "sourcesystem").equals(sourcesystem))) {
                    this.extractionScript(name, unl_file, params, database, version, p_database, p_version);
                }
                NodeList mySqls = myNode.getChildNodes();
                String sql = "";
                int k2 = 0;
                while (k2 < mySqls.getLength()) {
                    Node mySqlNode = mySqls.item(k2);
                    if (mySqlNode.getNodeName().equals(extraction_sql) && (!XMLUtils.hasAttrib(mySqlNode, "sourcesystem") || XMLUtils.getAttribValue(mySqlNode, "sourcesystem").equals("") || XMLUtils.hasAttrib(mySqlNode, "sourcesystem") && XMLUtils.getAttribValue(mySqlNode, "sourcesystem").equals(sourcesystem))) {
                        params = this.extractionSql(unl_file, params, p_database, p_version, mySqlNode);
                    }
                    ++k2;
                }
            }
            ++i2;
        }
    }

    private String extractionSql(String unl_file, String params, String p_database, String p_version, Node mySqlNode) {
        String sql;
        String version;
        String database = XMLUtils.hasAttrib(mySqlNode, database_name) ? XMLUtils.getAttribValue(mySqlNode, database_name) : "";
        if (this.isDatabaseAndVersionOk(p_database, p_version, database, version = XMLUtils.hasAttrib(mySqlNode, version_name) ? XMLUtils.getAttribValue(mySqlNode, version_name) : "") && !(sql = XMLUtils.getChildNodeValues(mySqlNode)).equals("")) {
            if (!params.equals("")) {
                if (!params.endsWith("|")) {
                    params = String.valueOf(params) + "|";
                }
                StringTokenizer st = new StringTokenizer(params, "|");
                while (st.hasMoreTokens()) {
                    String param = st.nextToken();
                    if (param.equals("")) continue;
                    String paramname = param.substring(0, param.indexOf("="));
                    String paramvalue = param.substring(param.indexOf("=") + 1, param.length());
                    sql = SxDBUtils.replaceString(sql, paramname, paramvalue);
                }
            }
            String[] myArgs = new String[]{this.logfile, this.dbpropfile, sql, this.outformat, this.delim, this.header, unl_file};
            try {
                Doquery.go(myArgs);
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            this.logger.info("Executed sql:\n " + sql);
        }
        return params;
    }

    private boolean isDatabaseAndVersionOk(String p_database, String p_version, String database, String version) {
        boolean version_ok = false;
        StringTokenizer st = new StringTokenizer(version, ",");
        while (st.hasMoreTokens()) {
            String m_version = st.nextToken();
            if (!m_version.trim().equals(p_version)) continue;
            version_ok = true;
        }
        return !(database.indexOf(p_database) <= -1 && !database.equals("") || !version_ok && !version.equals(""));
    }

    private void extractionScript(String name, String unl_file, String params, String database, String version, String p_database, String p_version) {
        if (this.isDatabaseAndVersionOk(p_database, p_version, database, version)) {
            String[] myArgs = new String[8];
            myArgs[0] = "-logger:" + this.logfile;
            myArgs[1] = "-dbproperties:" + this.dbpropfile;
            myArgs[2] = "-sqlfile:" + name;
            myArgs[3] = "-outFormat:" + this.outformat;
            myArgs[4] = "-delim:" + this.delim;
            myArgs[5] = "-header:" + this.header;
            myArgs[6] = "-params:" + params;
            myArgs[7] = unl_file.equals("") ? (this.outformat.equals("txt") ? "-outfile:" + name + ".unl" : "-outfile:" + name + "." + this.outformat) : "-outfile:" + unl_file;
            try {
                Dosql.execute(myArgs);
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            this.logger.info("Executed sqlFile: " + name);
        }
    }

    private void extractTable(String name, String unl_file, String database, String version, String p_database, String p_version) {
        if (this.isDatabaseAndVersionOk(p_database, p_version, database, version)) {
            String[] myArgs = new String[7];
            myArgs[0] = this.logfile;
            myArgs[1] = this.dbpropfile;
            myArgs[2] = "select * from " + name;
            myArgs[3] = this.outformat;
            myArgs[4] = this.delim;
            myArgs[5] = this.header;
            myArgs[6] = unl_file.equals("") ? (this.outformat.equals("txt") ? String.valueOf(name) + ".unl" : String.valueOf(name) + "." + this.outformat) : unl_file;
            try {
                Doquery.go(myArgs);
            }
            catch (FileNotFoundException e2) {
                e2.printStackTrace();
            }
            catch (ClassNotFoundException e3) {
                e3.printStackTrace();
            }
            catch (IOException e4) {
                e4.printStackTrace();
            }
            catch (SQLException e5) {
                e5.printStackTrace();
            }
            this.logger.info("Unloaded Table " + name);
        }
    }

    public static void main(String[] args) {
        try {
            SxExtractor test = new SxExtractor(args);
        }
        catch (Exception ex) {
            System.err.println("Exception caught.\n" + ex);
            ex.printStackTrace();
        }
    }

    private void severeEnd(String txt) {
        this.logger.severe(txt);
        System.exit(-1);
    }
}

