/*
 * Decompiled with CFR 0.152.
 */
package de.superx.bin;

import de.superx.util.PropsReader;
import de.superx.util.SqlStringUtils;
import java.io.File;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;

public class SxConnection {
    byte[] key = new byte[]{-1, -35, 127, 109, -127};
    int keyLength = this.key.length;
    boolean isPwLogWanted = false;
    public Connection con;
    private String m_DBUrl;
    private String m_User;
    private String m_Password;
    private Properties props = new Properties();
    public String m_DriverClass;
    public String propfile = "";

    public synchronized Connection getConnection() throws Exception {
        DatabaseMetaData dbmd;
        this.loadProperties();
        this.props.put("user", this.m_User);
        this.props.put("password", this.m_Password);
        if (this.m_DriverClass.equals("org.postgresql.Driver")) {
            this.props.put("charSet", SqlStringUtils.getEncoding().equals("UTF-8") ? "UTF-8" : "Latin-1");
            this.props.put("DateStyle", "German, DMY");
        }
        if (this.m_DriverClass.equals("com.informix.jdbc.IfxDriver")) {
            this.props.put("GL_DATETIME", "%d.%m.%Y %T");
            this.props.put("CLIENT_LOCALE", SqlStringUtils.getEncoding().equals("UTF-8") ? "UTF-8" : "de_de.8859-1");
        }
        Class.forName(this.m_DriverClass);
        this.con = DriverManager.getConnection(this.m_DBUrl, this.props);
        if (this.m_DriverClass.equals("org.postgresql.Driver") && (dbmd = this.con.getMetaData()).getDatabaseMajorVersion() >= 8) {
            Statement stmt = this.con.createStatement();
            stmt.execute("set datestyle to 'ISO, DMY';");
            stmt.close();
        }
        return this.con;
    }

    private void loadProperties() throws Exception {
        String pfad = "";
        pfad = this.propfile.equals("") || this.propfile.equals(null) ? ".." + System.getProperty("file.separator") + "conf" + System.getProperty("file.separator") + "db.properties" : this.propfile;
        File f2 = new File(pfad);
        this.props = PropsReader.prepareProps(f2);
        this.m_DBUrl = this.props.getProperty("connectionURL");
        this.m_User = this.props.getProperty("connectionName");
        this.m_Password = PropsReader.check(this.props.getProperty("connectionPassword"));
        this.m_DriverClass = this.props.getProperty("driverName");
    }

    public PreparedStatement prepareStatement(String stm) {
        PreparedStatement t = null;
        try {
            t = this.con.prepareStatement(stm);
        }
        catch (SQLException e2) {
            e2.printStackTrace();
        }
        return t;
    }

    public String getCatalog() throws SQLException {
        String dbname = "";
        dbname = this.con.getCatalog();
        return dbname;
    }

    public String getM_DriverClass() {
        return this.m_DriverClass;
    }

    public String getDatabaseAbbr() {
        String result = "unknown";
        if (this.getM_DriverClass().toLowerCase().indexOf("postgres") > -1) {
            result = "PG";
        }
        if (this.getM_DriverClass().toLowerCase().indexOf("informix") > -1) {
            result = "IDS";
        }
        return result;
    }

    public String getPropfile() {
        return this.propfile;
    }

    public void setM_DriverClass(String string) {
        this.m_DriverClass = string;
    }

    public void setPropfile(String string) {
        this.propfile = string;
    }

    public void close() throws SQLException {
        this.con.close();
    }
}

