/*
 * Decompiled with CFR 0.152.
 */
package de.superx.bin;

import de.memtext.db.ConnectionCreator;
import de.memtext.util.DateUtils;
import de.memtext.util.GetOpts;
import de.memtext.util.StringUtils;
import de.superx.common.SxResultRow;
import de.superx.common.SxResultSet;
import de.superx.common.TableFieldExists;
import de.superx.common.TemplateProcessor;
import de.superx.util.PropsReader;
import de.superx.util.SqlStringUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Properties;

public class FMParser
extends TemplateProcessor {
    private String dbprop;
    private String infile;
    private String outfile;
    private Properties props;
    private Connection con = null;
    private Statement stm;
    private String isSimpleParser;

    FMParser() {
        this.inServlet = true;
    }

    private void run() throws FileNotFoundException, IOException, Exception {
        this.dbprop = GetOpts.getValue("-dbproperties:");
        this.props = PropsReader.prepareProps(new File(this.dbprop));
        this.infile = GetOpts.getValue("-in:");
        this.outfile = GetOpts.getValue("-out:");
        if (GetOpts.isPresent("-simpleParser")) {
            this.isSimpleParser = GetOpts.getValue("-simpleParser:");
        }
        String input = StringUtils.readFile(new File(this.infile));
        String output = "";
        if (this.isSimpleParser != null && this.isSimpleParser.equalsIgnoreCase("true")) {
            output = FMParser.simpleParser(this.dbprop, input);
        } else {
            this.initConAndParser();
            String sqlDialect = SqlStringUtils.getSqlDialect(this.props.getProperty("driverName"));
            HashMap<String, TableFieldExists> map = new HashMap<String, TableFieldExists>();
            map.put("TableFieldExists", new TableFieldExists(this.con));
            output = "--automatically created by SuperX/Freemarker for " + sqlDialect + " (" + DateUtils.getTodayString() + " " + DateUtils.getNowString() + ")\n" + this.process("FM-Parsing " + this.infile, input, map, sqlDialect);
            this.stm.close();
            this.con.close();
        }
        StringUtils.write(new File(this.outfile), output);
    }

    private void initConAndParser() throws IOException, SQLException, ClassNotFoundException {
        this.con = ConnectionCreator.getConnectionCryptPassword(this.dbprop, "driverName", "connectionURL", "connectionName", "connectionPassword");
        this.stm = this.con.createStatement();
        this.setTemplates(this.readFromDb("select trim(both from id),content from fm_templates"));
        FMParser.repositoryToMap(this.readFromDb("select trim(both from id) as id,caption,content,gueltig_seit,gueltig_bis,comment,sort1,sort2,sort3 from sx_repository where aktiv=1"), this.repositoryMap);
        SxResultSet rs = this.readFromDb("select trim(both from beschreibung),apnr from konstanten");
        for (SxResultRow row : rs) {
            String beschreibung = (String)row.get(0);
            this.repositoryMap.put("K_" + beschreibung.trim(), row.get(1));
        }
    }

    @Override
    protected SxResultSet readFromDb(String sql) throws SQLException {
        SxResultSet result = new SxResultSet();
        ResultSet rs = this.stm.executeQuery(sql);
        result.setColumnNames(rs.getMetaData());
        int naturalOrder = 0;
        while (rs.next()) {
            SxResultRow row = new SxResultRow(rs.getMetaData().getColumnCount(), naturalOrder++);
            int i2 = 1;
            while (i2 <= rs.getMetaData().getColumnCount()) {
                if (rs.getMetaData().getColumnType(i2) == -1) {
                    row.add(rs.getString(i2));
                } else {
                    row.add(rs.getObject(i2));
                }
                ++i2;
            }
            result.add(row);
        }
        rs.close();
        return result;
    }

    public static void main(String[] args) {
        GetOpts.setOpts(args);
        String isdrin = GetOpts.isAllRequiredOptionsPresent("-dbproperties,-in,-out");
        if (isdrin != null) {
            System.err.println("-dbproperties: -in: -out:");
            System.exit(1);
        }
        try {
            new FMParser().run();
        }
        catch (Exception e2) {
            System.err.println("Fehler beim FM-Parsen ");
            e2.printStackTrace();
            System.exit(1);
        }
    }

    public static String simpleParser(String dbprop, String input) throws FileNotFoundException, IOException, Exception {
        Properties props = PropsReader.prepareProps(new File(dbprop));
        String output = "";
        String sqlDialect = SqlStringUtils.getSqlDialect(props.getProperty("driverName"));
        HashMap map = new HashMap();
        try {
            output = "--automatically created by SuperX/Freemarker for " + sqlDialect + " (" + DateUtils.getTodayString() + " " + DateUtils.getNowString() + ")\n" + new FMParser().process("FM-Parsing ", input, map, sqlDialect);
        }
        catch (Exception e2) {
            System.err.println("Fehler beim FM-Parsen ");
            e2.printStackTrace();
            System.exit(1);
        }
        return output;
    }
}

