/*
 * Decompiled with CFR 0.152.
 */
package de.superx.applet;

import de.memtext.icons.MBStandardIcons;
import de.superx.applet.SxDefaults;
import de.superx.applet.SxField;
import de.superx.applet.SxHeaderRenderer;
import de.superx.applet.SxJDBCAdapter;
import de.superx.applet.SxLogoPanel;
import de.superx.applet.SxMask;
import de.superx.applet.SxTableModel;
import de.superx.applet.SxTableSorter;
import de.superx.applet.SxWaitCursor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class SxTablePanel
extends JPanel
implements Printable {
    private static final int MAX_COLUMN_WIDTH = 400;
    private static final Font HEADERFONT = new Font("SansSerif", 1, 12);
    private SxLogoPanel logo = null;
    private SxMask sxMask;
    private SxTableSorter sorter = null;
    JTable rowheaderTable = null;
    JTable table = null;
    private MouseAdapter mouseToHeader = null;
    private MouseAdapter mouseInTable = null;
    private Vector V_header = new Vector();
    private Vector V_width = new Vector();
    private int fixedColumns = 0;
    private int max_headerlines = 1;
    private int aktuellrow = 0;
    private JScrollPane tableScrollPane = this.createTable();
    private JScrollPane tmp_druck;
    private SxTablePanel tmp_drucktab = null;
    private JTextField statusField = null;
    private String selectStmt = null;
    private String hsName = null;
    private PageFormat defaultFormat = null;
    private Vector datarows;
    private Vector headerVector;
    private Vector widthVector;
    private Object metaObject;

    public SxTablePanel() {
        this.tableScrollPane.setBorder(new BevelBorder(1));
        this.setLayout(new BorderLayout());
        this.setName("SxTable");
        this.add((Component)this.tableScrollPane, "Center");
    }

    public synchronized void setData(Vector datarows, Vector headerVector, Vector widthVector, Object metaObject) {
        this.datarows = datarows;
        this.headerVector = headerVector;
        this.widthVector = widthVector;
        this.metaObject = metaObject;
        if (this.table != null) {
            SxTableModel model = this.sorter.getModel();
            if (model == null) {
                this.sorter.setModel(new SxJDBCAdapter());
            }
            this.V_header.removeAllElements();
            this.V_width.removeAllElements();
            if (datarows.size() == 0 || headerVector.size() == 0) {
                this.fixedColumns = 0;
            } else {
                if (headerVector != null) {
                    this.V_header.addAll(headerVector);
                }
                if (widthVector != null) {
                    this.V_width.addAll(widthVector);
                }
            }
            this.sorter.setDataVector(datarows, this.V_header, metaObject);
            this.setTableProperties(this.table);
            this.setRowHeader(datarows);
            int m = 0;
            while (m < this.fixedColumns) {
                this.removeFixedColumns(this.table, 0);
                ++m;
            }
        }
    }

    public synchronized void setData(Vector datarows) {
        this.datarows = datarows;
        if (this.table != null) {
            SxTableModel model = this.sorter.getModel();
            if (model == null) {
                this.sorter.setModel(new SxJDBCAdapter());
            }
            this.sorter.setDataVector(datarows);
            this.setHeaderModel(datarows);
        }
    }

    private void restore() {
        this.setData(this.datarows, this.headerVector, this.widthVector, this.metaObject);
    }

    public void setEditable(boolean editable) {
        SxTableModel model = this.sorter.getModel();
        if (model != null) {
            this.sorter.setEditable(editable);
        }
    }

    public void setFixedColumns(int numberOfFixedColumns) {
        this.fixedColumns = numberOfFixedColumns;
    }

    public int getFixedColumns() {
        return this.fixedColumns;
    }

    public JScrollPane getScrollPane() {
        return this.tableScrollPane;
    }

    public String getText() {
        TableColumn tableColumn;
        int i2;
        int[] selectedCols;
        int[] selectedRows;
        TableColumnModel r_columnModel = this.rowheaderTable.getColumnModel();
        TableColumnModel t_columnModel = this.table.getColumnModel();
        boolean areRowsSelected = false;
        boolean areColsSelected = false;
        if (this.table.getSelectedRowCount() > 0) {
            areRowsSelected = true;
            selectedRows = this.table.getSelectedRows();
        } else {
            selectedRows = new int[1];
        }
        if (this.table.getSelectedColumnCount() > 0) {
            areColsSelected = true;
            selectedCols = this.table.getSelectedColumns();
        } else {
            selectedCols = new int[1];
        }
        StringBuffer value = new StringBuffer();
        String tab = "\t";
        String nl = "\n";
        if (this.rowheaderTable != null) {
            i2 = 0;
            while (i2 < this.rowheaderTable.getColumnCount()) {
                tableColumn = r_columnModel.getColumn(i2);
                value.append(tableColumn.getHeaderValue().toString());
                value.append(tab);
                ++i2;
            }
        }
        if (this.table == null) {
            return "";
        }
        i2 = 0;
        while (i2 < this.table.getColumnCount()) {
            tableColumn = t_columnModel.getColumn(i2);
            if (!areColsSelected || this.isRowOrColSelected(i2, selectedCols)) {
                value.append(tableColumn.getHeaderValue().toString());
                if (i2 < this.table.getColumnCount() - 1) {
                    value.append(tab);
                }
            }
            ++i2;
        }
        value.append(nl);
        int n = 0;
        while (n < this.table.getRowCount()) {
            if (this.rowheaderTable != null && (!areRowsSelected || this.isRowOrColSelected(n, selectedRows))) {
                int m = 0;
                while (m < this.rowheaderTable.getColumnCount()) {
                    value.append(this.rowheaderTable.getValueAt(n, m).toString());
                    value.append(tab);
                    ++m;
                }
                m = 0;
                while (m < this.table.getColumnCount()) {
                    if (!areColsSelected || this.isRowOrColSelected(m, selectedCols)) {
                        value.append(this.table.getValueAt(n, m).toString());
                        if (m < this.table.getColumnCount() - 1) {
                            value.append(tab);
                        }
                    }
                    ++m;
                }
                value.append(nl);
            }
            ++n;
        }
        return value.toString();
    }

    private boolean isRowOrColSelected(int welche, int[] selektierte) {
        boolean drin = false;
        int i2 = 0;
        while (i2 < selektierte.length) {
            if (welche == selektierte[i2]) {
                drin = true;
            }
            ++i2;
        }
        return drin;
    }

    public void printTable(SxMask mask) {
        PageFormat pageFormat;
        this.sxMask = mask;
        PrinterJob pj = PrinterJob.getPrinterJob();
        if (this.defaultFormat == null) {
            this.defaultFormat = pj.defaultPage();
            this.defaultFormat.setOrientation(0);
        }
        if ((pageFormat = pj.pageDialog(this.defaultFormat)).equals(this.defaultFormat)) {
            return;
        }
        Paper a4 = new Paper();
        a4.setSize(595.275590551181, 841.8897637795275);
        a4.setImageableArea(36.0, 36.0, 523.275590551181, 769.8897637795275);
        pageFormat.setPaper(a4);
        this.defaultFormat = pageFormat;
        pj.setPrintable(this, pageFormat);
        if (!pj.printDialog()) {
            return;
        }
        this.logo = mask.getLogo();
        this.statusField = mask.getStatusField();
        try {
            this.hsName = (String)SxDefaults.getPropertyValue("SxTitle");
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex.toString(), "Fehler", 0);
        }
        try {
            this.logo.start();
            pj.print();
        }
        catch (Exception PrintException2) {
            System.err.println(PrintException2);
            PrintException2.printStackTrace();
        }
        this.statusField.setText("Drucken beendet");
        this.logo.stop();
    }

    private void ggfs_nurMarkierterBereich(PrinterJob pj, PageFormat pageFormat) {
        int i2;
        if (this.table.getSelectedRowCount() > 0) {
            DefaultTableModel tmodel = new DefaultTableModel();
            DefaultTableModel rmodel = new DefaultTableModel();
            JTable dummy = new JTable(tmodel);
            JTable dummyr = new JTable(rmodel);
            int spaltenzahlr = this.rowheaderTable.getColumnCount();
            i2 = 0;
            while (i2 < spaltenzahlr) {
                rmodel.addColumn(this.rowheaderTable.getColumnName(i2));
                ++i2;
            }
            int i22 = 0;
            int zeilenzahl = this.table.getRowCount();
            int spaltenzahl = this.table.getColumnCount();
            i2 = 0;
            while (i2 < spaltenzahl) {
                tmodel.addColumn(this.table.getColumnName(i2));
                ++i2;
            }
            Vector<Object> zeile = new Vector<Object>();
            Vector<Object> rzeile = new Vector<Object>();
            Object wert = new Object();
            i2 = 0;
            while (i2 < zeilenzahl) {
                if (this.table.isRowSelected(i2)) {
                    i22 = 0;
                    while (i22 < spaltenzahlr) {
                        wert = this.rowheaderTable.getValueAt(i2, i22);
                        rzeile.addElement(wert);
                        ++i22;
                    }
                    int i3 = 0;
                    while (i3 < spaltenzahl) {
                        wert = this.table.getValueAt(i2, i3);
                        zeile.addElement(wert);
                        ++i3;
                    }
                    rmodel.addRow(rzeile);
                    tmodel.addRow(zeile);
                }
                ++i2;
            }
            this.table = dummy;
            this.rowheaderTable = dummyr;
            this.table.addNotify();
            this.rowheaderTable.addNotify();
            this.remove(this.tableScrollPane);
            this.add((Component)this.tmp_druck, "Center");
            this.validate();
            this.table.repaint();
            this.rowheaderTable.repaint();
            this.repaint();
        }
        if (this.table.getSelectedColumnCount() > 0) {
            TableColumnModel mycolumnModel = this.table.getColumnModel();
            TableColumn aCol = new TableColumn();
            int i23 = 0;
            int spaltenzahl = this.table.getColumnCount();
            i2 = 0;
            while (i2 < spaltenzahl) {
                if (!this.table.isColumnSelected(i2 - i23)) {
                    aCol = mycolumnModel.getColumn(i2 - i23);
                    ++i23;
                    this.table.removeColumn(aCol);
                }
                ++i2;
            }
        }
        this.table.clearSelection();
        this.table.repaint();
        this.rowheaderTable.repaint();
    }

    @Override
    public int print(Graphics g2, PageFormat pageFormat, int pageIndex) throws PrinterException {
        int numRowsLeft;
        int lastRowPrinted;
        Graphics2D g22 = (Graphics2D)g2;
        g22.setColor(Color.black);
        int fontHeight = g22.getFontMetrics().getHeight();
        int fontDesent = g22.getFontMetrics().getDescent();
        double pageHeight = pageFormat.getImageableHeight() - (double)fontHeight - (double)fontDesent;
        double pageWidth = pageFormat.getImageableWidth();
        double rowheaderWidth = this.rowheaderTable.getColumnModel().getTotalColumnWidth();
        double tableWidth = this.table.getColumnModel().getTotalColumnWidth();
        double headerHeight = 30 + this.sxMask.getParameterPanel().lblParams.getHeight();
        double paramWidth = this.sxMask.getParameterPanel().lblEingabeparam.getWidth() + 10;
        double paramAreaWidth = this.sxMask.getParameterPanel().lblParams.getWidth();
        double scale = 1.0;
        double scale2 = 1.0;
        if (rowheaderWidth + tableWidth >= pageWidth) {
            scale = pageWidth / (rowheaderWidth + tableWidth);
        }
        if (paramWidth + paramAreaWidth >= pageWidth) {
            scale2 = pageWidth / (paramWidth + paramAreaWidth);
        }
        paramWidth *= scale2;
        double scaledTableHeaderHeight = (double)this.table.getTableHeader().getHeight() * scale;
        double scaledRowheaderWidth = rowheaderWidth * scale;
        double scaledTableWidth = tableWidth * scale;
        double oneRowHeight = (double)this.table.getRowHeight() * scale;
        int numRowsOnAPage = (int)((pageHeight - headerHeight - scaledTableHeaderHeight) / oneRowHeight);
        double pageHeightForTable = oneRowHeight * (double)numRowsOnAPage;
        int totalNumPages = (int)Math.ceil((double)this.table.getRowCount() / (double)numRowsOnAPage);
        if (pageIndex >= totalNumPages) {
            return 1;
        }
        String msg = "Drucke Seite " + (pageIndex + 1);
        this.statusField.setText(msg);
        Font font = g22.getFont();
        Font pr_font = new Font(font.getFontName(), font.getStyle(), (int)((double)font.getSize() * scale));
        Font b_font = new Font(font.getFontName(), 1, (int)((double)font.getSize() * scale));
        Font h_font = this.sxMask.getParameterPanel().lblAbfragename.getFont();
        font = this.sxMask.getParameterPanel().lblStand.getFont();
        Font d_font = new Font(font.getFontName(), font.getStyle(), (int)((double)font.getSize() * scale));
        g22.setFont(pr_font);
        g22.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        this.printBottomLine(pageIndex, g22, fontHeight, pageHeight, pageWidth, b_font, d_font);
        g22.setFont(pr_font);
        g22.translate(0.0, headerHeight + scaledTableHeaderHeight);
        g22.translate(0.0, (double)(-pageIndex) * pageHeightForTable);
        if (this.fixedColumns > 0) {
            if (pageIndex + 1 == totalNumPages) {
                lastRowPrinted = numRowsOnAPage * pageIndex;
                numRowsLeft = this.table.getRowCount() - lastRowPrinted;
                g22.setClip(0, (int)(pageHeightForTable * (double)pageIndex), (int)Math.ceil(scaledRowheaderWidth), (int)Math.ceil(pageHeightForTable));
            } else {
                g22.setClip(0, (int)(pageHeightForTable * (double)pageIndex), (int)Math.ceil(scaledRowheaderWidth), (int)Math.ceil(pageHeightForTable));
            }
        }
        g22.scale(scale, scale);
        if (this.fixedColumns > 0) {
            try {
                this.rowheaderTable.print(g22);
            }
            catch (IllegalArgumentException h_ex) {
                System.err.println(h_ex);
            }
        }
        g22.scale(1.0 / scale, 1.0 / scale);
        g22.translate(scaledRowheaderWidth, 0.0);
        if (pageIndex + 1 == totalNumPages) {
            lastRowPrinted = numRowsOnAPage * pageIndex;
            numRowsLeft = this.table.getRowCount() - lastRowPrinted;
            g22.setClip(0, (int)(pageHeightForTable * (double)pageIndex), (int)Math.ceil(scaledTableWidth), (int)Math.ceil(pageHeightForTable));
        } else {
            g22.setClip(0, (int)(pageHeightForTable * (double)pageIndex), (int)Math.ceil(scaledTableWidth), (int)Math.ceil(pageHeightForTable));
        }
        g22.scale(scale, scale);
        try {
            this.table.print(g22);
        }
        catch (IllegalArgumentException t_ex) {
            System.err.println(t_ex);
        }
        g22.scale(1.0 / scale, 1.0 / scale);
        g22.translate(-scaledRowheaderWidth, (double)pageIndex * pageHeightForTable - scaledTableHeaderHeight);
        g22.setClip(0, 0, (int)Math.ceil(scaledRowheaderWidth + scaledTableWidth), (int)Math.ceil(scaledTableHeaderHeight));
        g22.scale(scale, scale);
        this.rowheaderTable.getTableHeader().print(g22);
        g22.scale(1.0 / scale, 1.0 / scale);
        g22.translate(scaledRowheaderWidth, 0.0);
        g22.scale(scale, scale);
        this.table.getTableHeader().print(g22);
        g22.scale(1.0 / scale, 1.0 / scale);
        g22.translate(-scaledRowheaderWidth, -(headerHeight + 2.0));
        g22.setClip(0, 0, (int)Math.ceil(paramWidth), (int)headerHeight);
        g22.scale(scale2, scale2);
        this.sxMask.getParameterPanel().lblEingabeparam.print(g22);
        g22.scale(1.0 / scale2, 1.0 / scale2);
        g22.translate(paramWidth, 0.0);
        g22.setClip(0, 0, (int)Math.ceil(pageWidth - paramWidth), (int)headerHeight);
        g22.scale(scale2, scale2);
        this.sxMask.getParameterPanel().lblParams.print(g22);
        g22.setFont(h_font);
        int laengeUberschriftuHSname = g22.getFontMetrics().stringWidth(String.valueOf(this.sxMask.getParameterPanel().lblAbfragename.getText()) + this.hsName + 10);
        while ((double)laengeUberschriftuHSname > pageWidth) {
            h_font = h_font.deriveFont((float)(h_font.getSize() - 1));
            g22.setFont(h_font);
            laengeUberschriftuHSname = g22.getFontMetrics().stringWidth(String.valueOf(this.sxMask.getParameterPanel().lblAbfragename.getText()) + this.hsName + 10);
        }
        g22.translate(-paramWidth, -30.0);
        g22.setClip(0, 0, (int)Math.ceil(scaledRowheaderWidth + scaledTableWidth), (int)Math.ceil(scaledTableHeaderHeight));
        g22.setFont(h_font);
        g22.drawString(this.sxMask.getParameterPanel().lblAbfragename.getText(), 0, g22.getFontMetrics().getHeight());
        int hsNameWidth = g22.getFontMetrics().stringWidth(this.hsName);
        g22.translate(pageWidth - (double)hsNameWidth, 0.0);
        g22.setClip(0, 0, (int)Math.ceil(pageWidth - (double)hsNameWidth), (int)Math.ceil(scaledTableHeaderHeight));
        g22.setFont(h_font);
        g22.drawString(this.hsName, 0, g22.getFontMetrics().getHeight());
        g22.translate(-1.0 * (pageWidth - (double)hsNameWidth), 0.0);
        return 0;
    }

    private void printBottomLine(int pageIndex, Graphics2D g2, int fontHeight, double pageHeight, double pageWidth, Font b_font, Font d_font) {
        int footWidth = g2.getFontMetrics().stringWidth("Seite #");
        g2.setFont(b_font);
        g2.drawString("SuperX", 0, (int)(pageHeight + (double)fontHeight));
        g2.setFont(d_font);
        g2.drawString("Seite " + (pageIndex + 1), (int)(pageWidth / 2.0 - (double)(footWidth / 2)), (int)(pageHeight + (double)fontHeight));
        double dateWidthOnPage = (double)g2.getFontMetrics().stringWidth(this.sxMask.getParameterPanel().lblStand.getText()) + 2.0;
        g2.drawString(this.sxMask.getParameterPanel().lblStand.getText(), (int)(pageWidth - dateWidthOnPage), (int)(pageHeight + (double)fontHeight));
    }

    private JScrollPane createTable() {
        this.sorter = new SxTableSorter();
        this.table = new JTable(this.sorter);
        this.table.setFont(new Font("SansSerif", 0, 12));
        this.table.setBackground(Color.white);
        this.table.setAutoResizeMode(0);
        this.table.setRowHeight((int)((double)this.table.getRowHeight() * 1.25));
        this.addActionsToTable(this.table);
        this.addMouseListenerToHeaderInTable(this.table);
        this.addMouseListenerInTable(this.table);
        this.addRendererInTable(this.table);
        JScrollPane scrollpane = new JScrollPane(this.table);
        return scrollpane;
    }

    JTable getTable() {
        return this.table;
    }

    private void removeHeaderMouseListener() {
        if (this.mouseToHeader != null) {
            JTableHeader th = this.table.getTableHeader();
            th.removeMouseListener(this.mouseToHeader);
        }
    }

    private void removeTableMouseListener() {
        if (this.mouseInTable != null) {
            this.table.removeMouseListener(this.mouseInTable);
        }
    }

    protected void setTableProperties(JTable jtable) {
        if (jtable == null) {
            return;
        }
        jtable.setColumnSelectionAllowed(false);
        jtable.setRowSelectionAllowed(true);
        if (jtable.getRowCount() <= 0) {
            return;
        }
        int nr_col = jtable.getColumnCount();
        if (nr_col <= 0) {
            return;
        }
        SxTableModel model = (SxTableModel)jtable.getModel();
        TableColumnModel columnModel = jtable.getColumnModel();
        FontMetrics metrics = jtable.getFontMetrics(jtable.getFont());
        int advance = metrics.charWidth('m');
        int width = -1;
        int pref_width = -1;
        int headerlines = 1;
        this.max_headerlines = 1;
        int i2 = 0;
        while (i2 < nr_col) {
            DefaultCellEditor numEditor;
            SxField numField;
            TableColumn tableColumn = columnModel.getColumn(i2);
            SxHeaderRenderer headerRenderer = new SxHeaderRenderer();
            headerRenderer.setHeaderFont(HEADERFONT);
            headerRenderer.setTextLines((String)tableColumn.getHeaderValue());
            tableColumn.setHeaderRenderer(headerRenderer);
            if (i2 >= this.fixedColumns && (headerlines = headerRenderer.getNumLines()) > this.max_headerlines) {
                this.max_headerlines = headerlines;
            }
            if ((width = this.V_width.isEmpty() ? model.getColumnSize(i2) : Integer.valueOf(this.V_width.elementAt(i2).toString()).intValue()) > 0) {
                pref_width = width * (advance * 7 / 10);
                if (pref_width > 400) {
                    pref_width = 400;
                }
                tableColumn.setPreferredWidth(pref_width);
            } else {
                pref_width = 1 * (advance * 3 / 10);
            }
            Object value = model.getObjectAt(0, i2);
            if (value instanceof Integer) {
                tableColumn.setMinWidth(30);
                numField = new SxField(1, 11);
                numField.setHorizontalAlignment(4);
                numField.setMargin(new Insets(0, 2, 0, 2));
                numField.setJTable(jtable);
                numEditor = new DefaultCellEditor(numField);
                numEditor.addCellEditorListener(new ChangeEditorListener());
                jtable.setDefaultEditor(Integer.class, numEditor);
            } else if (value instanceof Short) {
                tableColumn.setMinWidth(30);
                numField = new SxField(1, 6);
                numField.setHorizontalAlignment(4);
                numField.setMargin(new Insets(0, 2, 0, 2));
                numField.setJTable(jtable);
                numEditor = new DefaultCellEditor(numField);
                numEditor.addCellEditorListener(new ChangeEditorListener());
                jtable.setDefaultEditor(Short.class, numEditor);
            } else if (value instanceof Double) {
                tableColumn.setMinWidth(50);
                tableColumn.setMaxWidth(400);
                numField = new SxField(2, 20);
                numField.setHorizontalAlignment(4);
                numField.setMargin(new Insets(0, 2, 0, 2));
                numField.setJTable(jtable);
                numEditor = new DefaultCellEditor(numField);
                numEditor.addCellEditorListener(new ChangeEditorListener());
                jtable.setDefaultEditor(Double.class, numEditor);
            } else if (value instanceof BigDecimal) {
                tableColumn.setMinWidth(50);
                tableColumn.setMaxWidth(400);
                numField = new SxField(2, 20);
                numField.setHorizontalAlignment(4);
                numField.setMargin(new Insets(0, 2, 0, 2));
                numField.setJTable(jtable);
                numEditor = new DefaultCellEditor(numField);
                numEditor.addCellEditorListener(new ChangeEditorListener());
                jtable.setDefaultEditor(BigDecimal.class, numEditor);
                DefaultTableCellRenderer decimalRenderer = new DefaultTableCellRenderer();
                decimalRenderer.setHorizontalAlignment(4);
                jtable.setDefaultRenderer(BigDecimal.class, decimalRenderer);
            } else if (value instanceof Float) {
                tableColumn.setMinWidth(50);
                tableColumn.setMaxWidth(400);
                numField = new SxField(2, 20);
                numField.setHorizontalAlignment(4);
                numField.setMargin(new Insets(0, 2, 0, 2));
                numField.setJTable(jtable);
                numEditor = new DefaultCellEditor(numField);
                numEditor.addCellEditorListener(new ChangeEditorListener());
                jtable.setDefaultEditor(Float.class, numEditor);
            } else if (value instanceof Number) {
                tableColumn.setMinWidth(50);
                tableColumn.setMaxWidth(400);
                numField = new SxField(2, 20);
                numField.setHorizontalAlignment(4);
                numField.setMargin(new Insets(0, 2, 0, 2));
                numField.setJTable(jtable);
                numEditor = new DefaultCellEditor(numField);
                numEditor.addCellEditorListener(new ChangeEditorListener());
                jtable.setDefaultEditor(Number.class, numEditor);
            } else if (value instanceof Timestamp) {
                SxField timeField = new SxField(0, 22);
                timeField.setMargin(new Insets(0, 2, 0, 2));
                timeField.setJTable(jtable);
                DefaultCellEditor timeEditor = new DefaultCellEditor(timeField);
                timeEditor.addCellEditorListener(new ChangeEditorListener());
                jtable.setDefaultEditor(Timestamp.class, timeEditor);
            } else if (value instanceof Date) {
                tableColumn.setMinWidth(70);
                tableColumn.setMaxWidth(100);
                SxField dateField = new SxField(3, 10);
                dateField.setHorizontalAlignment(4);
                dateField.setMargin(new Insets(0, 2, 0, 2));
                dateField.setJTable(jtable);
                DefaultCellEditor dateEditor = new DefaultCellEditor(dateField);
                dateEditor.addCellEditorListener(new ChangeEditorListener());
                jtable.setDefaultEditor(Date.class, dateEditor);
            } else if (value instanceof String) {
                SxField textField = new SxField();
                textField.setMargin(new Insets(0, 2, 0, 2));
                textField.setJTable(jtable);
                textField.setHorizontalAlignment(4);
                DefaultCellEditor textEditor = new DefaultCellEditor(textField);
                textEditor.addCellEditorListener(new ChangeEditorListener());
                jtable.setDefaultEditor(String.class, textEditor);
            }
            ++i2;
        }
    }

    private void removeFixedColumns(JTable jtable, int col) {
        SxTableModel model = (SxTableModel)jtable.getModel();
        TableColumnModel columnModel = jtable.getColumnModel();
        jtable.removeColumn(columnModel.getColumn(col));
    }

    private void setHeaderModel(Vector rows) {
        TableColumn header_tableColumn;
        final Vector V_rows = rows;
        final int numberOfRows = V_rows.size();
        final int[] indexes = this.sorter.getIndexes();
        if (this.rowheaderTable == null) {
            return;
        }
        AbstractTableModel headerModel = new AbstractTableModel(){

            @Override
            public int getColumnCount() {
                return SxTablePanel.this.fixedColumns;
            }

            @Override
            public String getColumnName(int col) {
                return (String)SxTablePanel.this.V_header.elementAt(col);
            }

            @Override
            public int getRowCount() {
                return numberOfRows;
            }

            @Override
            public Object getValueAt(int row, int col) {
                Vector n_row = (Vector)V_rows.elementAt(indexes[row]);
                Object obj = n_row.elementAt(col);
                if (obj != null) {
                    if (obj.toString().length() == 0) {
                        return " ";
                    }
                } else {
                    return " ";
                }
                return obj;
            }
        };
        TableColumnModel header_columnModel = this.rowheaderTable.getColumnModel();
        boolean width = false;
        int header_width = 0;
        int col = this.rowheaderTable.getColumnCount();
        int[] arr_width = new int[col];
        int i2 = 0;
        while (i2 < col) {
            header_tableColumn = header_columnModel.getColumn(i2);
            arr_width[i2] = header_tableColumn.getPreferredWidth();
            header_width += arr_width[i2];
            ++i2;
        }
        this.rowheaderTable.setModel(headerModel);
        header_columnModel = this.rowheaderTable.getColumnModel();
        i2 = 0;
        while (i2 < arr_width.length) {
            header_tableColumn = header_columnModel.getColumn(i2);
            header_tableColumn.setPreferredWidth(arr_width[i2]);
            header_tableColumn.setWidth(arr_width[i2]);
            SxHeaderRenderer headerRenderer = new SxHeaderRenderer();
            headerRenderer.setHeaderFont(new Font("SansSerif", 1, 12));
            headerRenderer.setTextLines((String)header_tableColumn.getHeaderValue());
            header_tableColumn.setHeaderRenderer(headerRenderer);
            ++i2;
        }
        Dimension dim = this.rowheaderTable.getPreferredSize();
        dim.width = header_columnModel.getTotalColumnWidth();
        this.rowheaderTable.setPreferredScrollableViewportSize(dim);
    }

    private void setRowHeader(Vector rows) {
        TableColumn table_tableColumn;
        this.rowheaderTable = new JTable();
        this.rowheaderTable.setFont(new Font("SansSerif", 0, 12));
        this.setHeaderModel(rows);
        this.rowheaderTable.setRowHeight((int)((double)this.rowheaderTable.getRowHeight() * 1.25));
        this.rowheaderTable.getTableHeader().setReorderingAllowed(false);
        this.addActionsToTable(this.rowheaderTable);
        this.addMouseListenerToHeaderInTable(this.rowheaderTable);
        this.addResizeListenerToHeaderInTable(this.rowheaderTable);
        this.addMouseListenerInTable(this.rowheaderTable);
        TableColumnModel header_columnModel = this.rowheaderTable.getColumnModel();
        TableColumnModel table_columnModel = this.table.getColumnModel();
        int header_width = 0;
        int headerlines = 1;
        boolean adjustheader = false;
        Dimension header_dim = null;
        int i2 = 0;
        while (i2 < this.fixedColumns) {
            table_tableColumn = table_columnModel.getColumn(i2);
            TableColumn header_tableColumn = header_columnModel.getColumn(i2);
            int width = table_tableColumn.getPreferredWidth();
            header_tableColumn.setPreferredWidth(width);
            header_tableColumn.setWidth(width);
            header_width += width;
            SxHeaderRenderer headerRenderer = new SxHeaderRenderer();
            headerRenderer.setHeaderFont(new Font("SansSerif", 1, 12));
            headerRenderer.setTextLines((String)header_tableColumn.getHeaderValue());
            header_tableColumn.setHeaderRenderer(headerRenderer);
            headerlines = headerRenderer.getNumLines();
            if (headerlines > this.max_headerlines) {
                this.max_headerlines = headerlines;
                header_dim = headerRenderer.getPreferredSize();
                adjustheader = true;
            }
            ++i2;
        }
        if (adjustheader) {
            int i3 = this.fixedColumns;
            while (i3 < table_columnModel.getColumnCount()) {
                table_tableColumn = table_columnModel.getColumn(i3);
                SxHeaderRenderer headerRenderer = (SxHeaderRenderer)table_tableColumn.getHeaderRenderer();
                headerRenderer.setPreferredSize(header_dim);
                ++i3;
            }
        }
        Dimension dim = this.rowheaderTable.getPreferredSize();
        dim.width = header_width;
        this.rowheaderTable.setPreferredScrollableViewportSize(dim);
        this.tableScrollPane.setCorner("UPPER_LEFT_CORNER", this.rowheaderTable.getTableHeader());
        this.tableScrollPane.setRowHeaderView(this.rowheaderTable);
    }

    private void addResizeListenerToHeaderInTable(JTable aTable) {
        final JTable jtable = aTable;
        MouseMotionAdapter columnListener = new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e2) {
                int cursor_type = jtable.getTableHeader().getCursor().getType();
                if (cursor_type != 11) {
                    return;
                }
                int width = e2.getX();
                if (width < 10) {
                    return;
                }
                TableColumnModel columnModel = jtable.getColumnModel();
                int viewColumn = columnModel.getColumnIndexAtX(width);
                int column = jtable.convertColumnIndexToModel(viewColumn);
                TableColumn tableColumn = columnModel.getColumn(column);
                tableColumn.setPreferredWidth(width);
                Dimension dim = jtable.getPreferredSize();
                dim.width = columnModel.getTotalColumnWidth();
                jtable.setPreferredScrollableViewportSize(dim);
                jtable.revalidate();
            }
        };
        jtable.getTableHeader().addMouseMotionListener(columnListener);
    }

    private void addRendererInTable(JTable table) {
        JTable jtable = table;
        DefaultTableCellRenderer numRenderer = new DefaultTableCellRenderer();
        numRenderer.setHorizontalAlignment(4);
        jtable.setDefaultRenderer(Number.class, numRenderer);
        DefaultTableCellRenderer intRenderer = new DefaultTableCellRenderer();
        intRenderer.setHorizontalAlignment(4);
        jtable.setDefaultRenderer(Integer.class, intRenderer);
        jtable.setDefaultRenderer(Short.class, intRenderer);
        jtable.setDefaultRenderer(BigInteger.class, intRenderer);
        DefaultTableCellRenderer decimalRenderer = new DefaultTableCellRenderer();
        decimalRenderer.setHorizontalAlignment(4);
        jtable.setDefaultRenderer(BigDecimal.class, decimalRenderer);
        jtable.setDefaultRenderer(Double.class, decimalRenderer);
        jtable.setDefaultRenderer(Float.class, decimalRenderer);
        jtable.setDefaultRenderer(Long.class, decimalRenderer);
        jtable.setDefaultRenderer(Math.class, decimalRenderer);
        jtable.setDefaultRenderer(Object.class, decimalRenderer);
        DefaultTableCellRenderer stringRenderer = new DefaultTableCellRenderer();
        stringRenderer.setHorizontalAlignment(2);
        jtable.setDefaultRenderer(String.class, stringRenderer);
        DefaultTableCellRenderer dateRenderer = new DefaultTableCellRenderer();
        dateRenderer.setHorizontalAlignment(4);
        jtable.setDefaultRenderer(Date.class, dateRenderer);
        DefaultTableCellRenderer timeRenderer = new DefaultTableCellRenderer();
        timeRenderer.setHorizontalAlignment(4);
        jtable.setDefaultRenderer(Timestamp.class, timeRenderer);
    }

    private void addMouseListenerToHeaderInTable(JTable aTable) {
        final JTable jtable = aTable;
        MouseAdapter listMouseListenerToHeader = new MouseAdapter(){
            int[] columnSelected;
            int columnCount = -1;

            @Override
            public void mousePressed(MouseEvent e2) {
                int button1 = e2.getModifiers() & 0x10;
                int button3 = e2.getModifiers() & 4;
                int cursor_type = jtable.getTableHeader().getCursor().getType();
                if (cursor_type == 11) {
                    return;
                }
                final TableColumnModel columnModel = jtable.getColumnModel();
                int viewColumn = columnModel.getColumnIndexAtX(e2.getX());
                final int column = jtable.convertColumnIndexToModel(viewColumn);
                final TableColumn tcolumn = columnModel.getColumn(viewColumn);
                if (button3 != 0 && e2.getClickCount() == 1 && column != -1) {
                    JPopupMenu menu = new JPopupMenu();
                    JMenuItem sort1 = new JMenuItem("Sortieren aufsteigend");
                    sort1.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent ae) {
                            SxTablePanel.this.sortTable(jtable, column, true);
                        }
                    });
                    JMenuItem sort2 = new JMenuItem("Sortieren absteigend");
                    sort2.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent ae) {
                            SxTablePanel.this.sortTable(jtable, column, false);
                        }
                    });
                    JMenuItem remove = new JMenuItem("Spalte l\u00f6schen", MBStandardIcons.getDelete());
                    remove.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent ae) {
                            columnModel.removeColumn(tcolumn);
                        }
                    });
                    JMenuItem restore = new JMenuItem("Alle \u00c4nderungen r\u00fcckg\u00e4ngig");
                    restore.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent ae) {
                            SxTablePanel.this.restore();
                        }
                    });
                    menu.add(sort1);
                    menu.add(sort2);
                    menu.add(remove);
                    menu.add(restore);
                    menu.show(e2.getComponent(), e2.getX(), e2.getY());
                    return;
                }
                if (button1 != 0 && jtable.equals(SxTablePanel.this.table) && e2.getClickCount() == 1 && column != -1) {
                    SxTablePanel.this.rowheaderTable.clearSelection();
                    jtable.setColumnSelectionAllowed(true);
                    jtable.setRowSelectionAllowed(false);
                    int ctrlPressed = e2.getModifiers() & 2;
                    if (ctrlPressed != 0) {
                        if (SxTablePanel.this.table.getSelectedColumnCount() == 0) {
                            SxTablePanel.this.table.clearSelection();
                        }
                        jtable.addColumnSelectionInterval(viewColumn, viewColumn);
                    } else {
                        SxTablePanel.this.table.clearSelection();
                        jtable.setColumnSelectionInterval(viewColumn, viewColumn);
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent e2) {
                if (jtable.equals(SxTablePanel.this.rowheaderTable)) {
                    return;
                }
                if (jtable.getRowCount() == 0) {
                    return;
                }
                Point point = e2.getPoint();
                int row = jtable.rowAtPoint(point);
                if (row == -1) {
                    TableColumnModel columnModel = jtable.getColumnModel();
                    int UIColumn = columnModel.getColumnIndexAtX(e2.getX());
                    if (UIColumn == -1) {
                        return;
                    }
                    TableColumn tableColumn = columnModel.getColumn(UIColumn);
                    columnModel.removeColumn(tableColumn);
                }
            }
        };
        JTableHeader th = jtable.getTableHeader();
        th.addMouseListener(listMouseListenerToHeader);
        this.mouseToHeader = listMouseListenerToHeader;
    }

    private void addMouseListenerInTable(JTable aTable) {
        final JTable tableView = aTable;
        MouseAdapter listMouseListenerInTable = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e2) {
                int button1 = e2.getModifiers() & 0x10;
                if (button1 == 0) {
                    return;
                }
                int ctrlPressed = e2.getModifiers() & 2;
                if (ctrlPressed != 0) {
                    SxTablePanel.this.table.setColumnSelectionAllowed(false);
                    SxTablePanel.this.rowheaderTable.setColumnSelectionAllowed(false);
                    SxTablePanel.this.table.setRowSelectionAllowed(true);
                    SxTablePanel.this.rowheaderTable.setRowSelectionAllowed(true);
                    int row = tableView.rowAtPoint(e2.getPoint());
                    if (SxTablePanel.this.table.getSelectedRowCount() == 0) {
                        SxTablePanel.this.table.clearSelection();
                        SxTablePanel.this.rowheaderTable.clearSelection();
                    } else {
                        SxTablePanel.this.table.addRowSelectionInterval(row, row);
                        SxTablePanel.this.rowheaderTable.addRowSelectionInterval(row, row);
                    }
                    return;
                }
                int shiftPressed = e2.getModifiers() & 1;
                if (shiftPressed != 0) {
                    return;
                }
                SxTablePanel.this.table.setColumnSelectionAllowed(false);
                SxTablePanel.this.rowheaderTable.setColumnSelectionAllowed(false);
                SxTablePanel.this.table.setRowSelectionAllowed(true);
                SxTablePanel.this.rowheaderTable.setRowSelectionAllowed(true);
                SxTablePanel.this.table.clearSelection();
                SxTablePanel.this.rowheaderTable.clearSelection();
                int row = tableView.rowAtPoint(e2.getPoint());
                SxTablePanel.this.aktuellrow = row;
                SxTablePanel.this.table.setRowSelectionInterval(row, row);
                SxTablePanel.this.rowheaderTable.setRowSelectionInterval(row, row);
            }
        };
        MouseMotionAdapter listMouseMotionListenerInTable = new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e2) {
                int button1 = e2.getModifiers() & 0x10;
                if (button1 == 0) {
                    return;
                }
                int ctrlPressed = e2.getModifiers() & 2;
                if (ctrlPressed != 0) {
                    return;
                }
                int shiftPressed = e2.getModifiers() & 1;
                if (shiftPressed != 0) {
                    return;
                }
                SxTablePanel.this.table.setColumnSelectionAllowed(false);
                SxTablePanel.this.rowheaderTable.setColumnSelectionAllowed(false);
                SxTablePanel.this.table.setRowSelectionAllowed(true);
                SxTablePanel.this.rowheaderTable.setRowSelectionAllowed(true);
                SxTablePanel.this.table.clearSelection();
                SxTablePanel.this.rowheaderTable.clearSelection();
                int row2 = tableView.rowAtPoint(e2.getPoint());
                SxTablePanel.this.table.setRowSelectionInterval(SxTablePanel.this.aktuellrow, row2);
                SxTablePanel.this.rowheaderTable.setRowSelectionInterval(SxTablePanel.this.aktuellrow, row2);
            }
        };
        tableView.addMouseListener(listMouseListenerInTable);
        tableView.addMouseMotionListener(listMouseMotionListenerInTable);
        this.mouseInTable = listMouseListenerInTable;
    }

    private void sortTable(JTable tableView, int column, boolean ascending) {
        SxWaitCursor.set(tableView, true);
        this.sorter.sortByColumn(column, ascending);
        SxWaitCursor.set(tableView, false);
        this.rowheaderTable.revalidate();
        this.rowheaderTable.repaint();
        this.table.revalidate();
        this.table.repaint();
    }

    private void addActionsToTable(JTable aTable) {
        final JTable tableView = aTable;
        AbstractAction Down = new AbstractAction("DOWN"){
            Rectangle rect;
            Rectangle rect_0_0;
            Rectangle rect_vis;
            int row;
            int col_h;
            int col_t;
            int row_height;
            int row_vis;

            @Override
            public void actionPerformed(ActionEvent e2) {
                this.row = tableView.getSelectedRow();
                this.col_h = SxTablePanel.this.rowheaderTable.getSelectedColumn();
                if (this.col_h == -1) {
                    this.col_h = 0;
                }
                this.col_t = SxTablePanel.this.table.getSelectedColumn();
                if (this.col_t == -1) {
                    this.col_t = 0;
                }
                this.rect_0_0 = tableView.getCellRect(0, 0, true);
                this.rect_vis = tableView.getVisibleRect();
                this.row_height = tableView.getScrollableBlockIncrement(this.rect_0_0, 1, 1);
                this.row_vis = this.rect_vis.height / this.row_height - 1;
                if (this.row + 1 < tableView.getRowCount()) {
                    ++this.row;
                    SxTablePanel.this.rowheaderTable.setRowSelectionInterval(this.row, this.row);
                    SxTablePanel.this.table.setRowSelectionInterval(this.row, this.row);
                    this.rect = tableView.getCellRect(this.row, this.col_h, true);
                    SxTablePanel.this.rowheaderTable.scrollRectToVisible(this.rect);
                    this.rect = SxTablePanel.this.table.getCellRect(this.row, this.col_t, true);
                    SxTablePanel.this.table.scrollRectToVisible(this.rect);
                }
            }
        };
        AbstractAction Up = new AbstractAction("UP"){
            Rectangle rect;
            Rectangle rect_0_0;
            Rectangle rect_vis;
            int row;
            int col_h;
            int col_t;
            int row_height;
            int row_vis;

            @Override
            public void actionPerformed(ActionEvent e2) {
                this.row = tableView.getSelectedRow();
                this.col_h = SxTablePanel.this.rowheaderTable.getSelectedColumn();
                if (this.col_h == -1) {
                    this.col_h = 0;
                }
                this.col_t = SxTablePanel.this.table.getSelectedColumn();
                if (this.col_t == -1) {
                    this.col_t = 0;
                }
                this.rect_0_0 = tableView.getCellRect(0, 0, true);
                this.rect_vis = tableView.getVisibleRect();
                this.row_height = tableView.getScrollableBlockIncrement(this.rect_0_0, 1, 1);
                this.row_vis = this.rect_vis.height / this.row_height - 1;
                if (this.row > 0) {
                    --this.row;
                    SxTablePanel.this.rowheaderTable.setRowSelectionInterval(this.row, this.row);
                    SxTablePanel.this.table.setRowSelectionInterval(this.row, this.row);
                    this.rect = tableView.getCellRect(this.row, this.col_h, true);
                    SxTablePanel.this.rowheaderTable.scrollRectToVisible(this.rect);
                    this.rect = SxTablePanel.this.table.getCellRect(this.row, this.col_t, true);
                    SxTablePanel.this.table.scrollRectToVisible(this.rect);
                }
            }
        };
        AbstractAction Left = new AbstractAction("LEFT"){
            Rectangle rect;
            Rectangle rect_0_0;
            Rectangle rect_vis;
            int row;
            int col_h;
            int col_t;
            int row_height;
            int row_vis;

            @Override
            public void actionPerformed(ActionEvent e2) {
                this.row = tableView.getSelectedRow();
                this.col_h = SxTablePanel.this.rowheaderTable.getSelectedColumn();
                if (this.col_h == -1) {
                    this.col_h = 0;
                }
                this.col_t = SxTablePanel.this.table.getSelectedColumn();
                if (this.col_t == -1) {
                    this.col_t = 0;
                }
                this.rect_0_0 = tableView.getCellRect(0, 0, true);
                this.rect_vis = tableView.getVisibleRect();
                this.row_height = tableView.getScrollableBlockIncrement(this.rect_0_0, 1, 1);
                this.row_vis = this.rect_vis.height / this.row_height - 1;
                if (tableView.equals(SxTablePanel.this.rowheaderTable)) {
                    if (this.col_h > 0) {
                        --this.col_h;
                        SxTablePanel.this.rowheaderTable.setColumnSelectionInterval(this.col_h, this.col_h);
                        this.rect = SxTablePanel.this.rowheaderTable.getCellRect(this.row, this.col_h, true);
                        SxTablePanel.this.rowheaderTable.scrollRectToVisible(this.rect);
                    }
                    return;
                }
                if (tableView.equals(SxTablePanel.this.table)) {
                    if (this.col_t == 0) {
                        SxTablePanel.this.rowheaderTable.requestFocus();
                        this.rect = SxTablePanel.this.rowheaderTable.getCellRect(this.row, this.col_h, true);
                        SxTablePanel.this.rowheaderTable.scrollRectToVisible(this.rect);
                    } else {
                        --this.col_t;
                        SxTablePanel.this.table.setColumnSelectionInterval(this.col_t, this.col_t);
                        this.rect = SxTablePanel.this.table.getCellRect(this.row, this.col_t, true);
                        SxTablePanel.this.table.scrollRectToVisible(this.rect);
                    }
                    return;
                }
            }
        };
        AbstractAction Right2 = new AbstractAction("RIGHT"){
            Rectangle rect;
            Rectangle rect_0_0;
            Rectangle rect_vis;
            int row;
            int col_h;
            int col_t;
            int row_height;
            int row_vis;

            @Override
            public void actionPerformed(ActionEvent e2) {
                this.row = tableView.getSelectedRow();
                this.col_h = SxTablePanel.this.rowheaderTable.getSelectedColumn();
                if (this.col_h == -1) {
                    this.col_h = 0;
                }
                this.col_t = SxTablePanel.this.table.getSelectedColumn();
                if (this.col_t == -1) {
                    this.col_t = 0;
                }
                this.rect_0_0 = tableView.getCellRect(0, 0, true);
                this.rect_vis = tableView.getVisibleRect();
                this.row_height = tableView.getScrollableBlockIncrement(this.rect_0_0, 1, 1);
                this.row_vis = this.rect_vis.height / this.row_height - 1;
                if (tableView.equals(SxTablePanel.this.rowheaderTable)) {
                    if (this.col_h == SxTablePanel.this.rowheaderTable.getColumnCount() - 1) {
                        SxTablePanel.this.table.requestFocus();
                        this.rect = SxTablePanel.this.table.getCellRect(this.row, this.col_t, true);
                        SxTablePanel.this.table.scrollRectToVisible(this.rect);
                    } else {
                        ++this.col_h;
                        SxTablePanel.this.rowheaderTable.setColumnSelectionInterval(this.col_h, this.col_h);
                        this.rect = SxTablePanel.this.rowheaderTable.getCellRect(this.row, this.col_h, true);
                        SxTablePanel.this.rowheaderTable.scrollRectToVisible(this.rect);
                    }
                    return;
                }
                if (tableView.equals(SxTablePanel.this.table)) {
                    if (this.col_t < SxTablePanel.this.table.getColumnCount() - 1) {
                        ++this.col_t;
                        SxTablePanel.this.table.setColumnSelectionInterval(this.col_t, this.col_t);
                        this.rect = SxTablePanel.this.table.getCellRect(this.row, this.col_t, true);
                        SxTablePanel.this.table.scrollRectToVisible(this.rect);
                    }
                    return;
                }
            }
        };
        AbstractAction pageDown = new AbstractAction("PAGE_DOWN"){
            Rectangle rect;
            Rectangle rect_0_0;
            Rectangle rect_vis;
            int row;
            int col_h;
            int col_t;
            int row_height;
            int row_vis;

            @Override
            public void actionPerformed(ActionEvent e2) {
                this.row = tableView.getSelectedRow();
                this.col_h = SxTablePanel.this.rowheaderTable.getSelectedColumn();
                if (this.col_h == -1) {
                    this.col_h = 0;
                }
                this.col_t = SxTablePanel.this.table.getSelectedColumn();
                if (this.col_t == -1) {
                    this.col_t = 0;
                }
                this.rect_0_0 = tableView.getCellRect(0, 0, true);
                this.rect_vis = tableView.getVisibleRect();
                this.row_height = tableView.getScrollableBlockIncrement(this.rect_0_0, 1, 1);
                this.row_vis = this.rect_vis.height / this.row_height - 1;
                if (this.row + this.row_vis < tableView.getRowCount()) {
                    this.row += this.row_vis;
                    SxTablePanel.this.rowheaderTable.setRowSelectionInterval(this.row, this.row);
                    SxTablePanel.this.table.setRowSelectionInterval(this.row, this.row);
                    this.rect = tableView.getCellRect(this.row, this.col_h, true);
                    SxTablePanel.this.rowheaderTable.scrollRectToVisible(this.rect);
                    this.rect = SxTablePanel.this.table.getCellRect(this.row, this.col_t, true);
                    SxTablePanel.this.table.scrollRectToVisible(this.rect);
                }
            }
        };
        AbstractAction pageUp = new AbstractAction("PAGE_UP"){
            Rectangle rect;
            Rectangle rect_0_0;
            Rectangle rect_vis;
            int row;
            int col_h;
            int col_t;
            int row_height;
            int row_vis;

            @Override
            public void actionPerformed(ActionEvent e2) {
                this.row = tableView.getSelectedRow();
                this.col_h = SxTablePanel.this.rowheaderTable.getSelectedColumn();
                if (this.col_h == -1) {
                    this.col_h = 0;
                }
                this.col_t = SxTablePanel.this.table.getSelectedColumn();
                if (this.col_t == -1) {
                    this.col_t = 0;
                }
                this.rect_0_0 = tableView.getCellRect(0, 0, true);
                this.rect_vis = tableView.getVisibleRect();
                this.row_height = tableView.getScrollableBlockIncrement(this.rect_0_0, 1, 1);
                this.row_vis = this.rect_vis.height / this.row_height - 1;
                if (this.row - this.row_vis > 0) {
                    this.row -= this.row_vis;
                    SxTablePanel.this.rowheaderTable.setRowSelectionInterval(this.row, this.row);
                    SxTablePanel.this.table.setRowSelectionInterval(this.row, this.row);
                    this.rect = tableView.getCellRect(this.row, this.col_h, true);
                    SxTablePanel.this.rowheaderTable.scrollRectToVisible(this.rect);
                    this.rect = SxTablePanel.this.table.getCellRect(this.row, this.col_t, true);
                    SxTablePanel.this.table.scrollRectToVisible(this.rect);
                }
            }
        };
        AbstractAction Enter = new AbstractAction("ENTER"){
            JButton defaultBtn;
            Rectangle rect;
            Rectangle rect_0_0;
            Rectangle rect_vis;
            int row;
            int col_h;
            int col_t;
            int row_height;
            int row_vis;

            @Override
            public void actionPerformed(ActionEvent e2) {
                this.row = tableView.getSelectedRow();
                this.col_h = SxTablePanel.this.rowheaderTable.getSelectedColumn();
                if (this.col_h == -1) {
                    this.col_h = 0;
                }
                this.col_t = SxTablePanel.this.table.getSelectedColumn();
                if (this.col_t == -1) {
                    this.col_t = 0;
                }
                this.rect_0_0 = tableView.getCellRect(0, 0, true);
                this.rect_vis = tableView.getVisibleRect();
                this.row_height = tableView.getScrollableBlockIncrement(this.rect_0_0, 1, 1);
                this.row_vis = this.rect_vis.height / this.row_height - 1;
                JButton defaultBtn = tableView.getRootPane().getDefaultButton();
                if (defaultBtn != null) {
                    defaultBtn.doClick();
                }
            }
        };
        AbstractAction Tab = new AbstractAction("TAB"){
            JButton defaultBtn;

            @Override
            public void actionPerformed(ActionEvent e2) {
                this.defaultBtn = tableView.getRootPane().getDefaultButton();
                if (this.defaultBtn != null) {
                    this.defaultBtn.requestFocus();
                }
            }
        };
    }

    class ChangeEditorListener
    implements CellEditorListener {
        ChangeEditorListener() {
        }

        @Override
        public void editingStopped(ChangeEvent e2) {
            System.err.println("ChangeEditorListener: Editing stopped .. Update ..");
        }

        @Override
        public void editingCanceled(ChangeEvent e2) {
            System.err.println("ChangeEditorListener: Editing canceled ..");
        }
    }
}

