/*
 * Decompiled with CFR 0.152.
 */
package de.memtext.widgets;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;

public class MBToggleButton
extends JButton {
    private String captionA;
    private String captionB;
    private String actionCommandA;
    private String actionCommandB;
    private Icon imageA;
    private Icon imageB;
    private String toolTipTextA;
    private String toolTipTextB;
    private boolean isVariantA;
    private ActionListener listener;

    public MBToggleButton() {
        this(null, null, null, null);
    }

    public MBToggleButton(String captionA, String captionB) {
        this(captionA, null, captionB, null);
    }

    public MBToggleButton(Icon iconA, Icon iconB) {
        this(null, iconA, null, iconB);
    }

    public MBToggleButton(String captionA, Icon iconA, String captionB, Icon iconB) {
        MBToggleButtonModel2 model = new MBToggleButtonModel2();
        super.setModel(model);
        this.setName("MBToggleBtn" + captionA + "/" + captionB);
        this.isVariantA = true;
        this.setImageA(iconA);
        this.setImageB(iconB);
        this.captionA = captionA;
        this.captionB = captionB;
        this.setVariantA();
    }

    public void toggle() {
        if (this.isVariantA) {
            this.setVariantB();
        } else {
            this.setVariantA();
        }
    }

    public void setVariantA() {
        super.setText(this.captionA);
        super.setActionCommand(this.actionCommandA);
        super.setToolTipText(this.toolTipTextA);
        super.setIcon(this.imageA);
        this.isVariantA = true;
    }

    public void setVariantB() {
        super.setText(this.captionB);
        super.setActionCommand(this.actionCommandB);
        super.setToolTipText(this.toolTipTextB);
        super.setIcon(this.imageB);
        this.isVariantA = false;
    }

    private void updateCurrentVariant() {
        if (this.isVariantA) {
            this.setVariantA();
        } else {
            this.setVariantB();
        }
    }

    public String getActionCommandA() {
        return this.actionCommandA;
    }

    public String getActionCommandB() {
        return this.actionCommandB;
    }

    public String getCaptionA() {
        return this.captionA;
    }

    public String getCaptionB() {
        return this.captionB;
    }

    public Icon getImageA() {
        return this.imageA;
    }

    public Icon getImageB() {
        return this.imageB;
    }

    public void setActionCommandA(String actionCommandA) {
        this.actionCommandA = actionCommandA;
        this.updateCurrentVariant();
    }

    public void setActionCommandB(String actionCommandB) {
        this.actionCommandB = actionCommandB;
        this.updateCurrentVariant();
    }

    public void setCaptionA(String captionA) {
        this.captionA = captionA;
        this.updateCurrentVariant();
    }

    public void setCaptionB(String captionB) {
        this.captionB = captionB;
        this.updateCurrentVariant();
    }

    public void setImageA(Icon imageA) {
        this.imageA = imageA;
        this.updateCurrentVariant();
    }

    public void setImageB(Icon imageB) {
        this.imageB = imageB;
        this.updateCurrentVariant();
    }

    public void setSingleActionCommand(String actionCommand) {
        this.actionCommandA = this.actionCommandB = actionCommand;
        this.updateCurrentVariant();
    }

    @Override
    public void setActionCommand(String ac) {
        throw new UnsupportedOperationException("overriden to avoid inconsistencies. Use setActionCommandA/B or setSingleActionCommand.");
    }

    @Override
    public void setToolTipText(String txt) {
        throw new UnsupportedOperationException("overriden to avoid inconsistencies. Use setToolTipTextA/B");
    }

    public String getToolTipTextA() {
        return this.toolTipTextA;
    }

    public String getToolTipTextB() {
        return this.toolTipTextB;
    }

    public void setToolTipTextA(String toolTipTextA) {
        this.toolTipTextA = toolTipTextA;
        if (this.isVariantA) {
            super.setToolTipText(toolTipTextA);
        }
    }

    public void setToolTipTextB(String toolTipTextB) {
        this.toolTipTextB = toolTipTextB;
        if (!this.isVariantA) {
            super.setToolTipText(toolTipTextB);
        }
    }

    public boolean isVariantA() {
        return this.isVariantA;
    }

    class MBToggleButtonModel2
    extends DefaultButtonModel {
        MBToggleButtonModel2() {
        }

        @Override
        protected void fireActionPerformed(ActionEvent e2) {
            boolean oldVariant = MBToggleButton.this.isVariantA();
            super.fireActionPerformed(e2);
        }
    }
}

