/*
 * Decompiled with CFR 0.152.
 */
package de.memtext.util;

import de.memtext.util.FilenamesFilter;
import de.memtext.util.StringUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class FileUtils {
    private FileUtils() {
    }

    public static int getHowOld(File f2) {
        long now = new Date().getTime();
        return (int)((now - f2.lastModified()) / 60000L);
    }

    public static String getFileNameWithoutSuffix(String filename) {
        int index = filename.indexOf(".");
        if (index == -1) {
            throw new IllegalArgumentException(String.valueOf(filename) + " doesn't contain .");
        }
        filename = filename.substring(0, index);
        return filename;
    }

    public static String addToEndOfFileName(String filename, String suffix) {
        int index = filename.indexOf(".");
        if (index == -1) {
            throw new IllegalArgumentException(String.valueOf(filename) + " doesn't contain .");
        }
        filename = String.valueOf(filename.substring(0, index)) + suffix + filename.substring(index, filename.length());
        return filename;
    }

    public static File[] getFileList(File dir, String beginning, String endings) {
        FilenamesFilter filt = new FilenamesFilter(null, endings, beginning);
        filt.setAllDirsAccepted(false);
        return dir.listFiles(filt);
    }

    public static void copyFile(String source, String target) throws IOException {
        FileUtils.copyFile(new File(source), new File(target));
    }

    public static void copyFile(File source, File target) throws IOException {
        FileInputStream is = null;
        FileOutputStream os = null;
        BufferedInputStream in = null;
        BufferedOutputStream out = null;
        try {
            is = new FileInputStream(source);
            os = new FileOutputStream(target);
            in = new BufferedInputStream(is);
            out = new BufferedOutputStream(os);
            int buffer_size = 32768;
            byte[] buffer = new byte[buffer_size];
            int len = in.read(buffer, 0, buffer_size);
            while (len != -1) {
                out.write(buffer, 0, len);
                len = in.read(buffer, 0, buffer_size);
            }
            in.close();
            is.close();
            out.close();
            os.close();
        }
        catch (FileNotFoundException fe) {
            throw new FileNotFoundException("Die Datei " + source + " konnte nicht gefunden werden!");
        }
        catch (IOException e2) {
            throw new IOException("Couldn't copy file " + e2.toString());
        }
    }

    public static void createZipFile(String pathToZipUp, String pathToSaveTo) {
        FileUtils.createZipFile(pathToZipUp, "", pathToSaveTo);
    }

    public static void createZipFile(String pathToZipUp, String relPath, String pathToSaveTo) {
        try {
            FileOutputStream fos = new FileOutputStream(pathToSaveTo);
            ZipOutputStream zos = new ZipOutputStream(fos);
            zos.setMethod(8);
            if (!relPath.equals("") && pathToZipUp.lastIndexOf("\\") + 1 != pathToZipUp.length()) {
                pathToZipUp = String.valueOf(pathToZipUp) + "\\";
            }
            System.out.println(String.valueOf(pathToZipUp) + relPath);
            File f2 = new File(String.valueOf(pathToZipUp) + relPath);
            String[] files = f2.list();
            if (pathToZipUp.lastIndexOf("\\") + 1 != pathToZipUp.length()) {
                pathToZipUp = String.valueOf(pathToZipUp) + "\\";
            }
            int y = 0;
            while (y < files.length) {
                File aFile;
                String fullpath = pathToZipUp;
                if (!relPath.equals("")) {
                    fullpath = String.valueOf(fullpath) + relPath + "\\";
                }
                if ((aFile = new File(fullpath = String.valueOf(fullpath) + files[y])).isDirectory()) {
                    relPath = relPath.equals("") ? files[y] : String.valueOf(relPath) + "\\" + files[y];
                    FileUtils.createZipFile(fullpath, relPath, pathToSaveTo);
                } else {
                    byte[] temp = new byte[files[y].length()];
                    try {
                        int n;
                        FileInputStream fis = new FileInputStream(aFile);
                        CRC32 crc32 = new CRC32();
                        while ((n = fis.read(temp)) > -1) {
                            crc32.update(temp, 0, n);
                        }
                        fis.close();
                        String shortName = files[y].substring(fullpath.length());
                        ZipEntry ze = new ZipEntry(shortName);
                        ze.setSize(aFile.length());
                        ze.setTime(aFile.lastModified());
                        ze.setCrc(crc32.getValue());
                        zos.putNextEntry(ze);
                        fis = new FileInputStream(aFile);
                        while ((n = fis.read(temp)) > -1) {
                            zos.write(temp, 0, n);
                        }
                        fis.close();
                        zos.closeEntry();
                    }
                    catch (FileNotFoundException e2) {
                        e2.printStackTrace();
                    }
                    catch (IOException e3) {
                        e3.printStackTrace();
                    }
                    catch (Exception e4) {
                        e4.printStackTrace();
                    }
                }
                ++y;
            }
            zos.close();
        }
        catch (FileNotFoundException e5) {
            e5.printStackTrace();
        }
        catch (Exception e6) {
            e6.printStackTrace();
        }
    }

    public static void main(String[] a2) {
        System.out.println(FileUtils.removeProblemChars("test/test2"));
        System.out.println(FileUtils.removeProblemChars("test\\test2"));
        System.out.println(FileUtils.removeProblemChars("test *test2"));
    }

    public static void download(URL url, File targetFile) throws IOException {
        URLConnection conn = url.openConnection();
        InputStream inStream = conn.getInputStream();
        FileOutputStream os = new FileOutputStream(targetFile);
        BufferedInputStream bufferedInStream = new BufferedInputStream(inStream);
        BufferedOutputStream bufferedOutStream = new BufferedOutputStream(os);
        int buffer_size = 32768;
        byte[] buffer = new byte[buffer_size];
        int len = inStream.read(buffer, 0, buffer_size);
        while (len != -1) {
            bufferedOutStream.write(buffer, 0, len);
            len = bufferedInStream.read(buffer, 0, buffer_size);
        }
        bufferedInStream.close();
        inStream.close();
        bufferedOutStream.close();
        os.close();
    }

    public static String removeProblemChars(String name) {
        String result = name.replace('\\', '-');
        result = result.replace('/', '-');
        result = StringUtils.replace(result, " - ", "-");
        result = StringUtils.replace(result, " -", "-");
        result = StringUtils.replace(result, "- ", "-");
        result = result.replace(' ', '_');
        result = result.replace('*', '_');
        result = result.replace('?', '_');
        return result;
    }
}

