/*
 * Decompiled with CFR 0.152.
 */
package de.memtext.util;

import de.memtext.widgets.UneditableTextArea;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class FMProcessor
extends JFrame {
    protected Configuration cfg = new Configuration();
    protected JTextField tfPath;
    protected JTextField tfTemplate;
    protected JTextArea txtTemplate;
    protected JTextArea txtResult;
    private Object rootMap;

    public FMProcessor(String title) {
        super(title);
        JPanel top = new JPanel();
        top.add(new JLabel("Path:"));
        this.tfPath = new JTextField(30);
        top.add(this.tfPath);
        top.add(new JLabel("Template:"));
        this.tfTemplate = new JTextField(10);
        top.add(this.tfTemplate);
        JButton process = new JButton("process");
        process.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                FMProcessor.this.process();
            }
        });
        top.add(process);
        this.getContentPane().add((Component)top, "North");
        this.txtResult = new UneditableTextArea();
        this.txtTemplate = new UneditableTextArea();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.txtTemplate.setPreferredSize(new Dimension(screenSize.width / 2 - 100, screenSize.height - 300));
        JSplitPane jsp = new JSplitPane();
        jsp.setLeftComponent(new JScrollPane(this.txtTemplate));
        jsp.setRightComponent(new JScrollPane(this.txtResult));
        this.getContentPane().add((Component)jsp, "Center");
        jsp.setDividerLocation(0.5);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                System.exit(0);
            }
        });
        this.setSize(screenSize.width - 50, screenSize.height - 100);
    }

    protected void buildDataModel() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("DATABASE_ABBR", "PG");
        map.put("MB_MACRO", "<#macro mb> MB makro is there  </#macro>");
        this.setRootMap(map);
    }

    protected void setRootMap(Object rootMap) {
        this.rootMap = rootMap;
    }

    protected void process() {
        try {
            this.buildDataModel();
            File dir = new File(this.tfPath.getText());
            this.cfg.setDirectoryForTemplateLoading(dir);
            this.cfg.setWhitespaceStripping(true);
            Template t = this.cfg.getTemplate(this.tfTemplate.getText());
            StringWriter out = new StringWriter();
            t.dump((Writer)out);
            this.txtTemplate.setText(((Object)out).toString());
            ((Writer)out).close();
            out = new StringWriter();
            t.process(this.rootMap, (Writer)out);
            ((Writer)out).close();
            this.txtResult.setText(((Object)out).toString());
            this.txtResult.setCaretPosition(0);
        }
        catch (Exception e2) {
            JOptionPane.showMessageDialog(this, e2.toString());
            e2.printStackTrace();
        }
    }

    protected void setDefaultPath(String path) {
        this.tfPath.setText(path);
    }

    protected void setDefaultTemplate(String filename) {
        this.tfTemplate.setText(filename);
    }

    public static void main(String[] args) {
        FMProcessor app = new FMProcessor("FMProcessor");
        app.setDefaultPath("e:/mb/diss/workspace/SuperX");
        app.setDefaultTemplate("test1.ftl");
        app.show();
    }
}

