/*
 * Decompiled with CFR 0.152.
 */
package de.memtext.tree.admin;

import de.memtext.db.DBAccess;
import de.memtext.tree.admin.AddSubNodeAction;
import de.memtext.tree.admin.AddTopLevelNodeAction;
import de.memtext.tree.admin.AdminTree;
import de.memtext.tree.admin.AdminTreeModel;
import de.memtext.tree.admin.DeleteAction;
import de.memtext.tree.admin.EditAction;
import de.memtext.tree.admin.ExitAction;
import de.memtext.tree.admin.SaveAction;
import de.memtext.tree.admin.Status;
import de.memtext.widgets.LogPanel;
import de.memtext.widgets.TitlePanel;
import de.memtext.widgets.WarningMessage;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;

public class RecursiveTableAdminPanel
extends JPanel {
    private AdminTreeModel model;
    private AdminTree tree;
    private EditAction editAction;
    private DeleteAction deleteAction;
    private AddSubNodeAction addSubNodeAction;
    private AddTopLevelNodeAction addTopLevelNodeAction;
    private SaveAction saveAction;
    private ExitAction exitAction;
    private final TitlePanel titlePanel = new TitlePanel();
    private final LogPanel logPanel = new LogPanel();

    public RecursiveTableAdminPanel(String tablename) {
        super(new BorderLayout());
        this.add((Component)this.titlePanel, "North");
        this.add((Component)this.logPanel, "South");
        this.titlePanel.setTitleText(tablename);
        try {
            this.model = new AdminTreeModel(tablename);
            if (!this.model.getProtocol().equals("")) {
                this.logPanel.log(this.model.getProtocol());
            }
        }
        catch (Exception e2) {
            this.closeWithWarning(e2);
        }
        this.saveAction = new SaveAction("Save", this.model);
        this.exitAction = new ExitAction("Exit", this.model);
        Status.getInstance().addObserver(this.exitAction);
        this.addTopLevelNodeAction = new AddTopLevelNodeAction("Add Top Level Node", this.model);
        this.editAction = new EditAction("Edit Node", this.model);
        this.deleteAction = new DeleteAction("Delete Node", this.model);
        this.addSubNodeAction = new AddSubNodeAction("Add Subnode", this.model);
        this.tree = new AdminTree(this.model, this.getPopupMenu());
        this.model.addTreeModelListener(this.tree);
        this.model.addTreeModelListener(Status.getInstance());
        this.tree.addTreeSelectionListener(this.editAction);
        this.tree.addTreeSelectionListener(this.addSubNodeAction);
        this.tree.addTreeSelectionListener(this.deleteAction);
        this.titlePanel.add(this.getToolBar());
        this.add((Component)new JScrollPane(this.tree), "Center");
    }

    private void closeWithWarning(Exception e2) {
        WarningMessage msg = new WarningMessage(this, "Fehler: " + e2);
        msg.show();
        e2.printStackTrace();
        DBAccess.get("RecursiveTableAdmin").closeConnection();
        System.exit(-1);
    }

    public void setTable(String tablename) {
        try {
            this.logPanel.logln("Changing to table: " + tablename);
            this.titlePanel.setTitleText(tablename);
            this.model.setTable(tablename);
            if (!this.model.getProtocol().equals("")) {
                this.logPanel.log(this.model.getProtocol());
            }
        }
        catch (Exception e2) {
            this.closeWithWarning(e2);
        }
    }

    private JPopupMenu getPopupMenu() {
        JPopupMenu popmenu = new JPopupMenu();
        popmenu.add(this.addSubNodeAction);
        popmenu.add(this.editAction);
        popmenu.add(this.deleteAction);
        return popmenu;
    }

    public JToolBar getToolBar() {
        JToolBar toolbar = new JToolBar();
        toolbar.add(this.addTopLevelNodeAction);
        toolbar.add(this.addSubNodeAction);
        toolbar.add(this.editAction);
        toolbar.add(this.deleteAction);
        return toolbar;
    }

    public JMenuBar getAMenuBar() {
        JMenuBar bar = new JMenuBar();
        JMenu m1 = new JMenu("Program");
        m1.add(this.saveAction);
        m1.add(this.exitAction);
        bar.add(m1);
        JMenu medit = new JMenu("Edit");
        medit.add(this.addTopLevelNodeAction);
        medit.add(this.addSubNodeAction);
        medit.add(this.editAction);
        medit.add(this.deleteAction);
        bar.add(medit);
        return bar;
    }

    private void end() {
        DBAccess.get("RecursiveTableAdmin").closeConnection();
        System.exit(-1);
    }
}

