/*
 * Decompiled with CFR 0.152.
 */
package com.informix.asf;

import com.informix.lang.IntervalDF;
import com.informix.lang.IntervalYM;
import com.informix.lang.JavaToIfxType;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;

public class IfxDataOutputStream
extends FilterOutputStream {
    protected int written = 0;
    private int byteCountAtEOT;
    private OutputStream os;
    private boolean usestrenc = false;
    static final int one = 1;
    private JavaToIfxType javatoifx = new JavaToIfxType();

    public IfxDataOutputStream(OutputStream outputStream) {
        super(outputStream);
        this.os = outputStream;
    }

    public IfxDataOutputStream(OutputStream outputStream, boolean bl) {
        super(outputStream);
        this.os = outputStream;
        this.usestrenc = bl;
    }

    public void write(int n) throws IOException {
        this.os.write(n);
        ++this.written;
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.os.write(byArray, n, n2);
        this.written += n2;
    }

    public void writePadded(byte[] byArray, int n, int n2) throws IOException {
        this.os.write(byArray, n, n2);
        this.written += n2;
        if ((n2 & 1) >= 1) {
            this.write(0);
        }
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void writeWithMangledTrace(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void writePadded(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
        if ((byArray.length & 1) >= 1) {
            this.write(0);
        }
    }

    public void writeInt(int n) throws IOException {
        byte[] byArray = JavaToIfxType.JavaToIfxInt(n);
        this.write(byArray);
    }

    public void flush() throws IOException {
        this.os.flush();
    }

    public void writeByte(int n) throws IOException {
        this.write(n);
    }

    public void writeBytes(String string) throws IOException {
        byte[] byArray = this.javatoifx.JavaToIfxChar(string, this.usestrenc);
        this.write(byArray, 2, byArray.length - 2);
    }

    public void writeBytes(String string, String string2) throws IOException {
        byte[] byArray = this.javatoifx.JavaToIfxChar(string, string2, this.usestrenc);
        this.write(byArray, 2, byArray.length - 2);
    }

    public void writeChar(String string) throws IOException {
        byte[] byArray = this.javatoifx.JavaToIfxChar(string, this.usestrenc);
        this.write(byArray);
        if ((byArray.length & 1) >= 1) {
            this.write(0);
        }
    }

    public void writeChar(String string, String string2) throws IOException {
        byte[] byArray = this.javatoifx.JavaToIfxChar(string, string2, this.usestrenc);
        this.write(byArray);
        if ((byArray.length & 1) >= 1) {
            this.write(0);
        }
    }

    public void writeChars(String string) throws IOException {
        this.writeChar(string);
    }

    public void writeDate(Date date) throws IOException {
        byte[] byArray = JavaToIfxType.JavaToIfxDate(date);
        this.write(byArray);
    }

    public void writeDateTime(Timestamp timestamp) throws IOException {
        byte[] byArray = JavaToIfxType.JavaToIfxDateTime(timestamp);
        this.write(byArray);
        if ((byArray.length & 1) >= 1) {
            this.write(0);
        }
    }

    public void writeInterval(IntervalDF intervalDF) throws IOException {
        byte[] byArray = JavaToIfxType.JavaToIfxInterval(intervalDF);
        this.write(byArray);
        if ((byArray.length & 1) >= 1) {
            this.write(0);
        }
    }

    public void writeInterval(IntervalYM intervalYM) throws IOException {
        byte[] byArray = JavaToIfxType.JavaToIfxInterval(intervalYM);
        this.write(byArray);
        if ((byArray.length & 1) >= 1) {
            this.write(0);
        }
    }

    public void writeDecimal(BigDecimal bigDecimal) throws IOException {
        byte[] byArray = JavaToIfxType.JavaToIfxDecimal(bigDecimal);
        this.write(byArray);
        if ((byArray.length & 1) >= 1) {
            this.write(0);
        }
    }

    public void writeDouble(double d2) throws IOException {
        byte[] byArray = JavaToIfxType.JavaToIfxDouble(d2);
        this.write(byArray);
        if ((byArray.length & 1) >= 1) {
            this.write(0);
        }
    }

    public void writeReal(float f2) throws IOException {
        byte[] byArray = JavaToIfxType.JavaToIfxReal(f2);
        this.write(byArray);
        if ((byArray.length & 1) >= 1) {
            this.write(0);
        }
    }

    public void writeSmallInt(short s) throws IOException {
        byte[] byArray = JavaToIfxType.JavaToIfxSmallInt(s);
        this.write(byArray);
    }

    public void writeShort(int n) throws IOException {
        short s = (short)n;
        this.writeSmallInt(s);
    }

    public void writeShort(short s) throws IOException {
        this.writeSmallInt(s);
    }

    public void writeLongInt(long l2) throws IOException {
        byte[] byArray = JavaToIfxType.JavaToIfxLongInt(l2);
        this.write(byArray);
    }

    public void writeLongBigint(long l2) throws IOException {
        byte[] byArray = JavaToIfxType.JavaToIfxLongBigInt(l2);
        this.write(byArray);
    }

    public void writeLong(long l2) throws IOException {
        this.writeLongInt(l2);
    }

    public void setByteCntAtEOT() {
        this.byteCountAtEOT = this.written;
    }

    public int getBytesSentSinceLastEOT() {
        return this.written - this.byteCountAtEOT;
    }
}

