/*
 * Decompiled with CFR 0.152.
 */
package de.superx.servlet;

import de.his.utils.string.parser.RightsParser;
import de.memtext.db.DBAccess;
import de.memtext.db.NichtAngemeldetException;
import de.superx.common.DBServletException;
import de.superx.servlet.SxPools;
import de.superx.servlet.TokenChecker;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.logging.Level;

class UserAndRightsStreamliner {
    private static final String ADMIN = "CS_BIA_STANDARDREPORTS_ADMIN";
    private static final String ADMIN_RIGHT = "RIGHT_CS_BIA_STANDARDREPORTS_ADMIN";
    private static final String VIEW_REPORTS = "CS_BIA_STANDARDREPORTS_VIEW_REPORTS";
    private static final String VIEW_REPORTS_RIGHT = "RIGHT_CS_BIA_STANDARDREPORTS_VIEW_REPORTS";
    private static final String ADMIN_TOPIC_AREA = "CS_BIA_ADMINISTRATE_TOPIC_AREA";
    private static final String ADMIN_TOPIC_AREA_RIGHT = "RIGHT_CS_BIA_ADMINISTRATE_TOPIC_AREA";
    private boolean isLogWanted = false;

    UserAndRightsStreamliner() {
    }

    public static synchronized Map<String, Map<String, String>> streamline(String mandantenID, TokenChecker tc) throws SQLException, NichtAngemeldetException, DBServletException {
        Connection con = SxPools.get(mandantenID).getConnection();
        String rights = tc.getRights();
        RightsParser rightsParser = new RightsParser(rights);
        Map rightsMap = rightsParser.parse();
        try {
            int userid = UserAndRightsStreamliner.streamlineUserId(tc, con);
            if (rightsMap.containsKey(ADMIN_RIGHT)) {
                UserAndRightsStreamliner.setAdminRights(userid, con);
            } else {
                UserAndRightsStreamliner.removePossibleAdminRight(userid, con);
                Map rightsParamsViewReports = (Map)rightsMap.get(VIEW_REPORTS_RIGHT);
                Map rightsParamsAdministrateTopicAreas = (Map)rightsMap.get(ADMIN_TOPIC_AREA_RIGHT);
                UserAndRightsStreamliner.streamlineInstitution(userid, tc.getInst(), con);
                String[] topicAreas = UserAndRightsStreamliner.extractRightsParamsFor(rightsParamsViewReports, RightsParam.topic_area);
                String[] topicAreasAdmin = UserAndRightsStreamliner.extractRightsParamsFor(rightsParamsAdministrateTopicAreas, RightsParam.topic_area_admin);
                String[] viewTypes = UserAndRightsStreamliner.extractRightsParamsFor(rightsParamsViewReports, RightsParam.view_type);
                String[] views = UserAndRightsStreamliner.extractRightsParamsFor(rightsParamsViewReports, RightsParam.view);
                String[] reports = UserAndRightsStreamliner.extractRightsParamsFor(rightsParamsViewReports, RightsParam.report);
                UserAndRightsStreamliner.streamlineOrgunits(userid, UserAndRightsStreamliner.extractRightsParamsFor(rightsParamsViewReports, RightsParam.orgunit), con);
                UserAndRightsStreamliner.clearTopicAreas(userid, con);
                if (rightsMap.containsKey(VIEW_REPORTS_RIGHT)) {
                    if (topicAreas.length == 0 && viewTypes.length == 0 && views.length == 0 && reports.length == 0) {
                        UserAndRightsStreamliner.setRightForAllSachgebiete(userid, con, VIEW_REPORTS);
                    } else if (topicAreas.length > 0) {
                        UserAndRightsStreamliner.setRightForSomeSachgebiete(userid, con, VIEW_REPORTS, topicAreas);
                    }
                }
                if (topicAreasAdmin.length > 0) {
                    UserAndRightsStreamliner.setRightForSomeSachgebiete(userid, con, ADMIN_TOPIC_AREA, topicAreasAdmin);
                }
                UserAndRightsStreamliner.streamlineReports(userid, reports, con);
                if (topicAreas.length == 0 && reports.length > 0 && viewTypes.length == 0 && views.length == 0) {
                    UserAndRightsStreamliner.addViewRightsForReport(userid, (String)rightsParamsViewReports.get(RightsParam.report.getParamName()), con);
                } else {
                    UserAndRightsStreamliner.streamlineViewTypes(userid, viewTypes, con);
                }
                UserAndRightsStreamliner.streamlineViews(userid, views, con);
            }
            if (!con.getAutoCommit()) {
                con.commit();
            }
        }
        catch (SQLException ex) {
            if (con != null && !con.getAutoCommit()) {
                con.rollback();
            }
            throw ex;
        }
        catch (NichtAngemeldetException ex) {
            if (con != null && !con.getAutoCommit()) {
                con.rollback();
            }
            throw ex;
        }
        finally {
            if (con != null) {
                DBAccess.removeConnection("superx");
                if (!con.isClosed()) {
                    con.close();
                }
            }
        }
        return rightsMap;
    }

    private static void streamlineInstitution(int userid, String orgunitStr, Connection con) throws SQLException {
        UserAndRightsStreamliner.deleteExternalEnteredInstitutions(userid, con);
        UserAndRightsStreamliner.streamlineInstitutionById(userid, orgunitStr, con);
    }

    private static void deleteExternalEnteredInstitutions(int userid, Connection con) throws SQLException {
        String del = "delete from  user_institution  where userid=? and external_entry=1";
        PreparedStatement stmt = con.prepareStatement(del);
        stmt.setInt(1, userid);
        stmt.executeUpdate();
        stmt.close();
    }

    private static void streamlineInstitutionByUniqueName(int userid, String uniqueName, Connection con) throws SQLException {
        int vorhanden;
        DBAccess.addConnection("superx", con);
        DBAccess.get("superx").setThrowRuntimeExceptionsActive(true);
        String name = DBAccess.get("superx").getString("select name from organigramm where key_apnr=?", uniqueName);
        if (name != null && !name.isEmpty() && (vorhanden = DBAccess.get("superx").getInt("select count(*) from user_institution where ch110_institut='" + uniqueName + "' and userid=" + userid, new Object[0])) == 0) {
            PreparedStatement pst = con.prepareStatement("INSERT INTO user_institution \n(userid, name, ch110_institut, hierarchie, gueltig_seit, gueltig_bis, lehre, externalid,external_entry) \nVALUES \n(?, ?, ?, 0, '1900-01-01', '3000-01-01', 0, null,1)");
            pst.setInt(1, userid);
            pst.setString(2, name);
            pst.setString(3, uniqueName);
            pst.execute();
            pst.close();
        }
    }

    private static void streamlineInstitutionById(int userid, String orgunitStr, Connection con) throws SQLException {
        String inst = "";
        DBAccess.addConnection("superx", con);
        DBAccess.get("superx").setThrowRuntimeExceptionsActive(true);
        inst = DBAccess.get("superx").getString("select apnr from cifx where key=110 and sourcesystem_id=? and sourcesystem=6", orgunitStr);
        if (inst == null || inst.isEmpty()) {
            inst = DBAccess.get("superx").getString("select key_apnr from organigramm where tid=?", Integer.valueOf(orgunitStr));
        }
        if (inst != null && !inst.trim().equals("")) {
            int vorhanden = DBAccess.get("superx").getInt("select count(*) from user_institution where ch110_institut=? and userid=?", inst, userid);
            if (inst.equals("1")) {
                inst = "0";
            }
            if (vorhanden == 0) {
                PreparedStatement pst = con.prepareStatement("INSERT INTO user_institution \n(userid, name, ch110_institut, hierarchie, gueltig_seit, gueltig_bis, lehre, externalid,external_entry) \nVALUES \n(?, '--', ?, 0, '1900-01-01', '3000-01-01', 0, ?,1)");
                pst.setInt(1, userid);
                pst.setString(2, inst);
                pst.setString(3, orgunitStr);
                pst.execute();
                pst.close();
            }
        }
    }

    private static void streamlineOrgunits(int userId, String[] orgunits, Connection con) throws SQLException {
        if (orgunits.length > 0) {
            UserAndRightsStreamliner.deleteExternalEnteredInstitutions(userId, con);
            for (String orgunit : orgunits) {
                UserAndRightsStreamliner.streamlineInstitutionById(userId, orgunit, con);
            }
        }
    }

    private static void clearTopicAreas(int userId, Connection con) throws SQLException {
        Statement stmt = con.createStatement();
        stmt.executeUpdate("delete from  user_sachgeb_bez  where userinfo_id=" + userId + " and external_entry=1");
        stmt.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void streamlineReports(int userid, String[] reports, Connection con) throws SQLException {
        Statement stmt = con.createStatement();
        stmt.executeUpdate("delete from  user_masken_bez  where userinfo_id=" + userid + " and external_entry=1");
        stmt.close();
        try (PreparedStatement pst = null;){
            pst = con.prepareStatement("insert into user_masken_bez (userinfo_id,maskeninfo_id,external_entry)   values ( ?,?,1 )");
            for (String report : reports) {
                int reportId = -1;
                try {
                    reportId = Integer.parseInt(report.trim());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (reportId == -1) continue;
                pst.setInt(1, userid);
                pst.setInt(2, reportId);
                pst.execute();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void streamlineViewTypes(int userId, String[] viewTypes, Connection con) throws SQLException {
        Statement stmt = con.createStatement();
        stmt.executeUpdate("delete from  user_sichtarten where userinfo_id=" + userId + " and external_entry=1");
        stmt.close();
        try (PreparedStatement pst = null;){
            pst = con.prepareStatement("insert into user_sichtarten (userinfo_id,sichtart,external_entry)   values ( ?,?,1 )");
            for (String viewType : viewTypes) {
                if (viewType.isEmpty()) continue;
                pst.setInt(1, userId);
                pst.setString(2, viewType);
                pst.execute();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void streamlineViews(int userId, String[] views, Connection con) throws SQLException {
        Statement stmt = con.createStatement();
        stmt.executeUpdate("delete from  user_sichten where userinfo_id=" + userId + " and external_entry=1");
        stmt.close();
        try (PreparedStatement pst = null;){
            pst = con.prepareStatement("insert into user_sichten (userinfo_id,sicht_name_intern,external_entry)   select ?,name_intern,1 from sichten where tid=?");
            for (String view : views) {
                if (view.isEmpty()) continue;
                pst.setInt(1, userId);
                pst.setInt(2, Integer.parseInt(view.trim()));
                pst.execute();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addViewRightsForReport(int userid, String reportParams, Connection con) throws SQLException {
        Statement stmt = con.createStatement();
        stmt.executeUpdate("delete from  user_sichtarten where userinfo_id=" + userid + " and external_entry=1");
        stmt.executeUpdate("delete from  user_sichten where userinfo_id=" + userid + " and external_entry=1");
        stmt.close();
        try (Statement pst = null;){
            pst = con.prepareStatement("insert into user_sichtarten (select distinct " + userid + ", unnest(regexp_matches(fi.relation, '\\\\x27(\\\\S+)\\\\x27', 'g')),1 from felderinfo as fi, masken_felder_bez as mfb where mfb.maskeninfo_id in (" + reportParams + ") and fi.tid = mfb.felderinfo_id and fi.art=12 and fi.relation LIKE '<<SQL>>%')");
            pst.executeUpdate();
            pst.close();
            pst = con.prepareStatement("insert into user_sichten select " + userid + ",s.name_intern,1 from sichten s where s.art in (select sichtart from user_sichtarten where userinfo_id=" + userid + " and external_entry=1)");
            pst.executeUpdate();
        }
    }

    private static String[] extractRightsParamsFor(Map<String, String> rightsParams, RightsParam rightsParam) {
        String paramList;
        String[] result = new String[]{};
        if (rightsParams != null && (paramList = rightsParams.get(rightsParam.getParamName())) != null && !paramList.isEmpty()) {
            result = paramList.split("\\s*,\\s*");
        }
        return result;
    }

    private static void setRightForSomeSachgebiete(int userid, Connection con, String right, String[] topic_areas) throws SQLException {
        PreparedStatement pst = con.prepareStatement("insert into user_sachgeb_bez (userinfo_id,sachgebiete_id,external_entry)  select " + userid + ",tid,1 from sachgebiete where rightname=? and tid not in (select sachgebiete_id from user_sachgeb_bez where userinfo_id=" + userid + ")");
        for (String sachgebiet : topic_areas) {
            sachgebiet = sachgebiet.toUpperCase();
            pst.setString(1, right + "[" + sachgebiet + "]");
            pst.execute();
        }
        pst.close();
    }

    private static void setRightForAllSachgebiete(int userid, Connection con, String right) throws SQLException {
        PreparedStatement pst = con.prepareStatement("insert into user_sachgeb_bez (userinfo_id,sachgebiete_id,external_entry)  select " + userid + ",tid,1 from sachgebiete where rightname  like '" + right + "%' and tid not in (select sachgebiete_id from user_sachgeb_bez where userinfo_id=" + userid + ")");
        pst.execute();
        pst.close();
    }

    private void log(Level l, String what) {
        if (this.isLogWanted) {
            System.out.println(what);
        }
    }

    private static void removePossibleAdminRight(int userid, Connection con) throws SQLException {
        PreparedStatement pst = con.prepareStatement("update userinfo set administration=0 where tid=?");
        pst.setInt(1, userid);
        pst.executeUpdate();
        pst.close();
        pst = con.prepareStatement("delete from user_group_bez where external_entry=1 and userinfo_id=? and  groupinfo_id=(select tid from groupinfo where name='Administratoren')");
        pst.setInt(1, userid);
        pst.executeUpdate();
        pst.close();
    }

    private static void setAdminRights(int userid, Connection con) throws SQLException {
        Statement stmt = con.createStatement();
        String del = "delete from  user_institution  where userid=" + userid + " and external_entry=1";
        stmt.executeUpdate(del);
        stmt.close();
        PreparedStatement pst = con.prepareStatement("update userinfo set administration=1 where tid=?");
        pst.setInt(1, userid);
        pst.executeUpdate();
        if (pst.getUpdateCount() != 1) {
            throw new SQLException("Fehler beim Setzen von Adminrechten f\u00fcr  Benutzer " + userid + " DETAILS: in Tabelle Superx.userinfo (updatecount!=1)");
        }
        int adminGroupId = UserAndRightsStreamliner.streamlineGroupId("Administratoren", con);
        UserAndRightsStreamliner.checkUserGroupBez(userid, adminGroupId, con);
        pst = con.prepareStatement("select count(*) from user_institution where userid=? and ch110_institut='0'");
        pst.setInt(1, userid);
        int count = 0;
        ResultSet rs = pst.executeQuery();
        while (rs.next()) {
            count = rs.getInt(1);
        }
        if (count == 0) {
            pst = con.prepareStatement("insert into user_institution (userid,name,ch110_institut,hierarchie,gueltig_seit,gueltig_bis,lehre,external_entry) values (?,'Alle','0',0,date_val('1.1.1900'),date_val('1.1.3000'),0,1) ");
            pst.setInt(1, userid);
            int resultcount = pst.executeUpdate();
            if (resultcount != 1) {
                throw new SQLException("Einf\u00fcgen von Kostenstellenrechten f\u00fcr admin fehlgeschlagen");
            }
        }
        Statement stmt2 = con.createStatement();
        stmt2.executeUpdate("delete from  user_sachgeb_bez  where userinfo_id=" + userid + " and external_entry=1");
        stmt2.executeUpdate("insert into user_sachgeb_bez (userinfo_id,sachgebiete_id,external_entry)  select " + userid + ",tid,1 from sachgebiete where tid not in (select sachgebiete_id from user_sachgeb_bez where userinfo_id=" + userid + ")");
        stmt2.close();
    }

    private static void checkUserGroupBez(int userid, int groupid, Connection con) throws SQLException {
        PreparedStatement pst = con.prepareStatement("delete from user_group_bez where external_entry=1 and userinfo_id=? and groupinfo_id!=?");
        pst.setInt(1, userid);
        pst.setInt(2, groupid);
        pst.executeUpdate();
        pst.close();
        pst = con.prepareStatement("select count(*) from user_group_bez where userinfo_id=? and groupinfo_id=?");
        pst.setInt(1, userid);
        pst.setInt(2, groupid);
        ResultSet rs = pst.executeQuery();
        int count = 0;
        while (rs.next()) {
            count = rs.getInt(1);
        }
        if (count == 0) {
            UserAndRightsStreamliner.insertUserGroupBez(con, userid, groupid);
        }
        pst.close();
    }

    private static int streamlineUserId(TokenChecker tc, Connection con) throws SQLException, NichtAngemeldetException {
        PreparedStatement pst = con.prepareStatement("select count(*) from userinfo where benutzer=?");
        pst.setString(1, tc.getKennung());
        ResultSet rs = pst.executeQuery();
        int count = 0;
        while (rs.next()) {
            count = rs.getInt(1);
        }
        rs.close();
        if (count > 1) {
            throw new SQLException("Mehr als ein Eintrag f\u00fcr benutzer " + tc.getKennung() + " in Tabelle SuperX.userinfo gefunden");
        }
        if (count == 0) {
            UserAndRightsStreamliner.insertUser(con, tc.getKennung());
        }
        pst = con.prepareStatement("select tid from userinfo where benutzer=?");
        pst.setString(1, tc.getKennung());
        rs = pst.executeQuery();
        int usertid = -999;
        while (rs.next()) {
            usertid = rs.getInt(1);
        }
        rs.close();
        pst.close();
        if (usertid == -999) {
            throw new SQLException("Kein Eintrag in Tabelle userinfo gefunden f\u00fcr " + tc.getKennung());
        }
        pst = con.prepareStatement("update userinfo set extern_person_id=?,extern_account_id=? where tid=" + usertid);
        pst.setString(1, tc.getExternPersonID());
        pst.setString(2, tc.getExternAccountID());
        pst.execute();
        pst.close();
        return usertid;
    }

    private static int streamlineGroupId(String group, Connection con) throws SQLException {
        PreparedStatement pst = con.prepareStatement("select count(*) from groupinfo where name=?");
        pst.setString(1, group);
        ResultSet rs = pst.executeQuery();
        int count = 0;
        while (rs.next()) {
            count = rs.getInt(1);
        }
        rs.close();
        if (count > 1) {
            throw new SQLException("Mehr als ein Eintrag f\u00fcr Gruppe " + group + " in Tabelle SuperX.groupinfo gefunden");
        }
        if (count == 0) {
            UserAndRightsStreamliner.insertGroup(con, group);
        }
        pst = con.prepareStatement("select tid from groupinfo where name=?");
        pst.setString(1, group);
        rs = pst.executeQuery();
        int groupid = -999;
        while (rs.next()) {
            groupid = rs.getInt(1);
        }
        rs.close();
        pst.close();
        if (groupid == -999) {
            throw new SQLException("Kein Eintrag in Tabelle groupinfo gefunden f\u00fcr " + group);
        }
        return groupid;
    }

    private static void insertUser(Connection con, String user) throws SQLException {
        PreparedStatement pst = con.prepareStatement("select max(tid) from userinfo");
        ResultSet rs = pst.executeQuery();
        rs.next();
        int tid = rs.getInt(1) + 1;
        pst = con.prepareStatement("insert into userinfo (tid,benutzer,max_versuch,akt_versuch,administration,archiv_recht,passwd_sha,info)values (?,?,999,0,0,0,'extern verwaltet','extern')");
        pst.setInt(1, tid);
        pst.setString(2, user);
        pst.execute();
        if (pst.getUpdateCount() != 1) {
            throw new SQLException("Einf\u00fcgen von Benutzer " + user + " in Tabelle Superx.userinfo fehlgeschlagen");
        }
        pst.close();
    }

    private static void insertGroup(Connection con, String group) throws SQLException {
        PreparedStatement pst = con.prepareStatement("select max(tid) from groupinfo");
        ResultSet rs = pst.executeQuery();
        rs.next();
        int tid = rs.getInt(1) + 1;
        rs.close();
        pst = con.prepareStatement("insert into groupinfo (tid,name) values (?,?)");
        pst.setInt(1, tid);
        pst.setString(2, group);
        pst.execute();
        if (pst.getUpdateCount() != 1) {
            throw new SQLException("Einf\u00fcgen von Gruppe " + group + " in Tabelle Superx.groupinfo fehlgeschlagen");
        }
        pst.close();
    }

    private static void insertUserGroupBez(Connection con, int userid, int groupid) throws SQLException {
        PreparedStatement pst = con.prepareStatement("insert into user_group_bez (userinfo_id,groupinfo_id,external_entry) values (?,?,1)");
        pst.setInt(1, userid);
        pst.setInt(2, groupid);
        pst.execute();
        if (pst.getUpdateCount() != 1) {
            throw new SQLException("Einf\u00fcgen von Gruppenzugeh\u00f6rigkeit fehlgeschlagen DETAILS: in user_group_bez " + userid + " - " + groupid + "  fehlgeschlagen");
        }
        pst.close();
    }

    public static void main(String[] a) {
        String user = null;
        String token = "1.0/1310722422/superx/studadmin/studadminrole/9/RIGHT_CS_BIA_STANDARDREPORTS_VIEW_REPORTS,RIGHT_CS_BIA_STANDARDREPORTS_ADMIN[edustore.topic_area=stu]/6fcf981a308d475b16b1290754dd8f3e";
        try {
            TokenChecker.checkingActive = false;
            TokenChecker tc = new TokenChecker(token);
            UserAndRightsStreamliner.streamline("default", tc);
            user = tc.getKennung();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static enum RightsParam {
        orgunit("edustore.orgunit"),
        topic_area("edustore.topic_area"),
        topic_area_admin("edustore.topic_area_admin"),
        report("edustore.report"),
        cameral_unit_proj("edustore.cameral_unit.proj"),
        cameral_unit_inst("edustore.cameral_unit.inst"),
        cameral_unit_lev3("edustore.cameral_unit.lev3"),
        cameral_unit_lev4("edustore.cameral_unit.lev4"),
        view_type("edustore.view_type"),
        view("edustore.view");

        private String paramName;

        private RightsParam(String name) {
            this.paramName = name;
        }

        public String getParamName() {
            return this.paramName;
        }
    }
}

