/*
 * Decompiled with CFR 0.152.
 */
package de.superx.servlet;

import de.memtext.hbt.AbstractAriel;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

public class SxMail {
    private String mandantenID;
    private String wtfai;
    private String pop3_host;
    private String smtp_host;
    private String username;
    private String password;
    private String daemon1;
    private String daemon2;
    private String daemon3;
    private int pop3_port;
    private int pop3_starttls_enable;
    private int smtp_port;
    private int smtp_auth;
    private int smtp_starttls_enable;
    private int daemon1_interval;
    private int daemon2_interval;
    private int daemon3_interval;
    private Session session;
    private Store store;
    private Folder inbox;
    private List<AbstractAriel> ariels = new LinkedList<AbstractAriel>();

    public SxMail(String mandantenID, String wtfai, String pop3_host, int pop3_port, int pop3_starttls_enable, String smtp_host, int smpt_port, int smtp_auth, int smtp_starttls_enable, String username, String password, String daemon1, int daemon1_interval, String daemon2, int daemon2_interval, String daemon3, int daemon3_interval) {
        this.mandantenID = mandantenID;
        this.wtfai = wtfai;
        this.pop3_host = pop3_host;
        this.pop3_port = pop3_port;
        this.pop3_starttls_enable = pop3_starttls_enable;
        this.smtp_host = smtp_host;
        this.smtp_port = smpt_port;
        this.smtp_auth = smtp_auth;
        this.smtp_starttls_enable = smtp_starttls_enable;
        this.username = username;
        this.password = password;
        this.daemon1 = daemon1;
        this.daemon1_interval = daemon1_interval;
        this.daemon2 = daemon2;
        this.daemon2_interval = daemon2_interval;
        this.daemon3 = daemon3;
        this.daemon3_interval = daemon3_interval;
        this.session = this.initSession();
        if (daemon1 != null && !daemon1.equals("")) {
            this.initDaemons();
        }
    }

    private void initDaemons() {
        try {
            Class<?> cls = Class.forName(this.daemon1);
            Class[] partypes = new Class[]{SxMail.class};
            Constructor<?> ct = cls.getConstructor(partypes);
            Object[] arglist = new Object[]{this};
            AbstractAriel ariel = (AbstractAriel)ct.newInstance(arglist);
            this.ariels.add(ariel);
            ariel.start();
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    private Session initSession() {
        Properties properties = new Properties();
        properties.put("mail.pop3.host", this.pop3_host);
        properties.put("mail.pop3.port", "" + this.pop3_port);
        if (this.pop3_starttls_enable == 1) {
            properties.put("mail.pop3.starttls.enable", "true");
        } else {
            properties.put("mail.pop3.starttls.enable", "false");
        }
        properties.put("mail.smtp.auth", this.smtp_auth == 1 ? "true" : "false");
        properties.put("mail.smtp.starttls.enable", this.smtp_starttls_enable == 1 ? "true" : "false");
        properties.put("mail.smtp.host", this.smtp_host);
        properties.put("mail.smtp.port", "" + this.smtp_port);
        return Session.getDefaultInstance((Properties)properties);
    }

    public Folder getInbox() throws MessagingException {
        this.store = this.pop3_starttls_enable == 1 ? this.session.getStore("pop3s") : this.session.getStore("pop3");
        this.store.connect(this.pop3_host, this.pop3_port, this.username, this.password);
        this.inbox = this.store.getFolder("INBOX");
        this.inbox.open(2);
        return this.inbox;
    }

    public void closeInbox() throws MessagingException {
        boolean expungeWhichMeansDelete = true;
        this.inbox.close(expungeWhichMeansDelete);
        this.store.close();
    }

    public String getMandantenID() {
        return this.mandantenID;
    }

    public void shutdownDaemons() {
        for (AbstractAriel a : this.ariels) {
            a.setActive(false);
        }
    }

    public MimeMessage createMessage() throws AddressException, MessagingException {
        MimeMessage m = new MimeMessage(this.session);
        m.setFrom((Address)new InternetAddress(this.username));
        return m;
    }

    public void setMessage(MimeMessage reply) throws MessagingException {
        Transport t = this.session.getTransport("smtp");
        t.connect(this.username, this.password);
        t.sendMessage((Message)reply, reply.getAllRecipients());
    }

    public String getWTFAI() {
        if (this.wtfai == null) {
            throw new IllegalStateException(" SxMail for " + this.username + " hat keine WTFAI-Angabe in der Datenbanktabelle");
        }
        return this.wtfai;
    }
}

