/*
 * Decompiled with CFR 0.152.
 */
package de.superx.servlet;

import com.google.common.io.ByteStreams;
import de.destatis.core.inspector.InspectionProblem;
import de.memtext.db.NichtAngemeldetException;
import de.memtext.tree.KeyParentEqualException;
import de.memtext.tree.NoMainEntryException;
import de.memtext.util.CryptUtils;
import de.memtext.util.EqualsUtil;
import de.memtext.util.FileUtils;
import de.memtext.util.ServletHelper;
import de.memtext.util.StringUtils;
import de.memtext.util.TimeUtils;
import de.superx.bin.KettleExecutor;
import de.superx.common.ChartCreator;
import de.superx.common.DBServletException;
import de.superx.common.GraphicFormat;
import de.superx.common.InvalidDataTypeException;
import de.superx.common.InvalidKeyException;
import de.superx.common.Maske;
import de.superx.common.ObligatoryFieldEmptyException;
import de.superx.common.SichtException;
import de.superx.common.Stylesheet;
import de.superx.common.SxUser;
import de.superx.common.TransletCache;
import de.superx.common.UngueltigeEingabeException;
import de.superx.servlet.AbstractSuperXServlet;
import de.superx.servlet.CSVResultReport;
import de.superx.servlet.CSVServletRequest;
import de.superx.servlet.CSVUploader;
import de.superx.servlet.JasperCreator;
import de.superx.servlet.MaskenContainer;
import de.superx.servlet.PreparedXmlProcessor;
import de.superx.servlet.RequestParameter;
import de.superx.servlet.ServletBasics;
import de.superx.servlet.ServletUtils;
import de.superx.servlet.SichtChanger;
import de.superx.servlet.SuperXManager;
import de.superx.servlet.SuperXServletHelper;
import de.superx.servlet.SxPools;
import de.superx.servlet.XmlTransformer;
import de.superx.stat.StatisticExport;
import de.superx.stat.StatisticsBase;
import de.superx.util.SqlStringUtils;
import freemarker.template.TemplateException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.jasperreports.engine.JRException;
import org.apache.commons.fileupload.DiskFileUpload;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUpload;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.dom4j.DocumentException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.xml.sax.SAXException;

public class SuperXmlTabelle
extends AbstractSuperXServlet {
    private static final String PARAM_IS_SENT_SUFFIX = "-isSent";
    private static final String PARAM_TRUE = "true";
    private static final String PARAM_XML_ = "/xml";
    private static final String PARAM_CLASS = "class";
    private static final long serialVersionUID = 1L;
    TimeUtils tutil = new TimeUtils();
    public static int maxOffset = 30;
    private static final int MAX_MACRO = 20;
    private static int cacheSecs = 300;
    private final String STYLESHEET_XML = "tabelle_xml.xsl";
    private final String STYLESHEET_PDF = "tabelle_pdf.xsl";
    private final String STYLESHEET_RTF = "tabelle_rtf.xsl";
    private final String STYLESHEET_TXT = "tabelle_text.xsl";
    protected TransformerFactory tFactory;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        ChartCreator.initPath(this.getServletConfig().getServletContext().getRealPath(PARAM_XML_));
        this.tFactory = TransformerFactory.newInstance();
        String mxr = config.getInitParameter("maxRows");
        mxr = config.getInitParameter("maxOffset");
        maxOffset = mxr == null || mxr.equals("") ? 30 : Integer.parseInt(mxr);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        SuperXmlTabelle.setEncoding(request);
        if (request.getParameter("checkFor") != null) {
            this.checkFor(request, response);
        } else if (!this.hasProperSession(request)) {
            this.infoNeuAnmelden(response);
        } else {
            this.checkCacheClearing(request);
            boolean sessionCreated = this.checkAnmeldungImRequest(request);
            LinkedList<FileItem> multipartData = new LinkedList();
            if (FileUpload.isMultipartContent((HttpServletRequest)request)) {
                multipartData = this.getMultipartContent(request);
            }
            if (SichtChanger.isSichtChangeWanted(request)) {
                SichtChanger sichtChanger = new SichtChanger(request, response, true);
                sichtChanger.run(true);
            } else if (ServletBasics.getParameter(request, "getKidRows") != null) {
                KidRowsResponder kr = new KidRowsResponder(request, response);
                kr.run(true);
            } else if (ServletBasics.getParameter(request, "getchart") != null) {
                this.getChartResponse(request, response);
            } else if (ServletBasics.getParameter(request, "getDynChart") != null) {
                this.getDynamicChartResponse(request, response);
            } else if (this.isKettleJobMaske(multipartData)) {
                KettleHelper kh = new KettleHelper(multipartData, request, response);
                kh.run(true);
            } else if (FileUpload.isMultipartContent((HttpServletRequest)request) || EqualsUtil.areEqual(ServletBasics.getParameter(request, "csvupload"), PARAM_TRUE)) {
                CSVUploadHelper cup = new CSVUploadHelper(request, response, multipartData);
                cup.run(true);
            } else {
                TableCreator tc = new TableCreator(request, response);
                tc.run(true);
            }
        }
    }

    private List<FileItem> getMultipartContent(HttpServletRequest request) throws IOException {
        List result = null;
        try {
            DiskFileUpload fu = new DiskFileUpload();
            result = fu.parseRequest(request);
        }
        catch (FileUploadException e) {
            throw new IOException(e);
        }
        return result;
    }

    private boolean isKettleJobMaske(List<FileItem> multipartData) {
        boolean result = false;
        for (FileItem item : multipartData) {
            String fieldName;
            if (!item.isFormField() || (fieldName = item.getFieldName()) == null || (!fieldName.equals("tid") || !item.getString().equals("71540")) && !fieldName.equals("dokettlejob")) continue;
            result = true;
            break;
        }
        return result;
    }

    private void getChartResponse(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        ChartResponder cr = new ChartResponder(request, response);
        cr.run(true);
    }

    private void getDynamicChartResponse(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        String classname = ServletHelper.getParameter(request, PARAM_CLASS);
        if (classname == null || classname.equals("")) {
            throw new IllegalArgumentException("Parameter class missing");
        }
        try {
            Object[] constr = new Object[]{request, response};
            Class<?> grafclass = Class.forName(classname);
            Class[] classparams = new Class[]{HttpServletRequest.class, HttpServletResponse.class};
            Constructor<?> con = grafclass.getConstructor(classparams);
            SuperXServletHelper graphHelper = (SuperXServletHelper)con.newInstance(constr);
            graphHelper.run(true);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServletException("Problem bei Grafikerzeugung :\n" + e);
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Integer tid = Integer.valueOf(this.getTid(request));
        if (SuperXManager.httpGetAccessGuard.isHttpGetAllowed(tid)) {
            if (request.getParameter(RequestParameter.bigexcel.toString()) != null && request.getParameter(RequestParameter.bigexcel.toString()).equals(PARAM_TRUE)) {
                BigExcelCreator b = new BigExcelCreator(request, response);
                b.run(true);
            } else if (request.getParameter(RequestParameter.checkFor.toString()) != null) {
                this.checkFor(request, response);
            } else {
                this.doPost(request, response);
            }
        } else if (ServletBasics.getParameter(request, RequestParameter.getKidRows) != null) {
            KidRowsResponder kr = new KidRowsResponder(request, response);
            kr.run(true);
        } else {
            System.out.println("GET-Aufruf von Maske " + tid.toString() + " wurde aufgrund von black-/whitelisting-policy abgewiesen");
            response.setStatus(403);
        }
    }

    private void checkFor(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String tidString = this.getTid(request);
        String isSent = (String)request.getSession().getAttribute(tidString + PARAM_IS_SENT_SUFFIX);
        for (int i = 0; !EqualsUtil.areEqual(isSent, PARAM_TRUE) && i < 10; ++i) {
            isSent = (String)request.getSession().getAttribute(tidString + PARAM_IS_SENT_SUFFIX);
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        response.getWriter().write("done");
    }

    public String getServletInfo() {
        return "SuperXTabelle 4.2";
    }

    public void transformToJrxmlAndExecute(String lastXml, String xslStylesheetFile, String params, HttpServletRequest request, HttpServletResponse response, Maske maske, String mandantenid) {
        try {
            Locale desiredLocale = request.getLocale();
            String currentXml = SxPools.get(mandantenid).localize(lastXml, desiredLocale);
            String reports_dir = this.getServletConfig().getServletContext().getRealPath("/") + "WEB-INF" + File.separator + "reports" + File.separator;
            String jrxmlFileName = xslStylesheetFile + ".jrxml";
            String jrxmlFilePath = reports_dir + jrxmlFileName;
            String xslFilePath = this.getServletConfig().getServletContext().getRealPath("/") + "xml" + File.separator + xslStylesheetFile;
            FileWriter myFilewriter = new FileWriter(jrxmlFilePath);
            PrintWriter myOutwriter = new PrintWriter(new BufferedWriter(myFilewriter));
            Logger.getLogger("superx_" + mandantenid + "_xml").log(Level.INFO, " Translet f\u00fcr Ergebnisvorbereitung:" + xslFilePath);
            Transformer transformer = TransletCache.getTransformer(mandantenid, xslFilePath);
            StringReader s1 = new StringReader(currentXml);
            transformer.setOutputProperty("encoding", SqlStringUtils.getEncoding());
            transformer.setOutputProperty("method", "xml");
            Object result = null;
            if (params != null) {
                if (!params.endsWith(",")) {
                    params = params + ",";
                }
                StringTokenizer st = new StringTokenizer(params, ",");
                while (st.hasMoreTokens()) {
                    String param = st.nextToken();
                    if (param.equals("")) continue;
                    String paramname = param.substring(0, param.indexOf("="));
                    String paramvalue = param.substring(param.indexOf("=") + 1, param.length());
                    transformer.setParameter(paramname, paramvalue);
                }
            }
            String rptContentype = request.getParameter("RPTContentype");
            String rptPageFormat = request.getParameter("RPTPageFormat");
            String rptPageFormatX = request.getParameter("RPTPageFormatX");
            String rptPageFormatY = request.getParameter("RPTPageFormatY");
            transformer.setParameter("RPTContentype", rptContentype);
            if (rptPageFormatX != null && !rptPageFormatX.equalsIgnoreCase("") && rptPageFormatY != null && !rptPageFormatY.equalsIgnoreCase("")) {
                transformer.setParameter("seitenbreite", rptPageFormatX);
                transformer.setParameter("seitenhoehe", rptPageFormatY);
            } else {
                if (rptPageFormat != null && rptPageFormat.equalsIgnoreCase("a4")) {
                    transformer.setParameter("seitenbreite", "842");
                    transformer.setParameter("seitenhoehe", "595");
                }
                if (rptPageFormat != null && rptPageFormat.equalsIgnoreCase("a3")) {
                    transformer.setParameter("seitenbreite", "1191");
                    transformer.setParameter("seitenhoehe", "842");
                }
            }
            transformer.transform(new StreamSource(s1), new StreamResult(myOutwriter));
            if (rptContentype.equals("text/xml")) {
                String filename_extension = ".jrxml";
                ServletOutputStream out = response.getOutputStream();
                response.setHeader("Content-disposition", "attachment; filename=" + FileUtils.removeProblemChars(maske.getExportName()) + filename_extension);
                response.setHeader("Cache-Control", "expires=0");
                String jrxmlFileContent = FileUtils.getFileContentsWithEncoding(jrxmlFilePath, SqlStringUtils.getEncoding());
                byte[] myBytes = jrxmlFileContent.getBytes(SqlStringUtils.getEncoding());
                response.setContentLength(myBytes.length);
                out.write(myBytes);
            } else {
                JasperCreator jc = new JasperCreator(request, response, (SxUser)request.getSession().getAttribute("user"), maske, jrxmlFileName, rptContentype, reports_dir);
                if (request.getParameter("irowno").isEmpty()) {
                    jc.perform(mandantenid, maske, null);
                } else {
                    jc.perform(mandantenid, currentXml, null);
                }
                Logger.getLogger("superx_" + mandantenid).log(Level.FINER, " schicken des JasperReport an Client " + this.tutil.getSinceStart());
            }
        }
        catch (JRException e) {
            System.err.println("Fehler bei JasperReport-Erzeugung " + e.toString());
        }
        catch (Exception e) {
            System.err.println("XSL-Transformation fehlgeschlagen: " + e.toString());
        }
    }

    private class ChartResponder
    extends SuperXServletHelper {
        private Maske maske;
        private final SxUser user;

        public ChartResponder(HttpServletRequest request, HttpServletResponse response) throws IOException {
            super(request, response);
            this.user = (SxUser)request.getSession().getAttribute("user");
            this.setAjaxResponder(true);
        }

        @Override
        protected void perform() throws SQLException {
            try {
                if (this.user == null) {
                    throw new IllegalStateException("Kein user in der Session gefunden - bitte Browser neu starten!");
                }
                this.userid = this.request.getSession().getAttribute("UserID").toString();
                String tidString = SuperXmlTabelle.this.getTid(this.request);
                MaskenContainer mc = MaskenContainer.getFromRequest(this.request);
                this.maske = mc.getMaske(tidString);
                if (this.maske == null) {
                    throw new IllegalStateException("Es wurde versucht, per AJAX Daten nachzuladen, ohne, dass die Maske geladen wurde");
                }
                GraphicFormat graphicformat = SxPools.get(this.getMandantenID()).getGraphicFormat2("1");
                StringBuffer tabXml = new StringBuffer(this.maske.getFullTableXml(this.getMandantenID(), this.user, this.request, this.getDesiredLocale()));
                File file = ChartCreator.createFile(tabXml, graphicformat);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new SQLException("XML konnte nicht erzeugt werden " + e);
            }
        }

        public void sendNotAuthorized() throws IOException {
            this.response.setContentType("text/html; charset=" + SqlStringUtils.getEncoding());
            PrintWriter p = this.response.getWriter();
            String msg = ServletUtils.getJSONErrorText(this.userid, this.getDesiredLocale());
            System.out.println(msg);
            p.print(msg);
            p.close();
        }
    }

    private class KidRowsResponder
    extends SuperXServletHelper {
        private Maske maske;
        private final SxUser user;

        public KidRowsResponder(HttpServletRequest request, HttpServletResponse response) throws IOException {
            super(request, response);
            this.user = (SxUser)request.getSession().getAttribute("user");
            this.setAjaxResponder(true);
        }

        @Override
        protected void perform() throws SQLException, DBServletException, TransformerException, KeyParentEqualException, NichtAngemeldetException, IOException, ParseException, ParserConfigurationException, FactoryConfigurationError, SAXException, DocumentException, IllegalArgumentException, SecurityException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, CloneNotSupportedException, TemplateException, InvalidKeyException, SichtException, IOException, ServletException {
            if (this.user == null) {
                throw new IllegalStateException("Kein user in der Session gefunden - bitte Browser neu starten!");
            }
            this.userid = this.request.getSession().getAttribute("UserID").toString();
            String tidString = SuperXmlTabelle.this.getTid(this.request);
            MaskenContainer mc = MaskenContainer.getFromRequest(this.request);
            this.maske = mc.getMaske(tidString);
            if (this.maske == null) {
                throw new IllegalStateException("Es wurde versucht, per AJAX Daten nachzuladen, ohne, dass die Maske geladen wurde");
            }
            String rowkids = ServletHelper.getParameter(this.request, "getKidRows");
            String treetableid = ServletHelper.getParameter(this.request, "treetableid");
            int row = Integer.parseInt(rowkids);
            StringBuffer xml = new StringBuffer("<?xml version=\"1.0\"  encoding=\"" + SqlStringUtils.getEncoding() + "\"?>\n<ergebnisse isMakro=\"false\">\n<sqlerg>");
            xml.append(this.maske.getKidRows(treetableid, row));
            xml.append("</sqlerg>\n</ergebnisse>");
            Logger.getLogger("superx_" + this.getMandantenID() + "_xml").log(Level.FINE, "   treetable rows\n" + xml);
            XmlTransformer xmlTransformer = new XmlTransformer(SuperXmlTabelle.this.getServletConfig(), this.request, this.response, this.getMandantenID(), this.getBrowser());
            String xsl = "tabelle_html_rows.xsl";
            if (this.maske.getChartx() != null && this.maske.getChartx().endsWith(".xsl")) {
                xsl = this.maske.getChartx();
            }
            xmlTransformer.transform(this.maske.getName(), null, xml.toString(), this.getDesiredLocale(), xsl, "", "false");
        }

        public void sendNotAuthorized() throws IOException {
            this.response.setContentType("text/html; charset=" + SqlStringUtils.getEncoding());
            PrintWriter p = this.response.getWriter();
            String msg = ServletUtils.getJSONErrorText(this.userid, this.getDesiredLocale());
            System.out.println(msg);
            p.print(msg);
            p.close();
        }
    }

    private class CSVUploadHelper
    extends SuperXServletHelper {
        private List filterList;
        private String tabelle;
        private String tid;
        private String delim;
        private String encoding;
        private boolean withHeader;
        private String hinzufuegenModus;
        private boolean showMaskResult;
        private File csvfile;
        private SxUser sxuser;
        private Locale desiredLocale;
        private final Hashtable formular;
        private StringBuffer msgAboutEmptyFields;
        private HashMap params;
        private Maske maske;
        private boolean navi;
        private boolean isZipped;
        private final boolean isXml = false;
        private final String insertMode = "false";
        private List<FileItem> multipartData;

        public CSVUploadHelper(HttpServletRequest request, HttpServletResponse response, List<FileItem> multipartData) throws IOException {
            super(request, response);
            this.filterList = new LinkedList();
            this.tabelle = "";
            this.tid = "";
            this.delim = "^";
            this.encoding = "";
            this.withHeader = false;
            this.hinzufuegenModus = "";
            this.showMaskResult = false;
            this.formular = new Hashtable();
            this.params = new HashMap();
            this.navi = false;
            this.isZipped = false;
            this.isXml = false;
            this.insertMode = "false";
            this.multipartData = new LinkedList<FileItem>();
            this.multipartData = multipartData;
            this.userid = request.getSession().getAttribute("UserID").toString();
            this.filterList.add(".csv");
            this.filterList.add(".txt");
            this.filterList.add(".zip");
            this.filterList.add(".unl");
        }

        private void loadMask() throws CloneNotSupportedException, TemplateException, KeyParentEqualException, SichtException, IOException, SQLException, DBServletException, ParseException, UngueltigeEingabeException, TransformerException, NumberFormatException, NoMainEntryException, InvalidDataTypeException {
            String tidString = this.tid;
            this.userid = this.request.getSession().getAttribute("UserID").toString();
            SxUser user = (SxUser)this.request.getSession().getAttribute("user");
            this.formular.put("UserID", this.userid);
            this.formular.put("locale", this.desiredLocale.getLanguage());
            this.request.getSession().setAttribute(tidString + SuperXmlTabelle.PARAM_IS_SENT_SUFFIX, (Object)"false");
            MaskenContainer mc = MaskenContainer.getFromRequest(this.request);
            String cm = ServletHelper.getParameter(this.request, "cachingcontrol");
            if (cm != null && cm.toLowerCase().equals("clearmask")) {
                mc.removeMaske(tidString);
                Logger.getLogger("superx_" + this.getMandantenID()).log(Level.FINER, " removing cached mask " + tidString);
            } else {
                this.maske = mc.getMaske(tidString);
            }
            SuperXmlTabelle.this.tutil.start();
            if (this.maske == null) {
                if (SxPools.get(this.getMandantenID()).hasMaske(new Integer(tidString))) {
                    this.maske = SxPools.get(this.getMandantenID()).getMaskenclone(new Integer(tidString));
                    Logger.getLogger("superx_" + this.getMandantenID()).log(Level.FINER, " using mask clone");
                } else {
                    this.maske = new Maske(this.getMandantenID(), user, new Integer(tidString), this.desiredLocale);
                }
                mc.addMaske(this.maske);
            }
            this.maske.setFieldDefaults(this.sxuser, this.request, this.params, true);
        }

        private void checkUserAndMaskAuthentification() {
            this.sxuser = (SxUser)this.request.getSession().getAttribute("user");
            if (this.sxuser == null) {
                throw new IllegalStateException("Kein user in der Session gefunden - bitte Browser neu starten!");
            }
            this.sxuser.checkAuthentificationForMask(this.tid);
        }

        private boolean isFileAllowed(String name) {
            boolean result = false;
            for (String afilter : this.filterList) {
                if (afilter.indexOf("*") == -1) {
                    if (!name.toLowerCase().endsWith(afilter)) continue;
                    result = true;
                    continue;
                }
                afilter = StringUtils.replace(afilter, ".", "\\.").toLowerCase();
                Pattern p = Pattern.compile(afilter = StringUtils.replace(afilter, "*", ".*"));
                Matcher m = p.matcher(name.toLowerCase());
                if (!m.matches()) continue;
                result = true;
            }
            return result;
        }

        private void uploadFile() throws IOException {
            this.csvfile = File.createTempFile("tmp", ".csv");
            try {
                String mandantenID = this.getMandantenID();
                for (FileItem item : this.multipartData) {
                    if (item.isFormField()) {
                        String fieldName = item.getFieldName();
                        if (fieldName == null) continue;
                        String itemValue = item.getString();
                        this.params.put(item.getFieldName(), itemValue);
                        switch (fieldName) {
                            case "tid": {
                                this.tid = itemValue;
                                break;
                            }
                            case "Tabelle": {
                                this.tabelle = itemValue;
                                break;
                            }
                            case "Trennzeichen": {
                                this.delim = itemValue;
                                break;
                            }
                            case "Kodierung": {
                                this.encoding = itemValue;
                                break;
                            }
                            case "zip-komprimiert": {
                                this.isZipped = itemValue.equals("1");
                                break;
                            }
                            case "Feldnamen 1. Zeile": {
                                if (!itemValue.equals("1")) break;
                                this.withHeader = true;
                                break;
                            }
                            case "Modus": {
                                this.hinzufuegenModus = itemValue;
                                break;
                            }
                            case "showMaskResult": {
                                String showMaskResultStr = itemValue;
                                this.showMaskResult = showMaskResultStr != null && !showMaskResultStr.isEmpty() ? Boolean.parseBoolean(showMaskResultStr) : false;
                                break;
                            }
                            case "navi": {
                                String naviResultStr = itemValue;
                                this.navi = naviResultStr != null && !naviResultStr.isEmpty() ? Boolean.parseBoolean(naviResultStr) : false;
                            }
                        }
                        continue;
                    }
                    if (item.getName().isEmpty()) {
                        throw new IllegalArgumentException("Bitte geben Sie eine Upload-Datei an!");
                    }
                    if (item.getSize() == 0L) {
                        throw new IllegalArgumentException("Upload-Datei darf nicht leer sein!");
                    }
                    if (this.isFileAllowed(item.getName())) {
                        try {
                            item.write(this.csvfile);
                            continue;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            throw new IOException("Dateiupload fehlgeschlagen:" + e.getMessage());
                        }
                    }
                    throw new IOException("Nicht erlaubte Datei " + item.getName());
                }
            }
            catch (IllegalArgumentException e) {
                this.writeResponse(e);
            }
        }

        @Override
        protected void perform() throws SQLException, DBServletException, TransformerException, KeyParentEqualException, NichtAngemeldetException, IOException, ParseException, ParserConfigurationException, FactoryConfigurationError, SAXException, DocumentException, IllegalArgumentException, SecurityException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, CloneNotSupportedException, TemplateException, InvalidKeyException, SichtException, IOException, ServletException, UngueltigeEingabeException, NoMainEntryException, InvalidDataTypeException {
            this.desiredLocale = this.getDesiredLocale();
            if (FileUpload.isMultipartContent((HttpServletRequest)this.request)) {
                this.uploadFile();
                if (this.showMaskResult) {
                    this.doUploadAndShowMask();
                } else {
                    this.uploadTest();
                }
            } else {
                this.doImport();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void uploadTest() throws IOException, SQLException, FileNotFoundException, TemplateException, KeyParentEqualException, CloneNotSupportedException, SichtException, TransformerConfigurationException, ParseException, InvalidKeyException, TransformerException, DBServletException, UngueltigeEingabeException, NoMainEntryException, InvalidDataTypeException {
            this.checkUserAndMaskAuthentification();
            if (!this.csvfile.exists()) {
                throw new IllegalStateException("Datei " + this.csvfile + " nicht gefunden");
            }
            Connection con = SxPools.get(this.getMandantenID()).getConnection();
            CSVUploader cu = new CSVUploader(this.userid, this.getMandantenID(), this.tabelle, this.csvfile.toString(), this.delim, this.encoding, this.withHeader, "false", false, "exclude-row", this.isZipped);
            cu.upload(true, true, con);
            try {
                this.runMask(true, cu.getResultReport(), con);
                this.dropTmpTabelle(con);
                CSVResultReport rr = cu.getResultReport();
                Iterator it = rr.getMessages().iterator();
                while (it.hasNext()) {
                    System.out.println(it.next());
                }
                if (rr.getErrorCount() > 0) {
                    this.csvfile.delete();
                    this.sendBackHtml(rr.errorsToHtml());
                } else {
                    this.sendBackHtml(this.readyToImport(cu.getHtmlPreview()));
                }
            }
            catch (ObligatoryFieldEmptyException e) {
                Logger.getLogger("superx_" + this.getMandantenID()).log(Level.WARNING, e.toString());
                this.response.reset();
                this.response.setContentType("text/html; charset=" + SqlStringUtils.getEncoding());
                PrintWriter output = this.response.getWriter();
                output.println("<html><head><LINK REL='stylesheet' type='text/css' href='../style/superx.css' /></LINK></head><body><p class='errmsg'>" + e.getMessage() + "</p></body></html>");
            }
            finally {
                if (!con.isClosed()) {
                    con.close();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doUploadAndShowMask() throws IOException, SQLException, TransformerConfigurationException, TemplateException, KeyParentEqualException, CloneNotSupportedException, SichtException, ParseException, InvalidKeyException, TransformerException, DBServletException, UngueltigeEingabeException, NoMainEntryException, InvalidDataTypeException {
            this.checkUserAndMaskAuthentification();
            if (!this.csvfile.exists()) {
                throw new IllegalStateException("Datei " + this.csvfile + " nicht gefunden");
            }
            Connection con = SxPools.get(this.getMandantenID()).getConnection();
            this.isZipped = false;
            CSVUploader cu = new CSVUploader(this.userid, this.getMandantenID(), this.tabelle, this.csvfile.toString(), this.delim, this.encoding, this.withHeader, "false", false, "exclude-row", this.isZipped);
            cu.upload(true, false, con);
            try {
                this.runMask(false, cu.getResultReport(), con);
                this.dropTmpTabelle(con);
                CSVResultReport rr = cu.getResultReport();
                if (rr.getErrorCount() > 0) {
                    this.csvfile.delete();
                    this.sendBackHtml(rr.errorsToHtml());
                } else {
                    XmlTransformer xmlTransformer = new XmlTransformer(SuperXmlTabelle.this.getServletConfig(), this.request, this.response, this.getMandantenID(), this.getBrowser());
                    xmlTransformer.setMaske(this.maske);
                    xmlTransformer.transform(this.maske.getName(), this.maske.getTmpFiles(), this.currentXml, this.desiredLocale, this.maske.getSelectedTableStylesheetFilename(), this.maske.getSelectedTableStylesheetContenttype(null), ServletHelper.getParameter(this.request, "encrypt"));
                }
            }
            catch (ObligatoryFieldEmptyException | NumberFormatException | FactoryConfigurationError | ParserConfigurationException e) {
                Logger.getLogger("superx_" + this.getMandantenID()).log(Level.WARNING, e.toString());
                this.response.reset();
                this.response.setContentType("text/html; charset=" + SqlStringUtils.getEncoding());
                PrintWriter output = this.response.getWriter();
                output.println(SuperXManager.htmlPageHead("Problem") + "<p class='errmsg'>" + e.getMessage() + "</p></body></html>");
            }
            finally {
                if (!con.isClosed()) {
                    con.close();
                }
                if (this.csvfile.exists()) {
                    this.csvfile.delete();
                }
            }
        }

        private void dropTmpTabelle(Connection con) throws SQLException {
            Statement stm = con.createStatement();
            stm.executeUpdate("drop table tmp_" + this.tabelle);
            stm.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doImport() throws SQLException, IOException, TransformerConfigurationException, TemplateException, KeyParentEqualException, CloneNotSupportedException, SichtException, ParseException, InvalidKeyException, TransformerException, DBServletException, UngueltigeEingabeException, NoMainEntryException, InvalidDataTypeException {
            this.readParams();
            this.checkUserAndMaskAuthentification();
            Connection con = SxPools.get(this.getMandantenID()).getConnection();
            this.isZipped = false;
            CSVUploader cu = new CSVUploader(this.userid, this.getMandantenID(), this.tabelle, this.csvfile.toString(), this.delim, this.encoding, this.withHeader, "false", false, "exclude-row", this.isZipped);
            cu.upload(true, false, con);
            try {
                this.runMask(false, cu.getResultReport(), con);
                this.dropTmpTabelle(con);
                CSVResultReport rr = cu.getResultReport();
                if (rr.getErrorCount() > 0) {
                    this.csvfile.delete();
                    this.sendBackHtml(rr.errorsToHtml());
                } else {
                    this.sendBackHtml(rr.resultToHtml());
                }
            }
            catch (ObligatoryFieldEmptyException | NumberFormatException | FactoryConfigurationError e) {
                Logger.getLogger("superx_" + this.getMandantenID()).log(Level.WARNING, e.toString());
                this.response.reset();
                this.response.setContentType("text/html; charset=" + SqlStringUtils.getEncoding());
                PrintWriter output = this.response.getWriter();
                output.println(SuperXManager.htmlPageHead("Problem") + "<p class='errmsg'>" + e.getMessage() + "</p></body></html>");
            }
            finally {
                if (!con.isClosed()) {
                    con.close();
                }
                if (this.csvfile.exists()) {
                    this.csvfile.delete();
                }
            }
        }

        private void readParams() {
            this.tid = ServletHelper.getParameter(this.request, "tid");
            this.tabelle = ServletHelper.getParameter(this.request, "Tabelle");
            this.delim = ServletHelper.getParameter(this.request, "Trennzeichen");
            this.encoding = ServletHelper.getParameter(this.request, "Kodierung");
            String feldnamen = ServletHelper.getParameter(this.request, "Feldnamen 1. Zeile");
            this.withHeader = feldnamen.equals("1");
            this.hinzufuegenModus = ServletHelper.getParameter(this.request, "Modus");
            String file = ServletHelper.getParameter(this.request, "tmpfile");
            this.csvfile = new File(file);
            if (!this.csvfile.exists()) {
                throw new IllegalStateException("Datei " + this.csvfile + " nicht gefunden");
            }
        }

        private void runMask(boolean isTestMode, CSVResultReport resultReport, Connection dbCon) throws SQLException, TemplateException, IOException, KeyParentEqualException, CloneNotSupportedException, SichtException, TransformerConfigurationException, ParseException, InvalidKeyException, TransformerException, DBServletException, UngueltigeEingabeException, NoMainEntryException, InvalidDataTypeException, ObligatoryFieldEmptyException {
            this.loadMask();
            this.desiredLocale = this.getDesiredLocale();
            this.maske.setMaxOffset(10000000);
            this.maske.setReuseResult(false);
            this.maske.setNavi(this.navi);
            SuperXManager.clearLog();
            Statement stm = null;
            if (isTestMode) {
                stm = dbCon.createStatement();
                try {
                    stm.executeUpdate("drop table tmp_errors");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                stm.executeUpdate("create temp table tmp_errors (tid integer,bezeichnung varchar(255))");
                this.sxuser.getBasicMap().put("testupload", "1");
            } else {
                this.sxuser.getBasicMap().put("testupload", "0");
                this.sxuser.getBasicMap().put("colnames", resultReport.getColnames());
                this.sxuser.getBasicMap().put("Modus", this.hinzufuegenModus);
            }
            try {
                this.currentXml = isTestMode ? this.maske.runQuery(this.sxuser, new CSVServletRequest(this.request, this.params), dbCon, this.params).toString() : this.maske.runQuery(this.sxuser, this.request, dbCon, this.params).toString();
                this.sxuser.getBasicMap().remove("testupload");
                this.sxuser.getBasicMap().remove("colnames");
                this.sxuser.getBasicMap().remove("Modus");
                SuperXManager.setLastXml(this.currentXml);
                if (isTestMode) {
                    ResultSet rs = stm.executeQuery("select distinct bezeichnung from tmp_errors ");
                    while (rs.next()) {
                        resultReport.incError("Error " + rs.getString(1));
                    }
                    rs.close();
                    stm.executeUpdate("drop table tmp_errors");
                }
            }
            catch (FileUploadException e) {
                throw new IOException(e.getMessage());
            }
        }

        private void prepareActualImport() {
            String file = ServletHelper.getParameter(this.request, "tmpfile");
            if (file == null) {
                throw new IllegalArgumentException("tmpfile nicht angegeben");
            }
            this.csvfile = new File(file);
            this.tabelle = ServletHelper.getParameter(this.request, "Tabelle");
            if (this.tabelle == null) {
                throw new IllegalArgumentException("Tabelle nicht angegeben");
            }
            this.encoding = ServletHelper.getParameter(this.request, "Kodierung");
            if (this.encoding == null) {
                throw new IllegalArgumentException("Kodierung nicht angegeben");
            }
            String header = ServletHelper.getParameter(this.request, "Feldnamen 1. Zeile");
            if (header == null) {
                throw new IllegalArgumentException("Feldnamen 1. Zeile nicht angegeben");
            }
            this.withHeader = header.equals("1");
            this.hinzufuegenModus = ServletHelper.getParameter(this.request, "Modus");
            if (this.hinzufuegenModus == null) {
                throw new IllegalArgumentException("Modus nicht angegeben");
            }
        }

        private String success() {
            String s = SuperXManager.htmlPageHead("Erfolg") + "<p align='center'>Import erfolgreich</p></body></html>";
            return s;
        }

        private String readyToImport(String htmlPreview) {
            StringBuffer buf = new StringBuffer(SuperXManager.htmlPageHead("Erfolg") + "<center><p align='center'>Die Daten k&ouml;nnen importiert werden</p>");
            buf.append("<p>Tabelle " + this.tabelle + "</p>");
            buf.append(htmlPreview + "<br><br>");
            buf.append("<form method='post' action='SuperXmlTabelle'>");
            buf.append("<input type='hidden' name='csvupload' value='true'>\n");
            buf.append("<input type='hidden' name='tid' value='" + this.tid + "'>\n");
            buf.append("<input type='hidden' name='Tabelle' value='" + this.tabelle + "'>\n");
            buf.append("<input type='hidden' name='Trennzeichen' value='" + this.delim + "'>\n");
            buf.append("<input type='hidden' name='Kodierung' value='" + this.encoding + "'>\n");
            buf.append("<input type='hidden' name='Feldnamen 1. Zeile' value='" + (this.withHeader ? "1" : "0") + "'>\n");
            buf.append("<input type='hidden' name='Modus' value='" + this.hinzufuegenModus + "'>\n");
            buf.append("<input type='hidden' name='tmpfile' value='" + this.csvfile.getAbsoluteFile() + "'>\n");
            for (String name : this.params.keySet()) {
                if (name.equals("tid") || name.equals("Tabelle") || name.equals("Trennzeichen") || name.equals("Kodierung") || name.equals("Feldnamen 1. Zeile") || name.equals("Modus")) continue;
                buf.append("<input type='hidden' name='" + name + "' value='" + this.params.get(name) + "'>\n");
            }
            buf.append("<input type='submit' name='jetzt importieren' value='jetzt importieren'></center>\n");
            buf.append("</form></body></html>");
            return buf.toString();
        }
    }

    private class TableCreator
    extends SuperXServletHelper {
        private final Hashtable formular;
        private StringBuffer msgAboutEmptyFields;
        private Maske maske;
        private Stylesheet mainStylesheet;
        private Locale desiredLocale;
        private SxUser sxuser;

        TableCreator(HttpServletRequest request, HttpServletResponse response) throws IOException {
            super(request, response);
            this.formular = new Hashtable();
        }

        private void checkUserAndMaskAuthentification() {
            String tidString = SuperXmlTabelle.this.getTid(this.request);
            this.sxuser = (SxUser)this.request.getSession().getAttribute("user");
            if (this.sxuser == null) {
                throw new IllegalStateException("Kein user in der Session gefunden - bitte Browser neu starten!");
            }
            this.sxuser.checkAuthentificationForMask(tidString);
        }

        @Override
        protected void perform() throws ParserConfigurationException, FactoryConfigurationError, SAXException, TransformerException, SQLException, NumberFormatException, TemplateException, IOException, InvalidKeyException, ParseException, DBServletException, KeyParentEqualException, CloneNotSupportedException, SichtException, UngueltigeEingabeException, NoMainEntryException, InvalidDataTypeException, ServletException {
            this.checkUserAndMaskAuthentification();
            this.desiredLocale = this.getDesiredLocale();
            boolean isClassicRunNeeded = true;
            String tidString = SuperXmlTabelle.this.getTid(this.request);
            String preparedxmlfileappendix = ServletHelper.getParameter(this.request, "preparedxmlfileappendix");
            if (preparedxmlfileappendix != null) {
                String filename;
                String contenttype = ServletHelper.getParameter(this.request, "contenttype");
                PreparedXmlProcessor px = new PreparedXmlProcessor(SuperXmlTabelle.this.getServletConfig(), this.request, this.response, this.getMandantenID(), this.getBrowser());
                if (px.isFileOk(filename = this.sxuser.getId() + "_" + tidString + "_" + preparedxmlfileappendix + ".xml", ServletHelper.getParameter(this.request, "preparedxmlnotolderthan"))) {
                    boolean success = px.process(filename, ServletHelper.getParameter(this.request, "stylesheet"), contenttype, ServletHelper.getParameter(this.request, "preparedxmlencrypted"));
                    boolean bl = isClassicRunNeeded = !success;
                }
            }
            if (isClassicRunNeeded) {
                this.classicRun();
            }
        }

        private void loadMask() throws CloneNotSupportedException, TemplateException, KeyParentEqualException, SichtException, IOException, SQLException, DBServletException, ParseException, UngueltigeEingabeException, TransformerException, NumberFormatException, NoMainEntryException, InvalidDataTypeException {
            String tidString = SuperXmlTabelle.this.getTid(this.request);
            this.userid = this.request.getSession().getAttribute("UserID").toString();
            SxUser user = (SxUser)this.request.getSession().getAttribute("user");
            this.formular.put("UserID", this.userid);
            this.formular.put("locale", this.desiredLocale.getLanguage());
            this.request.getSession().setAttribute(tidString + SuperXmlTabelle.PARAM_IS_SENT_SUFFIX, (Object)"false");
            MaskenContainer mc = MaskenContainer.getFromRequest(this.request);
            String cm = ServletHelper.getParameter(this.request, "cachingcontrol");
            if (cm != null && cm.toLowerCase().equals("clearmask")) {
                mc.removeMaske(tidString);
                Logger.getLogger("superx_" + this.getMandantenID()).log(Level.FINER, " removing cached mask " + tidString);
            } else {
                this.maske = mc.getMaske(tidString);
            }
            SuperXmlTabelle.this.tutil.start();
            if (this.maske == null) {
                if (SxPools.get(this.getMandantenID()).hasMaske(new Integer(tidString))) {
                    this.maske = SxPools.get(this.getMandantenID()).getMaskenclone(new Integer(tidString));
                    Logger.getLogger("superx_" + this.getMandantenID()).log(Level.FINER, " using mask clone");
                } else {
                    this.maske = new Maske(this.getMandantenID(), user, new Integer(tidString), this.desiredLocale);
                }
                this.maske.setFieldDefaults(this.sxuser, this.request, true);
                mc.addMaske(this.maske);
            }
        }

        private void classicRun() throws CloneNotSupportedException, TransformerConfigurationException, TemplateException, KeyParentEqualException, SichtException, IOException, DBServletException, ParseException, InvalidKeyException, TransformerException, FactoryConfigurationError, ParserConfigurationException, UngueltigeEingabeException, NoMainEntryException, NumberFormatException, InvalidDataTypeException, ServletException, SQLException {
            try {
                String contenttype;
                this.loadMask();
                if (TableCreator.getParameter(this.request, "Statistikexport") != null) {
                    String ausgabeFormat = TableCreator.getParameter(this.request, "Exportformat");
                    AbstractSuperXServlet.logger.debug((Object)("Amtliche Statistik. Ausgabeformat = " + ausgabeFormat));
                    if (this.xmlStatisticExport(ausgabeFormat)) {
                        return;
                    }
                }
                if ((contenttype = ServletHelper.getParameter(this.request, "contenttype")) == null) {
                    this.maske.setDesiredContenttype(null);
                }
                if (contenttype != null && contenttype.startsWith("application/pdf") && this.maske.isMaxRowsReached()) {
                    this.sendBackHtml(SuperXManager.htmlPageHead("Datenproblem") + "<h2>Achtung</h2><p>Datenmenge ist zu gro\u00df - bitte schr\u00e4nken Sie Ihre Abfrage ggfs. st\u00e4rker ein</p></body></html>");
                } else if (contenttype != null && contenttype.indexOf("spreadsheetml") > -1 && this.maske.isMaxRowsReached()) {
                    this.sendBackHtml(SuperXManager.htmlPageHead("Datenproblem") + "<center><h2>Achtung</h2><p>Gro\u00dfe Datenmenge <br> <input id='ss' type='submit' value='Alle Daten als Exceldatei downloaden' onclick='document.getElementById(\"ss\").disabled=\"true\";location.href=\"/superx/servlet/SuperXmlTabelle?tid=" + this.maske.getId() + "&bigexcel=true\"'><br><br>(Kann l&auml;nger dauern)</p></center></body></html>");
                } else {
                    String closeHeader;
                    String openHeader;
                    if (ServletHelper.getParameter(this.request, "maxoffset") != null && !ServletHelper.getParameter(this.request, "maxoffset").equals("")) {
                        this.maske.setMaxOffset(Integer.parseInt(ServletHelper.getParameter(this.request, "maxoffset")));
                    } else if (contenttype != null && contenttype.indexOf("html") == -1) {
                        this.maske.setMaxOffset(10000000);
                    } else {
                        this.maske.setMaxOffset(maxOffset);
                    }
                    this.maske.setOffset(this.getOffset());
                    boolean isReuseResult = false;
                    String reuse = ServletHelper.getParameter(this.request, "reuseresult");
                    if (reuse != null && reuse.equals(SuperXmlTabelle.PARAM_TRUE)) {
                        isReuseResult = true;
                    }
                    if ((openHeader = ServletHelper.getParameter(this.request, "openHeader")) != null) {
                        this.maske.openHeader(openHeader);
                        isReuseResult = true;
                    }
                    if ((closeHeader = ServletHelper.getParameter(this.request, "closeHeader")) != null) {
                        this.maske.closeHeader(closeHeader);
                        isReuseResult = true;
                    }
                    this.maske.setReuseResult(isReuseResult);
                    this.maske.resetTableStylesheet();
                    if (ServletHelper.getParameter(this.request, "stylesheet") != null && !ServletHelper.getParameter(this.request, "stylesheet").toString().trim().equals("")) {
                        this.maske.setSelectedTableStylesheetFileAndContenttype(ServletHelper.getParameter(this.request, "stylesheet"));
                    }
                    if (contenttype != null && !contenttype.equals("")) {
                        this.maske.setDesiredContenttype(contenttype);
                    }
                    SuperXManager.clearLog();
                    this.currentXml = this.maske.runQuery(this.sxuser, this.request, null).toString();
                    Logger.getLogger("superx_" + this.getMandantenID() + "_xml").log(Level.FINE, "--Ergebnis\n" + this.currentXml);
                    SuperXManager.setLastXml(this.currentXml);
                    Logger.getLogger("superx_" + this.getMandantenID() + "_xml").log(Level.FINEST, "Ergebnisxml:\n" + this.currentXml);
                    Logger.getLogger("superx_" + this.getMandantenID()).log(Level.FINER, " ausf\u00fchren der Abfrage " + SuperXmlTabelle.this.tutil.getSinceStart());
                    SuperXmlTabelle.this.tutil.start();
                    this.setExpires(cacheSecs);
                    if (contenttype != null && contenttype.equals("text/csv")) {
                        this.csvExport();
                    } else if (this.maske.getSelectedTableStylesheetFilename() != null && this.maske.getSelectedTableStylesheetFilename().equals("tabelle_xml.xsl")) {
                        this.response.setContentType("application/x-xml; charset=" + SqlStringUtils.getEncoding());
                        this.response.setHeader("Content-disposition", "attachment; filename=" + FileUtils.removeProblemChars(this.maske.getExportName()) + ".xml");
                        this.response.setHeader("Cache-Control", "expires=0");
                        this.currentXml = SxPools.get(this.getMandantenID()).localize(this.currentXml, this.desiredLocale);
                        if (this.currentXml.indexOf("Insgesamt 0 S\u00e4tze gefunden") < 1) {
                            // empty if block
                        }
                        PrintWriter out = this.response.getWriter();
                        if (ServletHelper.getParameter(this.request, "encrypted") != null && ServletHelper.getParameter(this.request, "encrypted").equals(SuperXmlTabelle.PARAM_TRUE)) {
                            this.currentXml = CryptUtils.simpleEncryptString2(this.currentXml);
                        }
                        out.write(this.currentXml);
                    } else if (this.maske.getSelectedTableStylesheetFilename() != null && this.maske.getSelectedTableStylesheetFilename().endsWith(".jrxml")) {
                        if ((this.currentXml.indexOf("Insgesamt 0 S\u00e4tze gefunden") < 1 || this.currentXml.indexOf("ergebnis ordnr=\"1\"") > -1) && this.currentXml.indexOf("Zeilen liegen \u00fcber max. Grenze") < 1) {
                            try {
                                this.turnCacheOff();
                                String reports_dir = SuperXmlTabelle.this.getServletConfig().getServletContext().getRealPath("/WEB-INF/reports") + System.getProperty("file.separator");
                                JasperCreator jc = new JasperCreator(this.request, this.response, (SxUser)this.request.getSession().getAttribute("user"), this.maske, this.maske.getSelectedTableStylesheetFilename(), this.maske.getDesiredContenttype(), reports_dir);
                                if (this.maske.getSelectedTableStylesheetFilename().indexOf("_xmlsource") > -1) {
                                    this.currentXml = SxPools.get(this.getMandantenID()).localize(this.currentXml, this.desiredLocale);
                                    jc.perform(this.getMandantenID(), this.currentXml, null);
                                }
                                if (this.maske.getSelectedTableStylesheetFilename().indexOf("_dbsource") > -1) {
                                    jc.perform(this.getMandantenID(), this.maske, null);
                                } else {
                                    jc.perform(this.getMandantenID(), this.maske, null);
                                }
                                Logger.getLogger("superx_" + this.getMandantenID()).log(Level.FINER, " schicken des JasperReport an Client " + SuperXmlTabelle.this.tutil.getSinceStart());
                            }
                            catch (JRException e) {
                                this.writeExceptionText("log", e, "JasperReport-Erzeugung ");
                            }
                        } else {
                            String sendBack = "";
                            sendBack = this.currentXml.indexOf("Zeilen liegen \u00fcber max. Grenze") >= 1 ? SuperXManager.htmlPageHead("Zu viele Daten") + "<h5 style='font-family:sans-serif'>F&uuml;r den ausgew&auml;hlten Zeitraum ist die Datenmenge gr&ouml;&szlig;er als die max. Zeilenanzahl.</h5>" : (this.currentXml.indexOf("Insgesamt 0 S\u00e4tze gefunden") >= 1 ? SuperXManager.htmlPageHead("Keine Daten") + "<h5 style='font-family:sans-serif'>F&uuml;r den ausgew&auml;hlten Zeitraum sind keine Daten vorhanden.</h5>" : SuperXManager.htmlPageHead("Datenproblem") + "<h5 style='font-family:sans-serif'>F&uuml;r den ausgew&auml;hlten Zeitraum gibt es keine Daten.</h5>");
                            if (contenttype != null && contenttype.startsWith("image/")) {
                                this.returnHtmlAsImage(sendBack, contenttype);
                            } else {
                                this.sendBackHtml(sendBack);
                            }
                        }
                    } else if (contenttype != null && contenttype.equalsIgnoreCase("application/jrxml") && this.maske.getSelectedTableStylesheet().getStylesheetType().equals("XSL_JRXML")) {
                        SuperXmlTabelle.this.transformToJrxmlAndExecute(this.currentXml, this.maske.getSelectedTableStylesheetFilename(), null, this.request, this.response, this.maske, this.getMandantenID());
                    } else {
                        if (contenttype != null && (contenttype.startsWith("text/xml") || contenttype.startsWith("application"))) {
                            String filename_extension = "";
                            if (contenttype.indexOf("/") > -1) {
                                filename_extension = "." + contenttype.substring(contenttype.lastIndexOf("/") + 1);
                                this.response.setContentType("application/x-xml; charset=" + SqlStringUtils.getEncoding());
                                this.response.setHeader("Content-disposition", "attachment; filename=" + FileUtils.removeProblemChars(this.maske.getExportName()) + filename_extension);
                                this.response.setHeader("Cache-Control", "expires=0");
                            }
                        }
                        XmlTransformer xmlTransformer = new XmlTransformer(SuperXmlTabelle.this.getServletConfig(), this.request, this.response, this.getMandantenID(), this.getBrowser());
                        xmlTransformer.setMaske(this.maske);
                        xmlTransformer.transform(this.maske.getExportName(), this.maske.getTmpFiles(), this.currentXml, this.desiredLocale, this.maske.getSelectedTableStylesheetFilename(), this.maske.getSelectedTableStylesheetContenttype(contenttype), ServletHelper.getParameter(this.request, "encrypt"));
                    }
                    this.request.getSession().setAttribute(this.maske.getId() + SuperXmlTabelle.PARAM_IS_SENT_SUFFIX, (Object)SuperXmlTabelle.PARAM_TRUE);
                }
            }
            catch (ObligatoryFieldEmptyException e) {
                Logger.getLogger("superx_" + this.getMandantenID()).log(Level.WARNING, e.toString());
                this.response.reset();
                this.response.setContentType("text/html; charset=" + SqlStringUtils.getEncoding());
                PrintWriter output = this.response.getWriter();
                output.println(SuperXManager.htmlPageHead("Problem") + "<p class='errmsg'>" + e.getMessage() + "</p></body></html>");
            }
        }

        private void csvExport() throws IOException {
            StringBuffer csv = this.maske.getCSV(this.getMandantenID());
            if (SxPools.get(this.getMandantenID()).getRepository().containsKey("K_CSV_Excel_ISO") && SxPools.get(this.getMandantenID()).getRepository().get("K_CSV_Excel_ISO").toString().equals("1")) {
                String outp = new String(csv.toString().getBytes("iso-8859-1"));
                this.response.setHeader("Content-disposition", "attachment; filename=" + FileUtils.removeProblemChars(this.maske.getExportName()) + ".csv");
                this.response.setHeader("Cache-Control", "expires=0");
                this.response.setHeader("ContentType", "text/plain");
                this.sendBackIso(csv.toString(), "text/csv; charset=ISO-8859-1");
            } else {
                this.response.setHeader("Content-disposition", "attachment; filename=" + FileUtils.removeProblemChars(this.maske.getExportName()) + ".csv");
                this.response.setHeader("Cache-Control", "expires=0");
                this.sendBack(csv.toString(), "text/csv");
            }
        }

        void sendBackIso(String txt, String contenttype) throws IOException {
            Object out = null;
            TimeUtils t = new TimeUtils();
            t.start();
            byte[] stuff = txt.getBytes("iso-8859-1");
            String encoding = this.request.getHeader("Accept-Encoding");
            if (!SuperXManager.isResponseCompressionWanted) {
                encoding = "none";
            }
            if (encoding != null && encoding.indexOf("gzip") != -1) {
                this.response.setHeader("Content-Encoding", "gzip");
                out = new GZIPOutputStream((OutputStream)this.response.getOutputStream());
            } else if (encoding != null && encoding.indexOf("compress") != -1) {
                this.response.setHeader("Content-Encoding", "compress");
                out = new ZipOutputStream((OutputStream)this.response.getOutputStream());
            } else {
                this.response.setContentLength(stuff.length);
                out = this.response.getOutputStream();
            }
            if (contenttype != null) {
                this.response.setContentType(contenttype);
            }
            ((OutputStream)out).write(stuff);
            ((OutputStream)out).close();
        }

        /*
         * Unable to fully structure code
         */
        private boolean xmlStatisticExport(String ausgabeFormat) throws IOException {
            done = true;
            propertiesFileName = TableCreator.getParameter(this.request, "propertiesFileName");
            sdf = TableCreator.getParameter(this.request, "sdf");
            dir = TableCreator.getParameter(this.request, "statdir");
            lieferung = TableCreator.getParameter(this.request, "Lieferung");
            semester = TableCreator.getParameter(this.request, "berichtssemester");
            inspectionLevel = TableCreator.getParameter(this.request, "Pr\u00fcfstufe");
            plausi = TableCreator.getParameter(this.request, "Plausibilisierung");
            stand = TableCreator.getParameter(this.request, "stand");
            sql = TableCreator.getParameter(this.request, "statsql");
            standort = TableCreator.getParameter(this.request, "Hochschulstandort");
            where = null;
            if (standort != null && !standort.isEmpty()) {
                where = "ef004='" + standort + "'";
            }
            distributionType = StatisticsBase.DistributionType.COMPLETE1990;
            if (dir.contains("2016")) {
                distributionType = StatisticsBase.DistributionType.COMPLETE2016;
            }
            var15_15 = lieferung.toLowerCase();
            var16_16 = -1;
            switch (var15_15.hashCode()) {
                case 50: {
                    if (!var15_15.equals("2")) break;
                    var16_16 = 0;
                    break;
                }
                case 51: {
                    if (!var15_15.equals("3")) break;
                    var16_16 = 1;
                    break;
                }
                case 52: {
                    if (!var15_15.equals("4")) break;
                    var16_16 = 2;
                }
            }
            switch (var16_16) {
                case 0: {
                    distributionType = StatisticsBase.DistributionType.STUDENTS1990;
                    if (!dir.contains("2016")) break;
                    distributionType = StatisticsBase.DistributionType.STUDENTS2016;
                    break;
                }
                case 1: {
                    distributionType = StatisticsBase.DistributionType.EXAMINATIONS1990;
                    if (!dir.contains("2016")) break;
                    distributionType = StatisticsBase.DistributionType.EXAMINATIONS2016;
                    break;
                }
                case 2: {
                    distributionType = StatisticsBase.DistributionType.GUEST_LISTENERS;
                }
            }
            AbstractSuperXServlet.logger.debug((Object)("Lieferungsart: " + lieferung));
            AbstractSuperXServlet.logger.debug((Object)("Plausi: " + plausi));
            servletContext = this.request.getSession().getServletContext();
            contextPath = servletContext.getRealPath("/");
            appContext = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)servletContext);
            statExport = new StatisticExport(distributionType, contextPath + File.separator + dir, sdf, propertiesFileName, sql, where);
            datasource = (DataSource)appContext.getBean("dataSource");
            statExport.setDataSource(datasource);
            offset = this.getOffset();
            if ("2".equals(plausi) && offset == 0) {
                statExport.doPlausi();
            }
            if (ausgabeFormat.equals("text/html")) {
                return false;
            }
            exportFormat = StatisticExport.ExportFormat.getForMimeType(ausgabeFormat);
            if (exportFormat == StatisticExport.ExportFormat.UNKNOWN) {
                throw new RuntimeException("Unbekanntes Ausgabeformat: " + ausgabeFormat);
            }
            fileName = distributionType.getDescription() + "_statistik_" + semester.replaceAll("\\/", "-") + "_" + stand + ".";
            fileName = fileName.replaceAll(" ", "_");
            responseOut = this.response.getOutputStream();
            var24_25 = null;
            try {
                if (exportFormat == StatisticExport.ExportFormat.ZIP) {
                    this.response.setHeader("Content-disposition", "attachment; filename=statistik.zip");
                    this.response.setHeader("Cache-Control", "expires=0");
                    tmp = Files.createTempFile("stat", "stud", new FileAttribute[0]);
                    tmpOut = new BufferedOutputStream(new FileOutputStream(tmp.toFile()));
                    var27_30 = null;
                    try {
                        statExport.generate(tmpOut);
                    }
                    catch (Throwable var28_33) {
                        var27_30 = var28_33;
                        throw var28_33;
                    }
                    finally {
                        if (tmpOut != null) {
                            if (var27_30 != null) {
                                try {
                                    tmpOut.close();
                                }
                                catch (Throwable var28_32) {
                                    var27_30.addSuppressed(var28_32);
                                }
                            } else {
                                tmpOut.close();
                            }
                        }
                    }
                    zipOutputStream = new ZipOutputStream((OutputStream)responseOut);
                    var27_30 = null;
                    try {
                        fileName = fileName + "xml";
                        entry = new ZipEntry(fileName);
                        zipOutputStream.putNextEntry(entry);
                        tmpIn = new BufferedInputStream(new FileInputStream(tmp.toFile()));
                        ByteStreams.copy((InputStream)tmpIn, (OutputStream)zipOutputStream);
                        if (inspectionLevel == null) ** GOTO lbl178
                        inspectionLevelInt = Integer.parseInt(inspectionLevel);
                        report = statExport.getInspectionReport(new BufferedInputStream(new FileInputStream(tmp.toFile())), inspectionLevelInt);
                        entry = new ZipEntry("inspection_report.txt");
                        zipOutputStream.putNextEntry(entry);
                        problems = report.getProblemList();
                        for (InspectionProblem problem : problems) {
                            position = problem.getPosition();
                            line = String.format("Problem: Zeile %d, Spalte %d: %s\n", new Object[]{position.getLine(), position.getColumn(), problem.getComment()});
                            zipOutputStream.write(line.getBytes());
                        }
                    }
                    catch (Throwable entry) {
                        var27_30 = entry;
                        throw entry;
                    }
                    finally {
                        if (zipOutputStream != null) {
                            if (var27_30 != null) {
                                try {
                                    zipOutputStream.close();
                                }
                                catch (Throwable entry) {
                                    var27_30.addSuppressed(entry);
                                }
                            } else {
                                zipOutputStream.close();
                            }
                        }
                    }
                } else {
                    if ("2".equals(plausi)) {
                        this.response.setHeader("Content-disposition", "attachment; filename=statistik.zip");
                        this.response.setHeader("Cache-Control", "expires=0");
                        tmp = Files.createTempFile("stat", "stud", new FileAttribute[0]);
                        tmpOut = new BufferedOutputStream(new FileOutputStream(tmp.toFile()));
                        var27_30 = null;
                        try {
                            statExport.getOutput(exportFormat.getMimeType(), tmpOut);
                        }
                        catch (Throwable entry) {
                            var27_30 = entry;
                            throw entry;
                        }
                        finally {
                            if (tmpOut != null) {
                                if (var27_30 != null) {
                                    try {
                                        tmpOut.close();
                                    }
                                    catch (Throwable entry) {
                                        var27_30.addSuppressed(entry);
                                    }
                                } else {
                                    tmpOut.close();
                                }
                            }
                        }
                        zipOutputStream = new ZipOutputStream((OutputStream)responseOut);
                        var27_30 = null;
                        try {
                            fileName = fileName + exportFormat.getExtension();
                            zipOutputStream.putNextEntry(new ZipEntry(fileName));
                            tmpIn = new BufferedInputStream(new FileInputStream(tmp.toFile()));
                            ByteStreams.copy((InputStream)tmpIn, (OutputStream)zipOutputStream);
                            zipOutputStream.putNextEntry(new ZipEntry("plausi.log"));
                            statExport.readPlausiFromDb(zipOutputStream);
                        }
                        catch (Throwable var28_41) {
                            var27_30 = var28_41;
                            throw var28_41;
                        }
                        finally {
                            if (zipOutputStream != null) {
                                if (var27_30 != null) {
                                    try {
                                        zipOutputStream.close();
                                    }
                                    catch (Throwable var28_40) {
                                        var27_30.addSuppressed(var28_40);
                                    }
                                } else {
                                    zipOutputStream.close();
                                }
                            }
                        }
                    }
                    fileName = fileName + exportFormat.getExtension();
                    this.response.setHeader("Content-disposition", "attachment; filename=" + fileName);
                    this.response.setHeader("Cache-Control", "expires=0");
                    statExport.getOutput(exportFormat.getMimeType(), (OutputStream)responseOut);
                }
lbl178:
                // 4 sources

                jt = new JdbcTemplate(datasource);
                switch (1.$SwitchMap$de$superx$stat$StatisticsBase$DistributionType[distributionType.ordinal()]) {
                    case 1: 
                    case 2: 
                    case 3: {
                        filenameUpdateSql = "update sos_stat_info set exportfile='" + fileName + "' where lieferungsart = 'statistik2016'";
                        jt.execute(filenameUpdateSql);
                        break;
                    }
                    case 4: {
                        filenameUpdateSql = "update sos_stat_info set exportfile='" + fileName + "' where lieferungsart = 'gasthoerer'";
                        jt.execute(filenameUpdateSql);
                    }
                }
                var26_29 = done;
                return var26_29;
            }
            catch (Throwable var25_27) {
                var24_25 = var25_27;
                throw var25_27;
            }
            finally {
                if (responseOut != null) {
                    if (var24_25 != null) {
                        try {
                            responseOut.close();
                        }
                        catch (Throwable var27_31) {
                            var24_25.addSuppressed(var27_31);
                        }
                    } else {
                        responseOut.close();
                    }
                }
            }
        }

        private int getOffset() {
            String offs = TableCreator.getParameter(this.request, "offset");
            int offset = offs == null || offs.isEmpty() ? 0 : Integer.parseInt(offs);
            return offset;
        }
    }

    private class KettleHelper
    extends SuperXServletHelper {
        private List<FileItem> multipartData;
        private SxUser sxuser;
        private Locale desiredLocale;
        private File uploadFile;
        private String pathstart;

        KettleHelper(List<FileItem> multipartData, HttpServletRequest request, HttpServletResponse response) throws IOException {
            super(request, response);
            this.pathstart = "";
            this.multipartData = multipartData;
            this.desiredLocale = this.getDesiredLocale();
            this.pathstart = System.getProperty("java.io.tmpdir");
            if (!this.pathstart.endsWith("/") && !this.pathstart.endsWith("\\")) {
                this.pathstart = this.pathstart + File.separator;
            }
        }

        private void checkUserAndMaskAuthentification(String maskNumber) {
            this.sxuser = (SxUser)this.request.getSession().getAttribute("user");
            if (this.sxuser == null) {
                throw new IllegalStateException("Kein user in der Session gefunden - bitte Browser neu starten!");
            }
            this.sxuser.checkAuthentificationForMask(maskNumber);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void perform() throws SQLException, DBServletException, TransformerException, KeyParentEqualException, NichtAngemeldetException, IOException, ParseException, ParserConfigurationException, FactoryConfigurationError, SAXException, DocumentException, IllegalArgumentException, SecurityException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, CloneNotSupportedException, TemplateException, InvalidKeyException, SichtException, IOException, ServletException, UngueltigeEingabeException, NoMainEntryException, InvalidDataTypeException {
            String maskNumber = this.getMaskNumber();
            this.checkUserAndMaskAuthentification(maskNumber);
            this.uploadSourceFile();
            MaskenContainer mc = MaskenContainer.getFromRequest(this.request);
            Maske maske = mc.getMaske(maskNumber);
            maske.setMultipartData(this.multipartData);
            try {
                boolean isDeleted;
                this.currentXml = maske.runQuery(this.sxuser, this.request, null).toString();
                KettleExecutor ke = new KettleExecutor(ServletUtils.getMandantenID(this.request));
                ke.setParams(this.getParams());
                StringBuffer results = ke.perform();
                if (this.uploadFile != null && this.uploadFile.exists() && (isDeleted = this.uploadFile.delete())) {
                    results.append("\n Tempor\u00e4re Datei " + this.uploadFile + " gel\u00f6scht");
                }
                this.returnHtml(maske, results);
            }
            catch (ObligatoryFieldEmptyException e) {
                Logger.getLogger("superx_" + this.getMandantenID()).log(Level.WARNING, e.toString());
                this.response.reset();
                this.response.setContentType("text/html; charset=" + SqlStringUtils.getEncoding());
                PrintWriter output = this.response.getWriter();
                output.println(SuperXManager.htmlPageHead("Problem") + "<p class='errmsg'>" + e.getMessage() + "</p></body></html>");
            }
            finally {
                if (this.uploadFile != null && this.uploadFile.exists()) {
                    this.uploadFile.delete();
                }
            }
        }

        private Map<String, String> getParams() {
            HashMap<String, String> jobParams = new HashMap<String, String>();
            String uploadFileParam = "";
            if (this.uploadFile != null) {
                uploadFileParam = this.uploadFile.getAbsolutePath();
            }
            jobParams.put("PATH_TO_UPLOADFILE", uploadFileParam);
            for (FileItem item : this.multipartData) {
                String paramName;
                if (!item.isFormField() || !this.isParamNeeded(paramName = item.getFieldName())) continue;
                jobParams.put(paramName, item.getString());
            }
            return jobParams;
        }

        private boolean isParamNeeded(String param) {
            boolean result = true;
            if (param.equals("navi") || param.equals("keyfieldsused") || param.equals("tid") || param.equals("stylesheet") || param.startsWith("select_") || param.startsWith("label_")) {
                result = false;
            }
            return result;
        }

        private String getMaskNumber() {
            String tid = null;
            for (FileItem item : this.multipartData) {
                if (!item.isFormField() || !item.getFieldName().equals("tid")) continue;
                tid = item.getString();
            }
            return tid;
        }

        private void uploadSourceFile() throws IOException {
            try {
                for (FileItem item : this.multipartData) {
                    if (item.isFormField() || item.getSize() == 0L) continue;
                    this.uploadFile = new File(this.pathstart + item.getName());
                    if (this.uploadFile.exists()) {
                        this.uploadFile.delete();
                    }
                    item.write(this.uploadFile);
                }
            }
            catch (Exception e) {
                throw new IOException("Hochladen nicht erfolgreich: " + e);
            }
        }

        private void returnHtml(Maske maske, StringBuffer results) throws DBServletException, FactoryConfigurationError, IOException, ParserConfigurationException, TransformerException {
            StringTokenizer st = new StringTokenizer(results.toString(), "\n");
            StringBuffer logxml = new StringBuffer();
            int i = 0;
            while (st.hasMoreTokens()) {
                String aline = st.nextToken();
                logxml.append("<row no=\"" + i + "\" > \n<col id=\"0\" typ=\"1\"> \n<f_name>Log</f_name> \n<wert><![CDATA[" + aline + "]]></wert> \n</col></row>");
                ++i;
            }
            this.currentXml = this.currentXml.replaceAll("<sqlerg.*>", "<sqlerg max=\"" + (i + 1) + "\" maxOffset= \"30\" offset=\"0\" istreetable=\"false\">");
            this.currentXml = StringUtils.replace(this.currentXml, "</sqlerg>", logxml + "\n</sqlerg>\n");
            this.currentXml.replaceAll("<msg>Insgesamt.*</msg>", "<msg>Insgesamt 1 S\u00e4tze gefunden</msg>");
            SuperXManager.setLastXml(this.currentXml);
            SuperXManager.setLastXmlMandantid(this.request.getSession().getAttribute("MandantenID").toString());
            XmlTransformer xmlTransformer = new XmlTransformer(SuperXmlTabelle.this.getServletConfig(), this.request, this.response, this.getMandantenID(), this.getBrowser());
            xmlTransformer.setMaske(maske);
            xmlTransformer.transform(maske.getExportName(), maske.getTmpFiles(), this.currentXml, this.desiredLocale, maske.getSelectedTableStylesheetFilename(), "text/html", ServletHelper.getParameter(this.request, "encrypt"));
            this.request.getSession().setAttribute(maske.getId() + SuperXmlTabelle.PARAM_IS_SENT_SUFFIX, (Object)SuperXmlTabelle.PARAM_TRUE);
        }
    }

    private class BigExcelCreator
    extends SuperXServletHelper {
        private HashMap styles;
        private SxUser user;

        BigExcelCreator(HttpServletRequest request, HttpServletResponse response) throws IOException {
            super(request, response);
            this.styles = new HashMap();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void perform() throws SQLException, DBServletException, TransformerException, KeyParentEqualException, NichtAngemeldetException, IOException, ParseException, ParserConfigurationException, FactoryConfigurationError, SAXException, DocumentException, IllegalArgumentException, SecurityException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, CloneNotSupportedException, TemplateException, InvalidKeyException, SichtException, IOException, ServletException, UngueltigeEingabeException, NoMainEntryException, InvalidDataTypeException {
            this.checkUserAndMaskAuthentification();
            String tidString = SuperXmlTabelle.this.getTid(this.request);
            MaskenContainer mc = MaskenContainer.getFromRequest(this.request);
            Maske maske = mc.getMaske(tidString);
            if (maske == null) {
                throw new ServletException("Maske " + tidString + " nicht in maskencontainer gefunden");
            }
            Connection con = SxPools.get(this.getMandantenID()).getConnection();
            SXSSFWorkbook wb = new SXSSFWorkbook(100);
            this.initStyles(wb);
            try {
                Statement stm = con.createStatement();
                ResultSet rs = this.executeQuery(maske, stm);
                SXSSFSheet sh = wb.createSheet("Tabelle 1");
                int rownum = 0;
                int colcount = rs.getMetaData().getColumnCount();
                Runtime rt = Runtime.getRuntime();
                TimeUtils t = new TimeUtils();
                t.start();
                ResultSetMetaData rsmd = rs.getMetaData();
                int[] coltypes = new int[rsmd.getColumnCount() + 1];
                for (int i = 0; i < rsmd.getColumnCount(); ++i) {
                    coltypes[i] = rsmd.getColumnType(i + 1);
                    sh.trackColumnForAutoSizing(i);
                }
                Row row = sh.createRow(rownum);
                row.setHeight(Short.parseShort("600"));
                Cell cell = row.createCell(0);
                cell.setCellValue(maske.getName());
                cell.setCellStyle((CellStyle)this.styles.get("title"));
                row = sh.createRow(++rownum);
                row.setHeight(Short.parseShort("1000"));
                cell = row.createCell(0);
                cell.setCellValue(maske.getLegendText(this.user));
                row = sh.createRow(++rownum);
                this.createHeaders(maske, (Sheet)sh, ++rownum);
                ++rownum;
                while (rs.next()) {
                    if (rownum % 50000 == 0) {
                        long mb = (rt.totalMemory() - rt.freeMemory()) / 1024L / 1024L;
                        System.gc();
                    }
                    row = sh.createRow(rownum);
                    block12: for (int cellnum = 0; cellnum < colcount; ++cellnum) {
                        cell = row.createCell(cellnum);
                        Object o = rs.getObject(cellnum + 1);
                        if (o == null) {
                            cell.setCellType(3);
                            continue;
                        }
                        switch (coltypes[cellnum]) {
                            case 91: {
                                cell.setCellStyle((CellStyle)this.styles.get("date"));
                                cell.setCellValue((Date)o);
                                continue block12;
                            }
                            case 2: 
                            case 3: 
                            case 6: 
                            case 8: {
                                cell.setCellType(0);
                                cell.setCellStyle((CellStyle)this.styles.get("double"));
                                Double d = new Double(o.toString());
                                cell.setCellValue(d.doubleValue());
                                continue block12;
                            }
                            case 4: 
                            case 5: {
                                cell.setCellType(0);
                                cell.setCellStyle((CellStyle)this.styles.get("integer"));
                                Double d2 = new Double(o.toString());
                                cell.setCellValue(d2.doubleValue());
                                continue block12;
                            }
                            default: {
                                cell.setCellValue(o.toString());
                            }
                        }
                    }
                    ++rownum;
                }
                for (int i = 1; i < rsmd.getColumnCount(); ++i) {
                    sh.autoSizeColumn(i);
                }
                stm.execute(maske.getCleanup_stmt());
                stm.close();
                con.close();
                this.sendResponse(maske, wb);
            }
            catch (SQLException e) {
                SxPools.invalidate(this.getMandantenID(), con);
            }
            finally {
                wb.dispose();
            }
        }

        private void createHeaders(Maske maske, Sheet sh, int rownum) {
            List headers = maske.getHeaderCaptionList(this.getMandantenID(), true);
            Row row = sh.createRow(rownum);
            for (int i = 0; i < headers.size(); ++i) {
                Cell cell = row.createCell(i);
                cell.setCellValue((String)headers.get(i));
                cell.setCellStyle((CellStyle)this.styles.get("header"));
                ((SXSSFSheet)sh).trackColumnForAutoSizing(i);
            }
        }

        private void sendResponse(Maske maske, SXSSFWorkbook wb) throws IOException {
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            wb.write((OutputStream)outStream);
            this.response.reset();
            this.response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            this.response.setHeader("Content-disposition", "attachment; filename=" + FileUtils.removeProblemChars(maske.getExportName()) + ".xlsx");
            this.response.setHeader("Cache-Control", "expires=0");
            this.response.setContentLength(outStream.size());
            ServletOutputStream sos = this.response.getOutputStream();
            outStream.writeTo((OutputStream)sos);
            sos.flush();
            wb.dispose();
        }

        private ResultSet executeQuery(Maske maske, Statement stm) throws SQLException {
            String cleanup = maske.getCleanup_stmt();
            String query = maske.getLastsql();
            if (cleanup != null && !cleanup.trim().equals("")) {
                query = StringUtils.replace(query, maske.getCleanup_stmt(), "");
            }
            StringTokenizer st = new StringTokenizer(query, ";");
            while (st.hasMoreTokens()) {
                String sqlstmt = st.nextToken().trim();
                if (sqlstmt.length() <= 3) continue;
                stm.execute(sqlstmt);
            }
            ResultSet rs = stm.getResultSet();
            return rs;
        }

        private void initStyles(SXSSFWorkbook wb) {
            CreationHelper createHelper = wb.getCreationHelper();
            CellStyle cellStyle = wb.createCellStyle();
            cellStyle.setDataFormat(createHelper.createDataFormat().getFormat("dd.mm.yyyy"));
            this.styles.put("date", cellStyle);
            cellStyle = wb.createCellStyle();
            cellStyle.setDataFormat(wb.createDataFormat().getFormat("0.00"));
            this.styles.put("double", cellStyle);
            cellStyle = wb.createCellStyle();
            cellStyle.setDataFormat(wb.createDataFormat().getFormat("#"));
            this.styles.put("integer", cellStyle);
            Font titleFont = wb.createFont();
            titleFont.setFontHeightInPoints((short)18);
            titleFont.setBold(true);
            cellStyle = wb.createCellStyle();
            cellStyle.setFont(titleFont);
            this.styles.put("title", cellStyle);
            cellStyle = wb.createCellStyle();
            cellStyle.setFillBackgroundColor(HSSFColor.GREY_25_PERCENT.index);
            cellStyle.setBorderLeft(BorderStyle.MEDIUM);
            cellStyle.setBorderRight(BorderStyle.MEDIUM);
            cellStyle.setBorderTop(BorderStyle.MEDIUM);
            cellStyle.setBorderBottom(BorderStyle.MEDIUM);
            this.styles.put("header", cellStyle);
        }

        private void checkUserAndMaskAuthentification() {
            String tidString = SuperXmlTabelle.this.getTid(this.request);
            this.user = (SxUser)this.request.getSession().getAttribute("user");
            if (this.user == null) {
                throw new IllegalStateException("Kein user (SxUser-Objekt) in der Session gefunden!");
            }
            this.user.checkAuthentificationForMask(tidString);
        }
    }
}

