/*
 * Decompiled with CFR 0.152.
 */
package de.superx.saiku;

import de.superx.common.SxUser;
import de.superx.servlet.SuperXManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.saiku.web.service.SessionService;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken;

public class SuperxSaikuSessionService
extends SessionService {
    public static Logger logger = Logger.getLogger(SuperxSaikuSessionService.class);
    public static final String VIEW_OLAP_RIGHT = "RIGHT_CS_BIA_OLAP_CREATE_TABLES";
    Map<Object, Map<String, Object>> sessionHolder = new HashMap<Object, Map<String, Object>>();
    private transient AuthenticationManager authenticationManager;

    public void authenticate(HttpServletRequest req, String username, String password) {
        SxUser sxUser = SuperxSaikuSessionService.getSuperxUserFromSession(req);
        SxUser principal = null;
        String credentials = null;
        if (sxUser != null) {
            if (SuperXManager.isHis1 && !sxUser.getHis1Rights().contains(VIEW_OLAP_RIGHT)) {
                throw new RuntimeException("SuperX Authentication failed. Missing right to view olap reports!");
            }
        } else {
            throw new RuntimeException("SuperX-Session Authentication failed for: " + username);
        }
        principal = sxUser;
        credentials = sxUser.getPassword();
        try {
            PreAuthenticatedAuthenticationToken token = new PreAuthenticatedAuthenticationToken((Object)principal, (Object)credentials);
            token.setDetails((Object)principal);
            Authentication authentication = this.authenticationManager.authenticate((Authentication)token);
            logger.info((Object)("Logging in with " + authentication.getPrincipal()));
            SecurityContextHolder.getContext().setAuthentication(authentication);
        }
        catch (BadCredentialsException bd) {
            throw new RuntimeException("Authentication failed for: " + username, bd);
        }
    }

    public Map<String, Object> getSession() {
        Object p;
        if (SecurityContextHolder.getContext() != null && SecurityContextHolder.getContext().getAuthentication() != null && this.sessionHolder.containsKey(p = SecurityContextHolder.getContext().getAuthentication().getPrincipal())) {
            HashMap<String, Object> r = new HashMap<String, Object>();
            r.putAll(this.sessionHolder.get(p));
            r.remove("password");
            return r;
        }
        return new HashMap<String, Object>();
    }

    public Map<String, Object> getAllSessionObjects() {
        Object p;
        if (SecurityContextHolder.getContext() != null && SecurityContextHolder.getContext().getAuthentication() != null && this.sessionHolder.containsKey(p = SecurityContextHolder.getContext().getAuthentication().getPrincipal())) {
            HashMap<String, Object> r = new HashMap<String, Object>();
            r.putAll(this.sessionHolder.get(p));
            return r;
        }
        return new HashMap<String, Object>();
    }

    public Map<String, Object> login(HttpServletRequest req, String username, String password) {
        if (this.authenticationManager != null) {
            this.authenticate(req, username, password);
        }
        if (SecurityContextHolder.getContext() != null && SecurityContextHolder.getContext().getAuthentication() != null) {
            String realUserName;
            Object p = SecurityContextHolder.getContext().getAuthentication().getPrincipal();
            if (!this.sessionHolder.containsKey(p)) {
                this.sessionHolder.put(p, new HashMap());
            }
            if ((realUserName = ((UserDetails)p).getUsername()) == null) {
                throw new RuntimeException("No real username found for: " + username);
            }
            this.sessionHolder.get(p).put("username", realUserName);
            this.sessionHolder.get(p).put("password", password);
            this.sessionHolder.get(p).put("sessionid", UUID.randomUUID().toString());
            ArrayList<String> roles = new ArrayList<String>();
            for (GrantedAuthority ga : SecurityContextHolder.getContext().getAuthentication().getAuthorities()) {
                roles.add(ga.getAuthority());
            }
            this.sessionHolder.get(p).put("roles", roles);
            return this.sessionHolder.get(p);
        }
        return new HashMap<String, Object>();
    }

    public void logout(HttpServletRequest httpServletRequest) {
        Object p;
        if (SecurityContextHolder.getContext() != null && SecurityContextHolder.getContext().getAuthentication() != null && this.sessionHolder.containsKey(p = SecurityContextHolder.getContext().getAuthentication().getPrincipal())) {
            this.sessionHolder.remove(p);
        }
        SecurityContextHolder.clearContext();
        HttpSession session = httpServletRequest.getSession(true);
        session.invalidate();
    }

    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    private static SxUser getSuperxUserFromSession(HttpServletRequest httpServletRequest) {
        SxUser result = null;
        HttpSession session = httpServletRequest.getSession();
        if (session != null) {
            result = (SxUser)session.getAttribute("user");
        }
        return result;
    }
}

