/*
 * Decompiled with CFR 0.152.
 */
package de.superx.bin;

import de.memtext.util.GetOpts;
import de.memtext.util.TimeUtils;
import de.superx.bin.SxTransformer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;

public class SimpleTransform {
    private static String usage = "-------------------------------------\nGebrauch: java de.superx.SimpleTransform -logger=<<Pfad zu logging.properties>> -IN=<<xml-Datei>> -XSL=<<xsl-Datei>> -method=<<xml |html|text>>(optional) -param=<<Parameter>>(optional) -OUT=<<Ausgabedatei>>(optional) \n---------------------------------------------------";
    static Logger logger = Logger.getLogger(SimpleTransform.class.toString());
    private static String _out = "";

    public static void transform(String[] args) throws TransformerException, TransformerConfigurationException, FileNotFoundException, IOException, ClassNotFoundException, FileNotFoundException, IOException {
        File f;
        String _xml = "";
        String _xsl = "";
        String method = "text";
        String _params = "";
        String logfile = "";
        GetOpts.setOpts(args);
        String isdrin = GetOpts.isAllRequiredOptionsPresent("-logger,-IN,-XSL");
        if (isdrin != null) {
            System.err.println("Folgende Optionen fehlen: " + isdrin);
            System.err.println(usage);
            System.exit(1);
        }
        if (GetOpts.isPresent("-logger")) {
            logfile = GetOpts.getValue("-logger");
        }
        if (GetOpts.isPresent("-IN")) {
            _xml = GetOpts.getValue("-IN");
        }
        if (GetOpts.isPresent("-XSL")) {
            _xsl = GetOpts.getValue("-XSL");
        }
        if (GetOpts.isPresent("-OUT")) {
            _out = GetOpts.getValue("-OUT");
        }
        if (GetOpts.isPresent("-method")) {
            method = GetOpts.getValue("-method");
        }
        if (GetOpts.isPresent("-params")) {
            _params = GetOpts.getValue("-params");
        }
        if (!(f = new File(logfile)).exists()) {
            throw new IOException("Datei nicht gefunden: " + logfile);
        }
        FileInputStream ins = new FileInputStream(logfile);
        LogManager MyLogManager = LogManager.getLogManager();
        MyLogManager.readConfiguration(ins);
        logger.info("Using Loggging-Level " + MyLogManager.getProperty(".level"));
        SxTransformer myTransformer = null;
        myTransformer = _out.equals("") ? new SxTransformer(logger, System.out) : new SxTransformer(logger, _out);
        myTransformer.quellstring = _xml;
        myTransformer.stylesheet = _xsl;
        myTransformer.setParams(_params);
        try {
            myTransformer.transformFile(method);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        try {
            if (args.length < 2) {
                System.err.println("Mindestens drei Parameter (Pfad zu den logger.properties, Pfad zur xml-Datei,Pfad zur xsl-Datei) erfoderlich");
                System.err.println(usage);
                System.exit(1);
            }
            TimeUtils t = new TimeUtils();
            t.start();
            SimpleTransform.transform(args);
            t.print(" done");
            String msg = "XML-Transformation erfolgreich ";
            if (_out != null && !_out.equals("")) {
                msg = msg + _out + " erzeugt";
            }
            System.out.println(msg);
        }
        catch (Exception ex) {
            System.err.println("Es ist ein Fehler aufgetreten, " + _out + " konnte nicht erstellt werden\n" + ex.toString());
            File f = new File(_out);
            if (f.exists()) {
                f.delete();
            }
            System.exit(1);
        }
    }
}

