/*
 * Decompiled with CFR 0.152.
 */
package de.memtext.widgets;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.Serializable;
import javax.swing.JEditorPane;
import javax.swing.RepaintManager;

public class PrintableEditorPane
extends JEditorPane
implements Printable,
Serializable {
    public PrintableEditorPane() {
    }

    public PrintableEditorPane(String type, String text) {
        super(type, text);
    }

    @Override
    public int print(Graphics g, PageFormat pf, int pageIndex) throws PrinterException {
        int totalNumPages;
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(Color.black);
        RepaintManager.currentManager(this).setDoubleBufferingEnabled(false);
        Dimension d = this.getSize();
        double panelWidth = d.width;
        double panelHeight = d.height;
        double pageWidth = pf.getImageableWidth();
        double pageHeight = pf.getImageableHeight();
        double scale = 1.0;
        if (panelWidth > pageWidth) {
            scale = pageWidth / panelWidth;
        }
        if (pageIndex >= (totalNumPages = (int)Math.ceil(scale * panelHeight / pageHeight))) {
            return 1;
        }
        g2.translate(pf.getImageableX(), pf.getImageableY());
        g2.translate(0.0, (double)(-pageIndex) * pageHeight);
        g2.scale(scale, scale);
        this.paint(g2);
        return 0;
    }
}

