/*
 * Decompiled with CFR 0.152.
 */
package de.werum.sis.xmlgen;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.util.Vector;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlUtil {
    public static Document parseString(String _xmlString) throws SAXParseException {
        return XmlUtil.parseString(_xmlString, false);
    }

    public static Document parseString(String _xmlString, boolean _validate) throws SAXParseException {
        try {
            InputSource in = new InputSource(new StringReader(_xmlString));
            return new Parser(_validate).parse(in);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static Document parseFile(String _xmlFilename) throws IOException, SAXParseException {
        InputSource in = new InputSource(new BufferedReader(new FileReader(_xmlFilename)));
        in.setSystemId(_xmlFilename);
        return new Parser(false).parse(in);
    }

    public static Document parseFile(File _xmlFile) throws IOException, SAXParseException {
        InputSource in = new InputSource(new BufferedReader(new FileReader(_xmlFile)));
        in.setSystemId(_xmlFile.getName());
        return new Parser(false).parse(in);
    }

    public static Document parse(Reader _xmlReader) throws IOException, SAXParseException {
        InputSource in = new InputSource(_xmlReader);
        return new Parser(false).parse(in);
    }

    public static Node getDtr(String _tag, Node _mom) {
        if (_mom == null) {
            return null;
        }
        for (Node dtr = _mom.getFirstChild(); dtr != null; dtr = dtr.getNextSibling()) {
            if (dtr.getNodeType() != 1 || !dtr.getNodeName().equals(_tag)) continue;
            return dtr;
        }
        return null;
    }

    public static Node getDtr(String _tag, int _nth, Node _mom) {
        if (_mom == null) {
            return null;
        }
        for (Node dtr = _mom.getFirstChild(); dtr != null; dtr = dtr.getNextSibling()) {
            if (!dtr.getNodeName().equals(_tag) || --_nth > 0) continue;
            return dtr;
        }
        return null;
    }

    public static Node getFeature(String _key, int _nth, Node _mom) {
        if (_mom == null) {
            return null;
        }
        for (Node dtr = _mom.getFirstChild(); dtr != null; dtr = dtr.getNextSibling()) {
            Attr attr;
            if (dtr.getNodeType() != 1 || (attr = ((Element)dtr).getAttributeNode("key")) == null || !attr.getValue().equals(_key) || --_nth > 0) continue;
            return dtr;
        }
        return null;
    }

    public static Node getFeature(String _key, Node _mom) {
        if (_mom == null) {
            return null;
        }
        for (Node dtr = _mom.getFirstChild(); dtr != null; dtr = dtr.getNextSibling()) {
            Attr attr;
            if (dtr.getNodeType() != 1 || (attr = ((Element)dtr).getAttributeNode("key")) == null || !attr.getValue().equals(_key)) continue;
            return dtr;
        }
        return null;
    }

    public static String getTextContent(Node _mom) {
        if (_mom == null || _mom.getFirstChild() == null) {
            return null;
        }
        if (_mom.getFirstChild().getNodeType() == 3 && _mom.getFirstChild().getNextSibling() == null) {
            return _mom.getFirstChild().getNodeValue();
        }
        StringBuffer buf = new StringBuffer();
        for (Node i = _mom.getFirstChild(); i != null; i = i.getNextSibling()) {
            if (i.getNodeType() != 3) continue;
            buf.append(i.getNodeValue());
        }
        return buf.toString();
    }

    public static void setTextContent(Node _mom, String _newContent) {
        if (_mom == null) {
            return;
        }
        if (_mom.getFirstChild() != null && _mom.getFirstChild().getNextSibling() == null && _mom.getFirstChild().getNodeType() == 3) {
            _mom.getFirstChild().setNodeValue(_newContent);
        } else {
            while (_mom.getFirstChild() != null) {
                _mom.removeChild(_mom.getFirstChild());
            }
            _mom.appendChild(_mom.getOwnerDocument().createTextNode(_newContent));
        }
    }

    public static String getAttr(String _key, Node _mom) {
        String attributeValue;
        if (_mom != null && _mom.getNodeType() == 1 && (attributeValue = ((Element)_mom).getAttribute(_key)).length() > 0) {
            return attributeValue;
        }
        return null;
    }

    public static void setAttr(String _key, String _value, Node _mom) {
        if (_mom != null && _mom.getNodeType() == 1) {
            if (_value != null) {
                ((Element)_mom).setAttribute(_key, _value);
            } else {
                ((Element)_mom).removeAttribute(_key);
            }
        }
    }

    public static void print(PrintWriter _out, Node _node) {
        new NodeWriter(_out).print(_node);
    }

    public static String toString(Node _node) {
        return new NodeBuffer().toString(_node);
    }

    protected static Attr[] sortAttributes(NamedNodeMap attrs) {
        int i;
        int len = attrs != null ? attrs.getLength() : 0;
        Attr[] array = new Attr[len];
        for (i = 0; i < len; ++i) {
            array[i] = (Attr)attrs.item(i);
        }
        for (i = 0; i < len - 1; ++i) {
            String name = array[i].getNodeName();
            int index = i;
            for (int j = i + 1; j < len; ++j) {
                String curName = array[j].getNodeName();
                if (curName.compareTo(name) >= 0) continue;
                name = curName;
                index = j;
            }
            if (index == i) continue;
            Attr temp = array[i];
            array[i] = array[index];
            array[index] = temp;
        }
        return array;
    }

    protected static String encode(String s) {
        StringBuffer str = new StringBuffer();
        int len = s != null ? s.length() : 0;
        block6: for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '<': {
                    str.append("&lt;");
                    continue block6;
                }
                case '>': {
                    str.append("&gt;");
                    continue block6;
                }
                case '&': {
                    str.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    str.append("&quot;");
                    continue block6;
                }
                default: {
                    str.append(ch);
                }
            }
        }
        return str.toString();
    }

    public static NodeList getElements(Node baseNode, String attName, String attValue) {
        final Vector<Node> elements = new Vector<Node>();
        for (Node n = baseNode.getFirstChild(); n != null; n = n.getNextSibling()) {
            Attr attr;
            if (n.getNodeType() != 1 || (attr = ((Element)n).getAttributeNode(attName)) == null || !attValue.equals(attr.getValue())) continue;
            elements.addElement(n);
        }
        return new NodeList(){

            public Node item(int index) {
                return (Node)elements.elementAt(index);
            }

            public int getLength() {
                return elements.size();
            }
        };
    }

    public static Node findNode(String locator, Node actualNode, boolean featureNodes) {
        if (locator == null) {
            return actualNode;
        }
        int pos = 0;
        Node n = actualNode;
        while (n != null && pos != -1) {
            String currentLocator = locator;
            pos = locator.indexOf(".");
            if (pos > -1) {
                currentLocator = locator.substring(0, pos);
                locator = locator.substring(pos + 1);
            }
            if (currentLocator.indexOf("#") != -1) {
                String tagName = currentLocator.substring(0, currentLocator.indexOf("#"));
                int i = 1;
                try {
                    i = Integer.parseInt(currentLocator.substring(currentLocator.indexOf("#") + 1));
                }
                catch (NumberFormatException nfe) {
                    return null;
                }
                n = featureNodes ? XmlUtil.getFeature(tagName, n) : XmlUtil.getDtr(tagName, n);
                while (i > 1 && n != null) {
                    if ((n = n.getNextSibling()).getNodeType() != 1 || (featureNodes ? !((Element)n).getAttributeNode("key").getValue().equals(tagName) : !n.getNodeName().equals(tagName))) continue;
                    --i;
                }
                continue;
            }
            if (featureNodes) {
                n = XmlUtil.getFeature(currentLocator, n);
            } else if (n == null) {
                System.out.println("n null.");
            }
            n = XmlUtil.getDtr(currentLocator, n);
        }
        return n;
    }

    public static class NodeBuffer {
        StringBuffer buf = new StringBuffer();

        public String toString(Node _node) {
            this.buf.setLength(0);
            this.toStringInternal(_node);
            return this.buf.toString();
        }

        private void toStringInternal(Node _node) {
            if (_node == null) {
                return;
            }
            switch (_node.getNodeType()) {
                case 9: {
                    this.buf.append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n");
                    for (Node dtr = _node.getFirstChild(); dtr != null; dtr = dtr.getNextSibling()) {
                        this.toStringInternal(dtr);
                    }
                    break;
                }
                case 1: {
                    this.buf.append('<');
                    this.buf.append(_node.getNodeName());
                    Attr[] attrs = XmlUtil.sortAttributes(((Element)_node).getAttributes());
                    for (int i = 0; i < attrs.length; ++i) {
                        Attr attr = attrs[i];
                        this.buf.append(' ');
                        this.buf.append(attr.getNodeName());
                        this.buf.append("=\"");
                        this.buf.append(XmlUtil.encode(attr.getNodeValue()));
                        this.buf.append('\"');
                    }
                    this.buf.append('>');
                    for (Node dtr = _node.getFirstChild(); dtr != null; dtr = dtr.getNextSibling()) {
                        this.toStringInternal(dtr);
                    }
                    this.buf.append("</");
                    this.buf.append(_node.getNodeName());
                    this.buf.append('>');
                    break;
                }
                case 5: {
                    this.buf.append('&');
                    this.buf.append(_node.getNodeName());
                    this.buf.append(';');
                    break;
                }
                case 4: {
                    this.buf.append("<![CDATA[");
                    this.buf.append(_node.getNodeValue());
                    this.buf.append("]]>");
                    break;
                }
                case 3: {
                    this.buf.append(XmlUtil.encode(_node.getNodeValue()));
                    break;
                }
                case 7: {
                    this.buf.append("<?");
                    this.buf.append(_node.getNodeName());
                    String data = _node.getNodeValue();
                    if (data != null && data.length() > 0) {
                        this.buf.append(' ');
                        this.buf.append(data);
                    }
                    this.buf.append("?>\n");
                }
            }
        }
    }

    public static class NodeWriter {
        PrintWriter out;

        public NodeWriter(PrintWriter _out) {
            this.out = _out;
        }

        public final void print(Node _node) {
            if (_node == null) {
                return;
            }
            switch (_node.getNodeType()) {
                case 9: {
                    this.out.println("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>");
                    for (Node dtr = _node.getFirstChild(); dtr != null; dtr = dtr.getNextSibling()) {
                        this.print(dtr);
                    }
                    break;
                }
                case 1: {
                    this.out.print('<');
                    this.out.print(_node.getNodeName());
                    Attr[] attrs = XmlUtil.sortAttributes(((Element)_node).getAttributes());
                    for (int i = 0; i < attrs.length; ++i) {
                        Attr attr = attrs[i];
                        this.out.print(' ');
                        this.out.print(attr.getNodeName());
                        this.out.print("=\"");
                        this.out.print(XmlUtil.encode(attr.getNodeValue()));
                        this.out.print('\"');
                    }
                    this.out.print('>');
                    for (Node dtr = _node.getFirstChild(); dtr != null; dtr = dtr.getNextSibling()) {
                        this.print(dtr);
                    }
                    this.out.print("</");
                    this.out.print(_node.getNodeName());
                    this.out.print('>');
                    break;
                }
                case 5: {
                    this.out.print('&');
                    this.out.print(_node.getNodeName());
                    this.out.print(';');
                    break;
                }
                case 4: {
                    this.out.print("<![CDATA[");
                    this.out.print(_node.getNodeValue());
                    this.out.print("]]>");
                    break;
                }
                case 3: {
                    this.out.print(XmlUtil.encode(_node.getNodeValue()));
                    break;
                }
                case 7: {
                    this.out.print("<?");
                    this.out.print(_node.getNodeName());
                    String data = _node.getNodeValue();
                    if (data != null && data.length() > 0) {
                        this.out.print(' ');
                        this.out.print(data);
                    }
                    this.out.println("?>");
                }
            }
        }
    }

    public static class Parser {
        DOMParser parser = new DOMParser();
        boolean validate = false;

        public Parser() {
            this(false);
        }

        public Parser(boolean _validate) {
            this.validate = _validate;
            try {
                this.parser.setFeature("http://xml.org/sax/features/validation", _validate);
                this.parser.setFeature("http://apache.org/xml/features/dom/include-ignorable-whitespace", false);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        public Document parse(InputSource _in) throws IOException, SAXParseException {
            try {
                try {
                    this.parser.reset();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                if (this.validate) {
                    ErrorHandler errorHandler = new ErrorHandler(){

                        public void error(SAXParseException exception) {
                        }

                        public void fatalError(SAXParseException exception) {
                            exception.printStackTrace();
                        }

                        public void warning(SAXParseException exception) {
                        }
                    };
                    this.parser.setErrorHandler(errorHandler);
                }
                this.parser.parse(_in);
                return this.parser.getDocument();
            }
            catch (SAXParseException ex) {
                throw ex;
            }
            catch (SAXException ex) {
                ex.printStackTrace();
                return null;
            }
        }
    }
}

