/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.pl;

import de.statspez.pleditor.generator.codegen.pl.DsbToRawNameConverter;
import de.statspez.pleditor.generator.codegen.pl.PrettyPrinter;
import de.statspez.pleditor.generator.meta.MetaArrayAccess;
import de.statspez.pleditor.generator.meta.MetaFactor;
import de.statspez.pleditor.generator.meta.MetaFieldAccess;
import de.statspez.pleditor.generator.meta.MetaIdentifier;
import de.statspez.pleditor.generator.meta.MetaStructureAccess;
import de.statspez.pleditor.generator.meta.MetaValueAccess;
import de.statspez.pleditor.generator.parser.Helper;
import java.util.Hashtable;
import java.util.Stack;

public class DsbToRawNameConverterImpl
implements DsbToRawNameConverter {
    @Override
    public String convert(String code, boolean forSetAccess, Hashtable dsbToRawMap) {
        String rueckgabe = new Converter(forSetAccess, dsbToRawMap).generate(Helper.metaStructureFor(code), code);
        return rueckgabe;
    }

    private class Converter
    extends PrettyPrinter {
        private boolean forSetAccess;
        private Hashtable dsbToRawMap;
        private boolean withinSetAccess;
        private Stack structureStack;

        public Converter(boolean forSetAccess, Hashtable dsbToRawMap) {
            this.forSetAccess = forSetAccess;
            this.dsbToRawMap = dsbToRawMap;
            this.withinSetAccess = false;
            this.structureStack = new Stack();
        }

        @Override
        protected void printAssignmentLeftValue(MetaValueAccess leftValue) {
            boolean prevWithinSetAccess = this.withinSetAccess;
            this.withinSetAccess = true;
            super.printAssignmentLeftValue(leftValue);
            this.withinSetAccess = prevWithinSetAccess;
        }

        @Override
        protected void printIndex(MetaFactor index) {
            boolean prevWithinSetAccess = this.withinSetAccess;
            this.withinSetAccess = false;
            super.printIndex(index);
            this.withinSetAccess = prevWithinSetAccess;
        }

        @Override
        protected void printStructureSelectedElement(MetaStructureAccess aStructureAccess) {
            StringBuffer structure = new StringBuffer();
            MetaValueAccess structureAccess = aStructureAccess.structureAccess();
            while (structureAccess instanceof MetaStructureAccess) {
                MetaStructureAccess tmpStructureAccess;
                if (structure.length() > 0) {
                    structure.insert(0, '.');
                }
                if ((tmpStructureAccess = (MetaStructureAccess)structureAccess).selectedElement() instanceof MetaFieldAccess) {
                    structure.insert(0, ((MetaFieldAccess)tmpStructureAccess.selectedElement()).accessedField().value());
                } else {
                    structure.insert(0, ((MetaArrayAccess)tmpStructureAccess.selectedElement()).accessedArray().value());
                }
                structureAccess = tmpStructureAccess.structureAccess();
            }
            if (structure.length() > 0) {
                structure.insert(0, '.');
            }
            if (structureAccess instanceof MetaFieldAccess) {
                structure.insert(0, ((MetaFieldAccess)structureAccess).accessedField().value());
            } else {
                structure.insert(0, ((MetaArrayAccess)structureAccess).accessedArray().value());
            }
            this.structureStack.push(structure.toString());
            super.printStructureSelectedElement(aStructureAccess);
            this.structureStack.pop();
        }

        @Override
        public void visitIdentifier(MetaIdentifier anIdentifier) {
            String dsbName;
            String rawName;
            String identifier = anIdentifier.value();
            if ((this.forSetAccess && this.withinSetAccess || !this.forSetAccess && !this.withinSetAccess) && (rawName = (String)this.dsbToRawMap.get(dsbName = !this.structureStack.isEmpty() ? String.valueOf((String)this.structureStack.peek()) + "." + identifier : identifier)) != null) {
                identifier = rawName;
            }
            this.print(identifier);
        }
    }
}

