/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.java;

import de.statspez.pleditor.generator.codegen.java.CodegenContext;
import de.statspez.pleditor.generator.codegen.java.PlausiElementCodeGenerator;
import de.statspez.pleditor.generator.codegen.java.Settings;
import de.statspez.pleditor.generator.codegen.java.StringHelper;
import de.statspez.pleditor.generator.meta.MetaCustomTBFeld;
import de.statspez.pleditor.generator.meta.MetaCustomThemenbereich;
import de.statspez.pleditor.generator.meta.generated.MetaMerkmal;
import de.statspez.pleditor.generator.meta.generated.MetaTBFeld;
import de.statspez.pleditor.generator.meta.generated.MetaThemenbereich;
import java.util.Iterator;

public class MaterialConstructorGenerator
extends PlausiElementCodeGenerator {
    private static final String PLAUSI_VAR = "plausi";
    private static final String FIELD_DESCRIPTOR_VAR = "feldDeskriptor";
    private static final String IS_REFERENCE_VAR = "isReference";
    private MetaThemenbereich topic;
    private boolean withinSegment;

    public synchronized void generate(CodegenContext context, MetaThemenbereich aTopic, String topicClassName, boolean superIsNotBaseClass, boolean isWithinSegment, Iterator fields) {
        this.topic = aTopic;
        this.withinSegment = isWithinSegment;
        if (this.withinSegment) {
            this.defineMethod("public", "", topicClassName, String.valueOf(context.getPlausiClassName()) + " " + PLAUSI_VAR + ", " + "FeldDeskriptorInterface" + " parent, " + "FeldDeskriptor" + " " + FIELD_DESCRIPTOR_VAR + ", " + "int[] indices, " + "String materialName, " + "String materialDSB, " + "boolean " + IS_REFERENCE_VAR);
        } else {
            this.defineMethod("public", "", topicClassName, "FeldDeskriptorInterface parent, FeldDeskriptor feldDeskriptor, int[] indices, String materialName, String materialDSB, boolean isReference");
        }
        this.indentNewLine();
        this.out.print("super(");
        if (superIsNotBaseClass) {
            if (this.withinSegment) {
                this.out.print(PLAUSI_VAR);
            } else {
                this.out.print(context.getPlausiClassName());
                this.out.print(".this");
            }
            this.out.print(", ");
        }
        this.out.print("parent, ");
        this.out.print(FIELD_DESCRIPTOR_VAR);
        this.out.print(", indices, materialName, materialDSB");
        if (superIsNotBaseClass) {
            this.out.print(", ");
            this.out.print(IS_REFERENCE_VAR);
        }
        this.out.print(");");
        this.indentNewLine();
        this.visitElements(fields);
        this.endMethodDefinition();
    }

    @Override
    public void visitTBFeld(MetaTBFeld anObject) {
        MetaCustomTBFeld aFeld = (MetaCustomTBFeld)anObject;
        boolean isRootTopic = ((MetaCustomThemenbereich)this.topic).countReferenzierendeFelder() == 0;
        this.indentNewLine();
        this.out.print("this.");
        this.out.print(StringHelper.getEscapedName(aFeld.getName()));
        this.out.print(" = new ");
        if (aFeld.getKlasse() instanceof MetaMerkmal) {
            int rtType = Settings.rtTypeForILType(((MetaMerkmal)aFeld.getKlasse()).getTyp());
            if (rtType == -1) {
                this.error(aFeld, "Ungueltiger Typ fuer das Merkmal des Felds " + aFeld.getName() + ".");
            }
            String maske = ((MetaMerkmal)aFeld.getKlasse()).getMaske();
            if (aFeld.getListe()) {
                this.out.print("MaterialArray(");
                this.createArrayDimensions(aFeld.dimensions());
                this.out.print(", new ");
            }
            this.out.print("MaterialVariable(");
            if (isRootTopic) {
                this.out.print("null");
            } else {
                this.out.print(IS_REFERENCE_VAR);
                this.out.print(" ? this : null");
            }
            this.out.print(", new FeldDeskriptor(");
            this.out.print(FIELD_DESCRIPTOR_VAR);
            this.out.print(".");
            this.out.print("getMappings");
            this.out.print("(), \"");
            this.out.print(aFeld.getName());
            this.out.print("\", ");
            if (isRootTopic) {
                this.out.print("null");
            } else {
                this.out.print(FIELD_DESCRIPTOR_VAR);
            }
            this.out.print(", ");
            this.out.print(Integer.toString(rtType));
            if (maske != null && maske.length() > 0) {
                this.out.print(", \"");
                this.out.print(StringHelper.getEscapedStringValue(maske));
                this.out.print("\"");
            }
            this.out.print("), null)");
            if (aFeld.getListe()) {
                this.out.print(")");
            }
        } else {
            MetaThemenbereich feldKlasse = (MetaThemenbereich)aFeld.getKlasse();
            if (aFeld.getListe()) {
                this.out.print("TopicMaterialArray(");
                this.createArrayDimensions(aFeld.dimensions());
                this.out.print(", new ");
            }
            if (this.withinSegment) {
                this.out.print(PLAUSI_VAR);
                this.out.print(".");
            }
            this.out.print(this.getTbClass(feldKlasse));
            this.out.print("(");
            if (isRootTopic) {
                this.out.print("null");
            } else {
                this.out.print(IS_REFERENCE_VAR);
                this.out.print(" ? this : null");
            }
            this.out.print(", new FeldDeskriptor(");
            this.out.print(FIELD_DESCRIPTOR_VAR);
            this.out.print(".");
            this.out.print("getMappings");
            this.out.print("(), \"");
            this.out.print(aFeld.getName());
            this.out.print("\", ");
            if (isRootTopic) {
                this.out.print("null");
            } else {
                this.out.print(FIELD_DESCRIPTOR_VAR);
            }
            this.out.print(", RuntimeSettings.RT_TYPE_CUSTOM), null");
            this.out.print(", materialName, materialDSB, true)");
            if (aFeld.getListe()) {
                this.out.print(")");
            }
        }
        this.out.print(";");
    }

    @Override
    protected String getTbClass(MetaThemenbereich aTb) {
        return "Material" + super.getTbClass(aTb);
    }
}

