/*
 * Decompiled with CFR 0.152.
 */
package com.bitmechanic.maxq;

import java.io.DataInputStream;
import java.io.InputStream;
import java.util.StringTokenizer;

public class HttpRequestHeader {
    public String method = new String();
    public String url = new String();
    public String version = new String();
    public String userAgent = new String();
    public String referer = new String();
    public String ifModifiedSince = new String();
    public String accept = new String();
    public String authorization = new String();
    public String contentType = new String();
    public int contentLength = -1;
    public int oldContentLength = -1;
    public String unrecognized = new String();
    public boolean pragmaNoCache = false;
    static String CR = "\r\n";

    public boolean parse(InputStream In) {
        StringTokenizer tz;
        DataInputStream lines;
        String CR = "\r\n";
        try {
            lines = new DataInputStream(In);
            tz = new StringTokenizer(lines.readLine());
        }
        catch (Exception e) {
            return false;
        }
        this.method = this.getToken(tz).toUpperCase();
        this.url = this.getToken(tz);
        this.version = this.getToken(tz);
        while (true) {
            try {
                tz = new StringTokenizer(lines.readLine());
            }
            catch (Exception e) {
                return false;
            }
            String Token = this.getToken(tz);
            if (0 == Token.length()) break;
            if (Token.equalsIgnoreCase("USER-AGENT:")) {
                this.userAgent = this.getRemainder(tz);
                continue;
            }
            if (Token.equalsIgnoreCase("ACCEPT:")) {
                this.accept = this.accept + " " + this.getRemainder(tz);
                continue;
            }
            if (Token.equalsIgnoreCase("REFERER:")) {
                this.referer = this.getRemainder(tz);
                continue;
            }
            if (Token.equalsIgnoreCase("PRAGMA:")) {
                Token = this.getToken(tz);
                if (Token.equalsIgnoreCase("NO-CACHE")) {
                    this.pragmaNoCache = true;
                    continue;
                }
                this.unrecognized = this.unrecognized + "Pragma:" + Token + " " + this.getRemainder(tz) + "\n";
                continue;
            }
            if (Token.equalsIgnoreCase("AUTHORIZATION:")) {
                this.authorization = this.getRemainder(tz);
                continue;
            }
            if (Token.equalsIgnoreCase("IF-MODIFIED-SINCE:")) {
                String str = this.getRemainder(tz);
                int index = str.indexOf(";");
                if (index == -1) {
                    this.ifModifiedSince = str;
                    continue;
                }
                this.ifModifiedSince = str.substring(0, index);
                index = str.indexOf("=");
                if (index == -1) continue;
                str = str.substring(index + 1);
                this.oldContentLength = Integer.parseInt(str);
                continue;
            }
            if (Token.equalsIgnoreCase("CONTENT-LENGTH:")) {
                Token = this.getToken(tz);
                this.contentLength = Integer.parseInt(Token);
                continue;
            }
            if (Token.equalsIgnoreCase("CONTENT-TYPE:")) {
                this.contentType = this.getRemainder(tz);
                continue;
            }
            this.unrecognized = this.unrecognized + Token + " " + this.getRemainder(tz) + CR;
        }
        return true;
    }

    public String toString(boolean sendUnknowen) {
        if (0 == this.method.length()) {
            this.method = "GET";
        }
        String Request = this.method + " " + this.url + " HTTP/1.0" + CR;
        if (0 < this.userAgent.length()) {
            Request = Request + "User-Agent:" + this.userAgent + CR;
        }
        if (0 < this.referer.length()) {
            Request = Request + "Referer:" + this.referer + CR;
        }
        if (this.pragmaNoCache) {
            Request = Request + "Pragma: no-cache" + CR;
        }
        if (0 < this.ifModifiedSince.length()) {
            Request = Request + "If-Modified-Since: " + this.ifModifiedSince + CR;
        }
        Request = 0 < this.accept.length() ? Request + "Accept: " + this.accept + CR : Request + "Accept: */* \r\n";
        if (0 < this.contentType.length()) {
            Request = Request + "Content-Type: " + this.contentType + CR;
        }
        if (0 < this.contentLength) {
            Request = Request + "Content-Length: " + this.contentLength + CR;
        }
        if (0 != this.authorization.length()) {
            Request = Request + "Authorization: " + this.authorization + CR;
        }
        if (sendUnknowen && 0 != this.unrecognized.length()) {
            Request = Request + this.unrecognized;
        }
        Request = Request + CR;
        return Request;
    }

    public String toString() {
        return this.toString(true);
    }

    String getToken(StringTokenizer tk) {
        String str = "";
        if (tk.hasMoreTokens()) {
            str = tk.nextToken();
        }
        return str;
    }

    String getRemainder(StringTokenizer tk) {
        String str = "";
        if (tk.hasMoreTokens()) {
            str = tk.nextToken();
        }
        while (tk.hasMoreTokens()) {
            str = str + " " + tk.nextToken();
        }
        return str;
    }
}

