/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.contrib.ssl;

import com.sun.net.ssl.TrustManager;
import com.sun.net.ssl.TrustManagerFactory;
import com.sun.net.ssl.X509TrustManager;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EasyX509TrustManager
implements X509TrustManager {
    private X509TrustManager standardTrustManager = null;
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$commons$httpclient$contrib$ssl$EasyX509TrustManager == null ? (class$org$apache$commons$httpclient$contrib$ssl$EasyX509TrustManager = EasyX509TrustManager.class$("org.apache.commons.httpclient.contrib.ssl.EasyX509TrustManager")) : class$org$apache$commons$httpclient$contrib$ssl$EasyX509TrustManager));
    static /* synthetic */ Class class$org$apache$commons$httpclient$contrib$ssl$EasyX509TrustManager;

    public EasyX509TrustManager(KeyStore keystore) throws NoSuchAlgorithmException, KeyStoreException {
        TrustManagerFactory factory = TrustManagerFactory.getInstance((String)"SunX509");
        factory.init(keystore);
        TrustManager[] trustmanagers = factory.getTrustManagers();
        if (trustmanagers.length == 0) {
            throw new NoSuchAlgorithmException("SunX509 trust manager not supported");
        }
        this.standardTrustManager = (X509TrustManager)trustmanagers[0];
    }

    public boolean isClientTrusted(X509Certificate[] certificates) {
        return this.standardTrustManager.isClientTrusted(certificates);
    }

    public boolean isServerTrusted(X509Certificate[] certificates) {
        if (certificates != null && LOG.isDebugEnabled()) {
            LOG.debug((Object)"Server certificate chain:");
            for (int i = 0; i < certificates.length; ++i) {
                LOG.debug((Object)("X509Certificate[" + i + "]=" + certificates[i]));
            }
        }
        if (certificates != null && certificates.length == 1) {
            X509Certificate certificate = certificates[0];
            try {
                certificate.checkValidity();
            }
            catch (CertificateException e) {
                LOG.error((Object)e.toString());
                return false;
            }
            return true;
        }
        return this.standardTrustManager.isServerTrusted(certificates);
    }

    public X509Certificate[] getAcceptedIssuers() {
        return this.standardTrustManager.getAcceptedIssuers();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

