/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.database;

import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Properties;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DriverManagerConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.PoolingDriver;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.i18n.BaseMessages;

public class ConnectionPoolUtil {
    private static Class<?> PKG = Database.class;
    private static final ReentrantLock lock = new ReentrantLock();
    private static PoolingDriver pd = ConnectionPoolUtil.initPoolingDriver();
    public static final int defaultInitialNrOfConnections = 5;
    public static final int defaultMaximumNrOfConnections = 10;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PoolingDriver initPoolingDriver() {
        Class<DriverManager> clazz = DriverManager.class;
        synchronized (DriverManager.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return new PoolingDriver();
        }
    }

    private static boolean isPoolRegistered(DatabaseMeta dbMeta, String partitionId) throws KettleDatabaseException {
        try {
            String name = ConnectionPoolUtil.buildPoolName(dbMeta, partitionId);
            return Const.indexOfString(name, pd.getPoolNames()) >= 0;
        }
        catch (Exception e) {
            throw new KettleDatabaseException(BaseMessages.getString(PKG, "Database.UnableToCheckIfConnectionPoolExists.Exception", new String[0]), e);
        }
    }

    private static void createPool(LogChannelInterface log, DatabaseMeta databaseMeta, String partitionId, int initialSize, int maximumSize) throws KettleDatabaseException {
        String password;
        String userName;
        String url;
        log.logBasic(BaseMessages.getString(PKG, "Database.CreatingConnectionPool", databaseMeta.getName()));
        GenericObjectPool gpool = new GenericObjectPool();
        gpool.setMaxIdle(-1);
        gpool.setWhenExhaustedAction((byte)2);
        gpool.setMaxActive(maximumSize);
        String clazz = databaseMeta.getDriverClass();
        try {
            Class.forName(clazz).newInstance();
        }
        catch (Exception e) {
            throw new KettleDatabaseException(BaseMessages.getString(PKG, "Database.UnableToLoadConnectionPoolDriver.Exception", databaseMeta.getName(), clazz), e);
        }
        try {
            url = databaseMeta.environmentSubstitute(databaseMeta.getURL(partitionId));
            userName = databaseMeta.environmentSubstitute(databaseMeta.getUsername());
            password = databaseMeta.environmentSubstitute(databaseMeta.getPassword());
        }
        catch (RuntimeException e) {
            url = databaseMeta.getURL(partitionId);
            userName = databaseMeta.getUsername();
            password = databaseMeta.getPassword();
        }
        password = Encr.decryptPasswordOptionallyEncrypted(password);
        Properties originalProperties = databaseMeta.getConnectionPoolingProperties();
        originalProperties.setProperty("user", Const.NVL(userName, ""));
        originalProperties.setProperty("password", Const.NVL(password, ""));
        Properties properties = new Properties();
        for (String string : originalProperties.keySet()) {
            String value = originalProperties.getProperty(string);
            properties.put(string, databaseMeta.environmentSubstitute(value));
        }
        DriverManagerConnectionFactory driverManagerConnectionFactory = new DriverManagerConnectionFactory(url, properties);
        new PoolableConnectionFactory((ConnectionFactory)driverManagerConnectionFactory, (ObjectPool)gpool, null, null, false, false);
        for (int i = 0; i < initialSize; ++i) {
            try {
                gpool.addObject();
                continue;
            }
            catch (Exception e) {
                throw new KettleDatabaseException(BaseMessages.getString(PKG, "Database.UnableToPreLoadConnectionToConnectionPool.Exception", new String[0]), e);
            }
        }
        pd.registerPool(ConnectionPoolUtil.buildPoolName(databaseMeta, partitionId), (ObjectPool)gpool);
        log.logBasic(BaseMessages.getString(PKG, "Database.CreatedConnectionPool", databaseMeta.getName()));
    }

    public static Connection getConnection(LogChannelInterface log, DatabaseMeta dbMeta, String partitionId) throws Exception {
        return ConnectionPoolUtil.getConnection(log, dbMeta, partitionId, dbMeta.getInitialPoolSize(), dbMeta.getMaximumPoolSize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Connection getConnection(LogChannelInterface log, DatabaseMeta dbMeta, String partitionId, int initialSize, int maximumSize) throws Exception {
        lock.lock();
        try {
            if (!ConnectionPoolUtil.isPoolRegistered(dbMeta, partitionId)) {
                ConnectionPoolUtil.createPool(log, dbMeta, partitionId, initialSize, maximumSize);
            }
        }
        finally {
            lock.unlock();
        }
        return DriverManager.getConnection("jdbc:apache:commons:dbcp:" + ConnectionPoolUtil.buildPoolName(dbMeta, partitionId));
    }

    protected static String buildPoolName(DatabaseMeta dbMeta, String partitionId) {
        return dbMeta.getName() + Const.NVL(dbMeta.getDatabaseName(), "") + Const.NVL(dbMeta.getHostname(), "") + Const.NVL(dbMeta.getDatabasePortNumberString(), "") + Const.NVL(partitionId, "");
    }
}

