/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.inspector.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Vector;
import org.xml.sax.Attributes;

public class XPathEntry {
    private static HashSet multiElements = new HashSet();
    private static HashMap identityAttributes = new HashMap();
    private String name;
    private String occurenceName;
    private Vector attributes = new Vector();
    private HashMap attributeNameValueMap = new HashMap();
    private int occurrence;

    public XPathEntry(String name, Attributes attributes) {
        this.name = name;
        this.occurrence = 0;
        String nameAttribute = (String)identityAttributes.get(this.name);
        if (nameAttribute != null) {
            for (int idx = 0; idx < attributes.getLength(); ++idx) {
                if (!attributes.getQName(idx).equals(nameAttribute)) continue;
                this.addAttribute(nameAttribute, attributes.getValue(idx));
                break;
            }
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.name);
        if (this.attributes.size() > 0) {
            boolean first = true;
            buffer.append("[");
            for (int idx = 0; idx < this.attributes.size(); ++idx) {
                if (!first) {
                    buffer.append(" and ");
                } else {
                    first = false;
                }
                buffer.append((String)this.attributes.get(idx));
            }
            buffer.append("]");
        }
        this.occurenceName = buffer.toString();
    }

    public String getName() {
        return this.name;
    }

    public boolean hasAttributes() {
        return this.attributes.size() > 0;
    }

    public String getAttribute(String name) {
        return (String)this.attributeNameValueMap.get(name);
    }

    public void addAttribute(String name, String value) {
        this.attributes.add("@" + name + "=\"" + value + "\"");
        this.attributeNameValueMap.put(name, value);
    }

    public void setOccurrence(int occurrence) {
        if (occurrence < 1) {
            throw new IllegalArgumentException("occurrence muss >= 1 sein.");
        }
        this.occurrence = occurrence;
    }

    public int getOccurrence() {
        if (this.occurrence == 0) {
            throw new IllegalStateException("Vorkommen wurde noch nicht gesetzt.");
        }
        return this.occurrence;
    }

    public String getOccurenceName() {
        return this.occurenceName;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.occurenceName);
        int occurrence = this.getOccurrence();
        if (occurrence > 1 || multiElements.contains(this.name)) {
            buffer.append("[" + occurrence + "]");
        }
        return buffer.toString();
    }

    static {
        multiElements.add("nachricht");
        multiElements.add("segment");
        multiElements.add("zeile");
        multiElements.add("satz");
        multiElements.add("mmgr");
        multiElements.add("dokumentinstanz");
        multiElements.add("ressourceID");
        identityAttributes.put("mm", "name");
        identityAttributes.put("hmm", "name");
        identityAttributes.put("mmgr", "name");
    }
}

