/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.map.editor;

import de.destatis.core.connect.Client;
import de.destatis.core.connect.ClientStatusEvent;
import de.destatis.core.connect.ClientStatusListener;
import de.destatis.core.connect.ServerAddress;
import de.destatis.core.connect.survey.ErhebungsId;
import de.destatis.core.map.Binding;
import de.destatis.core.map.BindingGroup;
import de.destatis.core.map.Mapping;
import de.destatis.core.map.MappingCheckResult;
import de.destatis.core.map.MappingProblem;
import de.destatis.core.map.MappingsParser;
import de.destatis.core.map.MetaMappingMerge;
import de.destatis.core.map.SDFMappingMerge;
import de.destatis.core.map.editor.AboutDialog;
import de.destatis.core.map.editor.BindingFeldCellRenderer;
import de.destatis.core.map.editor.EditorProperties;
import de.destatis.core.map.editor.IconFactory;
import de.destatis.core.map.editor.Icons;
import de.destatis.core.map.editor.MappingEditorTool;
import de.destatis.core.map.editor.MetaMappingEditorTool;
import de.destatis.core.map.editor.ProblemTableModel;
import de.destatis.core.map.editor.SDFMappingEditorTool;
import de.destatis.core.map.editor.UndoSupport;
import de.destatis.core.map.editor.task.ProgressDialog;
import de.destatis.core.map.editor.task.ProgressMonitor;
import de.destatis.core.map.editor.task.Task;
import de.destatis.core.map.editor.util.SelectionFocusListener;
import de.destatis.core.map.editor.util.SwingUtil;
import de.destatis.core.map.editor.welcome.WelcomePageTool;
import de.destatis.core.map.editor.wizard.CreateMappingWizard;
import de.destatis.core.map.editor.wizard.CreateMetaMappingWizard;
import de.destatis.core.map.editor.wizard.WizardDialog;
import de.destatis.core.map.editor.wizard.csvtemplate.CsvTemplateWizard;
import de.destatis.core.map.model.MetaMapping;
import de.destatis.core.resource.DatmlSdfSource;
import de.destatis.core.resource.NoResourceFoundException;
import de.destatis.core.resource.ResourceConfig;
import de.destatis.core.resource.ResourceException;
import de.destatis.core.resource.SDFMetaResource;
import de.destatis.core.resource.util.CommonResourceId;
import de.destatis.core.resource.util.ResourceManager;
import de.statspez.sdf.generator.meta.SDFElement;
import de.statspez.sdf.generator.meta.generated.MetaErhebungsbeschreibung;
import de.statspez.sdf.generator.meta.generated.MetaSDFMetabeschreibung;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Locale;
import java.util.Properties;
import java.util.Stack;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableColumn;
import javax.swing.undo.UndoableEdit;
import javax.swing.undo.UndoableEditSupport;

public class MappingEditor
implements UndoSupport {
    public static final String APPLICATION_NAME = new String("CORE.mapper");
    public static final String VERSION = new String("1.0.1");
    public static final String BUILD_DATE = new String("06.12.2013");
    public static final String VENDOR = new String("Statistisches Bundesamt");
    private static final String PROP_LAST_MAPPING_FILE = new String("editor.lastMappingFile");
    private WelcomePageTool welcomePage;
    private MappingEditorTool mappingTool;
    private File mappingToolFile;
    private JPanel mappingToolPanel;
    private JFrame frame;
    private Action saveAction;
    private Action saveAsAction;
    private Action undoAction;
    private Action redoAction;
    private Action checkAction;
    private Action tablePreviewAction;
    private Action createCsvTemplateAction;
    private Action closeEditorAction;
    private JSplitPane mainSplitPane;
    private JLabel statusBar;
    private JFileChooser fileChooser;
    private JLabel errorTitleBar;
    private JTable table;
    private ProblemTableModel problemTableModel;
    private JLabel tablePreview;
    private ResourceManager resourceManager;
    private Properties clientProperties;
    private static ServerAddress coreServerAddress;
    private EditorProperties editorProperties;
    private UndoableEditSupport undoableEditSupport;
    private Stack undoStack;
    private Stack redoStack;
    private File lastMappingFile;
    private Integer frameWidth = null;
    private Integer frameHeight = null;
    private Integer frameX = null;
    private Integer frameY = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        System.out.println("os:                " + System.getProperty("os.name") + " (" + System.getProperty("os.version") + ") / " + System.getProperty("os.arch"));
        System.out.println("java.version:      " + System.getProperty("java.version") + " (" + System.getProperty("java.vendor") + ")");
        System.out.println("java.home:         " + System.getProperty("java.home"));
        System.out.println("java.library.path: " + System.getProperty("java.library.path"));
        System.out.println("java.class.path:   " + System.getProperty("java.class.path"));
        System.out.println("file.encoding:     " + System.getProperty("file.encoding"));
        System.out.println("Locale:            " + Locale.getDefault());
        System.out.println("Programmversion:   " + VERSION + " (" + BUILD_DATE + ")");
        String configFile = null;
        String username = null;
        String password = null;
        if (args != null && args.length > 0) {
            if (args.length == 1) {
                if ("-version".equalsIgnoreCase(args[0])) {
                    System.out.println(APPLICATION_NAME + " Version " + VERSION + " " + BUILD_DATE + " (" + VENDOR + ")");
                    System.exit(0);
                }
            } else {
                for (int i = 0; i < args.length - 1; ++i) {
                    if ("-conffile".equalsIgnoreCase(args[i])) {
                        configFile = args[i + 1];
                        ++i;
                        continue;
                    }
                    if ("-username".equalsIgnoreCase(args[i])) {
                        username = args[i + 1];
                        ++i;
                        continue;
                    }
                    if (!"-password".equalsIgnoreCase(args[i])) continue;
                    password = args[i + 1];
                    ++i;
                }
            }
        }
        ResourceConfig resourceConfig = new ResourceConfig();
        Properties properties = new Properties();
        if (configFile != null) {
            FileInputStream in = null;
            try {
                in = new FileInputStream(configFile);
                properties.load(new BufferedInputStream(in));
                Boolean surveyAutoUpdate = null;
                String property = properties.getProperty("resourceconfig.survey.autoupdate");
                if (property != null) {
                    surveyAutoUpdate = "1".equals(property = property.trim()) || "wahr".equalsIgnoreCase(property) || "true".equalsIgnoreCase(property) ? Boolean.TRUE : Boolean.FALSE;
                }
                if (surveyAutoUpdate != null) {
                    resourceConfig.setSurveyAutoUpdate(surveyAutoUpdate);
                }
                if ((property = properties.getProperty("resourceconfig.survey.dir")) != null) {
                    property = property.trim();
                    resourceConfig.setSurveyDir(property);
                }
                Boolean sdfMetaAutoUpdate = null;
                property = properties.getProperty("resourceconfig.sdfmeta.autoupdate");
                if (property != null) {
                    sdfMetaAutoUpdate = "1".equals(property = property.trim()) || "true".equalsIgnoreCase(property) ? Boolean.TRUE : Boolean.FALSE;
                }
                if (sdfMetaAutoUpdate != null) {
                    resourceConfig.setSdfMetaAutoUpdate(sdfMetaAutoUpdate);
                }
                if ((property = properties.getProperty("resourceconfig.sdfmeta.dir")) != null) {
                    property = property.trim();
                    resourceConfig.setSdfMetaDir(property);
                }
                if (username == null && (property = properties.getProperty("client.username")) != null && property.trim().length() > 0) {
                    username = property;
                }
                if (password == null && (property = properties.getProperty("client.password")) != null && property.trim().length() > 0) {
                    password = property;
                }
            }
            catch (IOException e) {
                System.err.println(e.getMessage());
                System.exit(1);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
        if (username != null && password != null) {
            Client client = new Client(username, password.toCharArray(), properties);
            resourceConfig.setClient(client);
        } else if (resourceConfig.isSurveyAutoUpdate() || resourceConfig.isSdfMetaAutoUpdate()) {
            throw new IllegalStateException("Bei aktiviertem Autoupdate muss die Kennung und das Passwort zum Herunterladen der Ressourcen vom CORE.server angegeben werden.");
        }
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        MappingEditor editor = new MappingEditor(resourceConfig, properties);
        editor.open();
    }

    public MappingEditor(ResourceConfig resourceConfig, Properties clientProperties) {
        ServerAddress serverAddress;
        this.resourceManager = new ResourceManager(resourceConfig, 0, 10);
        this.clientProperties = clientProperties;
        Client client = this.clientProperties != null ? new Client("whatever", "whatever".toCharArray(), this.clientProperties) : new Client("whatever", "whatever".toCharArray());
        coreServerAddress = serverAddress = client.getCoreServerAddress();
        this.undoableEditSupport = new UndoableEditSupport();
        this.undoableEditSupport.addUndoableEditListener(new UndoableEditListener(){

            @Override
            public void undoableEditHappened(UndoableEditEvent e) {
                MappingEditor.this.undoStack.push(e.getEdit());
                MappingEditor.this.redoStack.clear();
                MappingEditor.this.undoAction.setEnabled(!MappingEditor.this.undoStack.isEmpty());
                MappingEditor.this.redoAction.setEnabled(false);
            }
        });
        this.undoStack = new Stack();
        this.redoStack = new Stack();
        this.editorProperties = EditorProperties.getInstance();
        this.initUI();
    }

    public static ServerAddress getCoreServerServerAddress() {
        ServerAddress result = coreServerAddress;
        if (result == null) {
            result = ServerAddress.CORE1;
        }
        return result;
    }

    @Override
    public UndoableEditSupport getUndoableEditSupport() {
        return this.undoableEditSupport;
    }

    @Override
    public void clearUndoStacks() {
        this.undoStack.clear();
        this.redoStack.clear();
        this.undoAction.setEnabled(false);
        this.redoAction.setEnabled(false);
    }

    public void open() {
        this.frame.setVisible(true);
    }

    private String getFramewStateAsString() {
        switch (this.frame.getExtendedState()) {
            case 1: {
                return "iconified";
            }
            case 6: {
                return "maximized-both";
            }
            case 2: {
                return "maximized-horiz";
            }
            case 4: {
                return "maximized-vert";
            }
        }
        return "normal";
    }

    private int getFrameStateFromString(String string) {
        int state = 0;
        if (string != null) {
            if ("iconified".equalsIgnoreCase(string)) {
                state = 1;
            } else if ("maximized-both".equalsIgnoreCase(string)) {
                state = 6;
            } else if ("maximized-horiz".equalsIgnoreCase(string)) {
                state = 2;
            } else if ("maximized-vert".equalsIgnoreCase(string)) {
                state = 4;
            }
        }
        return state;
    }

    public void close() {
        if (!this.saveUnsavedChanges()) {
            return;
        }
        String filePath = this.lastMappingFile != null ? this.lastMappingFile.getAbsolutePath().replace('\\', '/') : "";
        this.editorProperties.setProperty(PROP_LAST_MAPPING_FILE, filePath);
        if (this.frameWidth != null) {
            this.editorProperties.setProperty("frame.width", String.valueOf(this.frameWidth));
        }
        if (this.frameHeight != null) {
            this.editorProperties.setProperty("frame.height", String.valueOf(this.frameHeight));
        }
        if (this.frameX != null) {
            this.editorProperties.setProperty("frame.left", String.valueOf(this.frameX));
        }
        if (this.frameY != null) {
            this.editorProperties.setProperty("frame.top", String.valueOf(this.frameY));
        }
        this.editorProperties.setProperty("frame.state", this.getFramewStateAsString());
        this.editorProperties.setProperty("frame.divider.top", String.valueOf(this.mainSplitPane.getDividerLocation()));
        if (this.mappingTool != null) {
            this.mappingTool.saveProperties();
        }
        if (this.table.isValid()) {
            this.editorProperties.setProperty("problemview.column1.width", String.valueOf(this.table.getColumnModel().getColumn(1).getWidth()));
            this.editorProperties.setProperty("problemview.column2.width", String.valueOf(this.table.getColumnModel().getColumn(2).getWidth()));
        }
        this.editorProperties.store();
        this.frame.setVisible(false);
        System.exit(0);
    }

    public void create() {
        if (!this.saveUnsavedChanges()) {
            return;
        }
        CreateMappingWizard wizard = new CreateMappingWizard(this.resourceManager, this.clientProperties);
        WizardDialog dialog = new WizardDialog((Frame)this.frame, wizard);
        dialog.setVisible(true);
        if (!wizard.isCanceled()) {
            this.editMapping(wizard.getMapping(), wizard.getSurveyDefinition(), null, true);
        }
    }

    public void createMetaDatenMapping() {
        if (!this.saveUnsavedChanges()) {
            return;
        }
        CreateMetaMappingWizard wizard = new CreateMetaMappingWizard(this.resourceManager, this.clientProperties);
        WizardDialog dialog = new WizardDialog((Frame)this.frame, wizard);
        dialog.setVisible(true);
        if (!wizard.isCanceled()) {
            MetaMapping metaMapping = wizard.getMetaMapping();
            MetaSDFMetabeschreibung sdfMetaBeschreibung = wizard.getSDFMetabeschreibung();
            this.editMetaMapping(metaMapping, sdfMetaBeschreibung, null, true);
        }
    }

    public void createCsvTemplate() {
        CsvTemplateWizard wizard = null;
        if (this.mappingTool instanceof MetaMappingEditorTool) {
            wizard = new CsvTemplateWizard(((MetaMappingEditorTool)this.mappingTool).getMapping());
        } else if (this.mappingTool instanceof SDFMappingEditorTool) {
            wizard = new CsvTemplateWizard(((SDFMappingEditorTool)this.mappingTool).getMapping(), ((SDFMappingEditorTool)this.mappingTool).getErhebungsbeschreibung());
        }
        if (wizard != null) {
            WizardDialog dialog = new WizardDialog((Frame)this.frame, wizard);
            dialog.setVisible(true);
        }
    }

    public void load() {
        if (!this.saveUnsavedChanges()) {
            return;
        }
        int rc = this.fileChooser.showOpenDialog(this.frame);
        if (rc == 0) {
            File file = this.lastMappingFile = this.fileChooser.getSelectedFile();
            LoadMappingTask task = new LoadMappingTask(file);
            task.execute(new ProgressDialog(this.frame, "Mapping laden...", true), true);
            if (task.getThrowable() != null) {
                String msg;
                Throwable t = task.getThrowable();
                t.printStackTrace();
                if (t instanceof NoResourceFoundException) {
                    String referencedResourceId = null;
                    if (task.getMapping() != null) {
                        referencedResourceId = task.getMapping().getId();
                    }
                    StringBuffer buf = new StringBuffer();
                    buf.append("Eine zum \u00d6ffnen des Mappings erforderliche Ressource konnte nicht geladen werden:\n");
                    buf.append(t.getMessage());
                    if (referencedResourceId != null) {
                        buf.append("\n\nHinweis: Das Mapping referenziert die RessourceID " + referencedResourceId + ".");
                    }
                    msg = buf.toString();
                } else {
                    msg = t.getMessage();
                }
                JOptionPane.showMessageDialog(this.frame, msg, "Fehler", 0);
            } else if (task.getMapping() != null) {
                BindingGroup mapping = task.getMapping();
                if (mapping instanceof Mapping) {
                    MetaErhebungsbeschreibung surveyDefinition = (MetaErhebungsbeschreibung)task.getSDFElement();
                    String resourceResourceId = "1" + surveyDefinition.getProzedurCode();
                    String mappingResourceId = mapping.getId();
                    boolean dirtyFlag = false;
                    if (!mappingResourceId.equals(resourceResourceId)) {
                        dirtyFlag = true;
                        int compare = mappingResourceId.compareTo(resourceResourceId);
                        if (compare > 0) {
                            JOptionPane.showMessageDialog(this.frame, "F\u00fcr das Mapping wurde nur eine \u00e4ltere Ressource gefunden:\nRessourceID Mapping: '" + mappingResourceId + "', RessourceID Ressource: '" + resourceResourceId + "'\n\n" + "Das Mapping wird daher unter Verwendung dieser \u00e4lteren Ressource ge\u00f6ffnet.\n" + "Kontrollieren Sie daher - insbesondere wenn Sie das Mapping speichern - bitte die Werte (Positionen usw.) des Mappings!", "Hinweis", 1);
                        } else {
                            JOptionPane.showMessageDialog(this.frame, "F\u00fcr das Mapping wurde eine neuere Ressource gefunden:\nRessourceID Mapping: '" + mappingResourceId + "', RessourceID Ressource: '" + resourceResourceId + "'\n\n" + "Das Mapping wird daher unter Verwendung dieser neuen Ressource ge\u00f6ffnet.\n" + "Kontrollieren Sie daher - insbesondere wenn Sie das Mapping speichern - bitte die Werte (Positionen usw.) des Mappings!", "Hinweis", 1);
                        }
                        SDFMappingMerge mappingMerge = new SDFMappingMerge();
                        mapping = mappingMerge.getMergedMapping(surveyDefinition, (Mapping)mapping);
                    }
                    this.editMapping((Mapping)mapping, surveyDefinition, file, dirtyFlag);
                } else if (mapping instanceof MetaMapping) {
                    MetaSDFMetabeschreibung sdfMetaBeschreibung = (MetaSDFMetabeschreibung)task.getSDFElement();
                    String resourceResourceId = sdfMetaBeschreibung.getProzedurCode();
                    String mappingResourceId = mapping.getId();
                    boolean dirtyFlag = false;
                    if (!mappingResourceId.equals(resourceResourceId)) {
                        dirtyFlag = true;
                        int compare = mappingResourceId.compareTo(resourceResourceId);
                        if (compare > 0) {
                            JOptionPane.showMessageDialog(this.frame, "F\u00fcr das Mapping wurde nur eine \u00e4ltere Ressource gefunden:\nRessourceID Mapping: '" + mappingResourceId + "', RessourceID Ressource: '" + resourceResourceId + "'\n\n" + "Das Mapping wird daher unter Verwendung dieser \u00e4lteren Ressource ge\u00f6ffnet.\n" + "Kontrollieren Sie daher - insbesondere wenn Sie das Mapping speichern - bitte die Werte (Positionen usw.) des Mappings!", "Hinweis", 1);
                        } else {
                            JOptionPane.showMessageDialog(this.frame, "F\u00fcr das Mapping wurde eine neuere Ressource gefunden:\nRessourceID Mapping: '" + mappingResourceId + "', RessourceID Ressource: '" + resourceResourceId + "'\n\n" + "Das Mapping wird daher unter Verwendung dieser neuen Ressource ge\u00f6ffnet.\n" + "Kontrollieren Sie daher - insbesondere wenn Sie das Mapping speichern - bitte die Werte (Positionen usw.) des Mappings!", "Hinweis", 1);
                        }
                        MetaMappingMerge metaMappingMerge = new MetaMappingMerge();
                        mapping = metaMappingMerge.getMergedMapping(sdfMetaBeschreibung, (MetaMapping)mapping);
                    }
                    this.editMetaMapping((MetaMapping)mapping, sdfMetaBeschreibung, file, dirtyFlag);
                }
            }
        }
    }

    private boolean saveUnsavedChanges() {
        int rc;
        boolean canContinue = this.mappingTool != null ? (this.mappingTool.commitChangesToMapping() ? (this.mappingTool.getDirtyFlag() ? ((rc = JOptionPane.showConfirmDialog(this.frame, "Sie haben \u00c4nderungen vorgenommen. Wenn Sie fortfahren ohne zu speichern,\ngehen diese verloren.\n\nSollen die \u00c4nderungen gespeichert werden?", "\u00c4nderungen speichern?", 1, 3)) == 0 ? this.save() : (rc == 1 ? true : (rc == 2 ? false : false))) : true) : false) : true;
        return canContinue;
    }

    private boolean save() {
        boolean saved;
        if (this.mappingTool.commitChangesToMapping()) {
            if (this.mappingToolFile != null) {
                boolean shouldSave = true;
                MappingCheckResult result = this.check();
                if (!result.isOk()) {
                    int rc = JOptionPane.showConfirmDialog(this.frame, "Das erstellte Mapping ist fehlerhaft.\nSoll das Mapping trotzdem gespeichert werden?", "Achtung", 1, 2);
                    boolean bl = shouldSave = rc == 0;
                }
                saved = shouldSave ? this.save(this.mappingToolFile) : false;
            } else {
                saved = this.saveAs();
            }
        } else {
            saved = false;
        }
        return saved;
    }

    public boolean saveAs() {
        boolean saved = false;
        if (this.mappingTool.commitChangesToMapping()) {
            boolean shouldSave = true;
            MappingCheckResult result = this.check();
            if (!result.isOk()) {
                int rc = JOptionPane.showConfirmDialog(this.frame, "Das erstellte Mapping ist fehlerhaft.\nSoll das Mapping trotzdem gespeichert werden?", "Achtung", 1, 2);
                boolean bl = shouldSave = rc == 0;
            }
            if (shouldSave) {
                File editorFile = this.mappingToolFile;
                if (editorFile != null) {
                    this.fileChooser.setSelectedFile(editorFile);
                } else {
                    this.fileChooser.setSelectedFile(null);
                }
                int rc = this.fileChooser.showSaveDialog(this.frame);
                if (rc == 0) {
                    File selectedFile = this.fileChooser.getSelectedFile();
                    if (selectedFile.exists() && (editorFile == null || !editorFile.equals(selectedFile))) {
                        rc = JOptionPane.showConfirmDialog(this.frame, "Die Datei \"" + selectedFile.getAbsolutePath() + "\" existiert bereits.\n" + "Soll die Datei \u00fcberschrieben werden?", "Achtung", 1, 2);
                        boolean bl = shouldSave = rc == 0;
                    }
                    if (shouldSave) {
                        this.lastMappingFile = selectedFile;
                        saved = this.save(selectedFile);
                    }
                }
            }
        }
        return saved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean save(File file) {
        boolean saved;
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            this.mappingTool.save(out);
            this.mappingToolFile = file;
            this.refreshEditorInfo();
            out = null;
            saved = true;
        }
        catch (IOException e) {
            saved = false;
            JOptionPane.showMessageDialog(this.frame, e.getMessage(), "Fehler", 0);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Throwable e) {}
            }
        }
        return saved;
    }

    public void undo() {
        UndoableEdit undoableEdit = (UndoableEdit)this.undoStack.pop();
        undoableEdit.undo();
        this.redoStack.push(undoableEdit);
        this.undoAction.setEnabled(!this.undoStack.isEmpty());
        this.redoAction.setEnabled(true);
    }

    public void redo() {
        UndoableEdit undoableEdit = (UndoableEdit)this.redoStack.pop();
        undoableEdit.redo();
        this.undoStack.push(undoableEdit);
        this.redoAction.setEnabled(!this.redoStack.isEmpty());
        this.undoAction.setEnabled(true);
    }

    public MappingCheckResult check() {
        MappingCheckResult result = null;
        if (this.mappingTool != null) {
            result = this.mappingTool.check();
        }
        this.showMappingCheckResult(result);
        return result;
    }

    private void showMappingCheckResult(MappingCheckResult result) {
        ImageIcon icon;
        MappingProblem[] problems;
        String text;
        if (result != null) {
            text = result.getNumOfFatal() + result.getNumOfError() + " Fehler, " + result.getNumOfWarning() + " Warnungen";
            problems = result.getProblems();
            icon = result.getNumOfFatal() > 0 ? IconFactory.getIcon("fatal.gif") : (result.getNumOfError() > 0 ? IconFactory.getIcon("error.gif") : (result.getNumOfWarning() > 0 ? IconFactory.getIcon("warning.gif") : (result.getNumOfInfo() > 0 ? IconFactory.getIcon("info.gif") : null)));
        } else {
            icon = null;
            text = "";
            problems = new MappingProblem[]{};
        }
        this.errorTitleBar.setIcon(icon);
        this.errorTitleBar.setText(text);
        this.problemTableModel.setProblems(problems);
    }

    public void showAboutDialog() {
        AboutDialog.showInfo(this.frame);
    }

    private void initUI() {
        File file;
        File directory;
        int column2Width;
        int column1Width;
        int dividerLocation;
        int top;
        int left;
        int height;
        int width;
        UIManager.put("SplitPane.border", BorderFactory.createEmptyBorder(0, 0, 0, 0));
        UIManager.put("SplitPaneDivider.border", BorderFactory.createEmptyBorder(0, 0, 0, 0));
        UIManager.put("SplitPane.dividerSize", new Integer(3));
        try {
            width = Integer.parseInt(this.editorProperties.getProperty("frame.width", "1024"));
        }
        catch (NumberFormatException e) {
            width = 1024;
        }
        try {
            height = Integer.parseInt(this.editorProperties.getProperty("frame.height", "780"));
        }
        catch (NumberFormatException e) {
            height = 780;
        }
        try {
            left = Integer.parseInt(this.editorProperties.getProperty("frame.left", "0"));
        }
        catch (NumberFormatException e) {
            left = 0;
        }
        try {
            top = Integer.parseInt(this.editorProperties.getProperty("frame.top", "0"));
        }
        catch (NumberFormatException e) {
            top = 0;
        }
        this.frame = new JFrame(APPLICATION_NAME){

            @Override
            protected void processWindowEvent(WindowEvent event) {
                if (event.getID() == 201) {
                    MappingEditor.this.close();
                } else {
                    super.processWindowEvent(event);
                }
            }
        };
        this.frame.setIconImage(Icons.ICON_MAPPER.getImage());
        this.frame.setDefaultCloseOperation(0);
        this.frame.setSize(width, height);
        this.frame.setLocation(left, top);
        int extendedState = this.getFrameStateFromString(this.editorProperties.getProperty("frame.state", "normal"));
        if (extendedState == 1) {
            extendedState = 0;
        }
        this.frame.setExtendedState(extendedState);
        CreateAction createAction = new CreateAction();
        CreateMetaMappingAction createMetaDatenMappingAction = new CreateMetaMappingAction();
        LoadAction loadAction = new LoadAction();
        JMenuBar menuBar = new JMenuBar();
        menuBar.setBorder(null);
        JMenu fileMenu = new JMenu("Datei");
        fileMenu.setMnemonic('D');
        JMenu newMenu = new JMenu("Neu");
        newMenu.setIcon(IconFactory.getIcon("new.gif"));
        newMenu.add(createAction);
        newMenu.add(createMetaDatenMappingAction);
        fileMenu.add(newMenu);
        fileMenu.addSeparator();
        fileMenu.add(loadAction);
        this.closeEditorAction = new CloseEditorAction();
        fileMenu.add(this.closeEditorAction);
        fileMenu.addSeparator();
        this.saveAction = new SaveAction();
        fileMenu.add(this.saveAction);
        this.saveAsAction = new SaveAsAction();
        fileMenu.add(this.saveAsAction);
        fileMenu.addSeparator();
        fileMenu.add(new CloseAction());
        menuBar.add(fileMenu);
        JMenu editMenu = new JMenu("Bearbeiten");
        editMenu.setMnemonic('B');
        this.undoAction = new UndoAction();
        editMenu.add(this.undoAction);
        this.redoAction = new RedoAction();
        editMenu.add(this.redoAction);
        editMenu.addSeparator();
        this.checkAction = new CheckAction();
        editMenu.add(this.checkAction);
        editMenu.addSeparator();
        this.tablePreviewAction = new TablePreviewAction();
        editMenu.add(this.tablePreviewAction);
        this.createCsvTemplateAction = new CreateCsvTemplateAction();
        editMenu.add(this.createCsvTemplateAction);
        menuBar.add(editMenu);
        JMenu helpMenu = new JMenu("Hilfe");
        helpMenu.setMnemonic('H');
        helpMenu.add(new AboutAction());
        menuBar.add(helpMenu);
        this.frame.setJMenuBar(menuBar);
        JToolBar toolBar = new JToolBar();
        toolBar.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, SystemColor.controlLtHighlight), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        toolBar.setFloatable(false);
        toolBar.add(createAction);
        toolBar.add(createMetaDatenMappingAction);
        toolBar.addSeparator();
        toolBar.add(loadAction);
        toolBar.add(this.closeEditorAction);
        toolBar.addSeparator();
        toolBar.add(this.saveAction);
        toolBar.addSeparator();
        toolBar.add(this.undoAction);
        toolBar.add(this.redoAction);
        toolBar.addSeparator();
        toolBar.add(this.checkAction);
        toolBar.addSeparator();
        toolBar.add(this.tablePreviewAction);
        toolBar.add(this.createCsvTemplateAction);
        this.frame.getContentPane().add((Component)toolBar, "North");
        this.mainSplitPane = new JSplitPane(0);
        this.mainSplitPane.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        try {
            dividerLocation = Integer.parseInt(this.editorProperties.getProperty("frame.divider.top", "300"));
        }
        catch (NumberFormatException e) {
            dividerLocation = 300;
        }
        this.mainSplitPane.setDividerLocation(dividerLocation);
        this.tablePreview = new JLabel();
        this.tablePreview.setVerticalAlignment(1);
        this.tablePreview.setBackground(Color.white);
        this.mappingToolPanel = new JPanel(new BorderLayout());
        this.welcomePage = new WelcomePageTool(this);
        this.welcomePage.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(SystemColor.controlShadow), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        this.mappingToolPanel.add(this.welcomePage.getGui(), "Center");
        this.mainSplitPane.setTopComponent(this.mappingToolPanel);
        this.errorTitleBar = new JLabel(" ");
        this.errorTitleBar.setPreferredSize(new Dimension(0, 22));
        this.errorTitleBar.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, SystemColor.controlShadow), BorderFactory.createEmptyBorder(0, 2, 0, 2)));
        this.errorTitleBar.setBackground(SystemColor.control);
        this.errorTitleBar.setOpaque(true);
        this.problemTableModel = new ProblemTableModel();
        this.table = new JTable(this.problemTableModel);
        this.table.setDefaultRenderer(Binding.class, new BindingFeldCellRenderer());
        this.table.setAutoResizeMode(0);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setGridColor(SystemColor.control);
        this.table.setRowHeight(18);
        this.table.addFocusListener(new SelectionFocusListener());
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MappingProblem problem;
                Binding binding;
                int selectedRow;
                if (e.getClickCount() == 2 && (selectedRow = MappingEditor.this.table.getSelectedRow()) != -1 && (binding = (problem = MappingEditor.this.problemTableModel.getProblemAt(selectedRow)).getBinding()) != null && MappingEditor.this.mappingTool != null && MappingEditor.this.mappingTool.activated()) {
                    MappingEditor.this.mappingTool.focusErrorBinding(binding);
                }
            }
        });
        try {
            column1Width = Integer.parseInt(this.editorProperties.getProperty("problemview.column1.width", "300"));
        }
        catch (NumberFormatException e) {
            column1Width = 300;
        }
        int defaultColumn2Width = Math.max(100, width - 300 - 38);
        try {
            column2Width = Integer.parseInt(this.editorProperties.getProperty("problemview.column2.width", defaultColumn2Width + ""));
        }
        catch (NumberFormatException e) {
            column2Width = defaultColumn2Width;
        }
        TableColumn column = this.table.getColumnModel().getColumn(0);
        column.setPreferredWidth(18);
        column = this.table.getColumnModel().getColumn(1);
        column.setPreferredWidth(column1Width);
        column = this.table.getColumnModel().getColumn(2);
        column.setPreferredWidth(column2Width);
        SwingUtil.removeUunnecessaryActionsFromTable(this.table);
        JScrollPane scrollPane = new JScrollPane(this.table);
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        scrollPane.getViewport().setBackground(this.table.getBackground());
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(SystemColor.controlShadow), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        panel.add((Component)this.errorTitleBar, "North");
        panel.add((Component)scrollPane, "Center");
        this.mainSplitPane.setBottomComponent(panel);
        this.frame.getContentPane().add((Component)this.mainSplitPane, "Center");
        this.statusBar = new JLabel(" ");
        this.statusBar.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.frame.getContentPane().add((Component)this.statusBar, "South");
        this.fileChooser = new JFileChooser();
        this.fileChooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.getName().toLowerCase().endsWith(".xml");
            }

            @Override
            public String getDescription() {
                return "Mappingdateien (*.xml)";
            }
        });
        this.lastMappingFile = null;
        String lastMappingFilePath = this.editorProperties.getProperty(PROP_LAST_MAPPING_FILE);
        if (lastMappingFilePath != null && lastMappingFilePath.trim().length() > 0 && (directory = (file = new File(lastMappingFilePath)).getParentFile()) != null && directory.isDirectory()) {
            this.lastMappingFile = file;
            this.fileChooser.setCurrentDirectory(directory);
            this.fileChooser.revalidate();
        }
        this.frame.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                this.saveValues();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                this.saveValues();
            }

            private void saveValues() {
                int n = MappingEditor.this.frame.getExtendedState();
                MappingEditor.this.frame;
                if ((n & 6) == 0) {
                    MappingEditor.this.saveFrameSizeAndLocation(MappingEditor.this.frame);
                }
            }
        });
    }

    private void saveFrameSizeAndLocation(Frame frame) {
        if (frame != null) {
            this.frameWidth = new Integer(frame.getWidth());
            this.frameHeight = new Integer(frame.getHeight());
            this.frameX = new Integer(frame.getX());
            this.frameY = new Integer(frame.getY());
        }
    }

    private void editMapping(Mapping mapping, MetaErhebungsbeschreibung surveyDefinition, File file, boolean dirtyFlag) {
        SDFMappingEditorTool mappingTool = new SDFMappingEditorTool(this, dirtyFlag, this.editorProperties, mapping, surveyDefinition, true);
        this.setMappingTool(mappingTool, file);
    }

    private void editMetaMapping(MetaMapping mapping, MetaSDFMetabeschreibung sdfMetaBeschreibung, File file, boolean dirtyFlag) {
        MetaMappingEditorTool mappingTool = new MetaMappingEditorTool(this, dirtyFlag, this.editorProperties, mapping, sdfMetaBeschreibung);
        this.setMappingTool(mappingTool, file);
    }

    private void setMappingTool(MappingEditorTool mappingTool, File mappingToolFile) {
        this.mappingToolFile = null;
        if (this.mappingTool != null) {
            try {
                this.mappingTool.saveProperties();
                this.mappingToolPanel.remove(this.mappingTool.getGUI());
                this.mappingTool.close();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        } else {
            this.mappingToolPanel.remove(this.welcomePage.getGui());
        }
        if (mappingTool != null) {
            mappingTool.assemble();
            mappingTool.activate();
            this.mappingTool = mappingTool;
            this.mappingToolFile = mappingToolFile;
            this.mappingToolPanel.add((Component)this.mappingTool.getGUI(), "Center");
            this.saveAction.setEnabled(true);
            this.saveAsAction.setEnabled(true);
            this.checkAction.setEnabled(true);
            this.tablePreviewAction.setEnabled(true);
            this.createCsvTemplateAction.setEnabled(true);
            this.closeEditorAction.setEnabled(true);
            this.mappingTool.addDirtyFlagChangedListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    MappingEditor.this.refreshEditorInfo();
                }
            });
        } else {
            this.mappingTool = null;
            this.mappingToolPanel.add(this.welcomePage.getGui(), "Center");
            this.saveAction.setEnabled(false);
            this.saveAsAction.setEnabled(false);
            this.checkAction.setEnabled(false);
            this.tablePreviewAction.setEnabled(false);
            this.createCsvTemplateAction.setEnabled(false);
            this.closeEditorAction.setEnabled(false);
        }
        this.mappingToolPanel.revalidate();
        this.mappingToolPanel.repaint();
        this.undoStack.clear();
        this.redoStack.clear();
        this.undoAction.setEnabled(false);
        this.redoAction.setEnabled(false);
        this.showMappingCheckResult(null);
        this.refreshEditorInfo();
    }

    private void closeMappingTool() {
        if (this.saveUnsavedChanges()) {
            this.setMappingTool(null, null);
        }
    }

    public void refreshEditorInfo() {
        this.refreshTitle();
    }

    private void refreshTitle() {
        StringBuffer title = new StringBuffer(APPLICATION_NAME);
        if (this.mappingTool != null) {
            title.append(" - ");
            if (this.mappingToolFile != null) {
                title.append(this.mappingToolFile.getAbsolutePath());
                if (this.mappingTool.getDirtyFlag()) {
                    title.append(" *");
                }
            } else {
                title.append("* Neu *");
            }
        }
        this.frame.setTitle(title.toString());
    }

    private void showTablePreview() {
        if (this.mappingTool != null) {
            this.mappingTool.showTablePreview();
        }
    }

    public static String cvrtHtml(String text) {
        if (text == null) {
            return text;
        }
        if (text.indexOf(60) != -1 || text.indexOf(62) != -1 || text.indexOf(38) != -1 || text.indexOf(34) != -1 || text.indexOf(39) != -1) {
            StringBuffer buffer = new StringBuffer();
            block6: for (char character : text.toCharArray()) {
                switch (character) {
                    case '<': {
                        buffer.append("&lt;");
                        continue block6;
                    }
                    case '>': {
                        buffer.append("&gt;");
                        continue block6;
                    }
                    case '&': {
                        buffer.append("&amp;");
                        continue block6;
                    }
                    case '\"': {
                        buffer.append("&quot;");
                        continue block6;
                    }
                    default: {
                        buffer.append(character);
                    }
                }
            }
            return buffer.toString();
        }
        return text;
    }

    private class LoadMappingTask
    extends Task {
        private File file;
        private BindingGroup result;
        private SDFElement sdfElement;

        public LoadMappingTask(File file) {
            this.file = file;
            this.result = null;
        }

        public BindingGroup getMapping() {
            return this.result;
        }

        public SDFElement getSDFElement() {
            return this.sdfElement;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void execute(final ProgressMonitor monitor) throws Exception {
            block12: {
                BindingGroup mapping;
                monitor.processing("Mapping wird geladen...");
                MappingsParser parser = new MappingsParser();
                this.result = mapping = parser.parse(this.file);
                monitor.processed(0.3);
                if (mapping instanceof Mapping) {
                    monitor.processing("Erhebungsbeschreibung wird geladen...");
                    ClientStatusListener listener = null;
                    if (MappingEditor.this.resourceManager.getResourceConfig().isSurveyAutoUpdate() && MappingEditor.this.resourceManager.getResourceConfig().getClient() != null) {
                        listener = new ClientStatusListener(){

                            @Override
                            public void statusChanged(ClientStatusEvent e) {
                                LoadMappingTask.this.abortIfCanceled(monitor);
                                switch (e.getType()) {
                                    case 2: {
                                        monitor.processed(0.35);
                                        break;
                                    }
                                    case 3: {
                                        monitor.processed(0.5);
                                        break;
                                    }
                                    case 4: {
                                        monitor.processed(0.95);
                                    }
                                }
                                monitor.processing(e.getDescription());
                            }
                        };
                        MappingEditor.this.resourceManager.getResourceConfig().getClient().addStatusListener(listener);
                    }
                    try {
                        String mappingResourceId = mapping.getId();
                        ErhebungsId erhebungsId = new ErhebungsId(mappingResourceId);
                        DatmlSdfSource sdfSource = MappingEditor.this.resourceManager.getSdfResource(erhebungsId.getStatId(), erhebungsId.getTimeId(), erhebungsId.getLkz());
                        try {
                            MetaErhebungsbeschreibung surveyDefinition = sdfSource.getErhebungsbeschreibung();
                            this.sdfElement = surveyDefinition;
                            break block12;
                        }
                        catch (ResourceException e) {
                            throw new RuntimeException("Fehler beim Parsen der Ressource '" + sdfSource.getResourceId() + "': " + e.getMessage(), e);
                        }
                    }
                    finally {
                        if (listener != null) {
                            MappingEditor.this.resourceManager.getResourceConfig().getClient().removeStatusListener(listener);
                        }
                    }
                }
                if (mapping instanceof MetaMapping) {
                    monitor.processing("Metadatenbeschreibung wird geladen...");
                    String resourceId = mapping.getId();
                    CommonResourceId commonResourceId = new CommonResourceId(resourceId);
                    String prettyDatMlRawVersion = commonResourceId.getPrettyDatMlRawVersion();
                    SDFMetaResource sdfMetaResource = MappingEditor.this.resourceManager.getSdfMetaResource(prettyDatMlRawVersion);
                    try {
                        MetaSDFMetabeschreibung sdfMetaBeschreibung = sdfMetaResource.getSdfMetaBeschreibung();
                        this.sdfElement = sdfMetaBeschreibung;
                    }
                    catch (ResourceException e) {
                        throw new RuntimeException("Fehler beim Parsen der Ressource '" + sdfMetaResource.getResourceId() + "': " + e.getMessage(), e);
                    }
                } else {
                    throw new IllegalStateException("Unbekannter Mappingtyp.");
                }
            }
        }
    }

    private class CloseEditorAction
    extends AbstractAction {
        public CloseEditorAction() {
            super("Schlie\u00dfen", Icons.ICON_CLOSE);
            this.putValue("ShortDescription", "Ge\u00f6ffnetes Mapping schlie\u00dfen");
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MappingEditor.this.closeMappingTool();
        }
    }

    private class CreateCsvTemplateAction
    extends AbstractAction {
        public CreateCsvTemplateAction() {
            super("CSV-Vorlage erstellen ...", Icons.ICON_CSV_TEMPLATE);
            this.putValue("ShortDescription", "CSV-Vorlage erstellen ...");
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MappingEditor.this.createCsvTemplate();
        }
    }

    private class TablePreviewAction
    extends AbstractAction {
        public TablePreviewAction() {
            super("Tabellenvorschau ...", Icons.ICON_TABLE_PREVIEW);
            this.putValue("ShortDescription", "Tabellenvorschau anzeigen ...");
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent paramActionEvent) {
            MappingEditor.this.showTablePreview();
        }
    }

    private class AboutAction
    extends AbstractAction {
        public AboutAction() {
            super("Info ...");
            this.putValue("MnemonicKey", new Integer(73));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MappingEditor.this.showAboutDialog();
        }
    }

    private class CheckAction
    extends AbstractAction {
        public CheckAction() {
            super("Pr\u00fcfen", IconFactory.getIcon("check.gif"));
            this.putValue("MnemonicKey", new Integer(80));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(80, 2));
            this.putValue("ShortDescription", "Mapping pr\u00fcfen");
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (MappingEditor.this.mappingTool.commitChangesToMapping()) {
                MappingEditor.this.check();
            }
        }
    }

    private class RedoAction
    extends AbstractAction {
        public RedoAction() {
            super("Wiederholen", IconFactory.getIcon("redo.gif"));
            this.putValue("MnemonicKey", new Integer(87));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(89, 2));
            this.putValue("ShortDescription", "Wiederholen");
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MappingEditor.this.redo();
        }
    }

    private class UndoAction
    extends AbstractAction {
        public UndoAction() {
            super("R\u00fcckg\u00e4ngig", IconFactory.getIcon("undo.gif"));
            this.putValue("MnemonicKey", new Integer(82));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(90, 2));
            this.putValue("ShortDescription", "R\u00fcckg\u00e4ngig");
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MappingEditor.this.undo();
        }
    }

    private class CloseAction
    extends AbstractAction {
        public CloseAction() {
            super("Beenden");
            this.putValue("MnemonicKey", new Integer(66));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(115, 8));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MappingEditor.this.close();
        }
    }

    private class SaveAsAction
    extends AbstractAction {
        public SaveAsAction() {
            super("Speichern unter...");
            this.putValue("MnemonicKey", new Integer(85));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MappingEditor.this.saveAs();
        }
    }

    private class SaveAction
    extends AbstractAction {
        public SaveAction() {
            super("Speichern", IconFactory.getIcon("save.gif"));
            this.putValue("MnemonicKey", new Integer(83));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(83, 2));
            this.putValue("ShortDescription", "Speichern");
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MappingEditor.this.save();
        }
    }

    private class LoadAction
    extends AbstractAction {
        public LoadAction() {
            super("\u00d6ffnen", IconFactory.getIcon("open.gif"));
            this.putValue("MnemonicKey", new Integer(102));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(79, 2));
            this.putValue("ShortDescription", "\u00d6ffnen ...");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MappingEditor.this.load();
        }
    }

    private class CreateMetaMappingAction
    extends AbstractAction {
        public CreateMetaMappingAction() {
            super("Metadaten-Mapping", Icons.ICON_META_MAPPING);
            this.putValue("MnemonicKey", new Integer(101));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(77, 2));
            this.putValue("ShortDescription", "Neues Metadaten-Mapping ...");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MappingEditor.this.createMetaDatenMapping();
        }
    }

    private class CreateAction
    extends AbstractAction {
        public CreateAction() {
            super("Mapping", Icons.ICON_MAPPING);
            this.putValue("MnemonicKey", new Integer(109));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(78, 2));
            this.putValue("ShortDescription", "Neues Mapping ...");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MappingEditor.this.create();
        }
    }
}

