/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.connect.transfer.https;

import de.destatis.core.connect.Request;
import de.destatis.core.connect.Response;
import de.destatis.core.connect.ResponseStatus;
import de.destatis.core.connect.util.ClientConfig;
import de.destatis.core.connect.util.ClientLogger;
import java.io.IOException;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.util.EntityUtils;

public abstract class HttpsRequestHandler {
    private static final ClientLogger LOG = ClientLogger.getLogger(HttpsRequestHandler.class);
    private Request request = null;
    private ClientConfig config = null;

    public HttpsRequestHandler(Request request, ClientConfig config) {
        this.request = request;
        this.config = config;
    }

    public Request getRequest() {
        return this.request;
    }

    public ClientConfig getConfig() {
        return this.config;
    }

    public abstract String getActionValue();

    public abstract void addParts(Map<String, ContentBody> var1);

    public abstract Response getResponse(HttpResponse var1);

    public boolean clientAuthenticatorRequired() {
        return true;
    }

    protected ResponseStatus getResponseStatus(HttpResponse httpResponse) {
        ResponseStatus responseStatus = null;
        Header resultHeader = httpResponse.getFirstHeader("X-Status");
        if (resultHeader != null && resultHeader.getValue() != null) {
            responseStatus = ResponseStatus.getInstance(Integer.parseInt(resultHeader.getValue()));
        }
        if (responseStatus == null) {
            LOG.info("Antwort vom Server enthaelt keinen Statuscode (X-Status)!");
            responseStatus = ResponseStatus.BAD_RESPONSE;
        }
        return responseStatus;
    }

    protected String getResponseBody(HttpResponse httpResponse) {
        String responseBody;
        try {
            HttpEntity entity = httpResponse.getEntity();
            responseBody = entity != null ? EntityUtils.toString((HttpEntity)entity) : null;
        }
        catch (IOException e) {
            LOG.error("I/O failure reading response body", e);
            responseBody = null;
        }
        return responseBody;
    }
}

