/*
 * Decompiled with CFR 0.152.
 */
package clover.org.jfree.chart.renderer.category;

import clover.org.jfree.chart.axis.CategoryAxis;
import clover.org.jfree.chart.axis.ValueAxis;
import clover.org.jfree.chart.entity.EntityCollection;
import clover.org.jfree.chart.labels.CategoryItemLabelGenerator;
import clover.org.jfree.chart.plot.CategoryPlot;
import clover.org.jfree.chart.plot.PlotOrientation;
import clover.org.jfree.chart.renderer.category.BarRenderer;
import clover.org.jfree.chart.renderer.category.CategoryItemRenderer;
import clover.org.jfree.chart.renderer.category.CategoryItemRendererState;
import clover.org.jfree.data.category.CategoryDataset;
import clover.org.jfree.data.category.IntervalCategoryDataset;
import clover.org.jfree.ui.RectangleEdge;
import clover.org.jfree.util.PublicCloneable;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;

public class IntervalBarRenderer
extends BarRenderer
implements CategoryItemRenderer,
Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = -5068857361615528725L;

    public void drawItem(Graphics2D g2, CategoryItemRendererState state, Rectangle2D dataArea, CategoryPlot plot, CategoryAxis domainAxis, ValueAxis rangeAxis, CategoryDataset dataset, int row, int column, int pass) {
        if (dataset instanceof IntervalCategoryDataset) {
            IntervalCategoryDataset d = (IntervalCategoryDataset)dataset;
            this.drawInterval(g2, state, dataArea, plot, domainAxis, rangeAxis, d, row, column);
        } else {
            super.drawItem(g2, state, dataArea, plot, domainAxis, rangeAxis, dataset, row, column, pass);
        }
    }

    protected void drawInterval(Graphics2D g2, CategoryItemRendererState state, Rectangle2D dataArea, CategoryPlot plot, CategoryAxis domainAxis, ValueAxis rangeAxis, IntervalCategoryDataset dataset, int row, int column) {
        EntityCollection entities;
        CategoryItemLabelGenerator generator;
        int seriesCount = this.getRowCount();
        int categoryCount = this.getColumnCount();
        PlotOrientation orientation = plot.getOrientation();
        double rectX = 0.0;
        double rectY = 0.0;
        RectangleEdge domainAxisLocation = plot.getDomainAxisEdge();
        RectangleEdge rangeAxisLocation = plot.getRangeAxisEdge();
        Number value0 = dataset.getEndValue(row, column);
        if (value0 == null) {
            return;
        }
        double java2dValue0 = rangeAxis.valueToJava2D(value0.doubleValue(), dataArea, rangeAxisLocation);
        Number value1 = dataset.getStartValue(row, column);
        if (value1 == null) {
            return;
        }
        double java2dValue1 = rangeAxis.valueToJava2D(value1.doubleValue(), dataArea, rangeAxisLocation);
        if (java2dValue1 < java2dValue0) {
            double temp = java2dValue1;
            java2dValue1 = java2dValue0;
            java2dValue0 = temp;
            Number tempNum = value1;
            value1 = value0;
            value0 = tempNum;
        }
        double rectWidth = state.getBarWidth();
        double rectHeight = Math.abs(java2dValue1 - java2dValue0);
        if (orientation == PlotOrientation.HORIZONTAL) {
            rectY = domainAxis.getCategoryStart(column, this.getColumnCount(), dataArea, domainAxisLocation);
            if (seriesCount > 1) {
                double seriesGap = dataArea.getHeight() * this.getItemMargin() / (double)(categoryCount * (seriesCount - 1));
                rectY += (double)row * (state.getBarWidth() + seriesGap);
            } else {
                rectY += (double)row * state.getBarWidth();
            }
            rectX = java2dValue0;
            rectHeight = state.getBarWidth();
            rectWidth = Math.abs(java2dValue1 - java2dValue0);
        } else if (orientation == PlotOrientation.VERTICAL) {
            rectX = domainAxis.getCategoryStart(column, this.getColumnCount(), dataArea, domainAxisLocation);
            if (seriesCount > 1) {
                double seriesGap = dataArea.getWidth() * this.getItemMargin() / (double)(categoryCount * (seriesCount - 1));
                rectX += (double)row * (state.getBarWidth() + seriesGap);
            } else {
                rectX += (double)row * state.getBarWidth();
            }
            rectY = java2dValue0;
        }
        Rectangle2D.Double bar = new Rectangle2D.Double(rectX, rectY, rectWidth, rectHeight);
        Paint seriesPaint = this.getItemPaint(row, column);
        g2.setPaint(seriesPaint);
        g2.fill(bar);
        if (state.getBarWidth() > 3.0) {
            Stroke stroke = this.getItemOutlineStroke(row, column);
            Paint paint = this.getItemOutlinePaint(row, column);
            if (stroke != null && paint != null) {
                g2.setStroke(stroke);
                g2.setPaint(paint);
                g2.draw(bar);
            }
        }
        if ((generator = this.getItemLabelGenerator(row, column)) != null && this.isItemLabelVisible(row, column)) {
            this.drawItemLabel(g2, dataset, row, column, plot, generator, bar, false);
        }
        if ((entities = state.getEntityCollection()) != null) {
            this.addItemEntity(entities, dataset, row, column, bar);
        }
    }
}

