/*
 * Decompiled with CFR 0.152.
 */
package de.superx.common;

import de.memtext.baseobjects.NamedIdObject;
import de.memtext.baseobjects.NamedIdObjectWithParent;
import de.memtext.baseobjects.NamedIdObjectWithParentI;
import de.memtext.rights.Allowable;
import de.memtext.tree.KeyParentEqualException;
import de.memtext.util.DateUtils;
import de.memtext.util.EqualsUtil;
import de.memtext.util.HashCodeUtil;
import de.memtext.util.StringUtils;
import de.superx.common.SxResultRow;
import de.superx.common.SxResultSet;
import java.sql.Date;
import java.util.Collection;
import java.util.TreeSet;

public class SelectableItem
extends NamedIdObjectWithParent
implements Allowable,
Comparable {
    private boolean isOrganigrammItem;
    private boolean isTreeView;
    private boolean isLehre;
    private boolean isAllowed;
    private String escapedId;
    private String subordinateKeyList = "undefined";
    private boolean isTemporary;
    private int nodeAttrib;
    private int sortNr;
    private boolean isSelectable = true;
    private boolean isClosedInAltHier = false;
    private boolean isClosedInTree = false;
    private Integer strukturInt = new Integer(-9999999);
    private String strukturStr = "";
    private static final long serialVersionUID = 3L;

    public SelectableItem() {
    }

    private SelectableItem(NamedIdObjectWithParentI namedIdObjectWithParent) throws KeyParentEqualException {
        this.setId(namedIdObjectWithParent.getId());
        this.setName(namedIdObjectWithParent.getName());
        this.setParentKey(namedIdObjectWithParent.getParentKey());
    }

    public SelectableItem(Object id, String name) {
        this.setName(name);
        String idstring = null;
        if (id != null) {
            idstring = id.toString();
            if (id instanceof java.util.Date) {
                idstring = "'" + DateUtils.format((Date)id) + "'";
                this.setName(idstring);
            }
        }
        this.setId(idstring);
    }

    public SelectableItem(Object id, String name, Object parentKey) throws KeyParentEqualException {
        super(id, name, parentKey);
    }

    public SelectableItem(NamedIdObject namedIdObject) {
        super(namedIdObject);
    }

    @Override
    public boolean isAllowed() {
        return this.isAllowed;
    }

    @Override
    public void setAllowed(boolean isErlaubt) {
        this.isAllowed = isErlaubt;
    }

    public boolean isLehre() {
        return this.isLehre;
    }

    public void setLehre(boolean isLehre) {
        this.isLehre = isLehre;
    }

    public String toXml() {
        StringBuffer result = new StringBuffer("<item>\n<key><![CDATA[" + this.getId() + "]]></key>\n<name><![CDATA[" + this.getName() + "]]></name>");
        if (this.isOrganigrammItem() || this.isTreeView()) {
            result.append("\n<parent>" + this.getParentKey() + "</parent>\n");
            if (this.isOrganigrammItem()) {
                if (this.isAllowed) {
                    result.append("<erlaubt>1</erlaubt>\n");
                } else {
                    result.append("<erlaubt>0</erlaubt>\n");
                }
            }
        }
        result.append("</item>\n");
        return result.toString();
    }

    public boolean isOrganigrammItem() {
        return this.isOrganigrammItem;
    }

    public boolean isTreeView() {
        return this.isTreeView;
    }

    public void setOrganigrammItem(boolean isOrganigrammItem) {
        this.isOrganigrammItem = isOrganigrammItem;
    }

    public void setTreeView(boolean isTreeView) {
        this.isTreeView = isTreeView;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        SelectableItem cl = null;
        try {
            NamedIdObjectWithParentI x = (NamedIdObjectWithParentI)super.clone();
            cl = new SelectableItem(x);
            if (this.escapedId != null) {
                cl.escapedId = new String(this.escapedId);
            }
            cl.setOrganigrammItem(this.isOrganigrammItem);
            cl.setNodeAttrib(new Integer(this.nodeAttrib));
            cl.setTreeView(this.isTreeView);
            cl.setLehre(this.isLehre);
            cl.setAllowed(this.isAllowed);
            cl.setTemporary(this.isTemporary);
            cl.setStrukturInt(this.strukturInt);
            cl.setStrukturStr(this.strukturStr);
            cl.setSubordinateKeyList(this.getSubordinateKeyList());
            cl.setSortNr(this.getSortNr());
        }
        catch (KeyParentEqualException e2) {
            throw new CloneNotSupportedException("Cloning didn't work" + e2);
        }
        return cl;
    }

    boolean isTemporary() {
        return this.isTemporary;
    }

    void setTemporary(boolean isTemporary) {
        this.isTemporary = isTemporary;
    }

    public static Collection toSelectableItemCollection(SxResultSet rohform, boolean isOrganigramm) throws KeyParentEqualException {
        String name = "";
        boolean isLehre = false;
        boolean isErlaubt = false;
        TreeSet<SelectableItem> result = new TreeSet<SelectableItem>();
        SxResultRow aRow2 = null;
        int sortnr = 0;
        int zeichen = 63;
        char eurosign = (char)zeichen;
        try {
            for (SxResultRow aRow2 : rohform) {
                name = "";
                if (aRow2.get(0) != null) {
                    name = aRow2.get(0).toString();
                    if (name.indexOf(";") > -1) {
                        name = name.replace(';', ',');
                    }
                    if (name.indexOf("'") > -1) {
                        name = name.replace('\'', '`');
                    }
                    if (name.indexOf(eurosign) > -1) {
                        name = StringUtils.replace(name, "" + eurosign, "EUR");
                    }
                }
                String key_apnr = null;
                if (aRow2.get(1) != null) {
                    key_apnr = aRow2.get(1).toString();
                }
                if (key_apnr != null && key_apnr instanceof String && key_apnr.toString().indexOf(",") > -1) {
                    throw new IllegalArgumentException("Ungueltiger Schluessel: " + key_apnr + " (Kommas nicht erlaubt)");
                }
                if (key_apnr != null && key_apnr instanceof String && key_apnr.toString().indexOf("|") > -1) {
                    throw new IllegalArgumentException("Ungueltiger Schluessel: " + key_apnr + " (| nicht erlaubt)");
                }
                if (key_apnr != null && key_apnr instanceof String && key_apnr.toString().indexOf("*") > -1) {
                    throw new IllegalArgumentException("Ungueltiger Schluessel: " + key_apnr + " (* nicht erlaubt)");
                }
                String parent = null;
                if (aRow2.get(2) != null) {
                    parent = aRow2.get(2).toString();
                }
                SelectableItem einEintrag = new SelectableItem(key_apnr, name);
                einEintrag.setParentKey(parent);
                einEintrag.setTreeView(true);
                if (isOrganigramm) {
                    einEintrag.setOrganigrammItem(true);
                    String lehre = "0";
                    if (aRow2.size() > 3) {
                        lehre = aRow2.get(3);
                    }
                    if (lehre != null && lehre.toString().equals("1")) {
                        isLehre = true;
                    }
                    String erlaubt = "0";
                    if (aRow2.size() > 4) {
                        erlaubt = aRow2.get(4);
                    }
                    isErlaubt = false;
                    if (erlaubt != null && erlaubt.toString().equals("1")) {
                        isErlaubt = true;
                    }
                    einEintrag.setAllowed(isErlaubt);
                    einEintrag.setLehre(isLehre);
                    if (aRow2.size() > 5) {
                        einEintrag.setStrukturInfo(aRow2.get(5));
                    }
                    if (aRow2.size() > 6) {
                        einEintrag.setStrukturInfo(aRow2.get(6));
                    }
                } else {
                    if (aRow2.size() > 3) {
                        if (rohform.getColumnName(3).equalsIgnoreCase("nodeattrib")) {
                            einEintrag.setNodeAttrib(aRow2.get(3));
                        } else {
                            einEintrag.setStrukturInfo(aRow2.get(3));
                        }
                    }
                    if (aRow2.size() > 4) {
                        if (rohform.getColumnName(4).equalsIgnoreCase("nodeattrib")) {
                            einEintrag.setNodeAttrib(aRow2.get(4));
                        } else {
                            einEintrag.setStrukturInfo(aRow2.get(4));
                        }
                    }
                    if (aRow2.size() > 5) {
                        if (rohform.getColumnName(5).equalsIgnoreCase("nodeattrib")) {
                            einEintrag.setNodeAttrib(aRow2.get(5));
                        }
                        if (rohform.getColumnName(5).toLowerCase().startsWith("struktur")) {
                            einEintrag.setStrukturInfo(aRow2.get(5));
                        }
                    }
                    if (aRow2.size() > 6) {
                        if (rohform.getColumnName(6).equalsIgnoreCase("nodeattrib")) {
                            einEintrag.setNodeAttrib(aRow2.get(6));
                        }
                        if (rohform.getColumnName(6).toLowerCase().startsWith("struktur")) {
                            einEintrag.setStrukturInfo(aRow2.get(6));
                        }
                    }
                }
                einEintrag.setSortNr(sortnr++);
                result.add(einEintrag);
            }
        }
        catch (RuntimeException e2) {
            e2.printStackTrace();
            throw new RuntimeException("Problem beim Einlesen eines Eintrags - name: " + name + " Datenarray sollte mindestens 3 Elemente name,key,parent enthalten\nggfs. zus\ufffdtzlich lehre,erlaubt tats\ufffdchl. Inhalt:" + aRow2.toString() + "\nGenaue Fehlermeldung:" + e2.toString());
        }
        rohform = null;
        return result;
    }

    public void setStrukturInfo(Object struktur) {
        if (struktur instanceof String) {
            this.setStrukturStr((String)struktur);
        }
        if (struktur instanceof Integer) {
            this.setStrukturInt((Integer)struktur);
        }
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public String getSubordinateKeyList() {
        return this.subordinateKeyList;
    }

    public void setSubordinateKeyList(String subordinateKeyList) {
        this.subordinateKeyList = subordinateKeyList;
    }

    public int compareTo(Object o) {
        SelectableItem i2 = (SelectableItem)o;
        int result = 0;
        if (this.getSortNr() < i2.getSortNr()) {
            result = -1;
        }
        if (this.getSortNr() > i2.getSortNr()) {
            result = 1;
        }
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        SelectableItem i2 = (SelectableItem)obj;
        return EqualsUtil.areEqual(this.getId(), i2.getId()) && EqualsUtil.areEqual(this.getName(), i2.getName()) && EqualsUtil.areEqual(this.getParentKey(), i2.getParentKey()) && EqualsUtil.areEqual(this.isOrganigrammItem, i2.isOrganigrammItem) && EqualsUtil.areEqual(this.isTreeView, i2.isTreeView) && EqualsUtil.areEqual(this.isTemporary, i2.isTemporary) && EqualsUtil.areEqual(this.isLehre, i2.isLehre) && EqualsUtil.areEqual(this.isAllowed, i2.isAllowed);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = HashCodeUtil.hash(result, this.isOrganigrammItem);
        result = HashCodeUtil.hash(result, this.isTreeView);
        result = HashCodeUtil.hash(result, this.isLehre);
        result = HashCodeUtil.hash(result, this.isAllowed);
        result = HashCodeUtil.hash(result, this.isTemporary);
        return result;
    }

    public int getSortNr() {
        return this.sortNr;
    }

    public void setSortNr(int sortNr) {
        this.sortNr = sortNr;
    }

    public Integer getStrukturInt() {
        return this.strukturInt;
    }

    public void setStrukturInt(Integer strukturInt) {
        this.strukturInt = strukturInt;
    }

    public String getStrukturStr() {
        return this.strukturStr;
    }

    public void setStrukturStr(String stukturStr) {
        this.strukturStr = stukturStr;
    }

    public boolean isClosedInAltHier() {
        return this.isClosedInAltHier;
    }

    public void setClosedInAltHier(boolean isClosedInAltHier) {
        this.isClosedInAltHier = isClosedInAltHier;
    }

    public boolean isClosedInTree() {
        return this.isClosedInTree;
    }

    public void setClosedInTree(boolean isClosedInTree) {
        this.isClosedInTree = isClosedInTree;
    }

    public int getNodeAttrib() {
        return this.nodeAttrib;
    }

    public void setNodeAttrib(Object nodeAttrib) {
        this.nodeAttrib = 0;
        if (nodeAttrib != null) {
            this.nodeAttrib = Integer.parseInt(nodeAttrib.toString());
        }
        this.setSelectable(this.nodeAttrib != 2);
    }

    public boolean isSelectable() {
        return this.isSelectable;
    }

    public void setSelectable(boolean isSelectable) {
        this.isSelectable = isSelectable;
    }

    public String getEscapedId() {
        return this.escapedId;
    }

    public void setEscapedId(String escapedId) {
        this.escapedId = escapedId;
    }
}

