/*
 * Decompiled with CFR 0.152.
 */
package de.superx.applet;

import de.memtext.util.DateUtils;
import de.superx.applet.SxDefaults;
import de.superx.applet.SxField;
import de.superx.applet.SxLogoPanel;
import de.superx.applet.SxPosLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.text.NumberFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRootPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;

public class SxForm
extends JPanel {
    private SxForm sxForm;
    private JButton defaultBtn;
    private SxPosLayout pL;
    private Insets defInsets = new Insets(2, 2, 2, 2);
    private int distX = 20;
    private int distY = 20;
    private int posX = 20;
    private int posY = 20;
    private int diffX = 20;
    private int diffY = 20;
    private int prefWidth = 200;
    private int prefHeight = 150;
    private int prefCompHeight = 25;
    private SxLogoPanel logo = null;
    private Vector fieldVector = null;
    private Vector fieldKeys = null;
    private Hashtable formMap;
    private Hashtable errorMap;
    private boolean isErlaubt = false;
    private String hinweis;
    private static NumberFormat nf = NumberFormat.getInstance();

    public SxForm() {
        this.sxForm = this;
        this.init();
    }

    public SxForm(int dist_x, int dist_y, int diff_x, int diff_y) {
        this.sxForm = this;
        this.distX = dist_x;
        this.distY = dist_y;
        this.diffX = diff_x;
        this.diffY = diff_y;
        this.init();
    }

    public void addComp(String value, String comp_name, String class_name, int columns, int type, int length, int obligatorisch) {
        SxField field;
        Dimension dim = null;
        if (class_name.equals("JButton")) {
            JButton button = new JButton(value);
            button.setName(comp_name);
            button.setMargin(this.defInsets);
            button.setFont(new Font("SansSerif", 1, 12));
            this.add(comp_name, button);
            dim = button.getPreferredSize();
            dim.height = this.prefCompHeight;
            button.setPreferredSize(dim);
            this.pL.setPosition(button, this.posX, this.posY, dim.width, dim.height);
            this.formMap.put(comp_name, button);
        }
        if (class_name.equals("JToggleButton")) {
            JToggleButton toggle = new JToggleButton(value);
            toggle.setName(comp_name);
            toggle.setMargin(this.defInsets);
            toggle.setFont(new Font("Arial", 1, 12));
            this.add(comp_name, toggle);
            dim = toggle.getPreferredSize();
            dim.height = this.prefCompHeight;
            toggle.setPreferredSize(dim);
            this.pL.setPosition(toggle, this.posX, this.posY, dim.width, dim.height);
            this.formMap.put(comp_name, toggle);
        }
        if (class_name.equals("JCheckBox")) {
            JCheckBox checkbox = new JCheckBox(value);
            checkbox.setName(comp_name);
            checkbox.setMargin(this.defInsets);
            checkbox.setFont(new Font("Arial", 1, 12));
            this.add(comp_name, checkbox);
            dim = checkbox.getPreferredSize();
            dim.height = this.prefCompHeight;
            checkbox.setPreferredSize(dim);
            this.pL.setPosition(checkbox, this.posX, this.posY, dim.width, dim.height);
            this.formMap.put(comp_name, checkbox);
        }
        if (class_name.equals("JLabel")) {
            JLabel label = new JLabel(value);
            label.setName(comp_name);
            label.setFont(new Font("SansSerif", 0, 12));
            this.add(comp_name, label);
            dim = label.getPreferredSize();
            if (!comp_name.equals("L_parameter")) {
                dim.height = this.prefCompHeight;
                label.setPreferredSize(dim);
            }
            this.pL.setPosition(label, this.posX, this.posY, dim.width, dim.height);
            this.formMap.put(comp_name, label);
        }
        if (class_name.equals("SxField")) {
            field = new SxField(value, columns, type, length);
            field.setName(comp_name);
            field.setForm(this.sxForm);
            field.setMargin(this.defInsets);
            field.setBackground(Color.white);
            if (length > 0) {
                field.setEditable(true);
            } else {
                field.setEditable(false);
            }
            if (obligatorisch != 0) {
                field.setInputNeeded(true);
            }
            this.add(comp_name, field);
            dim = field.getPreferredSize();
            dim.height = this.prefCompHeight;
            field.setPreferredSize(dim);
            this.pL.setPosition(field, this.posX, this.posY, dim.width, dim.height);
            this.formMap.put(comp_name, field);
        }
        if (class_name.equals("JPasswordField")) {
            JPasswordField passwordfield = new JPasswordField(value);
            passwordfield.setName(comp_name);
            passwordfield.setMargin(this.defInsets);
            passwordfield.setFont(new Font("Arial", 1, 12));
            this.add(comp_name, passwordfield);
            dim = passwordfield.getPreferredSize();
            dim.height = this.prefCompHeight;
            passwordfield.setPreferredSize(dim);
            this.pL.setPosition(passwordfield, this.posX, this.posY, dim.width, dim.height);
            this.formMap.put(comp_name, passwordfield);
        }
        if (class_name.equals("JTextArea")) {
            JTextArea t_area = new JTextArea(value);
            t_area.setName(comp_name);
            t_area.setMargin(this.defInsets);
            t_area.setBackground(Color.white);
            if (length > 0) {
                t_area.setEditable(true);
            } else {
                t_area.setEditable(false);
            }
            this.add(comp_name, t_area);
            dim = t_area.getPreferredSize();
            dim.height = this.prefCompHeight;
            t_area.setPreferredSize(dim);
            this.pL.setPosition(t_area, this.posX, this.posY, dim.width, dim.height);
            this.formMap.put(comp_name, t_area);
        }
        if (class_name.equals("JComboBox")) {
            JComboBox combo = new JComboBox();
            combo.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            combo.setName(comp_name);
            combo.setBackground(Color.white);
            if (length > 0) {
                field = new SxField(type, length);
                field.setName(comp_name);
                field.setWithCombo(true);
                field.setMargin(this.defInsets);
                field.setForm(this.sxForm);
                if (obligatorisch != 0) {
                    field.setInputNeeded(true);
                }
                combo.setEditor(field);
                combo.setEditable(true);
            } else {
                combo.setEditable(false);
            }
            this.add(comp_name, combo);
            dim = combo.getPreferredSize();
            dim.height = this.prefCompHeight;
            combo.setPreferredSize(dim);
            this.pL.setPosition(combo, this.posX, this.posY, dim.width, dim.height);
            this.formMap.put(comp_name, combo);
        }
        this.fieldKeys.add(comp_name);
        if (this.diffX + dim.width + this.posX < this.prefWidth) {
            this.posX += this.diffX + dim.width;
        } else {
            this.posX = this.distX;
            this.posY += this.diffY + dim.height;
        }
    }

    public void addErrorComp(Component comp) {
        String err_name = comp.getName();
        if (err_name != null && !this.errorMap.containsKey(err_name)) {
            this.errorMap.put(err_name, comp);
        }
    }

    public JComponent getComp(String comp_name) {
        return (JComponent)this.formMap.get(comp_name);
    }

    public JButton getDefaultBtn() {
        if (this.defaultBtn == null) {
            JRootPane root = this.sxForm.getRootPane();
            return root.getDefaultButton();
        }
        return this.defaultBtn;
    }

    public void restoreValuesFromFormerSelections() {
        Enumeration en = this.formMap.keys();
        while (en.hasMoreElements()) {
            Properties prop;
            SxField field;
            String name = (String)en.nextElement();
            if (!name.startsWith("F_") || (field = this.getField(name)) == null) continue;
            name = name.substring(2);
            if (field.hasSichten()) {
                name = String.valueOf(name) + "-Sicht" + field.getSelectedSicht().getId();
            }
            if ((prop = SxDefaults.getProperty(name)) == null) continue;
            try {
                Object key = prop.get("key");
                field.setKey(key);
                if (field.hasSichten()) {
                    if (key == null || key.toString().equals("null")) {
                        field.getSelectedSicht().clearSelection();
                    } else {
                        field.getSelectedSicht().setSelectedKey(key.toString());
                    }
                }
                Object value = prop.get("value");
                if (field.isWithCombo()) {
                    if (value instanceof String[]) {
                        String[] values = (String[])value;
                        JComboBox combo = (JComboBox)this.getComp("F_" + name);
                        int n = values.length;
                        int i2 = 0;
                        while (i2 < n) {
                            combo.insertItemAt(values[i2], i2);
                            ++i2;
                        }
                        field.setText(" < Ihre Auswahl> ");
                        continue;
                    }
                    field.setText(value.toString());
                    continue;
                }
                if (key instanceof String[]) {
                    return;
                }
                field.setText(value.toString());
            }
            catch (Exception e2) {
                System.out.println("Problem beim Wiederherstellen von Auswahlwert " + e2);
            }
        }
    }

    public boolean isErlaubt() {
        return this.isErlaubt;
    }

    public Component getErrorComp() {
        Enumeration en = this.errorMap.keys();
        if (en.hasMoreElements()) {
            String err_name = (String)en.nextElement();
            return (Component)this.errorMap.get(err_name);
        }
        return null;
    }

    public Component getErrorComp(String name) {
        return (Component)this.errorMap.get(name);
    }

    public SxField getField(Object obj) {
        SxField field = null;
        if (obj == null) {
            return null;
        }
        if (obj instanceof SxField) {
            return (SxField)obj;
        }
        if (obj instanceof JComboBox) {
            JComboBox combo = (JComboBox)obj;
            field = (SxField)combo.getEditor();
            return field;
        }
        return field;
    }

    public SxField getField(String comp_name) {
        return this.getField(this.getComp(comp_name));
    }

    HashMap getHashMap(Integer maskNo) {
        HashMap<String, Object> t = new HashMap<String, Object>();
        if (maskNo != null) {
            t.put("Maskennummer", maskNo);
        }
        Enumeration enumeration = this.getMap().keys();
        while (enumeration.hasMoreElements()) {
            String fieldname = (String)enumeration.nextElement();
            if (!fieldname.startsWith("F_")) continue;
            SxField aField = this.getField(fieldname);
            if (aField.hasSichten()) {
                t.put(aField.getName().substring(2), aField.getSelectedSicht());
                aField.getSelectedSicht().updateKlappstatus();
                if (!aField.getSelectedSicht().isStandbuttonWanted()) continue;
                t.put(String.valueOf(aField.getName().substring(2)) + "-Stand", aField.getSelectedSicht().getStand());
                continue;
            }
            Object o = aField.getKey();
            if (o != null && o.toString().equals("-1")) {
                o = this.getFieldKey(aField.getName());
            }
            t.put(aField.getName().substring(2), o);
            aField.getItem();
        }
        return t;
    }

    void checkFields() throws Exception {
        Enumeration enumeration = this.getMap().keys();
        while (enumeration.hasMoreElements()) {
            String fieldname = (String)enumeration.nextElement();
            if (!fieldname.startsWith("F_")) continue;
            SxField aField = this.getField(fieldname);
            String content = aField.getText();
            if (!aField.isInputNeeded() || content != null && !content.equals("")) continue;
            aField.setBackground(Color.red);
            this.addErrorComp(aField);
        }
        Component err_comp = this.getErrorComp();
        if (err_comp != null) {
            String err_name = err_comp.getName().substring(2);
            throw new Exception("Im Feld '" + err_name + "' m\u00fcssen Sie etwas ausw\u00e4hlen bzw. eingeben!");
        }
    }

    private String getFieldContents(String field_name) {
        String contents = null;
        SxField field = this.getField(field_name);
        if (field == null) {
            return null;
        }
        if (field.getText().equals("")) {
            return null;
        }
        if (field.getType() == 3) {
            contents = field.getText();
        }
        if (field.getType() == 2) {
            try {
                Number number_value = nf.parse(field.getText().replace('.', ','));
                Double double_value = new Double(number_value.doubleValue());
                if (double_value != null) {
                    contents = double_value.toString();
                }
            }
            catch (Exception ex) {
                contents = null;
            }
        }
        if (field.getType() == 0 && (contents = field.getText()) != null) {
            contents = contents.replace(';', '^');
        }
        if (field.getType() == 4 && (contents = field.getText()) != null) {
            contents = contents.replace(';', '^');
        }
        if (field.getType() == 1) {
            contents = field.getText();
        }
        if (field.isInputNeeded() && (contents == null || contents.equals(""))) {
            System.err.println("Eingabe in '" + field_name.substring(2) + "' fehlt !");
            field.setBackground(Color.red);
            this.addErrorComp(field);
        }
        return contents;
    }

    public String getFieldKey(String field_name) {
        String sx_db = (String)SxDefaults.getPropertyValue("SxDB");
        JComponent obj = this.getComp(field_name);
        if (obj == null) {
            return null;
        }
        SxField field = this.getField(obj);
        if (field == null) {
            return null;
        }
        Object key = field.getKey();
        if (!field.isWithCombo()) {
            if (key instanceof String[]) {
                return "";
            }
            if (key.toString().equals("null")) {
                if (field.getType() == 0 || field.getType() == 3) {
                    return "'null'";
                }
                return "";
            }
            if (key.toString().equals("-1")) {
                String w = this.getFieldContents(field_name);
                boolean dummy = true;
                if (w == null) {
                    return "";
                }
                if (field.getType() == 0 || field.getType() == 3) {
                    return "'" + w + "'";
                }
                if (field.getType() == 2) {
                    return w.replace(',', '.');
                }
                return w;
            }
            if (key.toString().equals("")) {
                return "";
            }
            if (field.getType() == 0 || field.getType() == 3) {
                return "'" + key.toString() + "'";
            }
            if (field.getType() == 2) {
                return key.toString().replace(',', '.');
            }
            return key.toString();
        }
        String key_str = "";
        if (key instanceof String[]) {
            String[] keys = (String[])key;
            int i2 = 0;
            while (i2 < keys.length) {
                if (i2 > 0) {
                    key_str = String.valueOf(key_str) + ",";
                }
                key_str = field.getType() == 0 ? String.valueOf(key_str) + "'" + keys[i2] + "'" : String.valueOf(key_str) + keys[i2];
                ++i2;
            }
        } else {
            if (key.toString().equals("-1")) {
                return this.getFieldContents(field_name);
            }
            if (field.getType() == 0) {
                return "'" + key.toString() + "'";
            }
            return key.toString();
        }
        return key_str;
    }

    public Vector getFieldVector() {
        return this.fieldVector;
    }

    public SxLogoPanel getLogo() {
        return this.logo;
    }

    public Hashtable getMap() {
        return this.formMap;
    }

    public String getParamList(String username, boolean isHtmlWanted) {
        StringBuffer paramList = new StringBuffer();
        String html_start = "";
        String html_end = "";
        String html_bold_on = "";
        String html_bold_off = "";
        try {
            html_start = (String)SxDefaults.getPropertyValue("SxParamStart");
            html_end = (String)SxDefaults.getPropertyValue("SxParamEnd");
            html_bold_on = (String)SxDefaults.getPropertyValue("SxParamBoldOn");
            html_bold_off = (String)SxDefaults.getPropertyValue("SxParamBoldOff");
        }
        catch (NullPointerException ex) {
            System.err.println(ex);
            JOptionPane.showMessageDialog(this.sxForm, ex.toString(), "Fehler", 0);
        }
        if (isHtmlWanted) {
            paramList.append(html_start);
        }
        String orgStand = "";
        int k2 = 0;
        while (k2 < this.fieldKeys.size()) {
            SxField field;
            String name = (String)this.fieldKeys.elementAt(k2);
            if (name.startsWith("F_") && (field = this.getField(name)) != null && field.isVisible()) {
                StringBuffer contents = new StringBuffer();
                if (!field.isWithCombo()) {
                    contents.append(field.getText());
                } else {
                    JComboBox combo = (JComboBox)this.getComp(name);
                    int n = combo.getItemCount();
                    if (n == 0) {
                        contents.append(field.getText());
                    } else {
                        int i2 = 0;
                        while (i2 < n) {
                            contents.append((String)combo.getItemAt(i2));
                            if (i2 < n - 1) {
                                contents.append(", ");
                            }
                            ++i2;
                        }
                    }
                }
                if (field.hasSichten()) {
                    if (contents.length() == 0) {
                        contents.append("keine Einschr\u00e4nkung ");
                    }
                    if (!field.getSelectedSicht().isPerfectlyRegular()) {
                        contents.append(" (" + field.getSelectedSicht().getName() + ")");
                    }
                    if (field.getSelectedSicht().isStandbuttonWanted()) {
                        contents.append(" - Stand " + field.getSelectedSicht().getStand());
                    }
                }
                if (contents.length() > 0) {
                    if (isHtmlWanted) {
                        paramList.append(String.valueOf(html_bold_on) + name.substring(2) + html_bold_off);
                    } else {
                        paramList.append(name.substring(2));
                    }
                    paramList.append(" = " + contents.toString() + "; ");
                    if (!isHtmlWanted) {
                        paramList.append("\n");
                    }
                }
            }
            ++k2;
        }
        if (isHtmlWanted) {
            paramList.append(String.valueOf(html_bold_on) + "User" + html_bold_off + "=" + username + ";<br>");
        } else {
            paramList.append("User=" + username + "\n");
        }
        paramList.append(this.getHinweis());
        if (isHtmlWanted) {
            paramList.append(html_end);
        }
        return paramList.toString();
    }

    public void init() {
        this.sxForm.setBorder(BorderFactory.createEtchedBorder());
        this.pL = new SxPosLayout(this.distX, this.distY, this.diffX, this.diffY);
        this.pL.setPreferredSize(this.prefWidth, this.prefHeight);
        this.sxForm.setLayout(this.pL);
        this.sxForm.setFont(new Font("Arial", 0, 12));
        this.formMap = new Hashtable();
        this.fieldKeys = new Vector();
        this.errorMap = new Hashtable();
    }

    @Override
    public void removeAll() {
        super.removeAll();
        this.formMap.clear();
        this.fieldKeys.clear();
        this.errorMap.clear();
        this.defaultBtn = null;
        this.posX = 20;
        this.posY = 20;
    }

    public void removeComp(String name) {
        JComponent comp = this.getComp(name);
        if (comp == null) {
            return;
        }
        this.formMap.remove(comp);
        super.remove(comp);
        comp = null;
    }

    public void removeErrorComp(Component comp) {
        String err_name = comp.getName();
        if (err_name != null) {
            this.errorMap.remove(err_name);
        }
    }

    public void setCompXY(String comp_name, int pos_x, int pos_y) {
        JComponent comp = this.getComp(comp_name);
        if (comp == null) {
            return;
        }
        Dimension dim = ((Component)comp).getPreferredSize();
        this.pL.setPosition(comp, pos_x, pos_y, dim.width, dim.height);
    }

    public void setDefaultBtn(JButton btn) {
        this.defaultBtn = btn;
    }

    public void rememberSelectionsAsDefaults() {
        Enumeration en = this.formMap.keys();
        while (en.hasMoreElements()) {
            SxField field;
            String name = (String)en.nextElement();
            if (!name.startsWith("F_") || (field = this.getField(name)) == null) continue;
            name = name.substring(2);
            if (!field.isWithCombo()) {
                if (field.hasSichten()) {
                    name = String.valueOf(name) + "-Sicht" + field.getSelectedSicht().getId();
                }
                SxDefaults.addProperty(name, field.getKey(), field.getText());
                continue;
            }
            if (field.getKey() instanceof Object[]) {
                String[] keys = (String[])field.getKey();
                String[] values = new String[keys.length];
                JComboBox combo = (JComboBox)this.getComp("F_" + name);
                int n = combo.getItemCount();
                int i2 = 0;
                while (i2 < n) {
                    values[i2] = (String)combo.getItemAt(i2);
                    ++i2;
                }
                SxDefaults.addProperty(name, keys, values);
                continue;
            }
            SxDefaults.addProperty(name, field.getKey(), field.getText());
        }
    }

    public void setErlaubt(boolean erl) {
        this.isErlaubt = erl;
    }

    public void setFieldVector(Vector V_field) {
        this.fieldVector = V_field;
    }

    public void setLogo(SxLogoPanel alogo) {
        this.logo = alogo;
    }

    public void setPreferredCompHeight(String comp_name, int height) {
        JComponent comp = this.getComp(comp_name);
        if (comp == null) {
            return;
        }
        Dimension dim = comp.getPreferredSize();
        dim.height = height;
        comp.setPreferredSize(dim);
    }

    public void setPreferredCompWidth(String comp_name, int width) {
        JComponent comp = this.getComp(comp_name);
        if (comp == null) {
            return;
        }
        Dimension dim = comp.getPreferredSize();
        dim.width = width;
        comp.setPreferredSize(dim);
    }

    public void setPreferredSize(int width, int height) {
        this.prefWidth = width;
        this.prefHeight = height;
        this.pL.setPreferredSize(this.prefWidth, this.prefHeight);
    }

    public String getHinweis() {
        return this.hinweis != null ? this.hinweis : new String("");
    }

    public void setHinweis(Object Hinw) {
        this.hinweis = Hinw == null ? null : Hinw.toString();
    }

    String getDefaultStand() {
        String defaultstand = null;
        if (defaultstand == null) {
            defaultstand = DateUtils.getTodayString();
        }
        return defaultstand;
    }
}

