/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import proguard.classfile.Field;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;

public class ClassEditor {
    private static final boolean DEBUG = false;
    private ProgramClass targetClass;

    public ClassEditor(ProgramClass programClass) {
        this.targetClass = programClass;
    }

    public void addInterface(int n) {
        int[] nArray = this.targetClass.u2interfaces;
        int n2 = this.targetClass.u2interfacesCount;
        if (nArray.length <= n2) {
            this.targetClass.u2interfaces = new int[n2 + 1];
            System.arraycopy(nArray, 0, this.targetClass.u2interfaces, 0, n2);
            nArray = this.targetClass.u2interfaces;
        }
        nArray[this.targetClass.u2interfacesCount++] = n;
    }

    public void removeInterface(int n) {
        int n2 = this.targetClass.u2interfacesCount--;
        int[] nArray = this.targetClass.u2interfaces;
        int n3 = this.findInterfaceIndex(n);
        System.arraycopy(nArray, n3 + 1, nArray, n3, n2 - n3 - 1);
        nArray[this.targetClass.u2interfacesCount] = 0;
    }

    private int findInterfaceIndex(int n) {
        int n2 = this.targetClass.u2interfacesCount;
        int[] nArray = this.targetClass.u2interfaces;
        for (int i = 0; i < n2; ++i) {
            if (nArray[i] != n) continue;
            return i;
        }
        return n2;
    }

    public void addField(Field field) {
        ProgramField[] programFieldArray = this.targetClass.fields;
        int n = this.targetClass.u2fieldsCount;
        if (programFieldArray.length <= n) {
            this.targetClass.fields = new ProgramField[n + 1];
            System.arraycopy(programFieldArray, 0, this.targetClass.fields, 0, n);
            programFieldArray = this.targetClass.fields;
        }
        programFieldArray[this.targetClass.u2fieldsCount++] = field;
    }

    public void removeField(Field field) {
        int n = this.targetClass.u2fieldsCount--;
        ProgramField[] programFieldArray = this.targetClass.fields;
        int n2 = this.findFieldIndex(field);
        System.arraycopy(programFieldArray, n2 + 1, programFieldArray, n2, n - n2 - 1);
        programFieldArray[this.targetClass.u2fieldsCount] = null;
    }

    private int findFieldIndex(Field field) {
        int n = this.targetClass.u2fieldsCount;
        ProgramField[] programFieldArray = this.targetClass.fields;
        for (int i = 0; i < n; ++i) {
            if (!programFieldArray[i].equals(field)) continue;
            return i;
        }
        return n;
    }

    public void addMethod(Method method) {
        ProgramMethod[] programMethodArray = this.targetClass.methods;
        int n = this.targetClass.u2methodsCount;
        if (programMethodArray.length <= n) {
            this.targetClass.methods = new ProgramMethod[n + 1];
            System.arraycopy(programMethodArray, 0, this.targetClass.methods, 0, n);
            programMethodArray = this.targetClass.methods;
        }
        programMethodArray[this.targetClass.u2methodsCount++] = method;
    }

    public void removeMethod(Method method) {
        int n = this.targetClass.u2methodsCount--;
        ProgramMethod[] programMethodArray = this.targetClass.methods;
        int n2 = this.findMethodIndex(method);
        System.arraycopy(programMethodArray, n2 + 1, programMethodArray, n2, n - n2 - 1);
        programMethodArray[this.targetClass.u2methodsCount] = null;
    }

    private int findMethodIndex(Method method) {
        int n = this.targetClass.u2methodsCount;
        ProgramMethod[] programMethodArray = this.targetClass.methods;
        for (int i = 0; i < n; ++i) {
            if (!programMethodArray[i].equals(method)) continue;
            return i;
        }
        return n;
    }
}

