/*
 * Decompiled with CFR 0.152.
 */
package de.memtext.dlg;

import de.memtext.dlg.OkCancelClearDlg;
import de.memtext.util.WindowUtils;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;

public class NodeSelectionDlg
extends OkCancelClearDlg {
    private JTree tree;
    private Object selectedNode = null;
    private String title;

    public NodeSelectionDlg(Frame owner, String title, JTree tree) {
        super(owner, title);
        this.tree = tree;
        this.title = title;
        this.setCenter(new JScrollPane(tree));
        this.selectedNode = null;
        if (tree.getLastSelectedPathComponent() != null) {
            this.selectedNode = (TreeNode)tree.getLastSelectedPathComponent();
        }
        this.pack();
        WindowUtils.center(this);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                NodeSelectionDlg.this.exit();
            }
        });
    }

    @Override
    protected void exit() {
    }

    public NodeSelectionDlg(Frame owner, String title, DefaultTreeModel treeModel) {
        this(owner, title, new JTree(treeModel));
    }

    public NodeSelectionDlg(Frame owner, String title, TreeNode node) {
        this(owner, title, new JTree(node));
    }

    protected boolean isSelectedNodeOk(TreeNode testme) {
        return true;
    }

    @Override
    protected void performOk() {
        if (!this.isSelectedNodeOk((TreeNode)this.tree.getLastSelectedPathComponent())) {
            return;
        }
        this.selectedNode = this.tree.getLastSelectedPathComponent();
        this.setVisible(false);
    }

    @Override
    protected void performCancel() {
        this.setVisible(false);
    }

    public TreeNode getSelectedNode() {
        return this.selectedNode == null ? null : (TreeNode)this.selectedNode;
    }

    @Override
    protected void performClear() {
        this.selectedNode = null;
        this.tree.clearSelection();
        this.setVisible(false);
    }

    @Override
    public void setSize(Dimension dim) {
        super.setSize(dim);
        WindowUtils.center(this);
    }

    @Override
    public void setSize(int x, int y) {
        super.setSize(x, y);
        WindowUtils.center(this);
    }

    public static void main(String[] a) {
        NodeSelectionDlg t = new NodeSelectionDlg(null, "adsf", new JTree());
        t.pack();
        t.show();
        System.out.println(t.getSelectedNode());
        t.show();
        System.out.println(t.getSelectedNode());
    }

    public void setNode(TreeNode node) {
        this.tree.setModel(new DefaultTreeModel(node));
        this.selectedNode = null;
    }

    public void setCellRenderer(TreeCellRenderer renderer) {
        this.tree.setCellRenderer(renderer);
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public String getInfoText() {
        return this.title;
    }
}

