/*
 * Decompiled with CFR 0.152.
 */
package org.saiku.web.rest.objects.acl.enumeration;

import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum AclMethod {
    NONE,
    READ,
    WRITE,
    GRANT;


    public static AclMethod max(AclMethod method1, AclMethod method2) {
        if (method1 == null) {
            if (method2 == null) {
                throw new RuntimeException("cannot compare two null objects");
            }
            return method2;
        }
        if (AclMethod.toInt(method1) > AclMethod.toInt(method2)) {
            return method1;
        }
        return method2;
    }

    public static AclMethod min(AclMethod method1, AclMethod method2) {
        if (method1 == null) {
            if (method2 == null) {
                throw new RuntimeException("cannot compare two null objects");
            }
            return method2;
        }
        if (AclMethod.toInt(method1) < AclMethod.toInt(method2)) {
            return method1;
        }
        return method2;
    }

    public static AclMethod max(List<AclMethod> methods) {
        if (methods != null && methods.size() > 0) {
            AclMethod method = methods.get(0);
            for (int i = 1; i < methods.size(); ++i) {
                method = AclMethod.max(methods.get(i), method);
            }
            return method;
        }
        return NONE;
    }

    public static AclMethod min(List<AclMethod> methods) {
        if (methods != null && methods.size() > 0) {
            AclMethod method = methods.get(0);
            for (int i = 1; i < methods.size(); ++i) {
                method = AclMethod.min(methods.get(i), method);
            }
            return method;
        }
        return NONE;
    }

    public static int toInt(AclMethod method) {
        switch (method) {
            case NONE: {
                return 0;
            }
            case READ: {
                return 1;
            }
            case WRITE: {
                return 2;
            }
            case GRANT: {
                return 3;
            }
        }
        return -1;
    }
}

