/*
 * Decompiled with CFR 0.152.
 */
package org.saiku.olap.query;

import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang.StringUtils;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.olap4j.Axis;
import org.olap4j.metadata.Level;
import org.olap4j.metadata.Member;
import org.olap4j.query.QueryAxis;
import org.olap4j.query.QueryDimension;
import org.olap4j.query.Selection;
import org.saiku.olap.dto.SaikuCube;
import org.saiku.olap.query.IQuery;
import org.saiku.olap.query.OlapQuery;
import org.saiku.olap.util.exception.QueryParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuerySerializer {
    private IQuery query;
    Document dom;
    private SaikuCube saikuCube;

    public QuerySerializer(IQuery query) {
        this.query = query;
        this.saikuCube = query.getSaikuCube();
    }

    public String createXML() throws QueryParseException {
        if (this.query == null) {
            throw new QueryParseException("Query object can not be null");
        }
        try {
            this.createDocument();
            this.createDOMTree();
            XMLOutputter serializer = new XMLOutputter();
            Format format = Format.getPrettyFormat();
            StringWriter st = new StringWriter();
            serializer.setFormat(format);
            serializer.output(this.dom, (Writer)st);
            return st.getBuffer().toString();
        }
        catch (Exception e) {
            throw new QueryParseException(e.getMessage(), e);
        }
    }

    private void createDocument() throws ParserConfigurationException {
        this.dom = new Document();
    }

    private void createDOMTree() {
        Element rootEle = new Element("Query");
        if (StringUtils.isNotBlank((String)this.query.getName())) {
            rootEle.setAttribute("name", this.query.getName());
        }
        if (StringUtils.isNotBlank((String)this.query.getType().toString())) {
            rootEle.setAttribute("type", this.query.getType().toString());
        }
        String cubeName = this.query.getCube().getUniqueName();
        if (StringUtils.isNotBlank((String)this.saikuCube.getConnectionName())) {
            rootEle.setAttribute("connection", this.saikuCube.getConnectionName());
        }
        if (StringUtils.isNotBlank((String)cubeName)) {
            rootEle.setAttribute("cube", cubeName);
        }
        if (StringUtils.isNotBlank((String)this.saikuCube.getCatalogName())) {
            rootEle.setAttribute("catalog", this.saikuCube.getCatalogName());
        }
        if (StringUtils.isNotBlank((String)this.saikuCube.getSchemaName())) {
            rootEle.setAttribute("schema", this.saikuCube.getSchemaName());
        }
        if (IQuery.QueryType.QM.equals((Object)this.query.getType())) {
            rootEle = this.appendQmQuery(rootEle);
        }
        rootEle = this.appendMdxQuery(rootEle);
        rootEle = this.appendProperties(rootEle);
        this.dom.setRootElement(rootEle);
    }

    private Element appendQmQuery(Element rootElement) {
        if (this.query != null) {
            Element qm = new Element("QueryModel");
            qm = this.appendAxes(qm);
            rootElement.addContent((Content)qm);
        }
        return rootElement;
    }

    private Element appendMdxQuery(Element rootElement) {
        Element mdx = new Element("MDX");
        if (StringUtils.isNotBlank((String)this.query.getMdx())) {
            mdx.setText(this.query.getMdx());
        }
        rootElement.addContent((Content)mdx);
        return rootElement;
    }

    private Element appendProperties(Element rootElement) {
        Element props = new Element("Properties");
        Properties p = this.query.getProperties();
        if (p != null && !p.isEmpty()) {
            for (Object key : p.keySet()) {
                Element pe = new Element("Property");
                String k = key.toString();
                String v = p.getProperty(k);
                pe.setAttribute("name", k);
                pe.setAttribute("value", v);
                props.addContent((Content)pe);
            }
        }
        rootElement.addContent((Content)props);
        return rootElement;
    }

    private Element appendAxes(Element rootElement) {
        QueryAxis pages;
        QueryAxis filters;
        QueryAxis columns;
        Element axes = new Element("Axes");
        QueryAxis rows = ((OlapQuery)this.query).getAxes().get(Axis.ROWS);
        if (rows != null) {
            Element rowsElement = this.createAxisElement(rows);
            axes.addContent((Content)rowsElement);
        }
        if ((columns = ((OlapQuery)this.query).getAxes().get(Axis.COLUMNS)) != null) {
            Element columnsElement = this.createAxisElement(columns);
            axes.addContent((Content)columnsElement);
        }
        if ((filters = ((OlapQuery)this.query).getAxes().get(Axis.FILTER)) != null) {
            Element filtersElement = this.createAxisElement(filters);
            axes.addContent((Content)filtersElement);
        }
        if ((pages = ((OlapQuery)this.query).getAxes().get(Axis.PAGES)) != null) {
            Element pagesElement = this.createAxisElement(pages);
            axes.addContent((Content)pagesElement);
        }
        rootElement.addContent((Content)axes);
        return rootElement;
    }

    private Element createAxisElement(QueryAxis axis) {
        Element axisElement = new Element("Axis");
        axisElement.setAttribute("location", this.getAxisName(axis));
        axisElement.setAttribute("nonEmpty", "" + axis.isNonEmpty());
        if (axis.getSortOrder() != null) {
            axisElement.setAttribute("sortOrder", axis.getSortOrder().toString());
        }
        if (StringUtils.isNotBlank((String)axis.getSortIdentifierNodeName())) {
            axisElement.setAttribute("sortEvaluationLiteral", axis.getSortIdentifierNodeName());
        }
        try {
            if (axis.getLimitFunction() != null) {
                axisElement.setAttribute("limitFunction", axis.getLimitFunction().toString());
            }
            if (axis.getLimitFunctionN() != null) {
                axisElement.setAttribute("limitFunctionN", axis.getLimitFunctionN().toPlainString());
            }
            if (StringUtils.isNotBlank((String)axis.getLimitFunctionSortLiteral())) {
                axisElement.setAttribute("limitFunctionSortLiteral", axis.getLimitFunctionSortLiteral());
            }
            if (StringUtils.isNotBlank((String)axis.getFilterCondition())) {
                axisElement.setAttribute("filterCondition", axis.getFilterCondition());
            }
        }
        catch (Error e) {
            // empty catch block
        }
        Element dimensions = new Element("Dimensions");
        for (QueryDimension dim : axis.getDimensions()) {
            Element d = this.createDimensionElement(dim);
            dimensions.addContent((Content)d);
        }
        if (axis.getDimensions().size() > 0) {
            axisElement.addContent((Content)dimensions);
        }
        return axisElement;
    }

    private Element createDimensionElement(QueryDimension dim) {
        Element dimension = new Element("Dimension");
        dimension.setAttribute("name", dim.getDimension().getName());
        if (dim.getSortOrder() != null) {
            dimension.setAttribute("sortOrder", dim.getSortOrder().toString());
        }
        if (dim.getHierarchizeMode() != null) {
            dimension.setAttribute("hierarchizeMode", dim.getHierarchizeMode().toString());
        }
        if (dim.getHierarchizeMode() != null) {
            dimension.setAttribute("hierarchyConsistent", "" + dim.isHierarchyConsistent());
        }
        Element inclusionsElement = new Element("Inclusions");
        List inclusions = dim.getInclusions();
        inclusionsElement = this.createSelectionsElement(inclusionsElement, inclusions);
        dimension.addContent((Content)inclusionsElement);
        Element exclusionsElement = new Element("Exclusions");
        List exclusions = dim.getExclusions();
        inclusionsElement = this.createSelectionsElement(exclusionsElement, exclusions);
        dimension.addContent((Content)inclusionsElement);
        return dimension;
    }

    private Element createSelectionsElement(Element rootElement, List<Selection> selections) {
        for (Selection sel : selections) {
            Element selection = new Element("Selection");
            if (sel.getDimension() != null) {
                selection.setAttribute("dimension", sel.getDimension().getName());
            }
            if (sel.getRootElement() instanceof Level) {
                selection.setAttribute("type", "level");
            } else if (sel.getRootElement() instanceof Member) {
                selection.setAttribute("type", "member");
            }
            selection.setAttribute("node", sel.getUniqueName());
            selection.setAttribute("operator", sel.getOperator().toString());
            if (sel.getSelectionContext() != null && sel.getSelectionContext().size() > 0) {
                Element context = new Element("Context");
                context = this.createSelectionsElement(context, sel.getSelectionContext());
                selection.addContent((Content)context);
            }
            rootElement.addContent((Content)selection);
        }
        return rootElement;
    }

    public String getAxisName(QueryAxis axis) {
        switch (axis.getLocation().axisOrdinal()) {
            case -1: {
                return "FILTER";
            }
            case 0: {
                return "COLUMNS";
            }
            case 1: {
                return "ROWS";
            }
            case 2: {
                return "PAGES";
            }
            case 3: {
                return "CHAPTERS";
            }
            case 4: {
                return "SECTIONS";
            }
        }
        throw new RuntimeException("Unsupported Axis-Ordinal: " + axis.getLocation().axisOrdinal());
    }
}

