/*
 * Decompiled with CFR 0.152.
 */
package org.saiku.datasources.connection;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.olap4j.OlapConnection;
import org.saiku.datasources.connection.IConnectionManager;
import org.saiku.datasources.connection.IConnectionProcessor;
import org.saiku.datasources.connection.ISaikuConnection;
import org.saiku.datasources.datasource.SaikuDatasource;
import org.saiku.service.datasource.IDatasourceManager;
import org.saiku.service.datasource.IDatasourceProcessor;
import org.saiku.service.util.exception.SaikuServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConnectionManager
implements IConnectionManager {
    private IDatasourceManager ds;

    @Override
    public void setDataSourceManager(IDatasourceManager ds) {
        this.ds = ds;
    }

    @Override
    public IDatasourceManager getDataSourceManager() {
        return this.ds;
    }

    public abstract void init();

    private SaikuDatasource preProcess(SaikuDatasource datasource) {
        if (datasource.getProperties().containsKey("datasource.processors")) {
            String[] processors;
            datasource = datasource.clone();
            for (String processor : processors = datasource.getProperties().getProperty("datasource.processors").split(",")) {
                try {
                    Class<?> clazz = Class.forName(processor);
                    Constructor<?> ctor = clazz.getConstructor(new Class[0]);
                    IDatasourceProcessor dsProcessor = (IDatasourceProcessor)ctor.newInstance(new Object[0]);
                    datasource = dsProcessor.process(datasource);
                }
                catch (Exception e) {
                    throw new SaikuServiceException("Error applying DatasourceProcessor \"" + processor + "\"", e);
                }
            }
        }
        return datasource;
    }

    private ISaikuConnection postProcess(SaikuDatasource datasource, ISaikuConnection con) {
        String[] processors;
        String[] arr$;
        int len$;
        int i$;
        if (datasource.getProperties().containsKey("connection.processors") && (i$ = 0) < (len$ = (arr$ = (processors = (datasource = datasource.clone()).getProperties().getProperty("connection.processors").split(","))).length)) {
            String processor = arr$[i$];
            try {
                Class<?> clazz = Class.forName(processor);
                Constructor<?> ctor = clazz.getConstructor(new Class[0]);
                IConnectionProcessor conProcessor = (IConnectionProcessor)ctor.newInstance(new Object[0]);
                return conProcessor.process(con);
            }
            catch (Exception e) {
                throw new SaikuServiceException("Error applying ConnectionProcessor \"" + processor + "\"", e);
            }
        }
        return con;
    }

    @Override
    public ISaikuConnection getConnection(String name) {
        SaikuDatasource datasource = this.ds.getDatasource(name);
        datasource = this.preProcess(datasource);
        ISaikuConnection con = this.getInternalConnection(name, datasource);
        con = this.postProcess(datasource, con);
        return con;
    }

    protected abstract ISaikuConnection getInternalConnection(String var1, SaikuDatasource var2);

    protected abstract ISaikuConnection refreshInternalConnection(String var1, SaikuDatasource var2);

    @Override
    public void refreshAllConnections() {
        this.ds.load();
        for (String name : this.ds.getDatasources().keySet()) {
            this.refreshConnection(name);
        }
    }

    @Override
    public void refreshConnection(String name) {
        SaikuDatasource datasource = this.ds.getDatasource(name);
        datasource = this.preProcess(datasource);
        ISaikuConnection con = this.refreshInternalConnection(name, datasource);
        con = this.postProcess(datasource, con);
    }

    @Override
    public Map<String, ISaikuConnection> getAllConnections() {
        HashMap<String, ISaikuConnection> resultDs = new HashMap<String, ISaikuConnection>();
        for (String name : this.ds.getDatasources().keySet()) {
            ISaikuConnection con = this.getConnection(name);
            if (con == null) continue;
            resultDs.put(name, con);
        }
        return resultDs;
    }

    @Override
    public OlapConnection getOlapConnection(String name) {
        Object o;
        ISaikuConnection con = this.getConnection(name);
        if (con != null && (o = con.getConnection()) != null && o instanceof OlapConnection) {
            return (OlapConnection)o;
        }
        return null;
    }

    @Override
    public Map<String, OlapConnection> getAllOlapConnections() {
        Map<String, ISaikuConnection> connections = this.getAllConnections();
        HashMap<String, OlapConnection> ocons = new HashMap<String, OlapConnection>();
        for (ISaikuConnection con : connections.values()) {
            Object o = con.getConnection();
            if (o == null || !(o instanceof OlapConnection)) continue;
            ocons.put(con.getName(), (OlapConnection)o);
        }
        return ocons;
    }

    public boolean isDatasourceSecurity(SaikuDatasource datasource, String value) {
        Properties props;
        if (datasource != null && value != null && (props = datasource.getProperties()) != null && this.isDatasourceSecurityEnabled(datasource) && props.containsKey("security.type")) {
            return props.getProperty("security.type").equals(value);
        }
        return false;
    }

    public boolean isDatasourceSecurityEnabled(SaikuDatasource datasource) {
        Properties props;
        if (datasource != null && (props = datasource.getProperties()) != null && props.containsKey("security.enabled")) {
            String enabled = props.getProperty("security.enabled", "false");
            boolean isSecurity = Boolean.parseBoolean(enabled);
            return isSecurity;
        }
        return false;
    }
}

