/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.parser;

import de.statspez.pleditor.generator.common.AbstractMessage;
import de.statspez.pleditor.generator.common.ElementMessageContext;
import de.statspez.pleditor.generator.common.MessageContextInterface;
import de.statspez.pleditor.generator.meta.MetaCustomAblauf;
import de.statspez.pleditor.generator.meta.MetaCustomFunktion;
import de.statspez.pleditor.generator.meta.MetaCustomInitwert;
import de.statspez.pleditor.generator.meta.MetaCustomPruefung;
import de.statspez.pleditor.generator.meta.MetaCustomTBFeld;
import de.statspez.pleditor.generator.meta.MetaCustomThemenbereich;
import de.statspez.pleditor.generator.meta.MetaCustomVariable;
import de.statspez.pleditor.generator.meta.MetaElement;
import de.statspez.pleditor.generator.meta.MetaProgram;
import de.statspez.pleditor.generator.meta.generated.MetaPLInitwert;
import de.statspez.pleditor.generator.meta.generated.MetaTBFeld;
import de.statspez.pleditor.generator.meta.generated.MetaTBMaterialReferenz;
import de.statspez.pleditor.generator.parser.AblaufParser;
import de.statspez.pleditor.generator.parser.FeldParser;
import de.statspez.pleditor.generator.parser.FunctionParser;
import de.statspez.pleditor.generator.parser.ILParseException;
import de.statspez.pleditor.generator.parser.InitwerteParser;
import de.statspez.pleditor.generator.parser.MaterialLinkParser;
import de.statspez.pleditor.generator.parser.ObjectContextParser;
import de.statspez.pleditor.generator.parser.ParserChain;
import de.statspez.pleditor.generator.parser.PropertiesParser;
import de.statspez.pleditor.generator.parser.PruefungParser;
import de.statspez.pleditor.generator.parser.Resolver;
import de.statspez.pleditor.generator.parser.SubParser;
import de.statspez.pleditor.generator.parser.SuperParser;
import de.statspez.pleditor.generator.parser.VariablenParser;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ThemenbereichParser
extends SubParser
implements SuperParser {
    private MetaCustomThemenbereich currentTb = null;
    private ParserChain parserChain = new ParserChain();
    private FeldParser feldParser;
    private PruefungParser pruefungParser;
    private VariablenParser variablenParser;
    private InitwerteParser initwerteParser;
    private AblaufParser ablaufParser;
    private FunctionParser functionParser;
    private PropertiesParser propertiesParser;
    private ObjectContextParser objectContextParser;
    private MaterialLinkParser materialLinkParser;

    public ThemenbereichParser(SuperParser sParser, Resolver resolver) {
        super(sParser, resolver);
        this.propertiesParser = new PropertiesParser(this, resolver);
        this.parserChain.addParser(this.propertiesParser);
        this.objectContextParser = new ObjectContextParser(this, resolver);
        this.parserChain.addParser(this.objectContextParser);
        this.feldParser = new FeldParser(this, resolver);
        this.parserChain.addParser(this.feldParser);
        this.pruefungParser = new PruefungParser(this, resolver);
        this.parserChain.addParser(this.pruefungParser);
        this.variablenParser = new VariablenParser(this, resolver);
        this.parserChain.addParser(this.variablenParser);
        this.initwerteParser = new InitwerteParser(this, resolver);
        this.parserChain.addParser(this.initwerteParser);
        this.ablaufParser = new AblaufParser(this, resolver);
        this.parserChain.addParser(this.ablaufParser);
        this.functionParser = new FunctionParser(this, resolver);
        this.parserChain.addParser(this.functionParser);
        this.materialLinkParser = new MaterialLinkParser(this, resolver);
        this.parserChain.addParser(this.materialLinkParser);
    }

    @Override
    public boolean canHandleOpenTag(String namespaceURI, String tag) {
        if ("http://www.werum.de/pl-editor".equalsIgnoreCase(namespaceURI) && "topic".equalsIgnoreCase(tag)) {
            return true;
        }
        return this.isEnabled();
    }

    @Override
    public boolean canHandleClosedTag(String namespaceURI, String tag) {
        return this.isEnabled();
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if ("topic".equalsIgnoreCase(localName)) {
            this.enable();
            this.currentTb = new MetaCustomThemenbereich();
            this.propertiesParser.setCurrentElement(this.currentTb);
            this.objectContextParser.setCurrentElement(this.currentTb);
        } else if (!this.parserChain.startElement(namespaceURI, localName, qName, atts)) {
            throw ILParseException.unknownTagException(localName);
        }
        this.handleAttributes(namespaceURI, localName, qName, atts);
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if ("topic".equalsIgnoreCase(localName)) {
            this.disableAndNotify();
        } else if (!this.parserChain.endElement(namespaceURI, localName, qName) && !this.handleTag(namespaceURI, localName, qName)) {
            throw ILParseException.unknownTagException(localName);
        }
    }

    @Override
    public MetaElement object() {
        return this.currentTb;
    }

    @Override
    public void notifyObjectAvailable(SubParser aParser) {
        if (aParser == this.feldParser) {
            MetaTBFeld aFeld = (MetaTBFeld)this.feldParser.object();
            this.currentTb.addToFelder(aFeld);
            ((MetaCustomTBFeld)aFeld).setThemenbereich(this.currentTb);
        } else if (aParser == this.pruefungParser) {
            MetaCustomPruefung aPruefung = (MetaCustomPruefung)this.pruefungParser.object();
            this.currentTb.addToPruefungen(aPruefung);
            aPruefung.setThemenbereich(this.currentTb);
            this.setContextInfos(aPruefung.getMetaSpezifikation(), new ElementMessageContext(1, aPruefung.getId(), aPruefung.getPruefschluessel(), 6, this.currentTb.getId(), this.currentTb.getName()));
        } else if (aParser == this.variablenParser) {
            MetaCustomVariable aVariable = (MetaCustomVariable)this.variablenParser.object();
            this.currentTb.addToVariablen(aVariable);
            aVariable.setThemenbereich(this.currentTb);
            this.setContextInfos(aVariable.getMetaBelegung(), new ElementMessageContext(6, this.currentTb.getId(), this.currentTb.getName(), "(Variable " + aVariable.getName() + ")"));
        } else if (aParser == this.initwerteParser) {
            MetaPLInitwert anInitwert = (MetaPLInitwert)this.initwerteParser.object();
            this.currentTb.addToInitialisierungswerte(anInitwert);
            ((MetaCustomInitwert)anInitwert).setThemenbereich(this.currentTb);
        } else if (aParser == this.ablaufParser) {
            MetaCustomAblauf anAblauf = (MetaCustomAblauf)this.ablaufParser.object();
            this.currentTb.addToAblaeufe(anAblauf);
            anAblauf.setThemenbereich(this.currentTb);
            this.setContextInfos(anAblauf.getMetaSpezifikation(), new ElementMessageContext(2, anAblauf.getId(), anAblauf.getName(), 6, this.currentTb.getId(), this.currentTb.getName()));
        } else if (aParser == this.functionParser) {
            MetaCustomFunktion aFunktion = (MetaCustomFunktion)this.functionParser.object();
            this.currentTb.addToFunktionen(aFunktion);
            aFunktion.setThemenbereich(this.currentTb);
            int contextType = 4;
            if (aFunktion.getFunctionType() == 1) {
                contextType = 3;
            }
            this.setContextInfos(aFunktion.getMetaSpezifikation(), new ElementMessageContext(contextType, aFunktion.getId(), aFunktion.getName(), 6, this.currentTb.getId(), this.currentTb.getName()));
        } else if (aParser == this.materialLinkParser) {
            MetaTBMaterialReferenz anReferenz = (MetaTBMaterialReferenz)this.materialLinkParser.object();
            this.currentTb.addToMaterialreferenzen(anReferenz);
        }
    }

    @Override
    public StringBuffer charData() {
        return this.superParser().charData();
    }

    @Override
    public String parentElement() {
        return this.superParser().parentElement();
    }

    private void handleAttributes(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if ("topic".equalsIgnoreCase(localName)) {
            String name = atts.getValue("name");
            if (name == null) {
                throw new ILParseException("Fuer den Themenbereich ist kein Name definiert!");
            }
            this.currentTb.setName(name.trim());
            String str = atts.getValue("id");
            if (str != null && str.trim().length() > 0 && this.resolver().isUseIDasRef()) {
                this.currentTb.setId(str.trim());
            } else {
                this.currentTb.setId(name);
            }
            String state = atts.getValue("state");
            if (state != null && state.trim().equals("approved")) {
                this.currentTb.setFreigabeStatus((short)1);
            }
        }
    }

    private boolean handleTag(String namespaceURI, String localName, String qName) {
        return false;
    }

    private void setContextInfos(MetaProgram prog, MessageContextInterface context) {
        if (prog != null) {
            prog.setContextInfos(context);
        }
    }

    @Override
    public void error(AbstractMessage errorMessage) {
        this.superParser().error(errorMessage);
    }

    @Override
    public String getKontextPath() {
        String kontext = super.getKontextPath();
        if (this.currentTb != null && this.currentTb.getName() != null) {
            kontext = String.valueOf(kontext) + (kontext != null && kontext.trim().length() > 0 ? "," : "") + "Themenbereich " + this.currentTb.getName();
        }
        return kontext;
    }
}

