/*
 * Decompiled with CFR 0.152.
 */
package org.olap4j.impl;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.RandomAccess;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.olap4j.impl.AbstractNamedList;
import org.olap4j.impl.Olap4jUtilCompatible;
import org.olap4j.metadata.NamedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Olap4jUtil {
    public static final boolean PreJdk15 = System.getProperty("java.version").startsWith("1.4");
    public static final boolean Retrowoven = DummyEnum.class.getSuperclass().getName().equals("com.rc.retroweaver.runtime.Enum_");
    private static final Olap4jUtilCompatible compatible;
    private static final NamedList<?> EMPTY_NAMED_LIST;
    private static final Pattern CELL_VALUE_REGEX1;
    private static final Pattern CELL_VALUE_REGEX2;

    public static void discard(boolean b) {
    }

    public static void discard(byte b) {
    }

    public static void discard(char c) {
    }

    public static void discard(double v) {
    }

    public static void discard(float v) {
    }

    public static void discard(int i) {
    }

    public static void discard(long l) {
    }

    public static void discard(Object o) {
    }

    public static void discard(short i) {
    }

    public static <T> Set<T> cast(Set<?> set) {
        return set;
    }

    public static <T> List<T> cast(List<?> list) {
        return list;
    }

    public static <T> NamedList<T> cast(NamedList<?> list) {
        return list;
    }

    public static <K, V> Map<K, V> mapOf(K key, V value, Object ... keyValues) {
        LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>(1 + keyValues.length);
        map.put(key, value);
        int i = 0;
        while (i < keyValues.length) {
            map.put(keyValues[i++], keyValues[i++]);
        }
        return map;
    }

    public static Map<String, String> toMap(final Properties properties) {
        return new AbstractMap<String, String>(){

            @Override
            public Set<Map.Entry<String, String>> entrySet() {
                return Olap4jUtil.cast(properties.entrySet());
            }
        };
    }

    public static AssertionError unexpected(Enum value) {
        return new AssertionError((Object)("Was not expecting value '" + value + "' for enumeration '" + value.getClass().getName() + "' in this context"));
    }

    public static <T> boolean equal(T t1, T t2) {
        return t1 == null ? t2 == null : t1.equals(t2);
    }

    public static String replace(String s, String find, String replace) {
        int found = s.indexOf(find);
        if (found == -1) {
            return s;
        }
        StringBuilder sb = new StringBuilder(s.length() + 20);
        int start = 0;
        char[] chars = s.toCharArray();
        int step = find.length();
        if (step == 0) {
            sb.append(s);
            Olap4jUtil.replace(sb, 0, find, replace);
        } else {
            while (true) {
                sb.append(chars, start, found - start);
                if (found == s.length()) break;
                sb.append(replace);
                start = found + step;
                if ((found = s.indexOf(find, start)) != -1) continue;
                found = s.length();
            }
        }
        return sb.toString();
    }

    public static StringBuilder replace(StringBuilder buf, int start, String find, String replace) {
        int i;
        int findLength = find.length();
        if (findLength == 0) {
            for (int j = buf.length(); j >= 0; --j) {
                buf.insert(j, replace);
            }
            return buf;
        }
        int k = buf.length();
        while (k > 0 && (i = buf.lastIndexOf(find, k)) >= start) {
            buf.replace(i, i + find.length(), replace);
            k = i - findLength;
        }
        return buf;
    }

    public static String wildcardToRegexp(List<String> wildcards) {
        StringBuilder buf = new StringBuilder();
        block0: for (String value : wildcards) {
            if (buf.length() > 0) {
                buf.append('|');
            }
            int i = 0;
            while (true) {
                int percent = value.indexOf(37, i);
                int underscore = value.indexOf(95, i);
                if (percent == -1 && underscore == -1) {
                    if (i >= value.length()) continue block0;
                    buf.append(Olap4jUtil.quotePattern(value.substring(i)));
                    continue block0;
                }
                if (underscore >= 0 && (underscore < percent || percent < 0)) {
                    if (i < underscore) {
                        buf.append(Olap4jUtil.quotePattern(value.substring(i, underscore)));
                    }
                    buf.append('.');
                    i = underscore + 1;
                    continue;
                }
                if (percent < 0 || percent >= underscore && underscore >= 0) break;
                if (i < percent) {
                    buf.append(Olap4jUtil.quotePattern(value.substring(i, percent)));
                }
                buf.append(".*");
                i = percent + 1;
            }
            throw new IllegalArgumentException();
        }
        return buf.toString();
    }

    public static String quotePattern(String s) {
        return compatible.quotePattern(s);
    }

    public static String camelToUpper(String s) {
        StringBuilder buf = new StringBuilder(s.length() + 10);
        int prevUpper = -1;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (Character.isUpperCase(c)) {
                if (i > prevUpper + 1) {
                    buf.append('_');
                }
                prevUpper = i;
            } else {
                c = Character.toUpperCase(c);
            }
            buf.append(c);
        }
        return buf.toString();
    }

    public static RuntimeException needToImplement(Object o) {
        throw new UnsupportedOperationException("need to implement " + o);
    }

    public static List<String> parseUniqueName(String uniqueName) {
        ArrayList<String> trail = new ArrayList<String>();
        Pattern regex = Pattern.compile("([^\\[\\]\\.]*)");
        Matcher matcher = regex.matcher(uniqueName);
        while (matcher.find()) {
            String match = matcher.group();
            if (match.equals("")) continue;
            trail.add(match);
        }
        return trail;
    }

    public static String stringArrayToString(String[] array) {
        StringBuilder sb = new StringBuilder("[");
        for (int i = 0; i < array.length; ++i) {
            sb.append(array[i]);
            if (i >= array.length - 1) continue;
            sb.append(",");
        }
        sb.append("]");
        return sb.toString();
    }

    public static <T> NamedList<T> emptyNamedList() {
        return EMPTY_NAMED_LIST;
    }

    public static <T> NamedList<T> unmodifiableNamedList(NamedList<T> list) {
        return list instanceof RandomAccess ? new UnmodifiableNamedRandomAccessList<T>(list) : new UnmodifiableNamedList<T>(list);
    }

    public static <E extends Enum<E>> Set<E> enumSetOf(E first, E ... rest) {
        return compatible.enumSetOf(first, (Enum[])rest);
    }

    public static <E extends Enum<E>> Set<E> enumSetNoneOf(Class<E> elementType) {
        return compatible.enumSetNoneOf(elementType);
    }

    public static <E extends Enum<E>> Set<E> enumSetAllOf(Class<E> elementType) {
        return compatible.enumSetAllOf(elementType);
    }

    public static String parseFormattedCellValue(String formattedValue, Map<String, String> map) {
        if (formattedValue.startsWith("|")) {
            String[] strs = formattedValue.substring(1).split("\\|");
            formattedValue = strs[0];
            for (int i = 1; i < strs.length; ++i) {
                String propValue;
                String propName;
                Matcher m = CELL_VALUE_REGEX1.matcher(strs[i]);
                if (m.matches()) {
                    propName = m.group(1);
                    propValue = m.group(2);
                    map.put(propName, propValue);
                    continue;
                }
                m = CELL_VALUE_REGEX2.matcher(strs[i]);
                if (m.matches()) {
                    propName = m.group(1);
                    propValue = m.group(2);
                    map.put(propName, propValue);
                    continue;
                }
                formattedValue = formattedValue + strs[i];
            }
        }
        return formattedValue;
    }

    static {
        EMPTY_NAMED_LIST = new EmptyNamedList();
        CELL_VALUE_REGEX1 = Pattern.compile("\\s*([a-zA-Z][\\w\\.]*)\\s*=\\s*'([^']*)'");
        CELL_VALUE_REGEX2 = Pattern.compile("\\s*([a-zA-Z][\\w\\.]*)\\s*=\\s*([^\\s]*)");
        String className = PreJdk15 || Retrowoven ? "org.olap4j.impl.Olap4jUtilCompatibleJdk14" : "org.olap4j.impl.Olap4jUtilCompatibleJdk15";
        try {
            Class<?> clazz = Class.forName(className);
            compatible = (Olap4jUtilCompatible)clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Could not load '" + className + "'", e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Could not load '" + className + "'", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Could not load '" + className + "'", e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UnmodifiableNamedRandomAccessList<T>
    extends UnmodifiableNamedList<T>
    implements RandomAccess {
        UnmodifiableNamedRandomAccessList(NamedList<T> list) {
            super(list);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UnmodifiableNamedList<T>
    implements NamedList<T> {
        private final NamedList<T> list;

        UnmodifiableNamedList(NamedList<T> list) {
            this.list = list;
        }

        @Override
        public T get(String s) {
            return this.list.get(s);
        }

        @Override
        public int indexOfName(String s) {
            return this.list.indexOfName(s);
        }

        @Override
        public String getName(Object element) {
            return this.list.getName(element);
        }

        @Override
        public Map<String, T> asMap() {
            return Collections.unmodifiableMap(this.list.asMap());
        }

        @Override
        public int size() {
            return this.list.size();
        }

        @Override
        public boolean isEmpty() {
            return this.list.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.list.contains(o);
        }

        @Override
        public Iterator<T> iterator() {
            return Collections.unmodifiableList(this.list).iterator();
        }

        @Override
        public Object[] toArray() {
            return this.list.toArray();
        }

        @Override
        public <T2> T2[] toArray(T2[] a) {
            return this.list.toArray(a);
        }

        @Override
        public boolean add(T t) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends T> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(int index, Collection<? extends T> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public T get(int index) {
            return (T)this.list.get(index);
        }

        @Override
        public T set(int index, T element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(int index, T element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public T remove(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int indexOf(Object o) {
            return this.list.indexOf(0);
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.list.lastIndexOf(o);
        }

        @Override
        public ListIterator<T> listIterator() {
            return Collections.unmodifiableList(this.list).listIterator();
        }

        @Override
        public ListIterator<T> listIterator(int index) {
            return Collections.unmodifiableList(this.list).listIterator(index);
        }

        @Override
        public List<T> subList(int fromIndex, int toIndex) {
            return Collections.unmodifiableList(this.list.subList(fromIndex, toIndex));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EmptyNamedList<T>
    extends AbstractNamedList<T> {
        private EmptyNamedList() {
        }

        @Override
        public String getName(Object element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public T get(int index) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }

        private Object readResolve() {
            return EMPTY_NAMED_LIST;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum DummyEnum {

    }
}

