/*
 * Decompiled with CFR 0.152.
 */
package mondrian.util;

import java.util.Calendar;
import mondrian.util.DateSchedule;
import mondrian.util.ScheduleUtil;

class DailyDateSchedule
implements DateSchedule {
    int period;
    int beginOrdinal;

    DailyDateSchedule(Calendar begin, int period) {
        this.period = period;
        ScheduleUtil.assertTrue(period > 0, "period must be positive");
        this.beginOrdinal = ScheduleUtil.julianDay(begin == null ? ScheduleUtil.epochDay : begin);
    }

    @Override
    public Calendar nextOccurrence(Calendar day, boolean strict) {
        day = (Calendar)day.clone();
        if (strict) {
            day.add(5, 1);
        }
        int ordinal;
        while (((ordinal = ScheduleUtil.julianDay(day)) - this.beginOrdinal) % this.period != 0) {
            day.add(5, 1);
        }
        return day;
    }
}

