/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.agg;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import mondrian.rolap.CellKey;
import mondrian.rolap.SqlStatement;
import mondrian.rolap.agg.SegmentDataset;
import mondrian.rolap.agg.SegmentLoader;
import mondrian.rolap.agg.SparseSegmentBody;
import mondrian.spi.SegmentBody;
import mondrian.util.Pair;

class SparseSegmentDataset
implements SegmentDataset {
    private final Map<CellKey, Object> values;

    SparseSegmentDataset() {
        this(new HashMap<CellKey, Object>());
    }

    SparseSegmentDataset(Map<CellKey, Object> values) {
        this.values = values;
    }

    @Override
    public Object getObject(CellKey pos) {
        return this.values.get(pos);
    }

    @Override
    public boolean isNull(CellKey pos) {
        return this.values.get(pos) == null;
    }

    @Override
    public int getInt(CellKey pos) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getDouble(CellKey pos) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean exists(CellKey pos) {
        return this.values.containsKey(pos);
    }

    public void put(CellKey key, Object value) {
        this.values.put(key, value);
    }

    @Override
    public Iterator<Map.Entry<CellKey, Object>> iterator() {
        return this.values.entrySet().iterator();
    }

    @Override
    public double getBytes() {
        return this.values.size() * 12;
    }

    @Override
    public void populateFrom(int[] pos, SegmentDataset data, CellKey key) {
        this.values.put(CellKey.Generator.newCellKey(pos), data.getObject(key));
    }

    @Override
    public void populateFrom(int[] pos, SegmentLoader.RowList rowList, int column) {
        Object o = rowList.getObject(column);
        this.put(CellKey.Generator.newCellKey(pos), o);
    }

    @Override
    public SqlStatement.Type getType() {
        return SqlStatement.Type.OBJECT;
    }

    @Override
    public SegmentBody createSegmentBody(List<Pair<SortedSet<Comparable>, Boolean>> axes) {
        return new SparseSegmentBody(this.values, axes);
    }
}

