/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.Map;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.HierarchyCalc;
import mondrian.calc.impl.AbstractMemberCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.Hierarchy;
import mondrian.olap.Member;
import mondrian.olap.fun.FunDefBase;
import mondrian.rolap.RolapHierarchy;

public class HierarchyCurrentMemberFunDef
extends FunDefBase {
    static final HierarchyCurrentMemberFunDef instance = new HierarchyCurrentMemberFunDef();

    private HierarchyCurrentMemberFunDef() {
        super("CurrentMember", "Returns the current member along a hierarchy during an iteration.", "pmh");
    }

    @Override
    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        HierarchyCalc hierarchyCalc = compiler.compileHierarchy(call.getArg(0));
        Hierarchy hierarchy = hierarchyCalc.getType().getHierarchy();
        if (hierarchy != null) {
            return new FixedCalcImpl((Exp)call, hierarchy);
        }
        return new CalcImpl((Exp)call, hierarchyCalc);
    }

    public static class FixedCalcImpl
    extends AbstractMemberCalc {
        private final RolapHierarchy hierarchy;

        public FixedCalcImpl(Exp exp, Hierarchy hierarchy) {
            super(exp, new Calc[0]);
            assert (hierarchy != null);
            this.hierarchy = (RolapHierarchy)hierarchy;
        }

        @Override
        protected String getName() {
            return "CurrentMemberFixed";
        }

        @Override
        public Member evaluateMember(Evaluator evaluator) {
            return evaluator.getContext(this.hierarchy);
        }

        @Override
        public boolean dependsOn(Hierarchy hierarchy) {
            return this.hierarchy == hierarchy;
        }

        @Override
        public void collectArguments(Map<String, Object> arguments) {
            arguments.put("hierarchy", this.hierarchy);
            super.collectArguments(arguments);
        }
    }

    public static class CalcImpl
    extends AbstractMemberCalc {
        private final HierarchyCalc hierarchyCalc;

        public CalcImpl(Exp exp, HierarchyCalc hierarchyCalc) {
            super(exp, new Calc[]{hierarchyCalc});
            this.hierarchyCalc = hierarchyCalc;
        }

        @Override
        protected String getName() {
            return "CurrentMember";
        }

        @Override
        public Member evaluateMember(Evaluator evaluator) {
            Hierarchy hierarchy = this.hierarchyCalc.evaluateHierarchy(evaluator);
            return evaluator.getContext(hierarchy);
        }

        @Override
        public boolean dependsOn(Hierarchy hierarchy) {
            return this.hierarchyCalc.getType().usesHierarchy(hierarchy, false);
        }
    }
}

