/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.pgpencryptstream;

import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.entries.pgpencryptfiles.GPG;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.pgpencryptstream.PGPEncryptStreamData;
import org.pentaho.di.trans.steps.pgpencryptstream.PGPEncryptStreamMeta;

public class PGPEncryptStream
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = PGPEncryptStreamMeta.class;
    private PGPEncryptStreamMeta meta;
    private PGPEncryptStreamData data;

    public PGPEncryptStream(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        block18: {
            this.meta = (PGPEncryptStreamMeta)smi;
            this.data = (PGPEncryptStreamData)sdi;
            boolean sendToErrorRow = false;
            String errorMessage = null;
            Object[] r = this.getRow();
            if (r == null) {
                this.setOutputDone();
                return false;
            }
            try {
                String dataToEncrypt;
                if (this.first) {
                    this.first = false;
                    this.data.previousRowMeta = this.getInputRowMeta().clone();
                    this.data.NrPrevFields = this.data.previousRowMeta.size();
                    this.data.outputRowMeta = this.data.previousRowMeta;
                    this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this, this.repository, this.metaStore);
                    if (Const.isEmpty((String)this.meta.getStreamField())) {
                        throw new KettleException(BaseMessages.getString(PKG, (String)"PGPEncryptStream.Error.DataStreamFieldMissing", (String[])new String[0]));
                    }
                    if (this.meta.isKeynameInField()) {
                        String keyField = this.meta.getKeynameFieldName();
                        if (Const.isEmpty((String)keyField)) {
                            throw new KettleException(BaseMessages.getString(PKG, (String)"PGPEncryptStream.Error.KeyNameFieldMissing", (String[])new String[0]));
                        }
                        this.data.indexOfKeyName = this.data.previousRowMeta.indexOfValue(keyField);
                        if (this.data.indexOfKeyName < 0) {
                            throw new KettleException(BaseMessages.getString(PKG, (String)"PGPEncryptStream.Exception.CouldnotFindField", (String[])new String[]{this.meta.getStreamField()}));
                        }
                    } else {
                        this.data.keyName = this.environmentSubstitute(this.meta.getKeyName());
                        if (Const.isEmpty((String)this.data.keyName)) {
                            throw new KettleException(BaseMessages.getString(PKG, (String)"PGPEncryptStream.Error.KeyNameMissing", (String[])new String[0]));
                        }
                    }
                    if (this.data.indexOfField < 0) {
                        this.data.indexOfField = this.data.previousRowMeta.indexOfValue(this.meta.getStreamField());
                        if (this.data.indexOfField < 0) {
                            throw new KettleException(BaseMessages.getString(PKG, (String)"PGPEncryptStream.Exception.CouldnotFindField", (String[])new String[]{this.meta.getStreamField()}));
                        }
                    }
                }
                Object[] outputRow = RowDataUtil.allocateRowData((int)this.data.outputRowMeta.size());
                for (int i = 0; i < this.data.NrPrevFields; ++i) {
                    outputRow[i] = r[i];
                }
                if (this.meta.isKeynameInField()) {
                    this.data.keyName = this.data.previousRowMeta.getString(r, this.data.indexOfKeyName);
                    if (Const.isEmpty((String)this.data.keyName)) {
                        throw new KettleException(BaseMessages.getString(PKG, (String)"PGPEncryptStream.Error.KeyNameMissing", (String[])new String[0]));
                    }
                }
                if (Const.isEmpty((String)(dataToEncrypt = this.data.previousRowMeta.getString(r, this.data.indexOfField)))) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"PGPEncryptStream.Error.DataToEncryptEmpty", (String[])new String[0]));
                }
                String encryptedData = this.data.gpg.encrypt(dataToEncrypt, this.data.keyName);
                outputRow[this.data.NrPrevFields] = encryptedData;
                this.putRow(this.data.outputRowMeta, outputRow);
                if (this.log.isRowLevel()) {
                    this.logRowlevel(BaseMessages.getString(PKG, (String)"PGPEncryptStream.LineNumber", (String[])new String[]{this.getLinesRead() + " : " + this.getInputRowMeta().getString(r)}));
                }
            }
            catch (Exception e) {
                if (!this.getStepMeta().isDoingErrorHandling()) {
                    this.logError(BaseMessages.getString(PKG, (String)"PGPEncryptStream.ErrorInStepRunning", (String[])new String[0]) + e.getMessage());
                    this.setErrors(1L);
                    this.stopAll();
                    this.setOutputDone();
                    return false;
                }
                sendToErrorRow = true;
                errorMessage = e.toString();
                if (!sendToErrorRow) break block18;
                this.putError(this.getInputRowMeta(), r, 1L, errorMessage, this.meta.getResultFieldName(), "PGPEncryptStreamO01");
            }
        }
        return true;
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (PGPEncryptStreamMeta)smi;
        this.data = (PGPEncryptStreamData)sdi;
        if (super.init(smi, sdi)) {
            if (Const.isEmpty((String)this.meta.getResultFieldName())) {
                this.logError(BaseMessages.getString(PKG, (String)"PGPEncryptStream.Error.ResultFieldMissing", (String[])new String[0]));
                return false;
            }
            try {
                this.data.gpg = new GPG(this.environmentSubstitute(this.meta.getGPGLocation()), this.log);
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"PGPEncryptStream.Init.Error", (String[])new String[0]), e);
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (PGPEncryptStreamMeta)smi;
        this.data = (PGPEncryptStreamData)sdi;
        super.dispose(smi, sdi);
    }
}

