/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.mappinginput;

import java.util.List;
import org.pentaho.di.core.BlockingRowSet;
import org.pentaho.di.core.RowSet;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.mapping.MappingValueRename;
import org.pentaho.di.trans.steps.mappinginput.MappingInputData;
import org.pentaho.di.trans.steps.mappinginput.MappingInputMeta;

public class MappingInput
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = MappingInputMeta.class;
    private int timeOut = 60000;
    private MappingInputMeta meta;
    private MappingInputData data;

    public MappingInput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public void setTimeOut(int timeOut) {
        this.timeOut = timeOut;
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        Object[] row;
        this.meta = (MappingInputMeta)smi;
        this.data = (MappingInputData)sdi;
        if (!this.data.linked) {
            int totalsleep = 0;
            while (!this.isStopped() && this.data.sourceSteps == null) {
                try {
                    totalsleep += 10;
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    this.stopAll();
                }
                if (totalsleep <= this.timeOut) continue;
                throw new KettleException(BaseMessages.getString(PKG, (String)"MappingInput.Exception.UnableToConnectWithParentMapping", (String[])new String[]{"" + totalsleep / 1000}));
            }
            this.data.linked = true;
        }
        if ((row = this.getRow()) == null) {
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            this.data.outputRowMeta = this.getInputRowMeta().clone();
            for (MappingValueRename valueRename : this.data.valueRenames) {
                ValueMetaInterface valueMeta = this.data.outputRowMeta.searchValueMeta(valueRename.getSourceValueName());
                if (valueMeta == null) {
                    throw new KettleStepException(BaseMessages.getString(PKG, (String)"MappingInput.Exception.UnableToFindMappedValue", (String[])new String[]{valueRename.getSourceValueName()}));
                }
                valueMeta.setName(valueRename.getTargetValueName());
                valueMeta = this.getInputRowMeta().searchValueMeta(valueRename.getSourceValueName());
                if (valueMeta == null) {
                    throw new KettleStepException(BaseMessages.getString(PKG, (String)"MappingInput.Exception.UnableToFindMappedValue", (String[])new String[]{valueRename.getSourceValueName()}));
                }
                valueMeta.setName(valueRename.getTargetValueName());
            }
            this.data.outputRowMeta.setValueMetaList(this.data.outputRowMeta.getValueMetaList());
            this.getInputRowMeta().setValueMetaList(this.getInputRowMeta().getValueMetaList());
            this.meta.setInputRowMeta(this.getInputRowMeta());
            if (this.meta.isSelectingAndSortingUnspecifiedFields()) {
                this.data.outputRowMeta = new RowMeta();
            } else {
                this.meta.setInputRowMeta((RowMetaInterface)new RowMeta());
            }
            this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this, this.repository, this.metaStore);
            if (this.meta.isSelectingAndSortingUnspecifiedFields()) {
                this.data.fieldNrs = new int[this.data.outputRowMeta.size()];
                for (int i = 0; i < this.data.outputRowMeta.size(); ++i) {
                    this.data.fieldNrs[i] = this.getInputRowMeta().indexOfValue(this.data.outputRowMeta.getValueMeta(i).getName());
                }
            }
        }
        if (this.meta.isSelectingAndSortingUnspecifiedFields()) {
            Object[] outputRowData = RowDataUtil.allocateRowData((int)this.data.outputRowMeta.size());
            for (int i = 0; i < this.data.fieldNrs.length; ++i) {
                outputRowData[i] = row[this.data.fieldNrs[i]];
            }
            this.putRow(this.data.outputRowMeta, outputRowData);
        } else {
            this.putRow(this.data.outputRowMeta, row);
        }
        return true;
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (MappingInputMeta)smi;
        this.data = (MappingInputData)sdi;
        return super.init(smi, sdi);
    }

    public void setConnectorSteps(StepInterface[] sourceSteps, List<MappingValueRename> valueRenames, String mappingStepname) {
        if (sourceSteps == null) {
            throw new IllegalArgumentException(BaseMessages.getString(PKG, (String)"MappingInput.Exception.IllegalArgumentSourceStep", (String[])new String[0]));
        }
        if (valueRenames == null) {
            throw new IllegalArgumentException(BaseMessages.getString(PKG, (String)"MappingInput.Exception.IllegalArgumentValueRename", (String[])new String[0]));
        }
        if (sourceSteps.length != 0 && mappingStepname == null) {
            throw new IllegalArgumentException(BaseMessages.getString(PKG, (String)"MappingInput.Exception.IllegalArgumentStepName", (String[])new String[0]));
        }
        for (StepInterface sourceStep : sourceSteps) {
            if (sourceStep.isMapping()) continue;
            BlockingRowSet rowSet = new BlockingRowSet(this.getTransMeta().getSizeRowset());
            rowSet.setThreadNameFromToCopy(sourceStep.getStepname(), 0, mappingStepname, 0);
            sourceStep.getOutputRowSets().add((RowSet)rowSet);
            sourceStep.identifyErrorOutput();
            this.getInputRowSets().add((RowSet)rowSet);
        }
        this.data.valueRenames = valueRenames;
        this.data.sourceSteps = sourceSteps;
    }
}

