/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.autodoc;

import java.awt.image.BufferedImage;
import java.util.Date;
import java.util.List;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.jfree.ui.Drawable;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.BaseLogTable;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.logging.LogStatus;
import org.pentaho.di.core.logging.LogTableInterface;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.steps.autodoc.JobInformation;
import org.pentaho.di.trans.steps.autodoc.ReportSubjectLocation;
import org.pentaho.di.trans.steps.autodoc.TransformationInformation;

public class KettleFileTableModel
implements TableModel {
    private List<ReportSubjectLocation> locations;
    private LoggingObjectInterface parentObject;
    private LogChannelInterface log;

    public KettleFileTableModel() {
    }

    public KettleFileTableModel(LoggingObjectInterface parentObject, List<ReportSubjectLocation> locations) {
        this.parentObject = parentObject;
        this.locations = locations;
        this.log = new LogChannel((Object)"Kettle File Table Model", parentObject);
    }

    @Override
    public void addTableModelListener(TableModelListener tableModelListener) {
    }

    @Override
    public Class<?> getColumnClass(int index) {
        return Field.values()[index].getClazz();
    }

    @Override
    public int getColumnCount() {
        return Field.values().length;
    }

    @Override
    public String getColumnName(int index) {
        return Field.values()[index].name();
    }

    @Override
    public int getRowCount() {
        return this.locations.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        ReportSubjectLocation location = this.locations.get(rowIndex);
        Field field = Field.values()[columnIndex];
        try {
            switch (field) {
                case location: {
                    return location;
                }
                case filename: {
                    return location.getFilename();
                }
                case name: {
                    return KettleFileTableModel.getName(location);
                }
                case description: {
                    return KettleFileTableModel.getDescription(location);
                }
                case extended_description: {
                    return KettleFileTableModel.getExtendedDescription(location);
                }
                case logging: {
                    return KettleFileTableModel.getLogging(location);
                }
                case creation: {
                    return KettleFileTableModel.getCreation(location);
                }
                case modification: {
                    return KettleFileTableModel.getModification(location);
                }
                case last_exec_result: {
                    return KettleFileTableModel.getLastExecutionResult(this.log, this.parentObject, location);
                }
                case image: {
                    return KettleFileTableModel.getImage(location);
                }
            }
            throw new RuntimeException("Unhandled field type: " + (Object)((Object)field) + " in function getValueAt()");
        }
        catch (Exception e) {
            this.log.logError("Unable to get data for field: " + (Object)((Object)field) + " : " + e.getMessage());
            return null;
        }
    }

    public static String getName(ReportSubjectLocation filename) throws KettleException {
        if (filename.isTransformation()) {
            return TransformationInformation.getInstance().getTransMeta(filename).getName();
        }
        return JobInformation.getInstance().getJobMeta(filename).getName();
    }

    public static String getDescription(ReportSubjectLocation filename) throws KettleException {
        if (filename.isTransformation()) {
            return TransformationInformation.getInstance().getTransMeta(filename).getDescription();
        }
        return JobInformation.getInstance().getJobMeta(filename).getDescription();
    }

    public static String getExtendedDescription(ReportSubjectLocation filename) throws KettleException {
        if (filename.isTransformation()) {
            return TransformationInformation.getInstance().getTransMeta(filename).getExtendedDescription();
        }
        return JobInformation.getInstance().getJobMeta(filename).getExtendedDescription();
    }

    public static String getLogging(ReportSubjectLocation filename) throws KettleException {
        List<LogTableInterface> logTables;
        if (filename.isTransformation()) {
            TransMeta transMeta = TransformationInformation.getInstance().getTransMeta(filename);
            logTables = transMeta.getLogTables();
        } else {
            JobMeta jobMeta = JobInformation.getInstance().getJobMeta(filename);
            logTables = jobMeta.getLogTables();
        }
        String logging = "";
        for (LogTableInterface logTableInterface : logTables) {
            if (logTableInterface.getDatabaseMeta() == null || Const.isEmpty((String)logTableInterface.getTableName())) continue;
            if (logging.length() > 0) {
                logging = logging + ", ";
            }
            logging = logging + logTableInterface.getTableName() + "@" + logTableInterface.getDatabaseMeta().getName();
        }
        return logging;
    }

    public static BufferedImage getImage(ReportSubjectLocation filename) throws KettleException {
        if (filename.isTransformation()) {
            return TransformationInformation.getInstance().getImage(filename);
        }
        return JobInformation.getInstance().getImage(filename);
    }

    public static String getCreation(ReportSubjectLocation filename) throws KettleException {
        Date date = null;
        String user = null;
        if (filename.isTransformation()) {
            date = TransformationInformation.getInstance().getTransMeta(filename).getCreatedDate();
            user = TransformationInformation.getInstance().getTransMeta(filename).getCreatedUser();
        } else {
            date = JobInformation.getInstance().getJobMeta(filename).getCreatedDate();
            user = JobInformation.getInstance().getJobMeta(filename).getCreatedUser();
        }
        return Const.NVL((String)XMLHandler.date2string((Date)date), (String)"-") + " by " + Const.NVL((String)user, (String)"-");
    }

    public static String getModification(ReportSubjectLocation filename) throws KettleException {
        Date date = null;
        String user = null;
        if (filename.isTransformation()) {
            date = TransformationInformation.getInstance().getTransMeta(filename).getModifiedDate();
            user = TransformationInformation.getInstance().getTransMeta(filename).getModifiedUser();
        } else {
            date = JobInformation.getInstance().getJobMeta(filename).getModifiedDate();
            user = JobInformation.getInstance().getJobMeta(filename).getModifiedUser();
        }
        return Const.NVL((String)XMLHandler.date2string((Date)date), (String)"-") + " by " + Const.NVL((String)user, (String)"-");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getLastExecutionResult(LogChannelInterface log, LoggingObjectInterface parentObject, ReportSubjectLocation filename) throws KettleException {
        BaseLogTable logTable = null;
        if (filename.isTransformation()) {
            TransMeta transMeta = TransformationInformation.getInstance().getTransMeta(filename);
            logTable = transMeta.getTransLogTable();
        } else {
            JobMeta jobMeta = JobInformation.getInstance().getJobMeta(filename);
            logTable = jobMeta.getJobLogTable();
        }
        if (logTable != null && logTable.isDefined()) {
            DatabaseMeta dbMeta = logTable.getDatabaseMeta();
            Database database = new Database(parentObject, dbMeta);
            try {
                database.connect();
                String sql = "SELECT ";
                sql = sql + dbMeta.quoteField(logTable.getStatusField().getFieldName()) + ", ";
                sql = sql + dbMeta.quoteField(logTable.getLogDateField().getFieldName()) + ", ";
                sql = sql + dbMeta.quoteField(logTable.getErrorsField().getFieldName()) + "";
                sql = sql + " FROM ";
                sql = sql + dbMeta.getQuotedSchemaTableCombination(logTable.getSchemaName(), logTable.getTableName());
                sql = sql + " ORDER BY " + dbMeta.quoteField(logTable.getLogDateField().getFieldName()) + " DESC";
                RowMetaAndData oneRow = database.getOneRow(sql);
                String status = oneRow.getString(0, "?");
                Date date = oneRow.getDate(1, null);
                Long nrErrors = oneRow.getInteger(2);
                String evaluation = status.equalsIgnoreCase(LogStatus.END.getStatus()) ? "Ended" : (status.equalsIgnoreCase(LogStatus.START.getStatus()) ? "Started" : (status.equalsIgnoreCase(LogStatus.STOP.getStatus()) ? "Stopped" : (status.equalsIgnoreCase(LogStatus.RUNNING.getStatus()) ? "Running" : (status.equalsIgnoreCase(LogStatus.PAUSED.getStatus()) ? "Paused" : (status.equalsIgnoreCase(LogStatus.ERROR.getStatus()) ? "Failed" : "Unknown")))));
                evaluation = nrErrors > 0L ? evaluation + " with errors" : evaluation + " with success";
                String string = evaluation + " at " + XMLHandler.date2string((Date)date);
                return string;
            }
            catch (Exception e) {
                log.logBasic("Unable to get logging information from log table" + logTable);
            }
            finally {
                database.disconnect();
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int arg0, int arg1) {
        return false;
    }

    @Override
    public void removeTableModelListener(TableModelListener arg0) {
    }

    @Override
    public void setValueAt(Object arg0, int arg1, int arg2) {
    }

    public static enum Field {
        location(ReportSubjectLocation.class),
        filename(String.class),
        name(String.class),
        description(String.class),
        extended_description(String.class),
        logging(String.class),
        creation(String.class),
        modification(String.class),
        last_exec_result(String.class),
        image(Drawable.class);

        private Class<?> clazz;

        private Field(Class<?> clazz) {
            this.clazz = clazz;
        }

        public Class<?> getClazz() {
            return this.clazz;
        }
    }
}

